/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support.remotefileselector;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.support.BaseActionProviderSupport;
import com.sas.actionprovider.support.remotefileselector.RemoteFileSelectorAreaInterface;
import com.sas.codepolicy.SASScope;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public abstract class BaseRemoteFileSelectorSupport
extends BaseActionProviderSupport
implements RemoteFileSelectorAreaInterface {
    public static final String OPEN_FOLDER_ACTION = "OPEN_FOLDER_ACTION";
    public static final String UP_ONE_LEVEL_ACTION = "UP_ONE_LEVEL_ACTION";
    public static final String START_SEARCH_ACTION = "START_SEARCH_ACTION";
    public static final String ADD_FOLDER_ACTION = "ADD_FOLDER_ACTION";
    public static final String DISPLAY_SEARCH_RESULTS_ACTION = "DISPLAY_SEARCH_RESULTS_ACTION";

    public BaseRemoteFileSelectorSupport(Class actionClass) {
        super(actionClass);
    }

    public void initialize() {
        this.createDefaultActions();
    }

    protected void createDefaultActions() {
        this.addDefaultAction(this.newActionInstance("COMBO_AREA", OPEN_FOLDER_ACTION), "COMBO_AREA");
        this.addDefaultAction(this.newActionInstance("TOOLBAR_AREA", UP_ONE_LEVEL_ACTION), "TOOLBAR_AREA");
        this.addDefaultAction(this.newActionInstance("SEARCH_BUTTON_AREA", START_SEARCH_ACTION), "SEARCH_BUTTON_AREA");
        this.addAreaType("TREE_AREA");
        this.addAreaType("DRILL_DOWN_AREA");
        this.addAreaType("FILTER_TYPE_AREA");
    }

    protected Map getAreaScopeAttributeMap(ActionSupportFilter filter) {
        HashMap<String, Object> areaScopeAttributeMap = new HashMap<String, Object>();
        String areaType = filter.getAreaType();
        RemoteFileServerModelInterface remoteFileServerModel = null;
        Object sortModelAdapter = null;
        if (areaType.equals("COMBO_AREA")) {
            remoteFileServerModel = (RemoteFileServerModelInterface)filter.getAttribute("model");
            areaScopeAttributeMap.put("model", remoteFileServerModel);
            areaScopeAttributeMap.put("modelColumn", filter.getAttribute("modelColumn"));
            areaScopeAttributeMap.put("path", remoteFileServerModel.getPath());
        } else if (areaType.equals("TOOLBAR_AREA")) {
            remoteFileServerModel = (RemoteFileServerModelInterface)filter.getAttribute("model");
            areaScopeAttributeMap.put("model", remoteFileServerModel);
            areaScopeAttributeMap.put("path", remoteFileServerModel.getPath());
        } else if (areaType.equals("SEARCH_BUTTON_AREA")) {
            areaScopeAttributeMap.put("serviceModel", filter.getAttribute("serviceModel"));
            areaScopeAttributeMap.put("remoteModel", filter.getAttribute("remoteModel"));
        }
        return areaScopeAttributeMap;
    }

    protected int getActionStatus(BaseAction action, ActionSupportFilter actionFilter) {
        int status = super.getActionStatus(action, actionFilter);
        if (status == 0) {
            RemoteFileServerModelInterface model;
            String actionType = action.getActionType();
            String areaType = actionFilter.getAreaType();
            if (actionType.equals(OPEN_FOLDER_ACTION)) {
                Integer column = (Integer)actionFilter.getAttribute("modelColumn");
                if (column != 0) {
                    status |= 0x40;
                }
            } else if (actionType.equals(UP_ONE_LEVEL_ACTION)) {
                RemoteFileServerModelInterface model2;
                if (actionFilter.containsAttributeNamed("model") && (model2 = (RemoteFileServerModelInterface)actionFilter.getAttribute("model")).isUpwardPathRestricted()) {
                    status |= 2;
                }
            } else if (actionType.equals(ADD_FOLDER_ACTION) && actionFilter.containsAttributeNamed("model") && (model = (RemoteFileServerModelInterface)actionFilter.getAttribute("model")).isUpwardPathRestricted()) {
                status |= 2;
            }
        }
        return status;
    }

    protected boolean validArea(Area area, ActionSupportFilter filter) {
        return true;
    }
}

