/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.strategies.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.strategies.olap.BaseOLAPModelStrategy;
import com.sas.actionprovider.util.olap.OLAPActionUtil;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import java.util.Locale;

@SASScope(value="ALL")
public abstract class BaseHeaderStrategy
extends BaseOLAPModelStrategy {
    public static final String TUPLE_ELEMENT = "tupleElement";
    public static final String TUPLE_ELEMENTS = "tupleElements";
    public static final String AXIS = "axis";
    public static final String IS_MEASURE = "isMeasure";
    public static final String TUPLE_ELEMENT_INDEX = "tupleElementIndex";
    public static final String TUPLE_INDEX = "tupleIndex";
    public static final String AXIS_INDEX = "axisIndex";
    public static final String ROW_TUPLES = "rowTuples";
    public static final String COLUMN_TUPLES = "columnTuples";
    public static final String TUPLE_LABEL = "tupleLabel";
    public static final String AREA_VALUE = "areaValue";
    public static final String ROW_INDEX = "rowIndex";
    public static final String COLUMN_INDEX = "columnIndex";

    public BaseHeaderStrategy() {
    }

    public BaseHeaderStrategy(boolean swing, OLAPActionUtil util) {
        super(swing, util);
    }

    @Override
    protected void initializeActionAttributes(BaseAction action, String areaType, Locale locale) {
        super.initializeActionAttributes(action, areaType, locale);
        if (this.isSwing()) {
            action.putValue(TUPLE_ELEMENT, null);
        } else {
            action.putValue(TUPLE_ELEMENT_INDEX, null);
            AttributeDescriptorInterface descriptor = action.getAttributeDescriptor(TUPLE_ELEMENT_INDEX);
            descriptor.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
            action.putValue(TUPLE_INDEX, null);
            descriptor = action.getAttributeDescriptor(TUPLE_INDEX);
            descriptor.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
            action.putValue(AXIS_INDEX, null);
            descriptor = action.getAttributeDescriptor(AXIS_INDEX);
            descriptor.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
            action.putValue("dataItem", null);
            descriptor = action.getAttributeDescriptor("dataItem");
            descriptor.setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
            descriptor.setVisible(false);
            descriptor.setSupplementalProperty("DYNAMIC", (Object)Boolean.TRUE);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.addDynamicValueInfo(AXIS, null, null);
        this.addDynamicValueInfo(TUPLE_ELEMENT, null, null);
        this.addDynamicValueInfo(IS_MEASURE, null, null);
        this.addDynamicValueInfo("dataItem", null, null);
        if (this.isSwing()) {
            this.addDynamicValueInfo(TUPLE_ELEMENTS, null, null);
        } else {
            this.addDynamicValueInfo(ROW_TUPLES, null, null);
            this.addDynamicValueInfo(COLUMN_TUPLES, null, null);
            this.addDynamicValueInfo(TUPLE_ELEMENT_INDEX, "getStringTupleElementIndex", null);
            this.addDynamicValueInfo(TUPLE_INDEX, "getStringTupleIndex", null);
            this.addDynamicValueInfo(AXIS_INDEX, "getStringAxisIndexFromTupleElement", null);
            this.addDynamicValueInfo(TUPLE_LABEL, "getTupleElementLabel", null);
            this.addDynamicValueInfo(AREA_VALUE, "getHeaderAreaValue", null);
            this.addDynamicValueInfo(ROW_INDEX, "getStringRowIndex", null);
            this.addDynamicValueInfo(COLUMN_INDEX, "getStringColumnIndex", null);
        }
    }

    public int getActionStatus(BaseAction action, ActionSupportFilter filter) {
        int status = super.getActionStatus(action, filter);
        return status |= OLAPActionUtil.validateHeaderArea(filter);
    }
}

