/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.message.mimb.response;

import MITI.mimb.bridge.BridgeId;
import MITI.mimb.bridge.BridgeSpecification;
import MITI.mimb.message.MessageObject;
import MITI.mimb.message.mimb.response.MimbResponse;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class BridgeSpecsResponse
extends MimbResponse {
    private Map<BridgeId, BridgeSpecification> specs = new LinkedHashMap<BridgeId, BridgeSpecification>();

    public Collection<BridgeSpecification> getBridgeSpecs() {
        return this.specs.values();
    }

    public BridgeSpecification getBridgeSpec(BridgeId bridgeId) {
        return this.specs.get(bridgeId);
    }

    public void addBridgeSpec(BridgeSpecification bridgeSpecification) {
        this.specs.put(bridgeSpecification.getBridgeId(), bridgeSpecification);
    }

    @Override
    protected void deserialize(MessageObject messageObject) {
        for (MessageObject messageObject2 : messageObject.list("ModelBridge")) {
            MessageObject messageObject3 = messageObject2.getFirstChild("Bridge");
            MessageObject messageObject4 = messageObject2.getFirstChild("Vendor");
            MessageObject messageObject5 = messageObject2.getFirstChild("Tool");
            MessageObject messageObject6 = messageObject2.getFirstChild("Methodology");
            MessageObject messageObject7 = messageObject2.getFirstChild("ToolInterface");
            BridgeId bridgeId = new BridgeId(messageObject3.getAttribute("id"), BridgeId.Direction.valueOf(messageObject3.getAttribute("direction")));
            BridgeSpecification.Vendor vendor = new BridgeSpecification.Vendor(messageObject4.getAttribute("id"), messageObject4.getAttribute("name"), messageObject4.getAttribute("web"));
            BridgeSpecification.Tool tool = new BridgeSpecification.Tool(messageObject5.getAttribute("name"), messageObject5.getAttribute("previousName"), messageObject5.getAttribute("versions"), messageObject5.getAttribute("web"));
            BridgeSpecification.Methodology methodology = new BridgeSpecification.Methodology(messageObject6.getAttribute("summary"), messageObject6.getAttribute("toolCategory"));
            BridgeSpecification.ToolInterface toolInterface = new BridgeSpecification.ToolInterface(messageObject7.getAttribute("summary"), messageObject7.getAttribute("api"), messageObject7.getAttribute("file"));
            BridgeSpecification bridgeSpecification = new BridgeSpecification();
            bridgeSpecification.setBridgeId(bridgeId);
            bridgeSpecification.setVendor(vendor);
            bridgeSpecification.setTool(tool);
            bridgeSpecification.setMethodology(methodology);
            bridgeSpecification.setToolInterface(toolInterface);
            bridgeSpecification.setDisplayName(messageObject3.getAttribute("displayName"));
            bridgeSpecification.setEnabled(Boolean.parseBoolean(messageObject3.getAttribute("isEnabled")));
            bridgeSpecification.setWindowsOnly(Boolean.parseBoolean(messageObject3.getAttribute("IsWindowsOnly")));
            bridgeSpecification.setAlias(Boolean.parseBoolean(messageObject3.getAttribute("isAlias")));
            bridgeSpecification.setToolRequired(Boolean.parseBoolean(messageObject3.getAttribute("isToolRequired")));
            bridgeSpecification.setRepositoryMultiModel(Boolean.parseBoolean(messageObject3.getAttribute("isRepositoryMultiModel")));
            bridgeSpecification.setRepositoryBrowsable(Boolean.parseBoolean(messageObject3.getAttribute("isRepositoryBrowsable")));
            bridgeSpecification.setIncrementallyHarvestable(Boolean.parseBoolean(messageObject3.getAttribute("isIncrementallyHarvestable")));
            bridgeSpecification.setDataProfile(Boolean.parseBoolean(messageObject3.getAttribute("isDataProfile")));
            bridgeSpecification.setMimbOemEnabled(Boolean.parseBoolean(messageObject3.getAttribute("isMimbOemEnabled")));
            bridgeSpecification.setPartnershipLevel(messageObject3.getAttribute("partnershipLevel"));
            this.specs.put(bridgeId, bridgeSpecification);
        }
    }

    @Override
    protected void serialize(MessageObject messageObject) {
        MessageObject messageObject2 = messageObject.addChild("GetBridgeSpecsResponse");
        for (BridgeSpecification bridgeSpecification : this.specs.values()) {
            MessageObject messageObject3 = messageObject2.addChild("ModelBridge");
            MessageObject messageObject4 = messageObject3.addChild("Bridge");
            messageObject4.setAttribute("id", bridgeSpecification.getBridgeId().getId());
            messageObject4.setAttribute("direction", bridgeSpecification.getBridgeId().getDirection().name());
            messageObject4.setAttribute("displayName", bridgeSpecification.getDisplayName());
            messageObject4.setAttribute("isEnabled", String.valueOf(bridgeSpecification.isEnabled()));
            messageObject4.setAttribute("IsWindowsOnly", String.valueOf(bridgeSpecification.isWindowsOnly()));
            messageObject4.setAttribute("isAlias", String.valueOf(bridgeSpecification.isAlias()));
            messageObject4.setAttribute("isToolRequired", String.valueOf(bridgeSpecification.isToolRequired()));
            messageObject4.setAttribute("isRepositoryMultiModel", String.valueOf(bridgeSpecification.isRepositoryMultiModel()));
            messageObject4.setAttribute("isRepositoryBrowsable", String.valueOf(bridgeSpecification.isRepositoryBrowsable()));
            messageObject4.setAttribute("isIncrementallyHarvestable", String.valueOf(bridgeSpecification.isIncrementallyHarvestable()));
            messageObject4.setAttribute("isDataProfile", String.valueOf(bridgeSpecification.isDataProfile()));
            messageObject4.setAttribute("isMimbOemEnabled", String.valueOf(bridgeSpecification.isMimbOemEnabled()));
            messageObject4.setAttribute("partnershipLevel", bridgeSpecification.getPartnershipLevel());
            MessageObject messageObject5 = messageObject3.addChild("Vendor");
            messageObject5.setAttribute("id", bridgeSpecification.getVendor().getId());
            messageObject5.setAttribute("name", bridgeSpecification.getVendor().getName());
            messageObject5.setAttribute("web", bridgeSpecification.getVendor().getWeb());
            MessageObject messageObject6 = messageObject3.addChild("Tool");
            messageObject6.setAttribute("name", bridgeSpecification.getTool().getName());
            messageObject6.setAttribute("previousName", bridgeSpecification.getTool().getPreviousName());
            messageObject6.setAttribute("versions", bridgeSpecification.getTool().getVersions());
            messageObject6.setAttribute("web", bridgeSpecification.getTool().getWeb());
            MessageObject messageObject7 = messageObject3.addChild("Methodology");
            messageObject7.setAttribute("summary", bridgeSpecification.getMethodology().getSummary());
            messageObject7.setAttribute("toolCategory", bridgeSpecification.getMethodology().getToolCategory());
            MessageObject messageObject8 = messageObject3.addChild("ToolInterface");
            messageObject8.setAttribute("summary", bridgeSpecification.getToolInterface().getSummary());
            messageObject8.setAttribute("api", bridgeSpecification.getToolInterface().getApi());
            messageObject8.setAttribute("file", bridgeSpecification.getToolInterface().getFile());
        }
    }
}

