/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.message.mimb.request;

import MITI.mimb.driver.ValidationLevel;
import MITI.mimb.log.MimbLogLevel;
import MITI.mimb.message.MessageObject;
import MITI.mimb.message.mimb.request.MimbRequest;

public abstract class StartMimbRequest
extends MimbRequest {
    private String sessionId = "";
    private int logLevel = MimbLogLevel.INFO.getId();
    private ValidationLevel validationLevel = ValidationLevel.BASIC;

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public void setLogLevel(MimbLogLevel mimbLogLevel) {
        this.logLevel = (mimbLogLevel != null ? mimbLogLevel : MimbLogLevel.INFO).getId();
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public ValidationLevel getValidationLevel() {
        return this.validationLevel;
    }

    public void setValidationLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
    }

    @Override
    protected void deserialize(MessageObject messageObject) {
        super.deserialize(messageObject);
        this.sessionId = messageObject.getAttribute("reuseMimbProcessId");
        try {
            this.logLevel = Integer.parseInt(messageObject.getAttribute("logLevel"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.validationLevel = ValidationLevel.getByName(messageObject.getAttribute("validationLevel"));
    }

    @Override
    protected void serialize(MessageObject messageObject) {
        super.serialize(messageObject);
        messageObject.setAttribute("reuseMimbProcessId", this.sessionId);
        messageObject.setAttribute("logLevel", String.valueOf(this.logLevel));
        messageObject.setAttribute("validationLevel", this.validationLevel.name());
    }
}

