/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.message.mimb.request;

import MITI.mimb.bridge.BridgeId;
import MITI.mimb.message.MessageObject;
import MITI.mimb.message.mimb.request.BridgeOption;
import java.util.Collection;
import java.util.LinkedHashMap;

public class BridgeConfig {
    private BridgeId bridgeId;
    private String displayName = "";
    private LinkedHashMap<String, BridgeOption> options = new LinkedHashMap();

    public BridgeId getBridgeId() {
        return this.bridgeId;
    }

    public void setBridgeId(BridgeId bridgeId) {
        this.bridgeId = bridgeId;
    }

    public String getBridgeDisplayName() {
        return this.displayName;
    }

    public void setBridgeDisplayName(String string) {
        this.displayName = string;
    }

    public void addBridgeOption(String string, String string2, String string3) {
        this.options.put(string, new BridgeOption(string, string2 != null ? string2 : "", string3));
    }

    public BridgeOption getBridgeOption(String string) {
        return this.options.get(string);
    }

    public Collection<BridgeOption> getBridgeOptions() {
        return this.options.values();
    }

    protected void deserialize(MessageObject messageObject) {
        this.bridgeId = new BridgeId(messageObject.getAttribute("bridgeIdentifier"), BridgeId.Direction.valueOf(messageObject.getAttribute("direction")));
        this.displayName = messageObject.getAttribute("bridgeDisplayName");
        if (this.displayName == null || this.displayName.isEmpty()) {
            this.displayName = this.bridgeId.getId();
        }
        for (MessageObject messageObject2 : messageObject.list("BridgeParameter")) {
            String string = messageObject2.getAttribute("bridgeParameterIdentifier");
            String string2 = messageObject2.getText();
            String string3 = messageObject2.getAttribute("clientSpecifiedText");
            if (string.equals("Worker Threads")) {
                string = "Multiple threads";
            }
            this.addBridgeOption(string, string2, string3);
        }
    }

    protected void serialize(MessageObject messageObject) {
        messageObject.setAttribute("bridgeIdentifier", this.bridgeId.getId());
        messageObject.setAttribute("direction", this.bridgeId.getDirection().name());
        messageObject.setAttribute("bridgeDisplayName", this.displayName);
        for (BridgeOption bridgeOption : this.options.values()) {
            MessageObject messageObject2 = messageObject.addChild("BridgeParameter");
            messageObject2.setAttribute("bridgeParameterIdentifier", bridgeOption.getName());
            messageObject2.setAttribute("clientSpecifiedText", bridgeOption.getClientText());
            messageObject2.setText(bridgeOption.getValue());
        }
    }
}

