/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.message;

import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.operation.GenericOperationOption;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlUtil {
    public static DocumentBuilderFactory getFactory() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        return documentBuilderFactory;
    }

    public static Element parse(String string) throws DriverError {
        Element element = null;
        if (string != null && !string.isEmpty()) {
            try {
                DocumentBuilder documentBuilder = XmlUtil.getFactory().newDocumentBuilder();
                Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
                element = document.getDocumentElement();
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                throw new DriverError(exception);
            }
        }
        return element;
    }

    public static String getElementValue(Node node) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 3 && node2.getNodeType() != 4) continue;
                return node2.getNodeValue();
            }
        }
        return null;
    }

    public static ArrayList<Element> getChildElements(Node node, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!XmlUtil.isElementNode(node2, string)) continue;
                arrayList.add((Element)node2);
            }
        }
        return arrayList;
    }

    public static Element getFirstElement(Element element, String string) {
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!XmlUtil.isElementNode(node, string)) continue;
                return (Element)node;
            }
        }
        return null;
    }

    public static String getNodeName(Node node) {
        String string = node.getLocalName() != null ? node.getLocalName() : node.getNodeName();
        int n = string.indexOf(58);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static boolean isElementNode(Node node, String string) {
        if (node != null && node.getNodeType() == 1) {
            return string == null || string.equals(XmlUtil.getNodeName(node));
        }
        return false;
    }

    public static void addGenericOperationOptions(Element element, Collection<GenericOperationOption> collection) {
        if (collection == null) {
            return;
        }
        for (GenericOperationOption genericOperationOption : collection) {
            Element element2 = element.getOwnerDocument().createElement("Option");
            element.appendChild(element2);
            element2.setAttribute("name", genericOperationOption.getName());
            for (Map.Entry<String, String> entry : genericOperationOption.getValues().entrySet()) {
                Element element3 = element.getOwnerDocument().createElement("Value");
                element2.appendChild(element3);
                element3.setAttribute("key", entry.getKey());
                element3.setAttribute("value", entry.getValue());
            }
        }
    }

    public static List<GenericOperationOption> getGenericOperationOptions(Element element) {
        ArrayList<GenericOperationOption> arrayList = new ArrayList<GenericOperationOption>();
        for (Element element2 : XmlUtil.getChildElements(element, "Option")) {
            GenericOperationOption genericOperationOption = new GenericOperationOption(element2.getAttribute("name"));
            for (Element element3 : XmlUtil.getChildElements(element2, "Value")) {
                genericOperationOption.addValue(element3.getAttribute("key"), element3.getAttribute("value"));
            }
            arrayList.add(genericOperationOption);
        }
        return arrayList;
    }

    public static Element createChild(Node node, String string) {
        Element element = (node instanceof Document ? (Document)node : node.getOwnerDocument()).createElement(string);
        node.appendChild(element);
        return element;
    }
}

