/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.message;

import MITI.mimb.message.MessageObject;
import MITI.mimb.message.XmlUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlMessageObject
extends MessageObject {
    private Node obj;
    private static final String VERSION = "1.0";

    public XmlMessageObject(Node node) {
        this.obj = node;
    }

    @Override
    public String getName() {
        return XmlUtil.getNodeName(this.obj);
    }

    @Override
    public XmlMessageObject addChild(String string) {
        return new XmlMessageObject(XmlUtil.createChild(this.obj, string));
    }

    public Collection<XmlMessageObject> list(String string) {
        ArrayList<XmlMessageObject> arrayList = new ArrayList<XmlMessageObject>();
        for (Element element : XmlUtil.getChildElements(this.obj, string)) {
            arrayList.add(new XmlMessageObject(element));
        }
        return arrayList;
    }

    @Override
    public boolean hasAttribute(String string) {
        if (this.obj instanceof Element) {
            return ((Element)this.obj).hasAttribute(string);
        }
        return false;
    }

    @Override
    public String getAttribute(String string) {
        if (this.obj instanceof Element) {
            return ((Element)this.obj).getAttribute(string);
        }
        return "";
    }

    @Override
    public void setAttribute(String string, String string2) {
        if (this.obj instanceof Element) {
            ((Element)this.obj).setAttribute(string, string2);
        }
    }

    @Override
    public String getText() {
        return XmlUtil.getElementValue(this.obj);
    }

    @Override
    public void setText(String string) {
        this.obj.appendChild(this.obj.getOwnerDocument().createTextNode(string));
    }

    public static XmlMessageObject createRoot() {
        try {
            Document document = XmlUtil.getFactory().newDocumentBuilder().newDocument();
            document.setXmlVersion(VERSION);
            return new XmlMessageObject(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    @Override
    public String getString() {
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("version", VERSION);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(this.obj), new StreamResult(stringWriter));
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return stringWriter.toString();
    }
}

