/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl.remote;

import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.RequestOptions;
import MITI.mimb.driver.impl.remote.MimbClient;
import MITI.mimb.driver.impl.remote.OemToken;
import MITI.mimb.message.Request;
import MITI.mimb.message.Response;
import MITI.mimb.message.file.request.DownloadTemporaryFileRequest;
import MITI.mimb.message.file.request.UploadTemporaryFileRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class RestClient
extends MimbClient {
    public static final String TEMPORARY_LICENSE_TOKEN_HEADER_ATTRIBUTE = "temporaryLicenseToken";
    public static final String OEM_PARTNER_TOKEN_HEADER_ATTRIBUTE = "oemPartnerToken";
    public static final String XML_REQUEST = "XmlRequest";
    public static final String FILE = "File";
    private String url;
    private boolean isLocal;
    private static final HostnameVerifier LOCALHOST_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return "localhost".equalsIgnoreCase(string);
        }
    };
    private static SSLContext RELAXED_SSL_CONTEXT = null;
    private static final int DEFAULT_BUFFER_SIZE = 10240;

    public RestClient(String string) throws DriverError {
        this.url = string;
        try {
            URL uRL = new URL(string);
            if (uRL.getHost() == null || uRL.getHost().isEmpty()) {
                this.isLocal = true;
            } else {
                InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
                if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || NetworkInterface.getByInetAddress(inetAddress) != null) {
                    this.isLocal = true;
                }
            }
        }
        catch (MalformedURLException | SocketException | UnknownHostException iOException) {
            throw new DriverError(iOException);
        }
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    private URL getUrl(Request request) throws MalformedURLException {
        return new URL(this.url + "/" + request.getService());
    }

    @Override
    protected Response call(Request request, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        return this.callRest(null, request, oemToken, null, requestOptions);
    }

    @Override
    protected void download(File file, DownloadTemporaryFileRequest downloadTemporaryFileRequest, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        this.callRest(file, downloadTemporaryFileRequest, oemToken, null, requestOptions);
    }

    @Override
    protected Response upload(File file, UploadTemporaryFileRequest uploadTemporaryFileRequest, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        return this.callRest(null, uploadTemporaryFileRequest, oemToken, file, requestOptions);
    }

    protected Map<String, String> getParameters(Request request, OemToken oemToken, RequestOptions requestOptions) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (oemToken != null) {
            linkedHashMap.put(OEM_PARTNER_TOKEN_HEADER_ATTRIBUTE, oemToken.getOemPartnerToken());
            linkedHashMap.put(TEMPORARY_LICENSE_TOKEN_HEADER_ATTRIBUTE, oemToken.getTempToken());
        }
        linkedHashMap.put(XML_REQUEST, request.toXml());
        return linkedHashMap;
    }

    private static SSLContext getRelaxedSslContext() {
        if (RELAXED_SSL_CONTEXT == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                MimbTrustManager mimbTrustManager = null;
                for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    mimbTrustManager = new MimbTrustManager((X509TrustManager)trustManager);
                    break;
                }
                if (mimbTrustManager != null) {
                    SSLContext sSLContext = SSLContext.getInstance("TLS");
                    sSLContext.init(null, new TrustManager[]{mimbTrustManager}, null);
                    RELAXED_SSL_CONTEXT = sSLContext;
                }
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
                // empty catch block
            }
        }
        return RELAXED_SSL_CONTEXT;
    }

    public static HttpURLConnection openConnection(URL uRL, boolean bl) throws IOException, GeneralSecurityException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        if (httpURLConnection instanceof HttpsURLConnection) {
            SSLContext sSLContext;
            boolean bl2 = "localhost".equalsIgnoreCase(uRL.getHost());
            if ((!bl || bl2) && (sSLContext = RestClient.getRelaxedSslContext()) != null) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sSLContext.getSocketFactory());
            }
            if (bl2) {
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(LOCALHOST_VERIFIER);
            }
        }
        return httpURLConnection;
    }

    /*
     * Exception decompiling
     */
    private Response callRest(File var1_1, Request var2_2, OemToken var3_3, File var4_4, RequestOptions var5_5) throws DriverError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final InputStream open(HttpURLConnection httpURLConnection, Map<String, String> map, Map<String, File> map2) throws IOException, RemoteException {
        String string = String.format("%016x+%016x", ThreadLocalRandom.current().nextLong(), System.currentTimeMillis());
        String string2 = StandardCharsets.UTF_8.name();
        OutputStream outputStream = null;
        httpURLConnection.setRequestProperty("Accept-Charset", string2);
        httpURLConnection.setRequestProperty("Content-Charset", string2);
        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        outputStream = httpURLConnection.getOutputStream();
        for (Map.Entry<String, String> object : map.entrySet()) {
            RestClient.printTextFormData(outputStream, string, object.getKey(), object.getValue());
        }
        if (map2 != null) {
            for (Map.Entry<String, Object> entry : map2.entrySet()) {
                RestClient.printFileFormData(outputStream, string, entry.getKey(), (File)entry.getValue());
            }
        }
        RestClient.printFormDataEnd(outputStream, string);
        int n = httpURLConnection.getResponseCode();
        if (n != 200 && n != 201 && n != 202 && n != 204) {
            String string3 = httpURLConnection.getResponseMessage();
            String string4 = "";
            try (Object object = httpURLConnection.getErrorStream();){
                string4 = RestClient.readStream((InputStream)object);
            }
            object = String.join((CharSequence)" ", String.valueOf(n), string3 != null ? string3 : "", string4);
            throw new RemoteException((String)object);
        }
        return httpURLConnection.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readStream(InputStream inputStream) {
        if (inputStream == null) return "";
        char[] cArray = new char[10240];
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            while (true) {
                int n;
                if ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) < 0) {
                    String string = stringBuilder.toString();
                    return string;
                }
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    private static void println(OutputStream outputStream, String string) throws IOException {
        outputStream.write((string + "\r\n").getBytes("UTF-8"));
    }

    private static void printTextFormData(OutputStream outputStream, String string, String string2, String string3) throws IOException {
        RestClient.println(outputStream, "--" + string);
        RestClient.println(outputStream, "Content-Disposition: form-data; name=\"" + string2 + "\"");
        RestClient.println(outputStream, "Content-Type: text/plain; charset=" + StandardCharsets.UTF_8.name());
        RestClient.println(outputStream, "");
        RestClient.println(outputStream, string3);
        outputStream.flush();
    }

    private static void printFileFormData(OutputStream outputStream, String string, String string2, File file) throws IOException {
        RestClient.println(outputStream, "--" + string);
        RestClient.println(outputStream, "Content-Disposition: form-data; name=\"" + string2 + "\"; filename=\"" + file.getName() + "\"");
        RestClient.println(outputStream, "Content-Type: application/octet-stream");
        RestClient.println(outputStream, "");
        Files.copy(file.toPath(), outputStream);
        RestClient.println(outputStream, "");
        outputStream.flush();
    }

    private static void printFormDataEnd(OutputStream outputStream, String string) throws IOException {
        RestClient.println(outputStream, "--" + string + "--");
        outputStream.flush();
    }

    private static class MimbTrustManager
    implements X509TrustManager {
        private X509TrustManager tm;

        MimbTrustManager(X509TrustManager x509TrustManager) {
            this.tm = x509TrustManager;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.tm.checkClientTrusted(x509CertificateArray, string);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            try {
                this.tm.checkClientTrusted(x509CertificateArray, string);
            }
            catch (CertificateException certificateException) {
                for (X509Certificate x509Certificate : x509CertificateArray) {
                    x509Certificate.checkValidity();
                }
            }
        }
    }
}

