/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl.remote;

import MITI.mimb.bridge.Bridge;
import MITI.mimb.bridge.BridgeId;
import MITI.mimb.bridge.BridgeParameter;
import MITI.mimb.driver.BridgeConfiguration;
import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbSession;
import MITI.mimb.driver.RequestOptions;
import MITI.mimb.driver.impl.MimbDriverImpl;
import MITI.mimb.driver.impl.MimbProcess;
import MITI.mimb.driver.impl.remote.GenericOperationProcess;
import MITI.mimb.driver.impl.remote.LocalFile;
import MITI.mimb.driver.impl.remote.MimbClient;
import MITI.mimb.driver.impl.remote.MimbFile;
import MITI.mimb.driver.impl.remote.OemToken;
import MITI.mimb.driver.impl.remote.RemoteFile;
import MITI.mimb.driver.impl.remote.RemoteMimbProcess;
import MITI.mimb.driver.impl.remote.RestClient;
import MITI.mimb.driver.operation.GenericOperation;
import MITI.mimb.log.MimbLog;
import MITI.mimb.message.Response;
import MITI.mimb.message.mimb.request.BridgeConfig;
import MITI.mimb.message.mimb.request.BridgeOption;
import MITI.mimb.message.mimb.request.BrowseRequest;
import MITI.mimb.message.mimb.request.CreateProcessRequest;
import MITI.mimb.message.mimb.request.MimbRequest;
import MITI.mimb.message.mimb.request.RunMimbExtendedRequest;
import MITI.mimb.message.mimb.request.RunMimbGenericOperationRequest;
import MITI.mimb.message.mimb.request.StartMimbRequest;
import MITI.mimb.message.mimb.request.TestRequest;
import MITI.mimb.message.mimb.response.CreateProcessResponse;
import MITI.mimb.message.mimb.response.MimbResponse;
import MITI.mimb.message.mimb.response.StartMimbResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class RemoteMimbDriver
extends MimbDriverImpl {
    private static final RemoteFile SESSION_DIR = new RemoteFile("mimb://", true);
    protected MimbClient client;
    protected String oemPartnerToken;
    private HashMap<BridgeId, Bridge> bridges;

    public RemoteMimbDriver(String string, String string2) throws DriverError {
        this(new RestClient(string), string2);
    }

    public RemoteMimbDriver(MimbClient mimbClient, String string) {
        this.client = mimbClient;
        this.oemPartnerToken = string;
        this.bridges = new HashMap();
    }

    @Override
    public Bridge getBridge(BridgeId bridgeId, RequestOptions requestOptions) throws DriverError {
        Bridge bridge = super.getBridge(bridgeId, requestOptions);
        if (bridge != null) {
            this.bridges.put(bridgeId, bridge);
        }
        return bridge;
    }

    @Override
    protected MimbResponse run(MimbRequest mimbRequest, RequestOptions requestOptions) throws DriverError {
        Response response = this.client.call(mimbRequest, this.client.getOemLicenseToken(this.oemPartnerToken, requestOptions), requestOptions);
        if (response instanceof MimbResponse) {
            return (MimbResponse)response;
        }
        return null;
    }

    @Override
    protected RemoteMimbProcess createSession(StartMimbRequest startMimbRequest, RequestOptions requestOptions, MimbLog mimbLog) throws DriverError {
        OemToken oemToken = this.client.getOemLicenseToken(this.oemPartnerToken, requestOptions);
        this.createSession(startMimbRequest, oemToken, requestOptions);
        ArrayList<MimbFile> arrayList = this.getRemoteFiles(startMimbRequest, oemToken, requestOptions);
        Response response = this.client.call(startMimbRequest, oemToken, requestOptions);
        if (response instanceof StartMimbResponse) {
            MimbSession mimbSession = new MimbSession(((StartMimbResponse)response).getSessionId());
            return this.createProcess(this.client, mimbSession, arrayList, mimbLog, oemToken, requestOptions);
        }
        return null;
    }

    private void createSession(StartMimbRequest startMimbRequest, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        CreateProcessRequest createProcessRequest = new CreateProcessRequest();
        createProcessRequest.setRequestType(startMimbRequest.getRequestType());
        Response response = this.client.call(createProcessRequest, oemToken, requestOptions);
        if (response instanceof CreateProcessResponse) {
            startMimbRequest.setSessionId(((CreateProcessResponse)response).getSessionId());
        }
    }

    protected ArrayList<MimbFile> getRemoteFiles(StartMimbRequest startMimbRequest, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        MimbFile mimbFile;
        String string = startMimbRequest.getSessionId();
        ArrayList<MimbFile> arrayList = new ArrayList<MimbFile>();
        if (!this.client.isLocal()) {
            if (startMimbRequest instanceof BrowseRequest) {
                arrayList.addAll(this.processFiles(((BrowseRequest)startMimbRequest).getBridge(), string, oemToken, requestOptions));
                mimbFile = this.processMimbFile(MimbFile.BROWSE, ((BrowseRequest)startMimbRequest).getBrowseFile(), string, oemToken, requestOptions);
                if (mimbFile != null) {
                    ((BrowseRequest)startMimbRequest).setBrowseFile(mimbFile.getRemoteFile().getHandle());
                    arrayList.add(mimbFile);
                }
            } else if (startMimbRequest instanceof RunMimbExtendedRequest) {
                arrayList.addAll(this.processFiles(((RunMimbExtendedRequest)startMimbRequest).getImportBridge(), string, oemToken, requestOptions));
                arrayList.addAll(this.processFiles(((RunMimbExtendedRequest)startMimbRequest).getExportBridge(), string, oemToken, requestOptions));
            } else if (startMimbRequest instanceof RunMimbGenericOperationRequest) {
                arrayList.addAll(this.processFiles(((RunMimbGenericOperationRequest)startMimbRequest).getImportBridge(), string, oemToken, requestOptions));
            } else if (startMimbRequest instanceof TestRequest) {
                arrayList.addAll(this.processFiles(((TestRequest)startMimbRequest).getBridge(), string, oemToken, requestOptions));
            }
        }
        if (startMimbRequest instanceof RunMimbGenericOperationRequest && (mimbFile = this.processMimbFile(MimbFile.OPERATION, ((RunMimbGenericOperationRequest)startMimbRequest).getGenericOperationOutputPath(), string, oemToken, requestOptions)) != null) {
            ((RunMimbGenericOperationRequest)startMimbRequest).setGenericOperationOutputPath(mimbFile.getRemoteFile().getHandle());
            arrayList.add(mimbFile);
        }
        return arrayList;
    }

    protected RemoteMimbProcess createProcess(MimbClient mimbClient, MimbSession mimbSession, Collection<MimbFile> collection, MimbLog mimbLog, OemToken oemToken, RequestOptions requestOptions) {
        return new RemoteMimbProcess(mimbClient, mimbSession, collection, mimbLog, oemToken, requestOptions);
    }

    private Collection<MimbFile> processFiles(BridgeConfig bridgeConfig, String string, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        ArrayList<MimbFile> arrayList = new ArrayList<MimbFile>();
        boolean bl = false;
        for (BridgeOption object2 : bridgeConfig.getBridgeOptions()) {
            if (object2.getClientText().isEmpty()) continue;
            bl = true;
            break;
        }
        if (bl) {
            Object object = this.bridges.get(bridgeConfig.getBridgeId());
            if (object == null) {
                object = this.getBridge(bridgeConfig.getBridgeId(), null);
            }
            if (object != null) {
                RemoteFile remoteFile = this.client.createFile(new LocalFile(bridgeConfig.getBridgeId().getDirection().name().toLowerCase(), true), SESSION_DIR, string, oemToken, requestOptions);
                for (BridgeParameter bridgeParameter : ((Bridge)object).getBridgeParameters()) {
                    MimbFile mimbFile;
                    RemoteFile remoteFile2;
                    BridgeOption bridgeOption;
                    if (!bridgeParameter.isTransferable() || bridgeParameter.getType() != BridgeParameter.ParameterType.FILE && bridgeParameter.getType() != BridgeParameter.ParameterType.DIRECTORY || (bridgeOption = bridgeConfig.getBridgeOption(bridgeParameter.getBridgeParameterIdentifier())) == null || bridgeOption.getValue() == null || bridgeOption.getValue().isEmpty()) continue;
                    RemoteFile remoteFile3 = this.client.createFile(new LocalFile(bridgeParameter.getBridgeParameterIdentifier(), true), remoteFile, string, oemToken, requestOptions);
                    BridgeParameter.OpenMode openMode = bridgeParameter.getOpenMode();
                    if (openMode == BridgeParameter.OpenMode.DEFAULT) {
                        openMode = bridgeConfig.getBridgeId().getDirection() == BridgeId.Direction.EXPORT ? BridgeParameter.OpenMode.WRITE : BridgeParameter.OpenMode.READ;
                    }
                    if ((remoteFile2 = this.processFile(mimbFile = new MimbFile(bridgeParameter.getBridgeParameterIdentifier(), new LocalFile(bridgeOption.getValue(), bridgeParameter.getType() == BridgeParameter.ParameterType.DIRECTORY), openMode), remoteFile3, string, oemToken, requestOptions)) != null) {
                        mimbFile.setRemoteFile(remoteFile2);
                        bridgeOption.setValue(remoteFile2.getHandle());
                    }
                    arrayList.add(mimbFile);
                }
            }
        }
        return arrayList;
    }

    protected MimbFile processMimbFile(MimbFile mimbFile, String string, String string2, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        if (!string.isEmpty()) {
            MimbFile mimbFile2 = new MimbFile(mimbFile.getParameterId(), new LocalFile(string, mimbFile.getLocalFile().isDirectory()), mimbFile.getOpenMode());
            RemoteFile remoteFile = this.processFile(mimbFile, SESSION_DIR, string2, oemToken, requestOptions);
            if (remoteFile != null) {
                mimbFile2.setRemoteFile(remoteFile);
                return mimbFile2;
            }
        }
        return null;
    }

    private RemoteFile processFile(MimbFile mimbFile, RemoteFile remoteFile, String string, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        if (mimbFile.getOpenMode() == BridgeParameter.OpenMode.READ || mimbFile.getOpenMode() == BridgeParameter.OpenMode.READWRITE && mimbFile.getLocalFile().exists()) {
            return this.client.uploadFile(mimbFile.getLocalFile().getFile(), remoteFile, string, oemToken, requestOptions);
        }
        if (mimbFile.getOpenMode() == BridgeParameter.OpenMode.WRITE || mimbFile.getOpenMode() == BridgeParameter.OpenMode.READWRITE) {
            return this.client.createFile(mimbFile.getLocalFile(), remoteFile, string, oemToken, requestOptions);
        }
        return null;
    }

    public MimbSession startGenericOperation(BridgeConfiguration bridgeConfiguration, GenericOperation genericOperation, RequestOptions requestOptions, MimbLog mimbLog) throws DriverError {
        RunMimbGenericOperationRequest runMimbGenericOperationRequest = this.buildRequest(new RunMimbGenericOperationRequest(), requestOptions, mimbLog);
        runMimbGenericOperationRequest.setImportBridge(this.buildBridge(bridgeConfiguration));
        runMimbGenericOperationRequest.setGenericOperatioName(genericOperation.getName());
        runMimbGenericOperationRequest.setGenericOperationOptions(genericOperation.getOptions());
        if (genericOperation.getOutputDir() != null) {
            runMimbGenericOperationRequest.setGenericOperationOutputPath(genericOperation.getOutputDir().getPath());
        }
        OemToken oemToken = this.client.getOemLicenseToken(this.oemPartnerToken, requestOptions);
        this.createSession((StartMimbRequest)runMimbGenericOperationRequest, oemToken, requestOptions);
        ArrayList<MimbFile> arrayList = this.getRemoteFiles(runMimbGenericOperationRequest, oemToken, requestOptions);
        MimbFile mimbFile = null;
        for (MimbFile object : arrayList) {
            if (!"Operation Directory".equals(object.getParameterId())) continue;
            mimbFile = object;
        }
        Response response = this.client.call(runMimbGenericOperationRequest, oemToken, requestOptions);
        if (response instanceof StartMimbResponse) {
            MimbSession mimbSession = new MimbSession(((StartMimbResponse)response).getSessionId());
            GenericOperationProcess genericOperationProcess = new GenericOperationProcess(this.client, mimbSession, mimbFile, mimbLog, oemToken, requestOptions);
            this.mimbSessions.put(genericOperationProcess.getSession(), genericOperationProcess);
            return genericOperationProcess.start();
        }
        return null;
    }

    public File getFile(MimbSession mimbSession) {
        MimbProcess mimbProcess = (MimbProcess)this.mimbSessions.get(mimbSession);
        if (mimbProcess instanceof GenericOperationProcess) {
            return ((GenericOperationProcess)mimbProcess).getFile();
        }
        return null;
    }
}

