/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl.remote;

import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.RequestOptions;
import MITI.mimb.driver.impl.remote.LocalFile;
import MITI.mimb.driver.impl.remote.OemToken;
import MITI.mimb.driver.impl.remote.OemTokenChallenge;
import MITI.mimb.driver.impl.remote.RemoteFile;
import MITI.mimb.message.Request;
import MITI.mimb.message.Response;
import MITI.mimb.message.file.request.DownloadTemporaryFileRequest;
import MITI.mimb.message.file.request.GenerateTemporaryDirectoryRequest;
import MITI.mimb.message.file.request.GenerateTemporaryFileRequest;
import MITI.mimb.message.file.request.ListTemporaryFilesRequest;
import MITI.mimb.message.file.request.UploadTemporaryFileRequest;
import MITI.mimb.message.file.response.GenerateTemporaryDirectoryResponse;
import MITI.mimb.message.file.response.GenerateTemporaryFileResponse;
import MITI.mimb.message.file.response.ListTemporaryFilesResponse;
import MITI.mimb.message.file.response.UploadTemporaryFileResponse;
import MITI.mimb.message.license.request.GetOemLicenseTokenChallengeRequest;
import MITI.mimb.message.license.request.GetOemLicenseTokenRequest;
import MITI.mimb.message.license.response.GetOemLicenseTokenChallengeResponse;
import MITI.mimb.message.license.response.GetOemLicenseTokenResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public abstract class MimbClient {
    protected abstract boolean isLocal();

    protected abstract Response call(Request var1, OemToken var2, RequestOptions var3) throws DriverError;

    protected abstract void download(File var1, DownloadTemporaryFileRequest var2, OemToken var3, RequestOptions var4) throws DriverError;

    protected abstract Response upload(File var1, UploadTemporaryFileRequest var2, OemToken var3, RequestOptions var4) throws DriverError;

    public RemoteFile createFile(LocalFile localFile, RemoteFile remoteFile, String string, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        RemoteFile remoteFile2 = null;
        if (localFile.isDirectory()) {
            Response response;
            GenerateTemporaryDirectoryRequest generateTemporaryDirectoryRequest = new GenerateTemporaryDirectoryRequest();
            generateTemporaryDirectoryRequest.setSessionId(string);
            generateTemporaryDirectoryRequest.setDirectoryName(localFile.getName());
            if (remoteFile != null) {
                generateTemporaryDirectoryRequest.setParentDirectoryHandle(remoteFile.getHandle());
            }
            if ((response = this.call(generateTemporaryDirectoryRequest, oemToken, requestOptions)) instanceof GenerateTemporaryDirectoryResponse) {
                remoteFile2 = new RemoteFile(((GenerateTemporaryDirectoryResponse)response).getFileHandle(), true);
            }
        } else {
            Response response;
            GenerateTemporaryFileRequest generateTemporaryFileRequest = new GenerateTemporaryFileRequest();
            generateTemporaryFileRequest.setSessionId(string);
            generateTemporaryFileRequest.setFileNameSuffix(localFile.getName());
            if (remoteFile != null) {
                generateTemporaryFileRequest.setParentDirectoryHandle(remoteFile.getHandle());
            }
            if ((response = this.call(generateTemporaryFileRequest, oemToken, requestOptions)) instanceof GenerateTemporaryFileResponse) {
                remoteFile2 = new RemoteFile(((GenerateTemporaryFileResponse)response).getFileHandle(), false);
            }
        }
        return remoteFile2;
    }

    public RemoteFile uploadFile(File file, RemoteFile remoteFile, String string, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        RemoteFile remoteFile2 = null;
        if (file.isDirectory()) {
            remoteFile2 = this.createFile(new LocalFile(file), remoteFile, string, oemToken, requestOptions);
            for (File file2 : file.listFiles()) {
                this.uploadFile(file2, remoteFile2, string, oemToken, requestOptions);
            }
        } else if (file.isFile()) {
            remoteFile2 = this.createFile(new LocalFile(file), remoteFile, string, oemToken, requestOptions);
            UploadTemporaryFileRequest uploadTemporaryFileRequest = new UploadTemporaryFileRequest();
            uploadTemporaryFileRequest.setSessionId(string);
            uploadTemporaryFileRequest.setFileHandle(remoteFile2.getHandle());
            uploadTemporaryFileRequest.setFileLastModificationTime(file.lastModified());
            Response response = this.upload(file, uploadTemporaryFileRequest, oemToken, requestOptions);
            if (!(response instanceof UploadTemporaryFileResponse)) {
                remoteFile2 = null;
            }
        }
        return remoteFile2;
    }

    public void downloadFile(File file, RemoteFile remoteFile, String string, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        ListTemporaryFilesRequest listTemporaryFilesRequest = new ListTemporaryFilesRequest();
        listTemporaryFilesRequest.setSessionId(string);
        listTemporaryFilesRequest.setFileHandle(remoteFile.getHandle());
        Response response = this.call(listTemporaryFilesRequest, oemToken, requestOptions);
        if (response instanceof ListTemporaryFilesResponse) {
            ArrayList<ListTemporaryFilesResponse.FileItem> arrayList = ((ListTemporaryFilesResponse)response).getFiles();
            if (remoteFile.isDirectory()) {
                this.download(file, arrayList, string, oemToken, requestOptions);
            } else {
                this.download(file, (ListTemporaryFilesResponse.FileItem)arrayList.iterator().next(), string, oemToken, requestOptions);
            }
        }
    }

    private void download(File file, Collection<ListTemporaryFilesResponse.FileItem> collection, String string, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        file.mkdirs();
        for (ListTemporaryFilesResponse.FileItem fileItem : collection) {
            if (fileItem.isDirectory) {
                this.download(new File(file, fileItem.name), fileItem.children, string, oemToken, requestOptions);
                continue;
            }
            this.download(new File(file, fileItem.name), fileItem, string, oemToken, requestOptions);
        }
    }

    private void download(File file, ListTemporaryFilesResponse.FileItem fileItem, String string, OemToken oemToken, RequestOptions requestOptions) throws DriverError {
        DownloadTemporaryFileRequest downloadTemporaryFileRequest = new DownloadTemporaryFileRequest();
        downloadTemporaryFileRequest.setSessionId(string);
        downloadTemporaryFileRequest.setFileHandle(fileItem.fileHandle);
        this.download(file, downloadTemporaryFileRequest, oemToken, requestOptions);
        if (fileItem.size <= 0L || file.length() != fileItem.size) {
            // empty if block
        }
    }

    protected OemToken getOemLicenseToken(String string, RequestOptions requestOptions) throws DriverError {
        GetOemLicenseTokenChallengeRequest getOemLicenseTokenChallengeRequest = new GetOemLicenseTokenChallengeRequest();
        getOemLicenseTokenChallengeRequest.setOemToken(string);
        Response response = this.call(getOemLicenseTokenChallengeRequest, null, requestOptions);
        if (response instanceof GetOemLicenseTokenChallengeResponse) {
            GetOemLicenseTokenRequest getOemLicenseTokenRequest = new GetOemLicenseTokenRequest();
            getOemLicenseTokenRequest.setOemToken(string);
            getOemLicenseTokenRequest.setOemChallenge(OemTokenChallenge.generateOemTokenChallengeResponse(string, ((GetOemLicenseTokenChallengeResponse)response).getOemChallenge()));
            Response response2 = this.call(getOemLicenseTokenRequest, null, requestOptions);
            if (response2 instanceof GetOemLicenseTokenResponse) {
                OemToken oemToken = new OemToken(string);
                oemToken.setTempToken(((GetOemLicenseTokenResponse)response2).getTempToken());
                return oemToken;
            }
        }
        return null;
    }
}

