/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl.remote;

import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbSession;
import MITI.mimb.driver.RequestOptions;
import MITI.mimb.driver.impl.remote.MimbClient;
import MITI.mimb.driver.impl.remote.MimbFile;
import MITI.mimb.driver.impl.remote.OemToken;
import MITI.mimb.driver.impl.remote.RemoteClientProcess;
import MITI.mimb.driver.impl.remote.RemoteFile;
import MITI.mimb.log.MimbLog;
import MITI.mimb.log.MimbLogEvent;
import MITI.mimb.message.Response;
import MITI.mimb.message.file.request.ListTemporaryFilesRequest;
import MITI.mimb.message.file.response.ListTemporaryFilesResponse;
import MITI.mimb.message.mimb.request.GetMimbExecutionStatusRequest;
import MITI.mimb.message.mimb.response.GetMimbExecutionStatusResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.LinkedBlockingDeque;

public class GenericOperationProcess
extends RemoteClientProcess {
    private static File NULL_FILE = new File("__null__");
    private MimbFile operationDir;
    private LinkedBlockingDeque<File> files;

    GenericOperationProcess(MimbClient mimbClient, MimbSession mimbSession, MimbFile mimbFile, MimbLog mimbLog, OemToken oemToken, RequestOptions requestOptions) {
        super(mimbClient, mimbSession, mimbLog, oemToken, requestOptions);
        this.operationDir = mimbFile;
        this.files = new LinkedBlockingDeque();
    }

    protected File getFile() {
        File file = null;
        try {
            file = this.files.take();
            if (file == NULL_FILE) {
                file = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean runInternal() {
        boolean bl = false;
        try {
            GetMimbExecutionStatusRequest getMimbExecutionStatusRequest = new GetMimbExecutionStatusRequest();
            getMimbExecutionStatusRequest.setSessionId(this.getSession().getSessionId());
            getMimbExecutionStatusRequest.setMaxLogLines(this.getLog() != null ? this.getLog().getLineCount() : 0);
            boolean bl2 = true;
            while (bl2) {
                try {
                    Response response = this.call(getMimbExecutionStatusRequest);
                    if (response instanceof GetMimbExecutionStatusResponse) {
                        GetMimbExecutionStatusResponse getMimbExecutionStatusResponse = (GetMimbExecutionStatusResponse)response;
                        if (!getMimbExecutionStatusResponse.isRunning()) {
                            bl = getMimbExecutionStatusResponse.isSuccessful();
                            boolean bl3 = bl2 = this.getLog() != null ? getMimbExecutionStatusResponse.isHasMoreLines() : false;
                        }
                        if (this.getLog() != null) {
                            for (MimbLogEvent mimbLogEvent : getMimbExecutionStatusResponse.getLogEvents()) {
                                this.getLog().printEvent(mimbLogEvent);
                            }
                        }
                        if (this.operationDir != null) {
                            ListTemporaryFilesRequest listTemporaryFilesRequest = new ListTemporaryFilesRequest();
                            listTemporaryFilesRequest.setSessionId(this.getSession().getSessionId());
                            listTemporaryFilesRequest.setFileHandle(this.operationDir.getRemoteFile().getHandle());
                            Response response2 = this.call(listTemporaryFilesRequest);
                            if (response2 instanceof ListTemporaryFilesResponse) {
                                for (ListTemporaryFilesResponse.FileItem fileItem : ((ListTemporaryFilesResponse)response2).getFiles()) {
                                    if (fileItem.isDirectory || fileItem.name.endsWith(".tmp")) continue;
                                    File file = File.createTempFile("op-" + this.getSession().getSessionId(), ".tmp");
                                    File file2 = new File(this.operationDir.getLocalFile().getFile(), fileItem.name);
                                    RemoteFile remoteFile = new RemoteFile(fileItem.fileHandle, fileItem.isDirectory);
                                    this.download(file, remoteFile);
                                    this.delete(remoteFile);
                                    Files.move(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                    this.files.add(file2);
                                }
                            }
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (DriverError | IOException exception) {
                    exception.printStackTrace();
                }
                bl2 = false;
                break;
            }
            this.files.add(NULL_FILE);
        }
        finally {
            if (this.operationDir != null) {
                try {
                    this.delete(this.operationDir.getRemoteFile());
                }
                catch (DriverError driverError) {}
            }
        }
        return bl;
    }
}

