/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl.local;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class ProcessMonitor
implements Runnable {
    private File file;
    private Thread t;
    private boolean stopped;

    private ProcessMonitor() {
    }

    public static ProcessMonitor create() {
        ProcessMonitor processMonitor = new ProcessMonitor();
        try {
            processMonitor.file = Files.createTempFile("shutdown", "pid", new FileAttribute[0]).toFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return processMonitor;
    }

    public String getPath() {
        return this.file != null ? this.file.getAbsolutePath() : "";
    }

    public void start() {
        if (this.file != null && this.t == null) {
            this.t = new Thread(this);
            this.t.setDaemon(true);
            this.t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        ProcessMonitor processMonitor = this;
        synchronized (processMonitor) {
            this.stopped = true;
            this.notifyAll();
        }
    }

    public void stop() {
        if (this.t != null) {
            this.t.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (FileChannel fileChannel = new RandomAccessFile(this.file, "rw").getChannel();){
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 8L);
            ProcessMonitor processMonitor = this;
            synchronized (processMonitor) {
                while (!this.stopped) {
                    this.wait();
                }
            }
            mappedByteBuffer.put(0, (byte)1);
            Thread.sleep(5000L);
        }
        catch (IOException | InterruptedException exception) {
        }
        finally {
            try {
                while (!this.file.delete()) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

