/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl.local;

import MITI.mimb.driver.DriverError;
import MITI.mimb.log.MimbLog;
import MITI.mimb.log.MimbLogEvent;
import MITI.mimb.message.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class MimbLogOutputStream
extends PrintStream {
    private static final int PROCESSING_HEADER = 1;
    private static final int PROCESSING_TEXT = 2;
    private static final int PROCESSING_XML = 3;
    private static final String MIR_LOG_EVENT_HEADER_START = "<!-- MIRLog size=";
    private static final String MIR_LOG_EVENT_HEADER_END = " -->";
    private static final int MIR_LOG_EVENT_HEADER_SIZE_LEN = 8;
    private static final int MIR_LOG_EVENT_HEADER_TOTAL_LEN = "<!-- MIRLog size=".length() + 8 + " -->".length();
    private StringBuilder buffer = new StringBuilder();
    private int state = 1;
    private int bytesToProcess = 0;
    private MimbLog log;

    protected MimbLogOutputStream(MimbLog mimbLog) {
        super(new ByteArrayOutputStream());
        this.log = mimbLog;
    }

    @Override
    public void close() {
        while (this.buffer.length() > 0) {
            this.state = 2;
            this.print('\n');
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void print(char c) {
        if (this.state == 1) {
            if (this.buffer.length() < MIR_LOG_EVENT_HEADER_START.length() && c != MIR_LOG_EVENT_HEADER_START.charAt(this.buffer.length())) {
                this.state = 2;
            } else {
                this.buffer.append(c);
                if (this.buffer.length() > MIR_LOG_EVENT_HEADER_START.length() && this.buffer.length() < MIR_LOG_EVENT_HEADER_START.length() + 8) {
                    int n = c - 48;
                    if (n >= 0 && n <= 9) {
                        this.bytesToProcess = this.bytesToProcess * 10 + n;
                    }
                } else if (this.buffer.length() == MIR_LOG_EVENT_HEADER_TOTAL_LEN) {
                    this.buffer.setLength(0);
                    this.state = 3;
                }
            }
        } else if (this.state == 3) {
            this.buffer.append(c);
            String string = this.buffer.toString();
            if (this.getByteLength(string) == this.bytesToProcess) {
                MimbLogEvent mimbLogEvent = new MimbLogEvent(string);
                try {
                    mimbLogEvent.parseXml(XmlUtil.parse(string));
                }
                catch (DriverError driverError) {
                    // empty catch block
                }
                this.log.printEvent(mimbLogEvent);
                this.reset();
            }
        }
        if (this.state == 2) {
            if (c == '\n') {
                if (this.buffer.length() > 0) {
                    MimbLogEvent mimbLogEvent = new MimbLogEvent(this.buffer.toString());
                    this.log.printEvent(mimbLogEvent);
                }
                this.reset();
            } else if (c != '\r') {
                this.buffer.append(c);
            }
        }
    }

    private int getByteLength(String string) {
        try {
            return string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.length();
        }
    }

    private void reset() {
        this.state = 1;
        this.bytesToProcess = 0;
        this.buffer.setLength(0);
    }
}

