/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl.local;

import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbSession;
import MITI.mimb.driver.RequestOptions;
import MITI.mimb.driver.impl.MimbDriverImpl;
import MITI.mimb.driver.impl.local.LocalMimbProcess;
import MITI.mimb.log.MimbLog;
import MITI.mimb.message.mimb.request.MimbRequest;
import MITI.mimb.message.mimb.request.StartMimbRequest;
import MITI.mimb.message.mimb.response.MimbResponse;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;

public class LocalMimbDriver
extends MimbDriverImpl {
    private File mimbHome;
    private String oemPartnerToken;
    private AtomicInteger pid;

    public LocalMimbDriver(File file, String string) throws DriverError {
        this.mimbHome = file;
        this.oemPartnerToken = string;
        this.pid = new AtomicInteger(0);
        if (!LocalMimbProcess.getFile(file).isFile()) {
            throw new DriverError("Invalid MIMB home directory");
        }
    }

    @Override
    protected MimbResponse run(MimbRequest mimbRequest, RequestOptions requestOptions) throws DriverError {
        LocalMimbProcess localMimbProcess = new LocalMimbProcess(this.mimbHome, this.oemPartnerToken, mimbRequest, this.createSession(), null, requestOptions.getTroubleShootingDirectory());
        localMimbProcess.run();
        return localMimbProcess.getResponse();
    }

    @Override
    protected LocalMimbProcess createSession(StartMimbRequest startMimbRequest, RequestOptions requestOptions, MimbLog mimbLog) throws DriverError {
        return new LocalMimbProcess(this.mimbHome, this.oemPartnerToken, startMimbRequest, this.createSession(), mimbLog, requestOptions.getTroubleShootingDirectory());
    }

    private MimbSession createSession() {
        return new MimbSession("MIMB-" + String.valueOf(this.pid.incrementAndGet()));
    }
}

