/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl;

import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbSession;
import MITI.mimb.driver.MimbStatus;
import MITI.mimb.log.MimbLog;

public abstract class MimbProcess
implements Runnable {
    private MimbSession session;
    private MimbLog log;
    private Thread thread;
    private MimbStatus status = MimbStatus.INVALID;

    protected MimbProcess(MimbSession mimbSession, MimbLog mimbLog) {
        this.session = mimbSession;
        this.log = mimbLog;
    }

    public MimbSession getSession() {
        return this.session;
    }

    public MimbLog getLog() {
        return this.log;
    }

    public MimbStatus getStatus() throws DriverError {
        return this.status;
    }

    public MimbSession start() throws DriverError {
        this.thread = new Thread(this);
        this.status = MimbStatus.RUNNING;
        this.thread.start();
        return this.session;
    }

    public void stop() throws DriverError {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void waitFor() throws DriverError {
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            this.stop();
        }
    }

    @Override
    public void run() {
        this.status = MimbStatus.RUNNING;
        try {
            boolean bl = this.runInternal();
            this.status = bl ? MimbStatus.SUCCESS : MimbStatus.ERROR;
        }
        catch (Exception exception) {
            this.status = MimbStatus.ERROR;
        }
    }

    protected abstract boolean runInternal();
}

