/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sdw;

import com.sas.sdw.ErrorMessageCode;
import com.sas.sdw.SDWException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDWLocalizedException
extends SDWException {
    private static Logger logger = LogManager.getLogger(SDWLocalizedException.class);
    private ErrorMessageCode msgCode;
    private String locale;
    private String arg1;
    private String arg2;
    private String arg3;
    private String arg4;

    public SDWLocalizedException(String message, Throwable cause) {
        super(message, cause);
    }

    public SDWLocalizedException(String message) {
        super(message);
    }

    public SDWLocalizedException(ErrorMessageCode msgCode) {
        this.msgCode = msgCode;
    }

    public SDWLocalizedException(ErrorMessageCode msgCode, Throwable cause) {
        super(cause);
        this.msgCode = msgCode;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setMessageArg1(String arg) {
        this.arg1 = arg;
    }

    public void setMessageArg2(String arg) {
        this.arg2 = arg;
    }

    public void setMessageArg3(String arg) {
        this.arg3 = arg;
    }

    public void setMessageArg4(String arg) {
        this.arg4 = arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage() {
        String message = null;
        if (this.msgCode != null) {
            String localeErrorMessageFile = "/${locale}/ErrorMessages.properties";
            String enErrorMessageFile = "/en/ErrorMessages.properties";
            ArrayList<String> errorMessageFiles = new ArrayList<String>();
            if (this.locale != null) {
                errorMessageFiles.add(localeErrorMessageFile);
            }
            if (localeErrorMessageFile != enErrorMessageFile) {
                errorMessageFiles.add(enErrorMessageFile);
            }
            for (String errorMessageFile : errorMessageFiles) {
                InputStream is = null;
                try {
                    is = this.getClass().getResourceAsStream(errorMessageFile);
                    if (is != null) {
                        Properties messages = new Properties();
                        messages.load(is);
                        message = messages.getProperty(this.msgCode.toString());
                        if (message != null) break;
                        continue;
                    }
                    logger.info("${errorMessageFile} does not exist.");
                }
                catch (IOException ioe) {
                    logger.warn("Failed to load error message property file: ${errorMessageFile}");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    ioe.printStackTrace(pw);
                    pw.flush();
                    sw.flush();
                    logger.warn(sw.toString());
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (message == null) {
                logger.error("No message found for code: " + this.msgCode);
            }
        }
        if (message != null) {
            logger.debug("format: $message arg1: $arg1");
            Formatter f = new Formatter();
            f.format(message, this.arg1, this.arg2, this.arg3, this.arg4);
            return f.toString();
        }
        return super.getMessage();
    }
}

