/*
 * Decompiled with CFR 0.152.
 */
package com.sas.appserver.vfabrictcsvr;

import com.sas.appserver.utils.AppServerConstants;
import com.sas.appserver.utils.ConfigFileAccessHelper;
import com.sas.appserver.utils.ContainerType;
import com.sas.appserver.utils.OsType;
import com.sas.appserver.utils.PlatformCode;
import com.sas.appserver.utils.ResourceManagerImpl;
import com.sas.appserver.utils.ResourceType;
import com.sas.appserver.utils.XmlHelper;
import com.sas.appserver.vfabrcersvrc.WebServerConstants;
import com.sas.appserver.vfabrictcsvr.GlobalResource;
import com.sas.appserver.vfabrictcsvr.PropertyFile;
import com.sas.appserver.vfabrictcsvr.TCServerHelper;
import com.sas.sdw.SDW;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class FIPSConfiguration
implements GroovyObject {
    private SDW sdw;
    private TCServerHelper tcHelper;
    private GlobalResource globalResource;
    private OsType serverOsType;
    private PlatformCode platformCode;
    private PropertyFile remoteProperties;
    private File webServerInstanceDir;
    private File webServerInstallDir;
    private static Logger logger;
    private static final String LINE_SEPARATOR;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public FIPSConfiguration(SDW sdw) throws IllegalArgumentException, IllegalStateException {
        SDW sDW;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (ScriptBytecodeAdapter.compareEqual((Object)sdw, null)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "The SDW argument cannot be null"));
        }
        CallSite resourceManager = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResourceManagerImpl.class, sdw, IndyInterface.bootstrap("getProperty", "TC_SERVER", 0, ContainerType.class)));
        IndyInterface.bootstrap("invoke", "loadResources", 0, resourceManager, true);
        this.sdw = sDW = sdw;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, TCServerHelper.class, sdw);
        this.tcHelper = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getResource", 0, resourceManager, IndyInterface.bootstrap("getProperty", "GLOBAL", 0, ResourceType.class));
        this.globalResource = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "getOsType", 0, this.globalResource);
        this.serverOsType = IndyInterface.bootstrap("cast", "()", 0, callSite3);
        CallSite callSite4 = IndyInterface.bootstrap("invoke", "parse", 0, PlatformCode.class, IndyInterface.bootstrap("invoke", "getPropertyAsString", 0, this.tcHelper, IndyInterface.bootstrap("getProperty", "OS_LOCALHOST_MACHINE_TYPE", 0, AppServerConstants.class)));
        this.platformCode = IndyInterface.bootstrap("cast", "()", 0, callSite4);
        IndyInterface.bootstrap("invoke", "setFIPSWebServerInstanceDir", 2, this);
        IndyInterface.bootstrap("invoke", "setFIPSWebServerInstallDir", 2, this);
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toString", 0, this.serverOsType)}, new String[]{"OS Type is \"", "\""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toString", 0, this.platformCode)}, new String[]{"Platform code is \"", "\""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getWebServerInstanceDir", 2, this))}, new String[]{"Web server instance dir = ", ""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getWebServerInstallDir", 2, this))}, new String[]{"Web server install dir = ", ""}));
    }

    private final void initRemoteProperties() throws FileNotFoundException {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "initRemoteProperties >>>");
        if (ScriptBytecodeAdapter.compareEqual((Object)this.remoteProperties, null)) {
            CallSite webCommonDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getConfigLevWebDir", 0, this.globalResource), "Common"));
            CallSite remoteCfgFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, webCommonDir, "sas-remote.cfg"));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, remoteCfgFile)) == false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, FileNotFoundException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, remoteCfgFile)}, new String[]{"Remote configuration file not found: ", ""})));
            }
            CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, PropertyFile.class);
            this.remoteProperties = IndyInterface.bootstrap("cast", "()", 0, callSite);
            IndyInterface.bootstrap("invoke", "loadProperties", 0, this.remoteProperties, remoteCfgFile);
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "initRemoteProperties <<<");
    }

    private final void setFIPSWebServerInstanceDir() throws IllegalStateException {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "setFIPSWebServerInstanceDir >>>");
        CallSite callSite = IndyInterface.bootstrap("invoke", "getPropertyAsFile", 0, this.tcHelper, IndyInterface.bootstrap("getProperty", "WEBSERVER_INSTANCE_DIR", 0, AppServerConstants.class));
        this.webServerInstanceDir = IndyInterface.bootstrap("cast", "()", 0, callSite);
        if (ScriptBytecodeAdapter.compareEqual((Object)this.webServerInstanceDir, null)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.remoteProperties, null)) {
                IndyInterface.bootstrap("invoke", "initRemoteProperties", 2, this);
            }
            CallSite remoteDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getProperty", 0, this.remoteProperties, "SASWebServerRemoteConfig")));
            if (ScriptBytecodeAdapter.compareEqual((Object)remoteDir, null) || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, remoteDir)) == false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, remoteDir)}, new String[]{"Remote configuration directory not found: ", ""})));
            }
            CallSite callSite2 = remoteDir;
            this.webServerInstanceDir = callSite2;
            IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{remoteDir}, new String[]{"setFIPSWebServerInstanceDir: remoteDir = ", ""}));
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "setFIPSWebServerInstanceDir <<<");
    }

    private final void setFIPSWebServerInstallDir() throws IllegalStateException {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "setFIPSWebServerInstallDir >>>");
        CallSite callSite = IndyInterface.bootstrap("invoke", "getPropertyAsFile", 0, this.tcHelper, IndyInterface.bootstrap("getProperty", "WEBSERVER_INSTALL_DIR", 0, AppServerConstants.class));
        this.webServerInstallDir = IndyInterface.bootstrap("cast", "()", 0, callSite);
        if (ScriptBytecodeAdapter.compareEqual((Object)this.webServerInstallDir, null)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.remoteProperties, null)) {
                IndyInterface.bootstrap("invoke", "initRemoteProperties", 2, this);
            }
            CallSite remoteDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getProperty", 0, this.remoteProperties, "SASWebServerRemoteHome")));
            if (ScriptBytecodeAdapter.compareEqual((Object)remoteDir, null) || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, remoteDir)) == false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, remoteDir)}, new String[]{"Remote configuration directory not found: ", ""})));
            }
            CallSite callSite2 = remoteDir;
            this.webServerInstallDir = callSite2;
            IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{remoteDir}, new String[]{"setFIPSWebServerInstallDir: remoteDir = ", ""}));
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "setFIPSWebServerInstallDir <<<");
    }

    private File getWebServerInstanceDir() {
        return this.webServerInstanceDir;
    }

    private File getWebServerInstallDir() {
        return this.webServerInstallDir;
    }

    private String getApacheVersion() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getPropertyAsString", 0, this.tcHelper, IndyInterface.bootstrap("getProperty", "APACHE_VERSION", 0, WebServerConstants.class)));
    }

    private String getHttpdVersion() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, String.class, IndyInterface.bootstrap("invoke", "plus", 0, "httpd-", IndyInterface.bootstrap("invoke", "getApacheVersion", 2, this))));
    }

    private File getOpenSSLConfigFile() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getWebServerInstanceDir", 2, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "separator", 0, File.class), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)}, new String[]{"conf", "extra", "openssl.cnf"})));
    }

    private File getOpenSSLFipsConfigFile() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getWebServerInstanceDir", 2, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "separator", 0, File.class), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)}, new String[]{"conf", "extra", "fipsmodule.cnf"})));
    }

    private File getWebServerInstallBinDir() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getWebServerInstallDir", 2, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getHttpdVersion", 2, this), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)}, new String[]{"", "", "bin"})));
    }

    private File getWebServerInstallLibDir() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getWebServerInstallDir", 2, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getHttpdVersion", 2, this), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)}, new String[]{"", "", "lib"})));
    }

    private File getFIPSProviderModuleDir() {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.serverOsType, (Object)IndyInterface.bootstrap("getProperty", "UNIX", 0, OsType.class))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getWebServerInstallLibDir", 2, this), "ossl-modules"));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getWebServerInstallBinDir", 2, this));
    }

    private void testGetMethods() {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "testGetMethods >>>");
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getWebServerInstanceDir", 2, this))}, new String[]{"getWebServerInstanceDir = ", ""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getWebServerInstallDir", 2, this))}, new String[]{"getWebServerInstallDir = ", ""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getApacheVersion", 2, this)}, new String[]{"getApacheVersion = ", ""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getHttpdVersion", 2, this)}, new String[]{"getHttpdVersion = ", ""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getOpenSSLConfigFile", 2, this))}, new String[]{"getOpenSSLConfigFile = ", ""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getOpenSSLFipsConfigFile", 2, this))}, new String[]{"getOpenSSLFipsConfigFile = ", ""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getWebServerInstallBinDir", 2, this))}, new String[]{"getWebServerInstallBinDir = ", ""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getWebServerInstallLibDir", 2, this))}, new String[]{"getWebServerInstallLibDir = ", ""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getFIPSProviderModuleDir", 2, this))}, new String[]{"getFIPSProviderModuleDir = ", ""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, "testGetMethods <<<");
    }

    private static void restoreFIPSServerConfig(File backupServerXmlFile, File currentServerXmlFile) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "restoreFIPSServerConfig >>>");
        CallSite backupXmlHelper = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlHelper.class));
        IndyInterface.bootstrap("invoke", "parse", 0, backupXmlHelper, backupServerXmlFile);
        CallSite currentXmlHelper = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlHelper.class));
        IndyInterface.bootstrap("invoke", "parse", 0, currentXmlHelper, currentServerXmlFile);
        CallSite fipsListener = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findNode", 0, currentXmlHelper, "/Server/Listener[@FIPSMode='on']"));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)fipsListener, null)) {
            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "FIPS Listener element already in ", IndyInterface.bootstrap("invoke", "getPath", 0, currentServerXmlFile)));
        } else {
            fipsListener = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findNode", 0, backupXmlHelper, "/Server/Listener[@FIPSMode='on']"));
            if (ScriptBytecodeAdapter.compareEqual((Object)fipsListener, null)) {
                IndyInterface.bootstrap("invoke", "error", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Failed to find a FIPS Listener element in ", IndyInterface.bootstrap("invoke", "getPath", 0, backupServerXmlFile)));
            } else {
                CallSite serverElement = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findNode", 0, currentXmlHelper, "/Server"));
                if (ScriptBytecodeAdapter.compareEqual((Object)serverElement, null)) {
                    IndyInterface.bootstrap("invoke", "error", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Failed to find a Server element in ", IndyInterface.bootstrap("invoke", "getPath", 0, currentServerXmlFile)));
                } else {
                    CallSite currentServerXmlDocument = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getXmlDocument", 0, currentXmlHelper));
                    CallSite fipsListenerAdopted = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "importNode", 0, currentServerXmlDocument, fipsListener, true));
                    IndyInterface.bootstrap("invoke", "appendChildElement", 0, currentXmlHelper, serverElement, fipsListenerAdopted);
                    IndyInterface.bootstrap("invoke", "write", 0, currentXmlHelper, currentServerXmlFile);
                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "FIPS Listener element added to Server element in ", IndyInterface.bootstrap("invoke", "getPath", 0, currentServerXmlFile)));
                }
            }
            CallSite copyFIPSAttributeList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
            String[] attr = new String[2];
            attr = new String[2];
            String string = "/Server/Service[@name='Catalina']/Connector";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, false, string);
            String string2 = "SSLCertificateFile";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, true, string2);
            IndyInterface.bootstrap("invoke", "add", 0, copyFIPSAttributeList, attr);
            attr = new String[2];
            String string3 = "/Server/Service[@name='Catalina']/Connector";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, false, string3);
            String string4 = "SSLCertificateKeyFile";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, true, string4);
            IndyInterface.bootstrap("invoke", "add", 0, copyFIPSAttributeList, attr);
            attr = new String[2];
            String string5 = "/Server/Service[@name='Catalina']/Connector";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, false, string5);
            String string6 = "SSLCertificateChainFile";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, true, string6);
            IndyInterface.bootstrap("invoke", "add", 0, copyFIPSAttributeList, attr);
            attr = new String[2];
            String string7 = "/Server/Service[@name='Catalina']/Connector";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, false, string7);
            String string8 = "SSLPassword";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, true, string8);
            IndyInterface.bootstrap("invoke", "add", 0, copyFIPSAttributeList, attr);
            attr = new String[2];
            String string9 = "/Server/Service[@name='Catalina']/Connector";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, false, string9);
            String string10 = "address";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, true, string10);
            IndyInterface.bootstrap("invoke", "add", 0, copyFIPSAttributeList, attr);
            attr = new String[2];
            String string11 = "/Server/Service[@name='Catalina']/Connector/SSLHostConfig/Certificate";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, false, string11);
            String string12 = "certificateFile";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, true, string12);
            IndyInterface.bootstrap("invoke", "add", 0, copyFIPSAttributeList, attr);
            attr = new String[2];
            String string13 = "/Server/Service[@name='Catalina']/Connector/SSLHostConfig/Certificate";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, false, string13);
            String string14 = "certificateKeyFile";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, true, string14);
            IndyInterface.bootstrap("invoke", "add", 0, copyFIPSAttributeList, attr);
            attr = new String[2];
            String string15 = "/Server/Service[@name='Catalina']/Connector/SSLHostConfig/Certificate";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, false, string15);
            String string16 = "certificateChainFile";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, true, string16);
            IndyInterface.bootstrap("invoke", "add", 0, copyFIPSAttributeList, attr);
            attr = new String[2];
            String string17 = "/Server/Service[@name='Catalina']/Connector/SSLHostConfig/Certificate";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, false, string17);
            String string18 = "certificateKeyPassword";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, true, string18);
            IndyInterface.bootstrap("invoke", "add", 0, copyFIPSAttributeList, attr);
            CallSite updateFIPSAttributeList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
            attr = new String[3];
            String string19 = "/Server/Service[@name='Catalina']/Connector";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, false, string19);
            String string20 = "protocol";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, true, string20);
            String string21 = "org.apache.coyote.http11.Http11NioProtocol";
            IndyInterface.bootstrap("invoke", "putAt", 0, attr, 2, string21);
            IndyInterface.bootstrap("invoke", "add", 0, updateFIPSAttributeList, attr);
            IndyInterface.bootstrap("invoke", "updateServerXml", 0, ConfigFileAccessHelper.class, backupServerXmlFile, currentServerXmlFile, copyFIPSAttributeList, updateFIPSAttributeList);
            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Connector element in ", IndyInterface.bootstrap("invoke", "getPath", 0, currentServerXmlFile)), " updated with FIPS attributes from "), IndyInterface.bootstrap("invoke", "getPath", 0, backupServerXmlFile)));
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "restoreFIPSServerConfig <<<");
    }

    private static void restoreFIPSServerScript(File backupCtlScriptFile, File currentCtlScriptFile, String targetKeyword) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "restoreFIPSServerScript >>>");
        CallSite backupScriptLines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "getText", 0, backupCtlScriptFile), "\n"));
        CallSite currentScriptLines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "getText", 0, currentCtlScriptFile), "\n"));
        CallSite libPathLine = null;
        CallSite libExportLine = null;
        int i = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("getProperty", "length", 0, currentScriptLines)) && (ScriptBytecodeAdapter.compareEqual(libPathLine, null) || ScriptBytecodeAdapter.compareEqual(libExportLine, null))) {
            if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, currentScriptLines, i), (Object)new GStringImpl(new Object[]{targetKeyword}, new String[]{"^\\s*", "\\s*=.*"}))) != false) {
                libPathLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, currentScriptLines, i));
            } else if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, currentScriptLines, i), (Object)new GStringImpl(new Object[]{targetKeyword}, new String[]{"^\\s*export\\s*", ".*"}))) != false) {
                libExportLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, currentScriptLines, i));
            }
            int n = i;
            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        if (ScriptBytecodeAdapter.compareNotEqual(libPathLine, null) || ScriptBytecodeAdapter.compareNotEqual(libExportLine, null)) {
            CallSite libPath = ScriptBytecodeAdapter.compareNotEqual(libPathLine, null) ? libPathLine : libExportLine;
            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "LOAD-LIBRARY-PATH statement for FIPS is already in ", IndyInterface.bootstrap("invoke", "getPath", 0, currentCtlScriptFile)), ": "), libPath));
        } else {
            int i2 = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i2, (Object)IndyInterface.bootstrap("getProperty", "length", 0, backupScriptLines)) && (ScriptBytecodeAdapter.compareEqual(libPathLine, null) || ScriptBytecodeAdapter.compareEqual(libExportLine, null))) {
                if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, backupScriptLines, i2), (Object)new GStringImpl(new Object[]{targetKeyword}, new String[]{"^\\s*", "\\s*=.*"}))) != false) {
                    libPathLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, backupScriptLines, i2));
                } else if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, backupScriptLines, i2), (Object)new GStringImpl(new Object[]{targetKeyword}, new String[]{"^\\s*export\\s*", ".*"}))) != false) {
                    libExportLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, backupScriptLines, i2));
                }
                int n = i2;
                i2 = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            }
            if (ScriptBytecodeAdapter.compareEqual(libPathLine, null) || ScriptBytecodeAdapter.compareEqual(libExportLine, null)) {
                IndyInterface.bootstrap("invoke", "error", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Export of LOAD-LIBRARY-PATH for FIPS not found in ", IndyInterface.bootstrap("invoke", "getPath", 0, backupCtlScriptFile)));
            } else {
                CallSite newCtlScriptContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
                int lineNumber = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)lineNumber, (Object)IndyInterface.bootstrap("getProperty", "length", 0, currentScriptLines)) && DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, currentScriptLines, lineNumber), (Object)"^\\s*$|^\\s*#.*"))) {
                    IndyInterface.bootstrap("invoke", "append", 0, newCtlScriptContent, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getAt", 0, currentScriptLines, lineNumber), LINE_SEPARATOR));
                    int n = lineNumber;
                    lineNumber = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                }
                libPathLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, libPathLine, "httpd-2.2", "httpd-2.4"));
                IndyInterface.bootstrap("invoke", "append", 0, newCtlScriptContent, IndyInterface.bootstrap("invoke", "plus", 0, libPathLine, LINE_SEPARATOR));
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Added LOAD-LIBRARY-PATH statement for FIPS to ", IndyInterface.bootstrap("invoke", "getPath", 0, currentCtlScriptFile)), ": "), libPathLine));
                IndyInterface.bootstrap("invoke", "append", 0, newCtlScriptContent, IndyInterface.bootstrap("invoke", "plus", 0, libExportLine, LINE_SEPARATOR));
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Added EXPORT statement for FIPS to ", IndyInterface.bootstrap("invoke", "getPath", 0, currentCtlScriptFile)), ": "), libExportLine));
                IndyInterface.bootstrap("invoke", "append", 0, newCtlScriptContent, LINE_SEPARATOR);
                while (ScriptBytecodeAdapter.compareLessThan((Object)lineNumber, (Object)IndyInterface.bootstrap("getProperty", "length", 0, currentScriptLines))) {
                    IndyInterface.bootstrap("invoke", "append", 0, newCtlScriptContent, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getAt", 0, currentScriptLines, lineNumber), LINE_SEPARATOR));
                    int n = lineNumber;
                    lineNumber = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                }
                IndyInterface.bootstrap("invoke", "write", 0, currentCtlScriptFile, IndyInterface.bootstrap("invoke", "toString", 0, newCtlScriptContent));
            }
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "restoreFIPSServerScript <<<");
    }

    private void UpdateServerEnvScript(String cloneName) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "UpdateServerEnvScript >>>");
        CallSite setEnvFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSetEnvFile", 0, this.globalResource, cloneName));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = setEnvFile;
            valueRecorder.record((Object)callSite, 8);
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "exists", 0, callSite);
            valueRecorder.record((Object)callSite2, 19);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite2) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert setEnvFile.exists()", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, setEnvFile)}, new String[]{"Updating OpenSSL configuration in ", ""}));
        IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "setenv file before update: \n", IndyInterface.bootstrap("invoke", "getText", 0, setEnvFile)));
        CallSite lineList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "getText", 0, setEnvFile), "\r", ""), "\n"));
        CallSite newFileContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuffer.class));
        String envDefPrefix = ScriptBytecodeAdapter.compareEqual((Object)this.serverOsType, (Object)IndyInterface.bootstrap("getProperty", "UNIX", 0, OsType.class)) ? "export" : "set";
        CallSite sslConfigVar = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getOpenSSLConfigFile", 2, this))}, new String[]{"OPENSSL_CONF=", ""}));
        CallSite sslModulesVar = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getFIPSProviderModuleDir", 2, this))}, new String[]{"OPENSSL_MODULES=", ""}));
        boolean updatedConfigVar = false;
        boolean updatedModulesVar = false;
        sslConfigVar = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replace", 0, sslConfigVar, "\\", "/"));
        sslModulesVar = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replace", 0, sslModulesVar, "\\", "/"));
        Object line = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, lineList));
        if (callSite != null) {
            while (callSite.hasNext()) {
                line = callSite.next();
                if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex(line, (Object)new GStringImpl(new Object[]{envDefPrefix}, new String[]{"(?i)^\\s*", "\\s*OPENSSL_CONF\\s*="}))) != false) {
                    IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{line}, new String[]{"Found OPENSSL_CONF definition: ", ""}));
                    IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, envDefPrefix, " "), sslConfigVar), LINE_SEPARATOR));
                    IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{sslConfigVar}, new String[]{"Updated OPENSSL_CONF definition to: ", ""}));
                    updatedConfigVar = true;
                    continue;
                }
                if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex(line, (Object)new GStringImpl(new Object[]{envDefPrefix}, new String[]{"(?i)^\\s*", "\\s*OPENSSL_MODULES\\s*="}))) != false) {
                    IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{line}, new String[]{"Found OPENSSL_MODULES definition: ", ""}));
                    IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, envDefPrefix, " "), sslModulesVar), LINE_SEPARATOR));
                    IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{sslModulesVar}, new String[]{"Updated OPENSSL_MODULES definition to: ", ""}));
                    updatedModulesVar = true;
                    continue;
                }
                IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, line, LINE_SEPARATOR));
            }
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)updatedConfigVar, (Object)false)) {
            IndyInterface.bootstrap("invoke", "info", 0, logger, "No OPENSSL_CONF definition found");
            IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, envDefPrefix, " "), sslConfigVar), LINE_SEPARATOR));
            IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{sslConfigVar}, new String[]{"Added OPENSSL_CONF definition: ", ""}));
            updatedConfigVar = true;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)updatedModulesVar, (Object)false)) {
            IndyInterface.bootstrap("invoke", "info", 0, logger, "No OPENSSL_MODULES definition found");
            IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, envDefPrefix, " "), sslModulesVar), LINE_SEPARATOR));
            IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{sslModulesVar}, new String[]{"Added OPENSSL_MODULES definition: ", ""}));
            updatedModulesVar = true;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.serverOsType, (Object)IndyInterface.bootstrap("getProperty", "UNIX", 0, OsType.class))) {
            lineList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "toString", 0, newFileContent), LINE_SEPARATOR));
            if (ScriptBytecodeAdapter.compareEqual((Object)this.platformCode, (Object)IndyInterface.bootstrap("getProperty", "R64", 0, PlatformCode.class))) {
                newFileContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "addWSLibToLibPath", 2, this, lineList, "LIBPATH"));
            } else if (ScriptBytecodeAdapter.compareNotEqual((Object)this.platformCode, null)) {
                newFileContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "addWSLibToLibPath", 2, this, lineList, "LD_LIBRARY_PATH"));
            } else {
                newFileContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "addWSLibToLibPath", 2, this, lineList, "LIBPATH"));
                lineList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "toString", 0, newFileContent), LINE_SEPARATOR));
                newFileContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "addWSLibToLibPath", 2, this, lineList, "LD_LIBRARY_PATH"));
            }
        }
        IndyInterface.bootstrap("invoke", "write", 0, setEnvFile, IndyInterface.bootstrap("invoke", "toString", 0, newFileContent));
        IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "setenv file after update: \n", IndyInterface.bootstrap("invoke", "getText", 0, setEnvFile)));
        IndyInterface.bootstrap("invoke", "info", 0, logger, "UpdateServerEnvScript <<<");
    }

    private StringBuffer addWSLibToLibPath(String[] lineList, String libVar) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "addWSLibToLibPath >>>");
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            OsType osType = this.serverOsType;
            valueRecorder.record((Object)osType, 15);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "UNIX", 0, OsType.class);
            valueRecorder.record((Object)callSite, 38);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)osType, (Object)callSite);
            valueRecorder.record((Object)bl, 28);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert ( this.serverOsType == OsType.UNIX )", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite newFileContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuffer.class));
        CallSite wsLibPath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getWebServerInstallLibDir", 2, this)));
        boolean updatedLibVar = false;
        CallSite line = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, lineList));
        if (callSite != null) {
            while (callSite.hasNext()) {
                line = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)line, (Object)new GStringImpl(new Object[]{libVar}, new String[]{"(?i)^\\s*(export\\s+)?", "\\s*="}))) != false) {
                    IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{libVar, line}, new String[]{"Found ", " definition: ", ""}));
                    if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)line, (Object)new GStringImpl(new Object[]{wsLibPath}, new String[]{"", ""}))) != false) {
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{libVar, wsLibPath}, new String[]{"", " definition already contains ", ""}));
                        IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, line, LINE_SEPARATOR));
                    } else {
                        CallSite leftSide = null;
                        CallSite libValue = null;
                        CallSite callSite2 = IndyInterface.bootstrap("invoke", "split", 0, line, new GStringImpl(new Object[]{libVar}, new String[]{"(?i)^\\s*(export\\s+)?", "\\s*="}));
                        leftSide = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, callSite2, Integer.valueOf(0)));
                        libValue = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, callSite2, Integer.valueOf(1)));
                        libValue = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "trim", 0, libValue));
                        CallSite newLine = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{libVar, libValue, wsLibPath}, new String[]{"export ", "=", ":", ""}));
                        IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, newLine, LINE_SEPARATOR));
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{libVar, newLine}, new String[]{"Updated ", " definition to: ", ""}));
                    }
                    updatedLibVar = true;
                    continue;
                }
                IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, line, LINE_SEPARATOR));
            }
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)updatedLibVar, (Object)false)) {
            IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{libVar}, new String[]{"No ", " definition found"}));
            IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{libVar, libVar, wsLibPath}, new String[]{"export ", "=$", ":", ""}), LINE_SEPARATOR));
            IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{libVar, libVar, wsLibPath}, new String[]{"Added ", " definition: $", ":", ""}));
            updatedLibVar = true;
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "addWSLibToLibPath <<<");
        return newFileContent;
    }

    private void UpdateWrapperConfig(String cloneName) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "UpdateWrapperConfig >>>");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.serverOsType, (Object)IndyInterface.bootstrap("getProperty", "WINDOWS", 0, OsType.class))) {
            IndyInterface.bootstrap("invoke", "info", 0, logger, "This method is only valid on Windows hosts.  No action taken.");
        } else {
            CallSite wrapperFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getWrapperConfFile", 0, this.globalResource, cloneName));
            ValueRecorder valueRecorder = new ValueRecorder();
            try {
                CallSite callSite = wrapperFile;
                valueRecorder.record((Object)callSite, 8);
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "exists", 0, callSite);
                valueRecorder.record((Object)callSite2, 20);
                if (IndyInterface.bootstrap("cast", "()", 0, callSite2) == false) {
                    throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert wrapperFile.exists()", (ValueRecorder)valueRecorder), null);
                }
                valueRecorder.clear();
            }
            catch (Throwable throwable) {
                valueRecorder.clear();
                throw throwable;
            }
            IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, wrapperFile)}, new String[]{"Updating OpenSSL configuration in ", ""}));
            CallSite wrapperFileContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "getText", 0, wrapperFile), "\r", ""), "\n"));
            CallSite newFileContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuffer.class));
            CallSite sslConfigDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replace", 0, IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getTcServerSSLDir", 0, this.globalResource)), "\\", "\\\\"));
            CallSite sslConfigVar = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getOpenSSLConfigFile", 2, this))}, new String[]{"set.OPENSSL_CONF=\"", "\""}));
            CallSite sslModulesVar = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, IndyInterface.bootstrap("invoke", "getFIPSProviderModuleDir", 2, this))}, new String[]{"set.OPENSSL_MODULES=\"", "\""}));
            boolean updatedConfigVar = false;
            boolean updatedModulesVar = false;
            sslConfigVar = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replace", 0, sslConfigVar, "\\", "/"));
            sslModulesVar = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replace", 0, sslModulesVar, "\\", "/"));
            Object line = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, wrapperFileContent));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    line = callSite.next();
                    if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex(line, (Object)"(?i)^\\s*set\\.OPENSSL_CONF\\s*=")) != false) {
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{line}, new String[]{"Found OPENSSL_CONF definition: ", ""}));
                        IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, sslConfigVar, LINE_SEPARATOR));
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{sslConfigVar}, new String[]{"Updated OPENSSL_CONF definition to: ", ""}));
                        updatedConfigVar = true;
                        continue;
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex(line, (Object)"(?i)^\\s*set\\.OPENSSL_MODULES\\s*=")) != false) {
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{line}, new String[]{"Found OPENSSL_MODULES definition: ", ""}));
                        IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, sslModulesVar, LINE_SEPARATOR));
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{sslModulesVar}, new String[]{"Updated OPENSSL_MODULES definition to: ", ""}));
                        updatedModulesVar = true;
                        continue;
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex(line, (Object)new GStringImpl(new Object[]{sslConfigDir}, new String[]{"(?i)^\\s*set\\.PATH\\s*=\\s*", ""}))) != false) {
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{line}, new String[]{"Found set.PATH defintion: ", ""}));
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{line}, new String[]{"Dropping line: ", ""}));
                        continue;
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex(line, (Object)new GStringImpl(new Object[]{sslConfigDir}, new String[]{"(?i)^\\s*wrapper\\.java\\.library\\.path\\.[0-9]*\\s*=\\s*", ""}))) != false) {
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{line}, new String[]{"Found wrapper.java.library.path defintion: ", ""}));
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{line}, new String[]{"Dropping line: ", ""}));
                        continue;
                    }
                    IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, line, LINE_SEPARATOR));
                }
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)updatedConfigVar, (Object)false)) {
                IndyInterface.bootstrap("invoke", "info", 0, logger, "No OPENSSL_CONF definition found");
                IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, sslConfigVar, LINE_SEPARATOR));
                IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{sslConfigVar}, new String[]{"Added OPENSSL_CONF definition: ", ""}));
                updatedConfigVar = true;
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)updatedModulesVar, (Object)false)) {
                IndyInterface.bootstrap("invoke", "info", 0, logger, "No OPENSSL_MODULES definition found");
                IndyInterface.bootstrap("invoke", "append", 0, newFileContent, IndyInterface.bootstrap("invoke", "plus", 0, sslModulesVar, LINE_SEPARATOR));
                IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{sslModulesVar}, new String[]{"Added OPENSSL_MODULES definition: ", ""}));
                updatedModulesVar = true;
            }
            IndyInterface.bootstrap("invoke", "write", 0, wrapperFile, IndyInterface.bootstrap("invoke", "toString", 0, newFileContent));
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "UpdateWrapperConfig <<<");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FIPSConfiguration.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LogManager.class, FIPSConfiguration.class);
        logger = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getProperty", 0, System.class, "line.separator");
        LINE_SEPARATOR = IndyInterface.bootstrap("cast", "()", 0, callSite2);
    }

    @Generated
    public SDW getSdw() {
        return this.sdw;
    }

    @Generated
    public void setSdw(SDW sDW) {
        this.sdw = sDW;
    }

    @Generated
    public TCServerHelper getTcHelper() {
        return this.tcHelper;
    }

    @Generated
    public void setTcHelper(TCServerHelper tCServerHelper) {
        this.tcHelper = tCServerHelper;
    }

    @Generated
    public GlobalResource getGlobalResource() {
        return this.globalResource;
    }

    @Generated
    public void setGlobalResource(GlobalResource globalResource) {
        this.globalResource = globalResource;
    }

    @Generated
    public OsType getServerOsType() {
        return this.serverOsType;
    }

    @Generated
    public void setServerOsType(OsType osType) {
        this.serverOsType = osType;
    }

    @Generated
    public PlatformCode getPlatformCode() {
        return this.platformCode;
    }

    @Generated
    public void setPlatformCode(PlatformCode platformCode) {
        this.platformCode = platformCode;
    }

    @Generated
    public PropertyFile getRemoteProperties() {
        return this.remoteProperties;
    }

    @Generated
    public void setRemoteProperties(PropertyFile propertyFile) {
        this.remoteProperties = propertyFile;
    }

    @Generated
    public void setWebServerInstanceDir(File file) {
        this.webServerInstanceDir = file;
    }

    @Generated
    public void setWebServerInstallDir(File file) {
        this.webServerInstallDir = file;
    }
}

