/*
 * Decompiled with CFR 0.152.
 */
package com.sas.appserver.utils;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class FileCheckSum
implements GroovyObject {
    private static Logger logger;
    private byte[] checksum;
    private String fileName;
    private String algorithm;
    public static final String DIGEST_MD5 = "MD5";
    public static final String DIGEST_SHA1 = "SHA-1";
    public static final String DIGEST_SHA256 = "SHA-256";
    public final Map digestAlgorithm;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public FileCheckSum() {
        MetaClass metaClass;
        Map map;
        Object var1_1 = null;
        this.checksum = (byte[])IndyInterface.bootstrap("cast", "()", 0, var1_1);
        Object var2_2 = null;
        this.fileName = IndyInterface.bootstrap("cast", "()", 0, var2_2);
        Object var3_3 = null;
        this.algorithm = IndyInterface.bootstrap("cast", "()", 0, var3_3);
        this.digestAlgorithm = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{0, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", DIGEST_MD5, "size", 16}), 1, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", DIGEST_SHA1, "size", 20}), 2, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", DIGEST_SHA256, "size", 32})});
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public String getFileName() {
        CallSite storedName = null;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.fileName, null)) {
            storedName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, String.class, this.fileName));
        }
        return storedName;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public String getHexChecksum() {
        CallSite hexValue = null;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.checksum, null)) {
            hexValue = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encodeHexString", 0, Hex.class, this.checksum));
        }
        return hexValue;
    }

    public String getSerializedChecksum() {
        CallSite serialized = null;
        if (ScriptBytecodeAdapter.compareEqual((Object)this.fileName, null) || ScriptBytecodeAdapter.compareEqual((Object)this.algorithm, null) || ScriptBytecodeAdapter.compareEqual((Object)this.checksum, null)) {
            IndyInterface.bootstrap("invoke", "error", 0, logger, "Checksum object properties are insufficient for serialization.");
        } else {
            serialized = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
            IndyInterface.bootstrap("invoke", "append", 0, serialized, this.fileName);
            IndyInterface.bootstrap("invoke", "append", 0, serialized, "::");
            IndyInterface.bootstrap("invoke", "append", 0, serialized, this.algorithm);
            IndyInterface.bootstrap("invoke", "append", 0, serialized, "::");
            IndyInterface.bootstrap("invoke", "append", 0, serialized, IndyInterface.bootstrap("invoke", "encodeHexString", 0, Hex.class, this.checksum));
        }
        return IndyInterface.bootstrap("cast", "()", 0, serialized);
    }

    public boolean deserializeChecksum(String serializedChecksum) {
        boolean status = true;
        if (ScriptBytecodeAdapter.compareEqual((Object)serializedChecksum, null)) {
            IndyInterface.bootstrap("invoke", "error", 0, logger, "Invalid checksum deserialization argument.");
            status = false;
        } else {
            CallSite part = null;
            part = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, serializedChecksum, "::", -1));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, part), (Object)3)) {
                IndyInterface.bootstrap("invoke", "error", 0, logger, "Invalid checksum deserialization argument.");
                status = false;
            } else {
                CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, part, false);
                this.fileName = IndyInterface.bootstrap("cast", "()", 0, callSite);
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "getAt", 0, part, true);
                this.algorithm = IndyInterface.bootstrap("cast", "()", 0, callSite2);
                CallSite callSite3 = IndyInterface.bootstrap("invoke", "decodeHex", 0, Hex.class, IndyInterface.bootstrap("invoke", "getAt", 0, part, 2));
                this.checksum = (byte[])IndyInterface.bootstrap("cast", "()", 0, callSite3);
            }
        }
        return status;
    }

    public String getHexChecksum(byte ... value) {
        CallSite hexValue = null;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)value, null)) {
            hexValue = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encodeHexString", 0, Hex.class, value));
        }
        return hexValue;
    }

    public boolean equals(byte ... value) {
        return ScriptBytecodeAdapter.compareEqual((Object)value, (Object)this.checksum);
    }

    public List getAlgorithmNames() {
        public final class _getAlgorithmNames_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAlgorithmNames_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object entry) {
                return IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAlgorithmNames_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, this.digestAlgorithm, new _getAlgorithmNames_closure1(this, this)));
    }

    public List getChecksumSizes() {
        public final class _getChecksumSizes_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getChecksumSizes_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object entry) {
                return IndyInterface.bootstrap("getProperty", "size", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getChecksumSizes_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, this.digestAlgorithm, new _getChecksumSizes_closure2(this, this)));
    }

    private byte[] generateFileChecksum(String hashName, File inputFile, boolean storeIt) {
        CallSite digestValue = null;
        CallSite algorithm = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toUpperCase", 0, hashName));
        public final class _generateFileChecksum_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _generateFileChecksum_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object entry) {
                return IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateFileChecksum_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        if (!ScriptBytecodeAdapter.isCase((Object)algorithm, (Object)IndyInterface.bootstrap("invoke", "collect", 0, this.digestAlgorithm, new _generateFileChecksum_closure3(this, this)))) {
            IndyInterface.bootstrap("invoke", "error", 0, logger, new GStringImpl(new Object[]{this.digestAlgorithm}, new String[]{"Invalid digest algorithm: ", ""}));
        } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, inputFile)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, inputFile)}, new String[]{"File ", " not found."}));
        } else {
            CallSite inputStream = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInputStream", 0, inputFile));
            CallSite checksumCalc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstance", 0, MessageDigest.class, algorithm));
            CallSite digestStream = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DigestInputStream.class, inputStream, checksumCalc));
            CallSite outputStream = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, NullOutputStream.class));
            IndyInterface.bootstrap("invoke", "copy", 0, IOUtils.class, digestStream, outputStream);
            IndyInterface.bootstrap("invoke", "close", 0, inputStream);
            IndyInterface.bootstrap("invoke", "close", 0, digestStream);
            IndyInterface.bootstrap("invoke", "close", 0, outputStream);
            digestValue = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "digest", 0, checksumCalc));
            if (ScriptBytecodeAdapter.compareEqual((Object)storeIt, (Object)true)) {
                String string;
                CallSite callSite = IndyInterface.bootstrap("invoke", "getPath", 0, inputFile);
                this.fileName = IndyInterface.bootstrap("cast", "()", 0, callSite);
                CallSite callSite2 = digestValue;
                this.checksum = (byte[])callSite2;
                this.algorithm = string = hashName;
            }
        }
        return digestValue;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileCheckSum.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LogManager.class, FileCheckSum.class);
        logger = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

