/*
 * Decompiled with CFR 0.152.
 */
package com.sas.appserver.utils;

import com.sas.appserver.impl.AbstractGlobal;
import com.sas.appserver.utils.AppServerHelper;
import com.sas.appserver.utils.ContainerType;
import com.sas.appserver.utils.JvmOption;
import com.sas.appserver.utils.OsType;
import com.sas.appserver.utils.ResourceManagerImpl;
import com.sas.appserver.utils.ResourceType;
import com.sas.appserver.utils.XmlHelper;
import com.sas.appserver.vfabrcersvrc.ProxyServer;
import com.sas.appserver.vfabrictcsvr.GlobalResource;
import com.sas.appserver.vfabrictcsvr.TCServerHelper;
import com.sas.sdw.SDW;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.FileInputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class ConfigFileAccessHelper
implements GroovyObject {
    private static Logger logger;
    public static final String BACKUP_FILE_DATE_FORMAT = "yyyy-MM-dd-HH.mm.ss";
    public static final SimpleDateFormat dateFormatter;
    private static final String LINE_SEPARATOR;
    private static final String CONNECTOR_XPATH = "/Server/Service[@name='Catalina']/Connector";
    private static final String SSL_HOST_CONFIG_XPATH = "/Server/Service[@name='Catalina']/Connector/SSLHostConfig";
    private static final String CERTIFICATE_XPATH = "/Server/Service[@name='Catalina']/Connector/SSLHostConfig/Certificate";
    private static final Object CONNECTOR_ELEMENTS;
    private static Object DEPRECATED_ATTRIBUTES_MAP;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ConfigFileAccessHelper() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static boolean isManualSSLEnabled(File serverXmlFile) {
        CallSite serverXmlHelper = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlHelper.class));
        IndyInterface.bootstrap("invoke", "parse", 0, serverXmlHelper, serverXmlFile);
        CallSite value = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAttribute", 0, serverXmlHelper, CONNECTOR_XPATH, "SSLEnabled", "SSLEnabled", "true"));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)value, null)) {
            IndyInterface.bootstrap("invoke", "info", 0, logger, "Manual SSL enabled");
            return true;
        }
        return false;
    }

    public static boolean isTCServerFIPSEnabled(File serverXmlFile) {
        boolean result = false;
        IndyInterface.bootstrap("invoke", "info", 0, logger, "isTCServerFIPSEnabled >>>");
        CallSite serverXmlHelper = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlHelper.class));
        IndyInterface.bootstrap("invoke", "parse", 0, serverXmlHelper, serverXmlFile);
        CallSite SSLEnabled = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAttribute", 0, serverXmlHelper, CONNECTOR_XPATH, "SSLEnabled", "SSLEnabled", "true"));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)SSLEnabled, null)) {
            CallSite fipsEnabled = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAttribute", 0, serverXmlHelper, "/Server/Listener", "FIPSMode", "FIPSMode", "on"));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)fipsEnabled, null)) {
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "FIPS is enabled in ", IndyInterface.bootstrap("invoke", "getPath", 0, serverXmlFile)));
                result = true;
            }
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)result, (Object)false)) {
            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "FIPS is not enabled in ", IndyInterface.bootstrap("invoke", "getPath", 0, serverXmlFile)));
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "isTCServerFIPSEnabled <<<");
        return result;
    }

    public static void backupConfigFiles(SDW sdw) {
        IndyInterface.bootstrap("invoke", "backupConfigFiles", 0, ConfigFileAccessHelper.class, sdw, null);
    }

    public static void backupConfigFiles(SDW sdw, GlobalResource globalResource) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "Back up server configuration files >>>");
        CallSite tcHelper = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, TCServerHelper.class, sdw));
        CallSite containerType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "TC_SERVER", 0, ContainerType.class));
        CallSite resourceManager = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResourceManagerImpl.class, sdw, containerType));
        IndyInterface.bootstrap("invoke", "loadResources", 0, resourceManager, true);
        if (ScriptBytecodeAdapter.compareEqual((Object)globalResource, null)) {
            globalResource = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResource", 0, resourceManager, IndyInterface.bootstrap("getProperty", "GLOBAL", 0, ResourceType.class)));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "webServerIsConfigured", 0, tcHelper)) != false) {
            IndyInterface.bootstrap("invoke", "backupSASConf", 0, ConfigFileAccessHelper.class, globalResource, IndyInterface.bootstrap("invoke", "getConfigLevWebDir", 0, tcHelper));
        }
        CallSite serverIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getEnabledServerIds", 0, tcHelper));
        IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Backup server count: ", IndyInterface.bootstrap("invoke", "size", 0, serverIds)));
        CallSite serverId = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, serverIds));
        if (callSite != null) {
            while (callSite.hasNext()) {
                serverId = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Backing up files for ", serverId));
                int members = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "getServerMultiplier", 0, tcHelper, serverId));
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, serverId, new GStringImpl(new Object[]{members}, new String[]{" server multiplier is ", ""})));
                Object clone = null;
                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, ScriptBytecodeAdapter.createRange((Object)1, (Object)members, (boolean)false, (boolean)false)));
                if (callSite2 == null) continue;
                while (callSite2.hasNext()) {
                    clone = callSite2.next();
                    IndyInterface.bootstrap("invoke", "info", 0, logger, "Backup server configuration files ...");
                    CallSite cloneName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCloneName", 0, tcHelper, serverId, clone));
                    IndyInterface.bootstrap("invoke", "backupWebAppServerConfig", 0, ConfigFileAccessHelper.class, globalResource, cloneName);
                }
            }
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "Back up server configuration files <<<");
    }

    private static void backupWebAppServerConfig(GlobalResource globalResource, String serverName) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "backupWebAppServerConfig ", serverName), " configuration files >>>"));
        CallSite confFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getServerConfDir", 0, globalResource, serverName));
        IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "AppServer ", serverName), " confFolder: "), confFolder));
        CallSite backupFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, confFolder, "Backup"));
        CallSite dateSuffix = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCurrentTimeStamp", 0, AppServerHelper.class));
        IndyInterface.bootstrap("invoke", "copyFile", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("invoke", "getServerXmlFile", 0, globalResource, serverName), backupFolder, IndyInterface.bootstrap("invoke", "plus", 0, "server.xml.", dateSuffix));
        IndyInterface.bootstrap("invoke", "copyFile", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("invoke", "getJaasConfigFile", 0, globalResource, serverName), backupFolder, IndyInterface.bootstrap("invoke", "plus", 0, "jaas.config.", dateSuffix));
        IndyInterface.bootstrap("invoke", "copyFile", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("init", "<init>", 0, File.class, confFolder, "web.xml"), backupFolder, IndyInterface.bootstrap("invoke", "plus", 0, "web.xml.", dateSuffix));
        IndyInterface.bootstrap("invoke", "copyFile", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("invoke", "getContextXmlFile", 0, globalResource, serverName), backupFolder, IndyInterface.bootstrap("invoke", "plus", 0, "context.xml.", dateSuffix));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getOsType", 0, globalResource), (Object)IndyInterface.bootstrap("getProperty", "WINDOWS", 0, OsType.class))) {
            IndyInterface.bootstrap("invoke", "copyFile", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("invoke", "getWrapperConfFile", 0, globalResource, serverName), backupFolder, IndyInterface.bootstrap("invoke", "plus", 0, "wrapper.conf.", dateSuffix));
        }
        backupFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getServerBinDir", 0, globalResource, serverName), "Backup"));
        IndyInterface.bootstrap("invoke", "copyFile", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("invoke", "getSetEnvFile", 0, globalResource, serverName), backupFolder, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getSetEnvFileName", 0, globalResource), "."), dateSuffix));
        IndyInterface.bootstrap("invoke", "copyFile", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("invoke", "getRuntimeCtlScript", 0, globalResource, serverName), backupFolder, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getRuntimeCtlScriptName", 0, globalResource), "."), dateSuffix));
        IndyInterface.bootstrap("invoke", "copyFile", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("invoke", "getTCServerCtlScript", 0, globalResource, serverName), backupFolder, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getTCServerCtlScriptName", 0, globalResource), "."), dateSuffix));
        IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "backupWebAppServerConfig ", serverName), " configuration files <<<"));
    }

    public static void backupSASConf(AbstractGlobal globalResource, File webFolder) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "Backing up WebServer sas.conf");
        CallSite dateSuffix = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCurrentTimeStamp", 0, AppServerHelper.class));
        CallSite webServerFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getWebServerInstanceDir", 0, globalResource));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)webServerFolder, null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "exists", 0, webServerFolder))) {
            CallSite confFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, webServerFolder, "conf"));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, confFolder)) != false) {
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "WebServer confFolder: ", confFolder));
                IndyInterface.bootstrap("invoke", "copyFile", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("init", "<init>", 0, File.class, confFolder, "sas.conf"), IndyInterface.bootstrap("init", "<init>", 0, File.class, confFolder, "Backup"), IndyInterface.bootstrap("invoke", "plus", 0, "sas.conf.", dateSuffix));
                IndyInterface.bootstrap("invoke", "copyFile", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("init", "<init>", 0, File.class, confFolder, "sas.conf"), IndyInterface.bootstrap("init", "<init>", 0, File.class, confFolder, "Backup"), "sas.conf");
            }
        } else {
            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "WebServer is remote, webFolder is ", IndyInterface.bootstrap("invoke", "getPath", 0, webFolder)));
            CallSite webServer = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getWebServer", 0, ProxyServer.class, globalResource));
            CallSite localSASConfFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, webFolder, IndyInterface.bootstrap("invoke", "plus", 0, "Backup/sas.conf.", dateSuffix)));
            CallSite remoteSASConfFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getWebServerRemoteInstanceDir", 0, globalResource), "conf/sas.conf"));
            try {
                IndyInterface.bootstrap("invoke", "pullRemoteSASConfigFile", 0, webServer, globalResource, remoteSASConfFile, localSASConfFile);
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Remote file is ", IndyInterface.bootstrap("invoke", "getPath", 0, remoteSASConfFile)));
            }
            catch (Throwable t) {
                IndyInterface.bootstrap("invoke", "info", 0, logger, "Failed to backup remote sas.conf file, may be ok.", t);
            }
        }
    }

    public static void updateServerXml(File backupServerXmlFile, File currentServerXmlFile, List<String[]> copyAttributeList, List<String[]> updateAttributeList) {
        CallSite backupXmlHelper = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlHelper.class));
        IndyInterface.bootstrap("invoke", "parse", 0, backupXmlHelper, backupServerXmlFile);
        CallSite currentXmlHelper = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlHelper.class));
        IndyInterface.bootstrap("invoke", "parse", 0, currentXmlHelper, currentServerXmlFile);
        CallSite attr = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, copyAttributeList));
        if (callSite != null) {
            while (callSite.hasNext()) {
                attr = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite xpath = IndyInterface.bootstrap("invoke", "getAt", 0, attr, false);
                Object attribute = IndyInterface.bootstrap("invoke", "getAt", 0, attr, true);
                CallSite existingValue = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAttribute", 0, backupXmlHelper, xpath, attribute, "SSLEnabled", "true"));
                if (ScriptBytecodeAdapter.compareEqual((Object)existingValue, null)) {
                    existingValue = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAttribute", 0, backupXmlHelper, xpath, attribute, null, null));
                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "WAS SSL not enabled, ", xpath), ":"), attribute), "="), existingValue));
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)attribute, (Object)"sslProtocols")) {
                    attribute = "sslEnabledProtocols";
                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Convert sslProtocols to sslEnabledProtocols: ", xpath), ":"), attribute), "="), existingValue));
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, DEPRECATED_ATTRIBUTES_MAP, attribute)) != false) {
                    CallSite newAttributes = IndyInterface.bootstrap("invoke", "getAt", 0, DEPRECATED_ATTRIBUTES_MAP, attribute);
                    IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{xpath, attribute, IndyInterface.bootstrap("invoke", "getAt", 0, newAttributes, false), IndyInterface.bootstrap("invoke", "getAt", 0, newAttributes, true)}, new String[]{"Convert ", ":", " to ", ":", ""}));
                    xpath = IndyInterface.bootstrap("invoke", "getAt", 0, newAttributes, false);
                    attribute = IndyInterface.bootstrap("invoke", "getAt", 0, newAttributes, true);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, CONNECTOR_ELEMENTS, xpath)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "nodeExists", 0, currentXmlHelper, xpath)) == false) {
                    IndyInterface.bootstrap("invoke", "addConnectorElements", 0, ConfigFileAccessHelper.class, currentXmlHelper);
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)existingValue, null) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "length", 0, existingValue), (Object)0)) {
                    IndyInterface.bootstrap("invoke", "setAttribute", 0, currentXmlHelper, xpath, attribute, existingValue);
                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Copy server.xml attribute: ", xpath), ":"), attribute), "="), existingValue));
                    continue;
                }
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Copy server.xml empty value not copied: ", xpath), ":"), attribute), "="), existingValue));
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual(updateAttributeList, null) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, updateAttributeList)) == false) {
            CallSite attr2 = null;
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, updateAttributeList));
            if (callSite2 != null) {
                while (callSite2.hasNext()) {
                    attr2 = IndyInterface.bootstrap("cast", "()", 0, callSite2.next());
                    if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, CONNECTOR_ELEMENTS, IndyInterface.bootstrap("invoke", "getAt", 0, attr2, false))) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "nodeExists", 0, currentXmlHelper, IndyInterface.bootstrap("invoke", "getAt", 0, attr2, false))) == false) {
                        IndyInterface.bootstrap("invoke", "addConnectorElements", 0, ConfigFileAccessHelper.class, currentXmlHelper);
                    }
                    IndyInterface.bootstrap("invoke", "setAttribute", 0, currentXmlHelper, IndyInterface.bootstrap("invoke", "getAt", 0, attr2, false), IndyInterface.bootstrap("invoke", "getAt", 0, attr2, true), IndyInterface.bootstrap("invoke", "getAt", 0, attr2, 2));
                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Add server.xml attribute: ", IndyInterface.bootstrap("invoke", "getAt", 0, attr2, false)), ":"), IndyInterface.bootstrap("invoke", "getAt", 0, attr2, true)), "="), IndyInterface.bootstrap("invoke", "getAt", 0, attr2, 2)));
                }
            }
        }
        IndyInterface.bootstrap("invoke", "write", 0, currentXmlHelper, currentServerXmlFile);
    }

    public static void addConnectorElements(XmlHelper xmlHelper) {
        CallSite certificate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findNode", 0, xmlHelper, CERTIFICATE_XPATH));
        if (ScriptBytecodeAdapter.compareEqual((Object)certificate, null)) {
            CallSite sslHostConfig = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findNode", 0, xmlHelper, SSL_HOST_CONFIG_XPATH));
            if (ScriptBytecodeAdapter.compareEqual((Object)sslHostConfig, null)) {
                IndyInterface.bootstrap("invoke", "info", 0, logger, "Creating SSLHostConfig in server.xml");
                sslHostConfig = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createElement", 0, xmlHelper, "SSLHostConfig"));
                CallSite connector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findNode", 0, xmlHelper, CONNECTOR_XPATH));
                IndyInterface.bootstrap("invoke", "appendChildElement", 0, xmlHelper, connector, sslHostConfig);
            }
            IndyInterface.bootstrap("invoke", "info", 0, logger, "Creating Certificate in server.xml");
            certificate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createElement", 0, xmlHelper, "Certificate"));
            IndyInterface.bootstrap("invoke", "appendChildElement", 0, xmlHelper, sslHostConfig, certificate);
        }
    }

    public static void updateServerXml(File backupServerXmlFile, File currentServerXmlFile, List<String[]> restoreAttributeList, String defaultValue) {
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isFile", 0, backupServerXmlFile)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isFile", 0, currentServerXmlFile)) && ScriptBytecodeAdapter.compareNotEqual(restoreAttributeList, null) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, restoreAttributeList)) == false) {
            CallSite backupXmlHelper = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlHelper.class));
            IndyInterface.bootstrap("invoke", "parse", 0, backupXmlHelper, backupServerXmlFile);
            CallSite currentXmlHelper = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlHelper.class));
            IndyInterface.bootstrap("invoke", "parse", 0, currentXmlHelper, currentServerXmlFile);
            CallSite attr = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, restoreAttributeList));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    attr = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                    CallSite val = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAttribute", 0, backupXmlHelper, IndyInterface.bootstrap("invoke", "getAt", 0, attr, false), IndyInterface.bootstrap("invoke", "getAt", 0, attr, true), null, null));
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)val, null) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "length", 0, val), (Object)0)) {
                        IndyInterface.bootstrap("invoke", "setAttribute", 0, currentXmlHelper, IndyInterface.bootstrap("invoke", "getAt", 0, attr, false), IndyInterface.bootstrap("invoke", "getAt", 0, attr, true), val);
                        IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Restore server.xml attribute: ", IndyInterface.bootstrap("invoke", "getAt", 0, attr, false)), ":"), IndyInterface.bootstrap("invoke", "getAt", 0, attr, true)), "="), val));
                        continue;
                    }
                    IndyInterface.bootstrap("invoke", "setAttribute", 0, currentXmlHelper, IndyInterface.bootstrap("invoke", "getAt", 0, attr, false), IndyInterface.bootstrap("invoke", "getAt", 0, attr, true), defaultValue);
                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Setting default value to server.xml attribute: ", IndyInterface.bootstrap("invoke", "getAt", 0, attr, false)), ":"), IndyInterface.bootstrap("invoke", "getAt", 0, attr, true)), "="), defaultValue));
                }
            }
            IndyInterface.bootstrap("invoke", "write", 0, currentXmlHelper, currentServerXmlFile);
        } else {
            IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{currentServerXmlFile, backupServerXmlFile}, new String[]{"Could not update server.xml [", "] from backup file [", "]"}));
        }
    }

    public static void updateSetenvFile(File backupSetenvFile, File setenvFile, Set<String> copyOptions, Set<String> preserveOptions, Map<String, String> inOptions, OsType osType) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "updateSetenvFile() >>>");
        boolean errorState = false;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, setenvFile)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, setenvFile)}, new String[]{"File ", " not found."}));
            errorState = true;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, backupSetenvFile)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, backupSetenvFile)}, new String[]{"File ", " not found."}));
            errorState = true;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)errorState, (Object)false)) {
            IndyInterface.bootstrap("invoke", "debug", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, setenvFile)}, new String[]{"Current setenv file is ", ""}));
            IndyInterface.bootstrap("invoke", "debug", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, backupSetenvFile)}, new String[]{"Backup setenv file is ", ""}));
            CallSite backupLines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "getText", 0, backupSetenvFile), "\n"));
            CallSite jvmOpBuf = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
            String key = ScriptBytecodeAdapter.compareEqual((Object)osType, (Object)IndyInterface.bootstrap("getProperty", "WINDOWS", 0, OsType.class)) ? "set JVM_OPTS=" : "JVM_OPTS=";
            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Updating setenv using Jvm Option key: ", key));
            CallSite line = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, backupLines));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    line = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                    if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)line, (Object)new GStringImpl(new Object[]{key}, new String[]{"^", ""}))) == false) continue;
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "length", 0, jvmOpBuf), (Object)0)) {
                        IndyInterface.bootstrap("invoke", "append", 0, jvmOpBuf, " ");
                    }
                    IndyInterface.bootstrap("invoke", "append", 0, jvmOpBuf, IndyInterface.bootstrap("invoke", "substring", 0, line, IndyInterface.bootstrap("invoke", "length", 0, key)));
                }
            }
            CallSite jvmOptionString = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, jvmOpBuf));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)osType, (Object)IndyInterface.bootstrap("getProperty", "WINDOWS", 0, OsType.class))) {
                jvmOptionString = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "constainsCron", 0, JvmOption.class, jvmOptionString)) != false ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "removeDoubleQuotesReplaceEscapedDoubleQuotesWithDoubleQuotesForCron", 0, JvmOption.class, jvmOptionString)) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "removeQuote", 0, JvmOption.class, jvmOptionString));
            }
            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "JVM options from backup: ", jvmOptionString));
            CallSite optionToCopy = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
            CallSite valuesToPreserve = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
            CallSite options = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseOptions", 0, JvmOption.class, jvmOptionString));
            CallSite itr = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, options));
            while (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasNext", 0, itr)) != false) {
                CallSite option = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, itr));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, copyOptions, IndyInterface.bootstrap("invoke", "getName", 0, option))) != false) {
                    IndyInterface.bootstrap("invoke", "put", 0, optionToCopy, IndyInterface.bootstrap("invoke", "getName", 0, option), option);
                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "JvmOption to copy: ", IndyInterface.bootstrap("invoke", "getName", 0, option)));
                    IndyInterface.bootstrap("invoke", "remove", 0, itr);
                    continue;
                }
                if (!(ScriptBytecodeAdapter.compareNotEqual(preserveOptions, null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, preserveOptions, IndyInterface.bootstrap("invoke", "getName", 0, option))))) continue;
                IndyInterface.bootstrap("invoke", "put", 0, valuesToPreserve, IndyInterface.bootstrap("invoke", "getName", 0, option), option);
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "JvmOption value to preserve: ", IndyInterface.bootstrap("invoke", "getName", 0, option)));
                IndyInterface.bootstrap("invoke", "remove", 0, itr);
            }
            CallSite updateOptions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clone", 0, inOptions));
            CallSite lines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "getText", 0, setenvFile), "\n"));
            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Current setenv file before update: \n", IndyInterface.bootstrap("invoke", "getText", 0, setenvFile)));
            jvmOpBuf = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
            CallSite line2 = null;
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, lines));
            if (callSite2 != null) {
                while (callSite2.hasNext()) {
                    line2 = IndyInterface.bootstrap("cast", "()", 0, callSite2.next());
                    if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)line2, (Object)new GStringImpl(new Object[]{key}, new String[]{"^", ""}))) == false) continue;
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "length", 0, jvmOpBuf), (Object)0)) {
                        IndyInterface.bootstrap("invoke", "append", 0, jvmOpBuf, " ");
                    }
                    IndyInterface.bootstrap("invoke", "append", 0, jvmOpBuf, IndyInterface.bootstrap("invoke", "substring", 0, line2, IndyInterface.bootstrap("invoke", "length", 0, key)));
                }
            }
            jvmOptionString = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, jvmOpBuf));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)osType, (Object)IndyInterface.bootstrap("getProperty", "WINDOWS", 0, OsType.class))) {
                jvmOptionString = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "constainsCron", 0, JvmOption.class, jvmOptionString)) != false ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "removeDoubleQuotesReplaceEscapedDoubleQuotesWithDoubleQuotesForCron", 0, JvmOption.class, jvmOptionString)) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "removeQuote", 0, JvmOption.class, jvmOptionString));
            }
            options = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseOptions", 0, JvmOption.class, jvmOptionString));
            CallSite itr2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, options));
            while (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasNext", 0, itr2)) != false) {
                CallSite option = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, itr2));
                CallSite preserve = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, valuesToPreserve, IndyInterface.bootstrap("invoke", "getName", 0, option)));
                CallSite backup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, optionToCopy, IndyInterface.bootstrap("invoke", "getName", 0, option)));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)preserve, null)) {
                    IndyInterface.bootstrap("invoke", "setValue", 0, option, IndyInterface.bootstrap("invoke", "getValue", 0, preserve));
                    IndyInterface.bootstrap("invoke", "remove", 0, updateOptions, IndyInterface.bootstrap("invoke", "getName", 0, option));
                    IndyInterface.bootstrap("invoke", "remove", 0, valuesToPreserve, IndyInterface.bootstrap("invoke", "getName", 0, preserve));
                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Updated JvmOption value from backup: ", IndyInterface.bootstrap("invoke", "getName", 0, option)));
                    continue;
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)backup, null)) {
                    IndyInterface.bootstrap("invoke", "setValue", 0, option, IndyInterface.bootstrap("invoke", "getValue", 0, backup));
                    IndyInterface.bootstrap("invoke", "remove", 0, updateOptions, IndyInterface.bootstrap("invoke", "getName", 0, option));
                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Updated JvmOption from backup: ", IndyInterface.bootstrap("invoke", "getName", 0, option)));
                    continue;
                }
                CallSite updateValue = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, updateOptions, IndyInterface.bootstrap("invoke", "getName", 0, option)));
                if (!ScriptBytecodeAdapter.compareNotEqual((Object)updateValue, null)) continue;
                IndyInterface.bootstrap("invoke", "setValue", 0, option, updateValue);
                IndyInterface.bootstrap("invoke", "remove", 0, updateOptions, IndyInterface.bootstrap("invoke", "getName", 0, option));
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Updated JvmOption value: ", IndyInterface.bootstrap("invoke", "getName", 0, option)), "->"), updateValue));
            }
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, updateOptions), (Object)0)) {
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "size", 0, updateOptions), " jvm options to add"));
                CallSite entry = null;
                CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "entrySet", 0, updateOptions)));
                if (callSite3 != null) {
                    while (callSite3.hasNext()) {
                        entry = IndyInterface.bootstrap("cast", "()", 0, callSite3.next());
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getValue", 0, entry), null)) {
                            CallSite newOption = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, JvmOption.class));
                            IndyInterface.bootstrap("invoke", "setName", 0, newOption, IndyInterface.bootstrap("invoke", "getKey", 0, entry));
                            IndyInterface.bootstrap("invoke", "setValue", 0, newOption, IndyInterface.bootstrap("invoke", "getValue", 0, entry));
                            IndyInterface.bootstrap("invoke", "setPrefix", 0, newOption, "-D");
                            IndyInterface.bootstrap("invoke", "setDelimiter", 0, newOption, "=");
                            IndyInterface.bootstrap("invoke", "add", 0, options, newOption);
                            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Added JVM option value: ", IndyInterface.bootstrap("invoke", "getName", 0, newOption)), "->"), IndyInterface.bootstrap("invoke", "getValue", 0, newOption)));
                            continue;
                        }
                        IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Add JVM option: ", IndyInterface.bootstrap("invoke", "getKey", 0, entry)), " is null, ignore"));
                    }
                }
            }
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, valuesToPreserve), (Object)0)) {
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "size", 0, valuesToPreserve), " jvm options to restore"));
                Object entry = null;
                CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, valuesToPreserve));
                if (callSite4 != null) {
                    while (callSite4.hasNext()) {
                        entry = callSite4.next();
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "value", 0, entry), null)) {
                            CallSite newOption = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, JvmOption.class));
                            IndyInterface.bootstrap("invoke", "setName", 0, newOption, IndyInterface.bootstrap("getProperty", "key", 0, entry));
                            IndyInterface.bootstrap("invoke", "setValue", 0, newOption, IndyInterface.bootstrap("invoke", "getValue", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry)));
                            IndyInterface.bootstrap("invoke", "setPrefix", 0, newOption, "-D");
                            IndyInterface.bootstrap("invoke", "setDelimiter", 0, newOption, "=");
                            IndyInterface.bootstrap("invoke", "add", 0, options, newOption);
                            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Restored JVM option value: ", IndyInterface.bootstrap("invoke", "getName", 0, newOption)), "->"), IndyInterface.bootstrap("invoke", "getValue", 0, newOption)));
                            continue;
                        }
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "key", 0, entry)}, new String[]{"Restore JVM option: ", " is null, ignore"}));
                    }
                }
            }
            CallSite fileContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
            boolean doneJVMOptionProcessing = false;
            CallSite line3 = null;
            CallSite callSite5 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, lines));
            if (callSite5 != null) {
                while (callSite5.hasNext()) {
                    line3 = IndyInterface.bootstrap("cast", "()", 0, callSite5.next());
                    if (doneJVMOptionProcessing || IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)line3, (Object)new GStringImpl(new Object[]{key}, new String[]{"^", ""}))) == false) {
                        IndyInterface.bootstrap("invoke", "append", 0, fileContent, line3);
                    } else {
                        IndyInterface.bootstrap("invoke", "append", 0, fileContent, key);
                        CallSite newJvmOptions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class, IndyInterface.bootstrap("invoke", "toString", 0, JvmOption.class, options)));
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toString", 0, newJvmOptions)}, new String[]{"New Jvm Options: ", ""}));
                        if (ScriptBytecodeAdapter.compareEqual((Object)osType, (Object)IndyInterface.bootstrap("getProperty", "WINDOWS", 0, OsType.class))) {
                            IndyInterface.bootstrap("invoke", "wrapInEscapedQuotesAsNeeded", 0, ConfigFileAccessHelper.class, newJvmOptions, osType);
                            IndyInterface.bootstrap("invoke", "append", 0, fileContent, IndyInterface.bootstrap("invoke", "toString", 0, newJvmOptions));
                        } else {
                            IndyInterface.bootstrap("invoke", "append", 0, fileContent, "\"");
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "constainsCron", 0, JvmOption.class, IndyInterface.bootstrap("invoke", "toString", 0, newJvmOptions))) != false) {
                                IndyInterface.bootstrap("invoke", "append", 0, fileContent, IndyInterface.bootstrap("invoke", "escapeDoubleQuotesForCron", 0, JvmOption.class, IndyInterface.bootstrap("invoke", "toString", 0, newJvmOptions)));
                            } else {
                                IndyInterface.bootstrap("invoke", "append", 0, fileContent, IndyInterface.bootstrap("invoke", "toString", 0, newJvmOptions));
                            }
                            IndyInterface.bootstrap("invoke", "append", 0, fileContent, "\"");
                        }
                        doneJVMOptionProcessing = true;
                        IndyInterface.bootstrap("invoke", "info", 0, logger, "Done Jvm Options processing");
                    }
                    IndyInterface.bootstrap("invoke", "append", 0, fileContent, "\n");
                }
            }
            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "New setenv file: \n", IndyInterface.bootstrap("invoke", "toString", 0, fileContent)));
            IndyInterface.bootstrap("invoke", "write", 0, setenvFile, IndyInterface.bootstrap("invoke", "toString", 0, fileContent));
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "updateSetenvFile() <<<");
    }

    public static void updateWrapperFile(File backupWrapperFile, File wrapperFile, Set<String> copyOptions, Map<String, String> inOptions, Set<String> preserveOptions) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "updateWrapperFile() >>>");
        boolean errorState = false;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, wrapperFile)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, wrapperFile)}, new String[]{"File ", " not found."}));
            errorState = true;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, backupWrapperFile)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, backupWrapperFile)}, new String[]{"File ", " not found."}));
            errorState = true;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)errorState, (Object)false)) {
            IndyInterface.bootstrap("invoke", "debug", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, wrapperFile)}, new String[]{"Current wrapper file is ", ""}));
            IndyInterface.bootstrap("invoke", "debug", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getPath", 0, backupWrapperFile)}, new String[]{"Backup wrapper file is ", ""}));
            CallSite lines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "getText", 0, backupWrapperFile), "\r", ""), "\n"));
            CallSite wrapperContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
            CallSite optionToCopy = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
            CallSite valuesToPreserve = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
            CallSite newOptions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clone", 0, inOptions));
            CallSite libPath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class));
            int optionCount = 0;
            int libPathCount = 0;
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("getProperty", "length", 0, lines))) {
                if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i), (Object)"^wrapper.java.additional.[\\d]+=.*")) != false) {
                    int idx = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i), "="));
                    CallSite option = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, JvmOption.class, IndyInterface.bootstrap("invoke", "substring", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i), IndyInterface.bootstrap("invoke", "plus", 0, idx, true))));
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, copyOptions, IndyInterface.bootstrap("invoke", "getName", 0, option))) != false) {
                        IndyInterface.bootstrap("invoke", "put", 0, optionToCopy, IndyInterface.bootstrap("invoke", "getName", 0, option), option);
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getName", 0, option), IndyInterface.bootstrap("invoke", "getValue", 0, option)}, new String[]{"Option value to copy from backup: ", " = ", ""}));
                    } else if (ScriptBytecodeAdapter.compareNotEqual(preserveOptions, null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, preserveOptions, IndyInterface.bootstrap("invoke", "getName", 0, option)))) {
                        IndyInterface.bootstrap("invoke", "put", 0, valuesToPreserve, IndyInterface.bootstrap("invoke", "getName", 0, option), option);
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getName", 0, option), IndyInterface.bootstrap("invoke", "getValue", 0, option)}, new String[]{"Option from backup to preserve: ", " = ", ""}));
                    }
                } else if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i), (Object)"^wrapper.java.library.path.[\\d]+=.*")) != false) {
                    int idx = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i), "="));
                    CallSite foundPath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i), IndyInterface.bootstrap("invoke", "plus", 0, idx, true)));
                    IndyInterface.bootstrap("invoke", "add", 0, libPath, foundPath);
                    IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{foundPath}, new String[]{"Library path from backup to preserve ", ""}));
                }
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            }
            lines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "getText", 0, wrapperFile), "\r", ""), "\n"));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("invoke", "getName", 0, wrapperFile), "wrapper")) != false) {
                int i2 = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i2, (Object)IndyInterface.bootstrap("getProperty", "length", 0, lines))) {
                    if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"^wrapper.java.additional.[\\d]+=.*")) != false) {
                        int n = optionCount;
                        optionCount = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                    } else if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"^wrapper.java.library.path.[\\d]+=.*")) != false) {
                        int n = libPathCount;
                        libPathCount = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                    }
                    int n = i2;
                    i2 = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                }
                int optionNumber = 1;
                int i3 = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i3, (Object)IndyInterface.bootstrap("getProperty", "length", 0, lines))) {
                    if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"^wrapper.java.additional.[\\d]+=.*")) != false) {
                        int idx = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), "="));
                        CallSite option = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, JvmOption.class, IndyInterface.bootstrap("invoke", "substring", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), IndyInterface.bootstrap("invoke", "plus", 0, idx, true))));
                        CallSite backup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, optionToCopy, IndyInterface.bootstrap("invoke", "getName", 0, option)));
                        CallSite preserve = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, valuesToPreserve, IndyInterface.bootstrap("invoke", "getName", 0, option)));
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)preserve, null)) {
                            CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "substring", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), false, IndyInterface.bootstrap("invoke", "plus", 0, idx, true)), IndyInterface.bootstrap("invoke", "getPrefix", 0, option)), IndyInterface.bootstrap("invoke", "getName", 0, option)), IndyInterface.bootstrap("invoke", "getDelimiter", 0, option)), IndyInterface.bootstrap("invoke", "getValue", 0, preserve));
                            IndyInterface.bootstrap("invoke", "putAt", 0, lines, i3, callSite);
                            IndyInterface.bootstrap("invoke", "remove", 0, valuesToPreserve, IndyInterface.bootstrap("invoke", "getName", 0, option));
                            IndyInterface.bootstrap("invoke", "remove", 0, newOptions, IndyInterface.bootstrap("invoke", "getName", 0, option));
                            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Updated wrapper.conf from backup -D", IndyInterface.bootstrap("invoke", "getName", 0, option)), IndyInterface.bootstrap("invoke", "getDelimiter", 0, preserve)), IndyInterface.bootstrap("invoke", "getValue", 0, preserve)));
                        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)backup, null)) {
                            CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "substring", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), false, IndyInterface.bootstrap("invoke", "plus", 0, idx, true)), IndyInterface.bootstrap("invoke", "getPrefix", 0, option)), IndyInterface.bootstrap("invoke", "getName", 0, option)), IndyInterface.bootstrap("invoke", "getDelimiter", 0, option)), IndyInterface.bootstrap("invoke", "getValue", 0, backup));
                            IndyInterface.bootstrap("invoke", "putAt", 0, lines, i3, callSite);
                            IndyInterface.bootstrap("invoke", "remove", 0, newOptions, IndyInterface.bootstrap("invoke", "getName", 0, option));
                            IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Updated wrapper.conf from backup -D", IndyInterface.bootstrap("invoke", "getName", 0, option)), IndyInterface.bootstrap("invoke", "getDelimiter", 0, backup)), IndyInterface.bootstrap("invoke", "getValue", 0, backup)));
                        } else {
                            CallSite newValue = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, newOptions, IndyInterface.bootstrap("invoke", "getName", 0, option)));
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)newValue, null)) {
                                CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "substring", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), false, IndyInterface.bootstrap("invoke", "plus", 0, idx, true)), IndyInterface.bootstrap("invoke", "getPrefix", 0, option)), IndyInterface.bootstrap("invoke", "getName", 0, option)), IndyInterface.bootstrap("invoke", "getDelimiter", 0, option)), newValue);
                                IndyInterface.bootstrap("invoke", "putAt", 0, lines, i3, callSite);
                                IndyInterface.bootstrap("invoke", "remove", 0, newOptions, IndyInterface.bootstrap("invoke", "getName", 0, option));
                                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Updated wrapper.conf -D", IndyInterface.bootstrap("invoke", "getName", 0, option)), "="), newValue));
                            }
                        }
                        IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, wrapperContent, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3)), LINE_SEPARATOR);
                        int n = optionNumber;
                        optionNumber = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                    } else if (optionNumber > optionCount) {
                        CallSite entry = null;
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "entrySet", 0, newOptions)));
                        if (callSite != null) {
                            while (callSite.hasNext()) {
                                entry = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                                IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, wrapperContent, "wrapper.java.additional."), optionNumber), "=-D"), IndyInterface.bootstrap("invoke", "getKey", 0, entry)), "="), IndyInterface.bootstrap("invoke", "getValue", 0, entry)), LINE_SEPARATOR);
                                int n = optionNumber;
                                optionNumber = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Added to wrapper.conf -D", IndyInterface.bootstrap("getProperty", "key", 0, entry)), "="), IndyInterface.bootstrap("getProperty", "value", 0, entry)));
                            }
                        }
                        Object entry2 = null;
                        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, valuesToPreserve));
                        if (callSite2 != null) {
                            while (callSite2.hasNext()) {
                                entry2 = callSite2.next();
                                IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, wrapperContent, "wrapper.java.additional."), optionNumber), "=-D"), IndyInterface.bootstrap("getProperty", "key", 0, entry2)), "="), IndyInterface.bootstrap("invoke", "getValue", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry2))), LINE_SEPARATOR);
                                int n = optionNumber;
                                optionNumber = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Added to wrapper.conf ", IndyInterface.bootstrap("invoke", "getValue", 0, entry2)));
                            }
                        }
                        optionCount = 0;
                        optionNumber = 0;
                        IndyInterface.bootstrap("invoke", "append", 0, wrapperContent, LINE_SEPARATOR);
                    } else {
                        IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, wrapperContent, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3)), LINE_SEPARATOR);
                    }
                    int n = i3;
                    i3 = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                }
                lines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, wrapperContent), "\r", ""), "\n"));
                wrapperContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
                int libPathNumber = 1;
                int i4 = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i4, (Object)IndyInterface.bootstrap("getProperty", "length", 0, lines)) || libPathCount > 0) {
                    if (ScriptBytecodeAdapter.compareLessThan((Object)i4, (Object)IndyInterface.bootstrap("getProperty", "length", 0, lines)) && DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i4), (Object)"^wrapper.java.library.path.[\\d]+=.*"))) {
                        int idx = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i4), "="));
                        CallSite foundPath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i4), IndyInterface.bootstrap("invoke", "plus", 0, idx, true)));
                        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{foundPath}, new String[]{"Found path ", ""}));
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, libPath, foundPath)) != false) {
                            IndyInterface.bootstrap("invoke", "remove", 0, libPath, foundPath);
                        }
                        IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, wrapperContent, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i4)), LINE_SEPARATOR);
                        int n = libPathNumber;
                        libPathNumber = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                    } else if (libPathNumber > libPathCount) {
                        CallSite path = null;
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, libPath));
                        if (callSite != null) {
                            while (callSite.hasNext()) {
                                path = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                                IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, wrapperContent, "wrapper.java.library.path."), libPathNumber), "="), path), LINE_SEPARATOR);
                                int n = libPathNumber;
                                libPathNumber = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{path}, new String[]{"Added to wrapper.conf ", ""}));
                            }
                        }
                        IndyInterface.bootstrap("invoke", "append", 0, wrapperContent, LINE_SEPARATOR);
                        libPathCount = 0;
                        libPathNumber = 0;
                    } else {
                        IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, wrapperContent, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i4)), LINE_SEPARATOR);
                    }
                    int n = i4;
                    i4 = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                }
            } else {
                CallSite line = null;
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, lines));
                if (callSite != null) {
                    while (callSite.hasNext()) {
                        line = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, line, "javaArgs=")) && (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, optionToCopy)) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, valuesToPreserve)) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, newOptions)) == false)) {
                            CallSite seg = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, line, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "indexOf", 0, line, "javaArgs="), 9)));
                            CallSite lineOptions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
                            CallSite lineOption = null;
                            while (ScriptBytecodeAdapter.compareNotEqual((Object)seg, null) && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "length", 0, seg), (Object)1)) {
                                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Parsing [", seg), "] for JVM options"));
                                int separatorIndex = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, seg, ";"));
                                CallSite option = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, JvmOption.class, IndyInterface.bootstrap("invoke", "substring", 0, seg, false, separatorIndex >= 0 ? Integer.valueOf(separatorIndex) : IndyInterface.bootstrap("invoke", "length", 0, seg))));
                                CallSite backup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, optionToCopy, IndyInterface.bootstrap("invoke", "getName", 0, option)));
                                CallSite preserve = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, valuesToPreserve, IndyInterface.bootstrap("invoke", "getName", 0, option)));
                                lineOption = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
                                IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, lineOption, IndyInterface.bootstrap("invoke", "getPrefix", 0, option)), IndyInterface.bootstrap("invoke", "getName", 0, option)), IndyInterface.bootstrap("invoke", "getDelimiter", 0, option));
                                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Processing JVM option ", option));
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)preserve, null)) {
                                    IndyInterface.bootstrap("invoke", "append", 0, lineOption, IndyInterface.bootstrap("invoke", "getValue", 0, preserve));
                                    IndyInterface.bootstrap("invoke", "remove", 0, valuesToPreserve, IndyInterface.bootstrap("invoke", "getName", 0, option));
                                    IndyInterface.bootstrap("invoke", "remove", 0, newOptions, IndyInterface.bootstrap("invoke", "getName", 0, option));
                                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Preserving value ", IndyInterface.bootstrap("invoke", "getValue", 0, preserve)));
                                } else if (ScriptBytecodeAdapter.compareNotEqual((Object)backup, null)) {
                                    IndyInterface.bootstrap("invoke", "append", 0, lineOption, IndyInterface.bootstrap("invoke", "getValue", 0, backup));
                                    IndyInterface.bootstrap("invoke", "remove", 0, newOptions, IndyInterface.bootstrap("invoke", "getName", 0, option));
                                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Restoring backup value ", IndyInterface.bootstrap("invoke", "getValue", 0, backup)));
                                } else {
                                    IndyInterface.bootstrap("invoke", "append", 0, lineOption, IndyInterface.bootstrap("invoke", "get", 0, newOptions, IndyInterface.bootstrap("invoke", "getName", 0, option)));
                                    IndyInterface.bootstrap("invoke", "remove", 0, newOptions, IndyInterface.bootstrap("invoke", "getName", 0, option));
                                    IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Assigning new value ", IndyInterface.bootstrap("invoke", "get", 0, newOptions, IndyInterface.bootstrap("invoke", "getName", 0, option))));
                                }
                                IndyInterface.bootstrap("invoke", "add", 0, lineOptions, IndyInterface.bootstrap("invoke", "toString", 0, lineOption));
                                if (separatorIndex > 0) {
                                    seg = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, seg, IndyInterface.bootstrap("invoke", "plus", 0, separatorIndex, true)));
                                    continue;
                                }
                                seg = IndyInterface.bootstrap("cast", "()", 0, null);
                            }
                            CallSite entry = null;
                            CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "entrySet", 0, newOptions)));
                            if (callSite3 != null) {
                                while (callSite3.hasNext()) {
                                    entry = IndyInterface.bootstrap("cast", "()", 0, callSite3.next());
                                    lineOption = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
                                    IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, lineOption, "=-D"), IndyInterface.bootstrap("invoke", "getKey", 0, entry)), "="), IndyInterface.bootstrap("invoke", "getValue", 0, entry));
                                    IndyInterface.bootstrap("invoke", "add", 0, lineOptions, IndyInterface.bootstrap("invoke", "toString", 0, lineOption));
                                }
                            }
                            Object entry3 = null;
                            CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, valuesToPreserve));
                            if (callSite4 != null) {
                                while (callSite4.hasNext()) {
                                    entry3 = callSite4.next();
                                    lineOption = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
                                    IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, lineOption, "=-D"), IndyInterface.bootstrap("getProperty", "key", 0, entry3)), "="), IndyInterface.bootstrap("invoke", "getValue", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry3)));
                                    IndyInterface.bootstrap("invoke", "add", 0, lineOptions, IndyInterface.bootstrap("invoke", "toString", 0, lineOption));
                                }
                            }
                            line = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "substring", 0, line, false, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "indexOf", 0, line, "javaArgs="), 9)), IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "toArray", 0, lineOptions), ";")));
                        }
                        IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, wrapperContent, line), LINE_SEPARATOR);
                    }
                }
            }
            IndyInterface.bootstrap("invoke", "write", 0, wrapperFile, IndyInterface.bootstrap("invoke", "toString", 0, wrapperContent));
            IndyInterface.bootstrap("invoke", "info", 0, logger, "updateWrapperFile() <<<");
        }
    }

    public static File findLatestFile(File folder, String filePrefix) {
        Reference filePrefix2 = new Reference((Object)filePrefix);
        CallSite files = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "list", 0, folder));
        Reference fileName = new Reference(null);
        String cfr_ignored_0 = (String)fileName.get();
        Reference latest = new Reference(null);
        public final class _findLatestFile_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference filePrefix;
            private /* synthetic */ Reference latest;
            private /* synthetic */ Reference fileName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findLatestFile_closure1(Object _outerInstance, Object _thisObject, Reference filePrefix, Reference latest, Reference fileName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.filePrefix = reference3 = filePrefix;
                this.latest = reference2 = latest;
                this.fileName = reference = fileName;
            }

            public Object doCall(Object it) {
                if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)it, (Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.filePrefix.get())}, new String[]{"", ""}))) != false) {
                    CallSite ts = IndyInterface.bootstrap("cast", "()", 0, it);
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "length", 0, ts), (Object)IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "length", 0, IndyInterface.bootstrap("cast", "()", 0, this.filePrefix.get())), true))) {
                        ts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, ts, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "length", 0, IndyInterface.bootstrap("cast", "()", 0, this.filePrefix.get())), true)));
                        CallSite d = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("getProperty", "dateFormatter", 12, this), ts));
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)d, null)) {
                            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.latest.get()), null)) {
                                CallSite callSite = d;
                                this.latest.set((Object)callSite);
                                Object object = it;
                                this.fileName.set((Object)IndyInterface.bootstrap("cast", "()", 0, object));
                                return object;
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "after", 0, d, IndyInterface.bootstrap("cast", "()", 0, this.latest.get()))) != false) {
                                CallSite callSite = d;
                                this.latest.set((Object)callSite);
                                Object object = it;
                                this.fileName.set((Object)IndyInterface.bootstrap("cast", "()", 0, object));
                                return object;
                            }
                        }
                    }
                }
                return null;
            }

            @Generated
            public String getFilePrefix() {
                return IndyInterface.bootstrap("cast", "()", 0, this.filePrefix.get());
            }

            @Generated
            public Date getLatest() {
                return IndyInterface.bootstrap("cast", "()", 0, this.latest.get());
            }

            @Generated
            public String getFileName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.fileName.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findLatestFile_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, files, new _findLatestFile_closure1(ConfigFileAccessHelper.class, ConfigFileAccessHelper.class, filePrefix2, latest, fileName));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)((String)fileName.get()), null)) {
            CallSite file = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, folder, (String)fileName.get()));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, file)) != false) {
                IndyInterface.bootstrap("invoke", "println", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Latest backup file of ", (String)filePrefix2.get()), " is: "), IndyInterface.bootstrap("invoke", "getName", 0, file)));
                return file;
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public static List<File> findLatestFile(File appServerFolder, String serverName, String filePrefix) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "findLatestFile() >>>");
        String subPath = "conf";
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, filePrefix, "setenv"), (Object)0)) {
            subPath = "bin";
        }
        CallSite filesToReturn = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class, 2));
        CallSite serverInstanceBackupFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, appServerFolder, "Backup"));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, serverInstanceBackupFolder)) != false) {
            CallSite serverInstanceFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findLatestFile", 0, ConfigFileAccessHelper.class, serverInstanceBackupFolder, serverName));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)serverInstanceFolder, null)) {
                CallSite confFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, serverInstanceFolder, subPath));
                CallSite file = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, confFolder, filePrefix));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, file)) != false) {
                    IndyInterface.bootstrap("invoke", "add", 0, filesToReturn, file);
                    return filesToReturn;
                }
            }
        }
        CallSite serverInstanceFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, appServerFolder, serverName));
        CallSite confFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, serverInstanceFolder, subPath));
        CallSite backupFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, confFolder, "Backup"));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, backupFolder)) != false) {
            CallSite file = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findLatestFile", 0, ConfigFileAccessHelper.class, backupFolder, filePrefix));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)file, null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "exists", 0, file))) {
                IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "file : ", IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, file)));
                IndyInterface.bootstrap("invoke", "add", 0, filesToReturn, file);
            }
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "findLatestFile() <<<");
        return filesToReturn;
    }

    public static List<File> findLatestFile(SDW sdw, String serverName, String filePrefix) {
        CallSite tcHelper = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, TCServerHelper.class, sdw));
        CallSite appServerFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTCServerInstanceDir", 0, tcHelper));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)appServerFolder, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findLatestFile", 0, ConfigFileAccessHelper.class, appServerFolder, serverName, filePrefix));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class, 2));
    }

    public static List<File> findLatestFile(GlobalResource globalResource, String serverName, String filePrefix) {
        CallSite appServerFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTcServerInstanceDir", 0, globalResource));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)appServerFolder, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findLatestFile", 0, ConfigFileAccessHelper.class, appServerFolder, serverName, filePrefix));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class, 2));
    }

    public static String copyFile(File sourceFile, File targetFolder, String tgtFile) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Copying file ", IndyInterface.bootstrap("invoke", "getName", 0, sourceFile)), " to "), IndyInterface.bootstrap("invoke", "getPath", 0, targetFolder)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, targetFolder)) == false) {
            IndyInterface.bootstrap("invoke", "mkdir", 0, targetFolder);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, sourceFile)) != false) {
            IndyInterface.bootstrap("invoke", "copyFileToDirectory", 0, FileUtils.class, sourceFile, targetFolder, false);
            sourceFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, targetFolder, IndyInterface.bootstrap("invoke", "getName", 0, sourceFile)));
            CallSite targetFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, targetFolder, tgtFile));
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "renameTo", 0, sourceFile, targetFile));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "warn", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "File not found: ", IndyInterface.bootstrap("invoke", "getPath", 0, sourceFile))));
    }

    public static String getPropertyValue(File propertyFile, String name) {
        CallSite props = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Properties.class));
        IndyInterface.bootstrap("invoke", "load", 0, props, IndyInterface.bootstrap("init", "<init>", 0, FileInputStream.class, propertyFile));
        CallSite property = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getProperty", 0, props, name));
        return property;
    }

    public static Object restoreSSLSASConfSettings(AbstractGlobal globalResource) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "Restore web server configuration file");
        CallSite confFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getWebServerInstanceDir", 0, globalResource), "conf"));
        CallSite backupFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, confFolder, "Backup"));
        IndyInterface.bootstrap("invoke", "info", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "Backup sas.conf location: ", IndyInterface.bootstrap("invoke", "getPath", 0, backupFolder)));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)backupFolder, null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "exists", 0, backupFolder))) {
            CallSite sasConfLatestBackupFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findLatestFile", 0, ConfigFileAccessHelper.class, backupFolder, "sas.conf"));
            CallSite sasConf = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, confFolder, "sas.conf"));
            return IndyInterface.bootstrap("invoke", "updateSasConfSSLSettings", 0, ConfigFileAccessHelper.class, sasConfLatestBackupFile, sasConf);
        }
        return null;
    }

    public static void updateSasConfSSLSettings(File oldSasConf, File sasConf) {
        IndyInterface.bootstrap("invoke", "info", 0, logger, "updateSasConfSSLSettings() >>>");
        CallSite proxySSLProxyEngineLine = null;
        CallSite sslProxyVerifyLine = null;
        CallSite sslProxyVerifyDepthLine = null;
        CallSite sslProxyCACertificateLine = null;
        CallSite sslProxyCheckPeerCN = null;
        CallSite sslProxyCheckPeerName = null;
        int count = 0;
        CallSite newLines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "getText", 0, sasConf), "\n"));
        CallSite newProxies = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class));
        int i = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("getProperty", "length", 0, newLines))) {
            if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, newLines, i), (Object)"<Proxy balancer:")) != false) {
                IndyInterface.bootstrap("invoke", "add", 0, newProxies, IndyInterface.bootstrap("invoke", "getAt", 0, newLines, i));
            }
            int n = i;
            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        CallSite existingBalancers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        CallSite balancerMemberBuf = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
        CallSite lines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "getText", 0, oldSasConf), "\n"));
        int i2 = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)i2, (Object)IndyInterface.bootstrap("getProperty", "length", 0, lines))) {
            if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"^SSLProxyEngine")) != false) {
                proxySSLProxyEngineLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2));
                int n = count;
                count = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            } else if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"SSLProxyVerifyDepth")) != false) {
                sslProxyVerifyDepthLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2));
                int n = count;
                count = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            } else if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"SSLProxyVerify ")) != false) {
                sslProxyVerifyLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2));
                int n = count;
                count = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            } else if (DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"SSLProxyCACertificateFile")) || DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"SSLProxyCACertificatePath"))) {
                sslProxyCACertificateLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2));
                int n = count;
                count = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"SSLProxyCheckPeerCN")) != false) {
                sslProxyCheckPeerCN = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2));
                int n = count;
                count = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"SSLProxyCheckPeerName")) != false) {
                sslProxyCheckPeerName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2));
                int n = count;
                count = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"<Proxy balancer:")) != false) {
                CallSite members = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class));
                IndyInterface.bootstrap("invoke", "put", 0, existingBalancers, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), members);
                boolean proxyExists = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, newProxies, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2)));
                while (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"</Proxy>")) == false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2), (Object)"BalancerMember")) != false) {
                        IndyInterface.bootstrap("invoke", "add", 0, members, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2));
                    }
                    if (!proxyExists) {
                        IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, balancerMemberBuf, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2)), "\n");
                    }
                    int n = i2;
                    i2 = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                }
                if (!proxyExists) {
                    IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, balancerMemberBuf, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i2)), "\n\n");
                }
            }
            int n = i2;
            i2 = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        if (ScriptBytecodeAdapter.compareEqual(proxySSLProxyEngineLine, null) || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("invoke", "trim", 0, proxySSLProxyEngineLine), "SSLProxyEngine on")) == false) {
            IndyInterface.bootstrap("invoke", "info", 0, logger, "App Server SSL is not enabled, exit");
            return;
        }
        lines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "getText", 0, sasConf), "\n"));
        CallSite sasConfContent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)proxySSLProxyEngineLine, null)) {
            IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, sasConfContent, proxySSLProxyEngineLine), "\n");
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)sslProxyVerifyLine, null)) {
            IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, sasConfContent, sslProxyVerifyLine), "\n");
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)sslProxyVerifyDepthLine, null)) {
            IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, sasConfContent, sslProxyVerifyDepthLine), "\n");
        }
        if (ScriptBytecodeAdapter.compareNotEqual(sslProxyCACertificateLine, null)) {
            IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, sasConfContent, sslProxyCACertificateLine), "\n");
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)sslProxyCheckPeerCN, null)) {
            IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, sasConfContent, sslProxyCheckPeerCN), "\n");
        }
        if (ScriptBytecodeAdapter.compareNotEqual(sslProxyCheckPeerName, null)) {
            IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, sasConfContent, sslProxyCheckPeerName), "\n");
        }
        IndyInterface.bootstrap("invoke", "info", 0, logger, "updateSasConf() find balancer members in current file");
        count = 0;
        CallSite newBalancers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
        int i3 = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)i3, (Object)IndyInterface.bootstrap("getProperty", "length", 0, lines))) {
            if (count < 6 && (DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"SSLProxyEngine")) || DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"SSLProxyVerify")) || DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"SSLProxyVerifyDepth")) || DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"SSLProxyCACertificateFile"))) || DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"SSLProxyCACertificatePath")) || DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"SSLProxyCheckPeerCN")) || DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"SSLProxyCheckPeerName"))) {
                int n = count;
                count = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            } else if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"<Proxy balancer:")) != false) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, existingBalancers, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3))) != false) {
                    CallSite existingBalancerMembers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, existingBalancers, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3)));
                    while (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"</Proxy>")) == false && ScriptBytecodeAdapter.compareLessThan((Object)i3, (Object)IndyInterface.bootstrap("getProperty", "length", 0, lines))) {
                        if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"BalancerMember")) != false) {
                            CallSite member = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findMatchingBalancerMember", 0, ConfigFileAccessHelper.class, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), existingBalancerMembers));
                            IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, newBalancers, member), "\n");
                        } else {
                            IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, newBalancers, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3)), "\n");
                        }
                        int n = i3;
                        i3 = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                    }
                    IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, newBalancers, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3)), "\n\n");
                } else {
                    while (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3), (Object)"</Proxy>")) == false && ScriptBytecodeAdapter.compareLessThan((Object)i3, (Object)IndyInterface.bootstrap("getProperty", "length", 0, lines))) {
                        IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, newBalancers, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3)), "\n");
                        int n = i3;
                        i3 = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                    }
                    IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, newBalancers, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3)), "\n\n");
                }
            } else {
                IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, sasConfContent, IndyInterface.bootstrap("invoke", "getAt", 0, lines, i3)), "\n");
            }
            int n = i3;
            i3 = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        while (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "charAt", 0, sasConfContent, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "length", 0, sasConfContent), true)), (Object)"\n")) {
            IndyInterface.bootstrap("invoke", "deleteCharAt", 0, sasConfContent, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "length", 0, sasConfContent), true));
        }
        IndyInterface.bootstrap("invoke", "append", 0, sasConfContent, "\n\n");
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "length", 0, balancerMemberBuf), (Object)0)) {
            IndyInterface.bootstrap("invoke", "append", 0, sasConfContent, IndyInterface.bootstrap("invoke", "toString", 0, balancerMemberBuf));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "length", 0, newBalancers), (Object)0)) {
            IndyInterface.bootstrap("invoke", "append", 0, sasConfContent, IndyInterface.bootstrap("invoke", "toString", 0, newBalancers));
        }
        while (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "charAt", 0, sasConfContent, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "length", 0, sasConfContent), true)), (Object)"\n")) {
            IndyInterface.bootstrap("invoke", "deleteCharAt", 0, sasConfContent, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "length", 0, sasConfContent), true));
        }
        IndyInterface.bootstrap("invoke", "write", 0, sasConf, IndyInterface.bootstrap("invoke", "toString", 0, sasConfContent));
        IndyInterface.bootstrap("invoke", "info", 0, logger, "updateSasConfSSLSettings() <<<");
    }

    public static File getLatestBackupDir(File backupDir, String name) {
        CallSite result = null;
        CallSite backupDirNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDirectory", 0, backupDir)) != false) {
            CallSite bak = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "listFiles", 0, backupDir)));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    bak = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                    if (!(DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isDirectory", 0, bak)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("invoke", "getName", 0, bak), name)))) continue;
                    IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{name, bak}, new String[]{"Found match for '", "' in backup directory. Match is ", ""}));
                    IndyInterface.bootstrap("invoke", "add", 0, backupDirNames, IndyInterface.bootstrap("invoke", "getName", 0, bak));
                }
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, backupDirNames)) == false) {
                IndyInterface.bootstrap("invoke", "sort", 0, Collections.class, backupDirNames);
                result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, backupDir, IndyInterface.bootstrap("invoke", "get", 0, backupDirNames, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "size", 0, backupDirNames), true))));
            } else {
                IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{name, backupDir}, new String[]{"No matches for '", "' in backup directory: ", ""}));
            }
        } else {
            IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{backupDir}, new String[]{"Directory [", "] does not exist."}));
        }
        return result;
    }

    public static File getServerBackupDirectory(GlobalResource globalResource, String serverName) {
        CallSite serverBackupDir = null;
        CallSite instanceDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTcServerInstanceDir", 0, globalResource));
        CallSite instanceBackupDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, instanceDir, "Backup"));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, instanceBackupDir)) != false) {
            serverBackupDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLatestBackupDir", 0, ConfigFileAccessHelper.class, instanceBackupDir, serverName));
        }
        return serverBackupDir;
    }

    public static boolean wrapInEscapedQuotesAsNeeded(StringBuilder builderValue, OsType osType) {
        boolean modified = false;
        if (ScriptBytecodeAdapter.compareEqual((Object)osType, (Object)IndyInterface.bootstrap("getProperty", "WINDOWS", 0, OsType.class)) && IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)builderValue, (Object)"^\\^\".*\\^\"$")) == false && IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)builderValue, (Object)"^'.*'$")) == false && DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)builderValue, (Object)"^.* .*$"))) {
            if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)builderValue, (Object)"^\".*\".*\"$")) != false) {
                IndyInterface.bootstrap("invoke", "delete", 0, builderValue, false, true);
                IndyInterface.bootstrap("invoke", "delete", 0, builderValue, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "length", 0, builderValue), true), IndyInterface.bootstrap("invoke", "length", 0, builderValue));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)builderValue, (Object)"^.* .*$")) && IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)builderValue, (Object)"^.*\".*$")) == false) {
                IndyInterface.bootstrap("invoke", "insert", 0, builderValue, false, "\"");
                IndyInterface.bootstrap("invoke", "insert", 0, builderValue, IndyInterface.bootstrap("invoke", "length", 0, builderValue), "\"");
                modified = true;
            } else if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)builderValue, (Object)"^\".*\"$")) == false) {
                IndyInterface.bootstrap("invoke", "insert", 0, builderValue, false, "^\"");
                IndyInterface.bootstrap("invoke", "insert", 0, builderValue, IndyInterface.bootstrap("invoke", "length", 0, builderValue), "^\"");
                modified = true;
            }
        }
        return modified;
    }

    public static String findMatchingBalancerMember(String balancerMember, Set<String> balancerMembers) {
        CallSite member = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, balancerMembers));
        if (callSite != null) {
            while (callSite.hasNext()) {
                member = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isSameBalancerMember", 0, ConfigFileAccessHelper.class, balancerMember, member)) == false) continue;
                IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{balancerMember, member}, new String[]{"Found matching BalancerMembers. Original: ", ", found: ", ""}));
                return member;
            }
        }
        return balancerMember;
    }

    public static boolean isSameBalancerMember(String bm1, String bm2) {
        CallSite host1 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractHostname", 0, ConfigFileAccessHelper.class, bm1));
        CallSite host2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractHostname", 0, ConfigFileAccessHelper.class, bm2));
        if (ScriptBytecodeAdapter.compareEqual((Object)host1, null) || ScriptBytecodeAdapter.compareEqual((Object)host2, null) || ScriptBytecodeAdapter.compareNotEqual((Object)host1, (Object)host2)) {
            return false;
        }
        CallSite route1 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractRoute", 0, ConfigFileAccessHelper.class, bm1));
        CallSite route2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractRoute", 0, ConfigFileAccessHelper.class, bm2));
        return ScriptBytecodeAdapter.compareEqual((Object)route1, (Object)route2);
    }

    public static String extractHostname(String balancerMember) {
        Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)balancerMember, (Object)"BalancerMember\\s+https?://([^:/\\s]+)");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, matcher)) != false ? IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAt", 0, matcher, false), true) : null);
    }

    public static String extractRoute(String balancerMember) {
        Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)balancerMember, (Object)"route=([^\\s]+)");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, matcher)) != false ? IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAt", 0, matcher, false), true) : null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConfigFileAccessHelper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LogManager.class, ConfigFileAccessHelper.class);
        logger = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, SimpleDateFormat.class, BACKUP_FILE_DATE_FORMAT);
        dateFormatter = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "getProperty", 0, System.class, "line.separator");
        LINE_SEPARATOR = IndyInterface.bootstrap("cast", "()", 0, callSite3);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{SSL_HOST_CONFIG_XPATH, CERTIFICATE_XPATH});
        CONNECTOR_ELEMENTS = list;
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sslProtocol", ScriptBytecodeAdapter.createList((Object[])new Object[]{SSL_HOST_CONFIG_XPATH, "sslProtocol"}), "sslEnabledProtocols", ScriptBytecodeAdapter.createList((Object[])new Object[]{SSL_HOST_CONFIG_XPATH, "protocols"}), "ciphers", ScriptBytecodeAdapter.createList((Object[])new Object[]{SSL_HOST_CONFIG_XPATH, "ciphers"}), "keystoreFile", ScriptBytecodeAdapter.createList((Object[])new Object[]{CERTIFICATE_XPATH, "certificateKeystoreFile"}), "keystorePass", ScriptBytecodeAdapter.createList((Object[])new Object[]{CERTIFICATE_XPATH, "certificateKeystorePassword"}), "SSLCertificateFile", ScriptBytecodeAdapter.createList((Object[])new Object[]{CERTIFICATE_XPATH, "certificateFile"}), "SSLCertificateKeyFile", ScriptBytecodeAdapter.createList((Object[])new Object[]{CERTIFICATE_XPATH, "certificateKeyFile"}), "SSLCertificateChainFile", ScriptBytecodeAdapter.createList((Object[])new Object[]{CERTIFICATE_XPATH, "certificateChainFile"}), "SSLPassword", ScriptBytecodeAdapter.createList((Object[])new Object[]{CERTIFICATE_XPATH, "certificateKeyPassword"})});
        DEPRECATED_ATTRIBUTES_MAP = map;
    }
}

