/*
 * Decompiled with CFR 0.152.
 */
package com.sas.appserver.scripting;

import com.sas.appserver.factory.ResourceFactoryImpl;
import com.sas.appserver.impl.AbstractGlobal;
import com.sas.appserver.scripting.Command;
import com.sas.appserver.scripting.CommandConstraints;
import com.sas.appserver.scripting.HelpException;
import com.sas.appserver.scripting.Operation;
import com.sas.appserver.scripting.Scope;
import com.sas.appserver.scripting.ScriptingExceptionHandler;
import com.sas.appserver.template.VelocityTemplateEngine;
import com.sas.appserver.utils.AppServerContextBuilder;
import com.sas.appserver.utils.AppServerUpdateContextBuilder;
import com.sas.appserver.utils.ContainerType;
import com.sas.appserver.utils.ResourceManager;
import com.sas.appserver.utils.ResourceManagerImpl;
import com.sas.appserver.utils.ResourceType;
import com.sas.appserver.vfabrictcsvr.ScriptDriver;
import com.sas.appserver.weblogic.WebLogicCommandConstraints;
import com.sas.sdw.SDWException;
import groovy.cli.commons.CliBuilder;
import groovy.cli.commons.OptionAccessor;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public abstract class AbstractScriptDriver
implements GroovyObject {
    private static Logger logger;
    public static final String EXECUTE_TYPE_COMMAND = "Command";
    public static final String EXECUTE_TYPE_SCRIPT = "Script";
    public static final String EXECUTE_TYPE_INTERPRETER = "Interpreter";
    public static final String EXECUTE_TYPE_NOT_SET = "not-set";
    public static final String EXECUTE_TYPE_ALL_RESOURCES = "All";
    public static final String EXECUTE_TYPE_START_RESOURCES = "Start";
    public static final String EXECUTE_TYPE_STOP_RESOURCES = "Stop";
    public static final String EXECUTE_TYPE_RESTART_RESOURCES = "Restart";
    public static final String EXECUTE_TYPE_CLUSTERED_APP_RESOURCES = "ConfigureCluster";
    public static final String EXECUTE_TYPE_GENERATE_ONLY = "Generate";
    public static final String DEFAULT_SCRIPT = "taskfile";
    public static final String DEFAULT_START_SCRIPT = "start_taskfile";
    public static final String DEFAULT_STOP_SCRIPT = "stop_taskfile";
    public static final String DEFAULT_RESTART_SCRIPT = "restart_taskfile";
    public static final String DEFAULT_CONFIGURE_CLUSTER_SCRIPT = "configure_cluster_taskfile";
    public static final String UNKNOWN_STATUS = "UNKNOWN";
    public static final String STARTED_STATUS = "STARTED";
    public static final String STOPPED_STATUS = "STOPPED";
    private String executeType;
    private File scriptFile;
    private Command command;
    private Boolean useScope;
    private CommandConstraints constraint;
    private ResourceManager resourceManager;
    private static CliBuilder cli;
    private Boolean requireCredentials;
    private static boolean hasException;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public AbstractScriptDriver() {
        MetaClass metaClass;
        String string;
        this.executeType = string = EXECUTE_TYPE_NOT_SET;
        Object var2_2 = null;
        this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, var2_2);
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, Command.class);
        this.command = IndyInterface.bootstrap("cast", "()", 0, callSite);
        boolean bl = true;
        this.useScope = bl;
        boolean bl2 = true;
        this.requireCredentials = bl2;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Boolean getRequireCredentials() {
        return this.requireCredentials;
    }

    public void setRequireCredentials(Boolean value) {
        Boolean bl;
        this.requireCredentials = bl = value;
    }

    public String getExecuteType() {
        return this.executeType;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public Command getCommand() {
        return this.command;
    }

    public Boolean isScopeSupported() {
        return this.useScope;
    }

    public void scopeIsNotSupported() {
        boolean bl = false;
        this.useScope = bl;
    }

    public void scopeIsSupported() {
        boolean bl = true;
        this.useScope = bl;
    }

    public Boolean isInteractive() {
        return ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_INTERPRETER);
    }

    protected final void setCommandConstraint(CommandConstraints c) {
        CommandConstraints commandConstraints;
        this.constraint = commandConstraints = c;
    }

    public final CommandConstraints getCommandConstraints() {
        return this.constraint;
    }

    protected final ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public final void setResourceManager(ResourceManager rm) {
        ResourceManager resourceManager;
        this.resourceManager = resourceManager = rm;
    }

    public abstract void doExecute(Command var1);

    public void doPostExecute() {
    }

    public static final void main(String ... args) {
        boolean bl;
        CallSite scriptingDirectory = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getenv", 0, System.class, "SCRIPTING_DIR")));
        IndyInterface.bootstrap("invoke", "configureBootstrapLogger", 0, AbstractScriptDriver.class, scriptingDirectory);
        CallSite containerType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, ContainerType.class, IndyInterface.bootstrap("invoke", "getenv", 0, System.class, "CONTAINER_TYPE")));
        CallSite script = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, AbstractScriptDriver.class, containerType));
        String productPath = "AppServer";
        if (ScriptBytecodeAdapter.compareEqual((Object)containerType, (Object)IndyInterface.bootstrap("getProperty", "WEB_SERVER", 0, ContainerType.class))) {
            productPath = "WebServer";
        } else if (ScriptBytecodeAdapter.compareEqual((Object)containerType, (Object)IndyInterface.bootstrap("getProperty", "HYPERIC_SERVER", 0, ContainerType.class))) {
            productPath = "SASEnvironmentManager";
        } else if (ScriptBytecodeAdapter.compareEqual((Object)containerType, (Object)IndyInterface.bootstrap("getProperty", "HYPERIC_AGENT", 0, ContainerType.class))) {
            productPath = "SASEnvironmentManagerAgent";
        }
        CallSite logpath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, scriptingDirectory), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), productPath), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), "logs"));
        CallSite statusFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, logpath, "status.txt"));
        IndyInterface.bootstrap("invoke", "println", 0, AbstractScriptDriver.class, "Script is running now. It might take longer time to complete with some options ...");
        IndyInterface.bootstrap("invoke", "println", 0, AbstractScriptDriver.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Please check the running status from the log files in the directory ", logpath), " for more details."));
        CallSite globalResource = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGlobalResource", 0, script, containerType, scriptingDirectory));
        IndyInterface.bootstrap("invoke", "setupLogger", 0, script, globalResource);
        hasException = bl = false;
        try {
            try {
                IndyInterface.bootstrap("invoke", "parseCommandLine", 0, script, args);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRequireCredentials", 0, script)) != false) {
                    globalResource = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGlobalResource", 0, script, containerType, scriptingDirectory, true));
                }
                IndyInterface.bootstrap("invoke", "execute", 0, script, args);
            }
            catch (HelpException e) {
            }
            catch (Exception e) {
                boolean bl2;
                CallSite handler = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ScriptingExceptionHandler.class));
                IndyInterface.bootstrap("invoke", "handle", 0, handler, e);
                hasException = bl2 = true;
            }
        }
        catch (Throwable throwable) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getExecuteType", 0, script), (Object)EXECUTE_TYPE_START_RESOURCES) || ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getExecuteType", 0, script), (Object)EXECUTE_TYPE_RESTART_RESOURCES)) {
                if (hasException) {
                    IndyInterface.bootstrap("invoke", "setText", 0, statusFile, IndyInterface.bootstrap("getProperty", "UNKNOWN_STATUS", 0, AbstractScriptDriver.class));
                } else {
                    IndyInterface.bootstrap("invoke", "setText", 0, statusFile, IndyInterface.bootstrap("getProperty", "STARTED_STATUS", 0, AbstractScriptDriver.class));
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getExecuteType", 0, script), (Object)EXECUTE_TYPE_STOP_RESOURCES)) {
                if (hasException) {
                    IndyInterface.bootstrap("invoke", "setText", 0, statusFile, IndyInterface.bootstrap("getProperty", "UNKNOWN_STATUS", 0, AbstractScriptDriver.class));
                } else {
                    IndyInterface.bootstrap("invoke", "setText", 0, statusFile, IndyInterface.bootstrap("getProperty", "STOPPED_STATUS", 0, AbstractScriptDriver.class));
                }
            }
            throw throwable;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getExecuteType", 0, script), (Object)EXECUTE_TYPE_START_RESOURCES) || ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getExecuteType", 0, script), (Object)EXECUTE_TYPE_RESTART_RESOURCES)) {
            if (hasException) {
                IndyInterface.bootstrap("invoke", "setText", 0, statusFile, IndyInterface.bootstrap("getProperty", "UNKNOWN_STATUS", 0, AbstractScriptDriver.class));
            } else {
                IndyInterface.bootstrap("invoke", "setText", 0, statusFile, IndyInterface.bootstrap("getProperty", "STARTED_STATUS", 0, AbstractScriptDriver.class));
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getExecuteType", 0, script), (Object)EXECUTE_TYPE_STOP_RESOURCES)) {
            if (hasException) {
                IndyInterface.bootstrap("invoke", "setText", 0, statusFile, IndyInterface.bootstrap("getProperty", "UNKNOWN_STATUS", 0, AbstractScriptDriver.class));
            } else {
                IndyInterface.bootstrap("invoke", "setText", 0, statusFile, IndyInterface.bootstrap("getProperty", "STOPPED_STATUS", 0, AbstractScriptDriver.class));
            }
        }
        IndyInterface.bootstrap("invoke", "println", 0, AbstractScriptDriver.class, "Script has ended.");
        IndyInterface.bootstrap("invoke", "exit", 0, System.class, hasException);
    }

    private void updateAppServerStatus(File statusFile, String status) {
        IndyInterface.bootstrap("invoke", "setText", 0, statusFile, status);
    }

    private long getPID() {
        CallSite bean = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRuntimeMXBean", 0, ManagementFactory.class));
        CallSite jvmName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getName", 0, bean));
        IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "out", 0, System.class), IndyInterface.bootstrap("invoke", "plus", 0, "Name = ", jvmName));
        long pid = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "valueOf", 0, Long.class, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "split", 0, jvmName, "@"), false)));
        IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "out", 0, System.class), IndyInterface.bootstrap("invoke", "plus", 0, "PID  = ", pid));
        return pid;
    }

    public static Object configureBootstrapLogger(File scriptingDir) {
        CallSite rootLogger = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRootLogger", 0, LogManager.class));
        CallSite ctx = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getContext", 0, LogManager.class, false));
        CallSite config = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getConfiguration", 0, ctx));
        CallSite loggerConfig = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRootLogger", 0, config));
        CallSite appenders = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAppenders", 0, loggerConfig));
        CallSite entry = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "entrySet", 0, appenders)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                entry = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                IndyInterface.bootstrap("invoke", "removeAppender", 0, loggerConfig, IndyInterface.bootstrap("invoke", "getName", 0, IndyInterface.bootstrap("invoke", "getValue", 0, entry)));
            }
        }
        IndyInterface.bootstrap("invoke", "setLevel", 0, loggerConfig, IndyInterface.bootstrap("getProperty", "DEBUG", 0, Level.class));
        IndyInterface.bootstrap("invoke", "updateLoggers", 0, ctx);
        CallSite layout = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "withPattern", 0, IndyInterface.bootstrap("invoke", "newBuilder", 0, PatternLayout.class), IndyInterface.bootstrap("getProperty", "TTCC_CONVERSION_PATTERN", 0, PatternLayout.class))));
        CallSite rfa = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "withImmediateFlush", 0, IndyInterface.bootstrap("invoke", "withLayout", 0, IndyInterface.bootstrap("invoke", "withFileName", 0, IndyInterface.bootstrap("invoke", "newBuilder", 0, RollingFileAppender.class), IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, scriptingDir, "AppServer/logs/bootstrap.log"))), layout), true)));
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "addAppender", 0, config, rfa);
        try {
            return callSite2;
        }
        catch (IOException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, "Failed to initialize bootstrap logger.", e));
        }
    }

    public static final AbstractScriptDriver newInstance(ContainerType containerType) {
        CallSite driver = null;
        ContainerType containerType2 = containerType;
        if (ScriptBytecodeAdapter.isCase((Object)containerType2, (Object)IndyInterface.bootstrap("getProperty", "WEBLOGIC", 0, ContainerType.class))) {
            driver = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, com.sas.appserver.weblogic.ScriptDriver.class));
            IndyInterface.bootstrap("invoke", "scopeIsNotSupported", 0, driver);
            CallSite c = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, WebLogicCommandConstraints.class, IndyInterface.bootstrap("getProperty", "global", 4, driver)));
            IndyInterface.bootstrap("invoke", "setCommandConstraint", 0, driver, c);
        } else if (ScriptBytecodeAdapter.isCase((Object)containerType2, (Object)IndyInterface.bootstrap("getProperty", "TC_SERVER", 0, ContainerType.class))) {
            driver = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ScriptDriver.class));
            IndyInterface.bootstrap("invoke", "setCommandConstraint", 0, driver, IndyInterface.bootstrap("init", "<init>", 0, com.sas.appserver.vfabrictcsvr.CommandConstraints.class));
        } else if (ScriptBytecodeAdapter.isCase((Object)containerType2, (Object)IndyInterface.bootstrap("getProperty", "JBOSS", 0, ContainerType.class))) {
            driver = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, com.sas.appserver.jboss.ScriptDriver.class));
            IndyInterface.bootstrap("invoke", "setCommandConstraint", 0, driver, IndyInterface.bootstrap("init", "<init>", 0, com.sas.appserver.jboss.CommandConstraints.class));
            IndyInterface.bootstrap("invoke", "scopeIsNotSupported", 0, driver);
        } else if (ScriptBytecodeAdapter.isCase((Object)containerType2, (Object)IndyInterface.bootstrap("getProperty", "WEB_SERVER", 0, ContainerType.class))) {
            driver = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, com.sas.appserver.vfabrcersvrc.ScriptDriver.class));
            IndyInterface.bootstrap("invoke", "setCommandConstraint", 0, driver, IndyInterface.bootstrap("init", "<init>", 0, com.sas.appserver.vfabrcersvrc.CommandConstraints.class));
        } else if (ScriptBytecodeAdapter.isCase((Object)containerType2, (Object)IndyInterface.bootstrap("getProperty", "HYPERIC_SERVER", 0, ContainerType.class))) {
            driver = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, com.sas.appserver.vfabrchyperc.ScriptDriver.class));
            IndyInterface.bootstrap("invoke", "setCommandConstraint", 0, driver, IndyInterface.bootstrap("init", "<init>", 0, com.sas.appserver.vfabrchyperc.CommandConstraints.class));
        } else {
            if (ScriptBytecodeAdapter.isCase((Object)containerType2, (Object)IndyInterface.bootstrap("getProperty", "WEBSPHERE", 0, ContainerType.class))) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{containerType}, new String[]{"AbstractScriptDriver does not support the containerType : ", "."})));
            }
            if (ScriptBytecodeAdapter.isCase((Object)containerType2, (Object)IndyInterface.bootstrap("getProperty", "WEBSPHERE_BASE", 0, ContainerType.class))) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{containerType}, new String[]{"AbstractScriptDriver does not support the containerType : ", "."})));
            }
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{containerType}, new String[]{"AbstractScriptDriver does not support the containerType : ", "."})));
        }
        return driver;
    }

    /*
     * Unable to fully structure code
     */
    public void execute(String ... args) {
        cmdLine = null;
        commandReader = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCommandReader", 2, this));
        while (true) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)commandReader)) ** GOTO lbl-1000
            v0 = IndyInterface.bootstrap("invoke", "readLine", 0, commandReader);
            cmdLine = IndyInterface.bootstrap("cast", "()", 0, v0);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)v0, null)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) break;
            try {
                cmd = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildCommand", 2, this, cmdLine));
                if (IndyInterface.bootstrap("cast", "()", 0, this.constraint) != false) {
                    IndyInterface.bootstrap("invoke", "validate", 0, this.constraint, cmd);
                }
                IndyInterface.bootstrap("invoke", "doExecute", 2, this, cmd);
            }
            catch (Exception e) {
                handler = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ScriptingExceptionHandler.class));
                IndyInterface.bootstrap("invoke", "handle", 0, handler, e);
                AbstractScriptDriver.hasException = var7_7 = true;
            }
        }
        IndyInterface.bootstrap("invoke", "doPostExecute", 2, this);
    }

    public Command buildCommand(String commandLine) {
        CallSite parms = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, commandLine, " "));
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isScopeSupported", 2, this)) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, parms), (Object)5) || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isScopeSupported", 2, this)) == false && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, parms), (Object)4)) {
            int targetPosition = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isScopeSupported", 2, this)) != false ? 4 : 3;
            Object var4_4 = null;
            this.command = IndyInterface.bootstrap("cast", "()", 0, var4_4);
            IndyInterface.bootstrap("invoke", "parseOperation", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, parms, false));
            IndyInterface.bootstrap("invoke", "parseResourceType", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, parms, true));
            IndyInterface.bootstrap("invoke", "parseResourceName", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, parms, 2));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isScopeSupported", 2, this)) != false) {
                IndyInterface.bootstrap("invoke", "parseScope", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, parms, 3));
            }
            IndyInterface.bootstrap("invoke", "parseTargetName", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, parms, targetPosition));
            IndyInterface.bootstrap("invoke", "validate", 0, this.constraint, this.command);
            IndyInterface.bootstrap("invoke", "debug", 0, logger, new GStringImpl(new Object[]{this.command}, new String[]{"Adding command to list: ", ""}));
            return this.command;
        }
        CallSite message = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{commandLine}, new String[]{"Invalid command line parsed:  ", ""}));
        IndyInterface.bootstrap("invoke", "error", 0, logger, message);
        IndyInterface.bootstrap("invoke", "println", 2, this, message);
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, message));
    }

    public final AbstractGlobal getGlobalResource(ContainerType containerType, File scriptingDirectory) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGlobalResource", 2, this, containerType, scriptingDirectory, false));
    }

    public final AbstractGlobal getGlobalResource(ContainerType containerType, File scriptingDirectory, boolean prompt) {
        CallSite rf = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResourceFactoryImpl.class, containerType));
        CallSite global = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, rf, IndyInterface.bootstrap("getProperty", "GLOBAL", 0, ResourceType.class)));
        IndyInterface.bootstrap("invoke", "setScriptingDir", 0, global, scriptingDirectory);
        IndyInterface.bootstrap("invoke", "setContainerType", 0, global, containerType);
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ResourceManagerImpl.class, global);
        this.resourceManager = IndyInterface.bootstrap("cast", "()", 0, callSite);
        IndyInterface.bootstrap("invoke", "loadResources", 0, this.resourceManager, true, prompt);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResource", 0, this.resourceManager, IndyInterface.bootstrap("getProperty", "GLOBAL", 0, ResourceType.class)));
    }

    public final void setupLogger(AbstractGlobal globalResource) {
        CallSite context = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getContext", 0, LogManager.class, false));
        CallSite file = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, IndyInterface.bootstrap("invoke", "getLogConfigurationFile", 0, globalResource))));
        IndyInterface.bootstrap("invoke", "setConfigLocation", 0, context, IndyInterface.bootstrap("invoke", "toURI", 0, file));
    }

    private final boolean parseExecType(String type) {
        CallSite etype = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, type));
        if (ScriptBytecodeAdapter.compareEqual((Object)etype, (Object)"run") || ScriptBytecodeAdapter.compareEqual((Object)etype, (Object)"command")) {
            String string;
            this.executeType = string = EXECUTE_TYPE_COMMAND;
        } else if (ScriptBytecodeAdapter.compareEqual((Object)etype, (Object)"file") || ScriptBytecodeAdapter.compareEqual((Object)etype, (Object)"script")) {
            String string;
            this.executeType = string = EXECUTE_TYPE_SCRIPT;
        } else if (ScriptBytecodeAdapter.compareEqual((Object)etype, (Object)"interactive")) {
            String string;
            this.executeType = string = EXECUTE_TYPE_INTERPRETER;
        } else {
            return false;
        }
        return true;
    }

    private final boolean parseTaskFile(String taskfile) {
        String string = taskfile;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"start")) {
            IndyInterface.bootstrap("invoke", "setRequireCredentials", 2, this, false);
            CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, File.class, DEFAULT_START_SCRIPT);
            this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
                String string2;
                this.executeType = string2 = EXECUTE_TYPE_START_RESOURCES;
            }
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"stop")) {
            IndyInterface.bootstrap("invoke", "setRequireCredentials", 2, this, false);
            CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, File.class, DEFAULT_STOP_SCRIPT);
            this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
                String string3;
                this.executeType = string3 = EXECUTE_TYPE_STOP_RESOURCES;
            }
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"restart")) {
            IndyInterface.bootstrap("invoke", "setRequireCredentials", 2, this, false);
            CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, File.class, DEFAULT_RESTART_SCRIPT);
            this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
                String string4;
                this.executeType = string4 = EXECUTE_TYPE_RESTART_RESOURCES;
            }
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"configure_cluster")) {
            CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, File.class, DEFAULT_CONFIGURE_CLUSTER_SCRIPT);
            this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
                String string5;
                this.executeType = string5 = EXECUTE_TYPE_CLUSTERED_APP_RESOURCES;
            }
        } else {
            CallSite taskFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, taskfile));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, taskFile)) == false) {
                IndyInterface.bootstrap("invoke", "error", 0, logger, "The specified task file does not exist.");
                return false;
            }
            CallSite callSite = taskFile;
            this.scriptFile = callSite;
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
                String string6;
                this.executeType = string6 = EXECUTE_TYPE_SCRIPT;
            }
        }
        return true;
    }

    private final boolean parseAllOption(OptionAccessor options) {
        CallSite taskFile = null;
        taskFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "allfile", 4, options)) != false ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("getProperty", "allfile", 4, options))) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, DEFAULT_SCRIPT));
        CallSite callSite = taskFile;
        this.scriptFile = callSite;
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
            String string;
            this.executeType = string = EXECUTE_TYPE_ALL_RESOURCES;
        }
        return true;
    }

    private final boolean parseStartOption(OptionAccessor options) {
        CallSite taskFile = null;
        taskFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, DEFAULT_START_SCRIPT));
        CallSite callSite = taskFile;
        this.scriptFile = callSite;
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
            String string;
            this.executeType = string = EXECUTE_TYPE_START_RESOURCES;
        }
        return true;
    }

    private final boolean parseStopOption(OptionAccessor options) {
        CallSite taskFile = null;
        taskFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, DEFAULT_STOP_SCRIPT));
        CallSite callSite = taskFile;
        this.scriptFile = callSite;
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
            String string;
            this.executeType = string = EXECUTE_TYPE_STOP_RESOURCES;
        }
        return true;
    }

    private final boolean parseRestartOption(OptionAccessor options) {
        CallSite taskFile = null;
        taskFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, DEFAULT_RESTART_SCRIPT));
        CallSite callSite = taskFile;
        this.scriptFile = callSite;
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
            String string;
            this.executeType = string = EXECUTE_TYPE_RESTART_RESOURCES;
        }
        return true;
    }

    private final boolean parseClusterConfigureOption(OptionAccessor options) {
        CallSite taskFile = null;
        taskFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, DEFAULT_CONFIGURE_CLUSTER_SCRIPT));
        CallSite callSite = taskFile;
        this.scriptFile = callSite;
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
            String string;
            this.executeType = string = EXECUTE_TYPE_CLUSTERED_APP_RESOURCES;
        }
        return true;
    }

    private final boolean parseGenerateOption(OptionAccessor options) {
        CallSite taskFile = null;
        taskFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "gen", 4, options)) != false ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("getProperty", "gen", 4, options))) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, DEFAULT_SCRIPT));
        CallSite callSite = taskFile;
        this.scriptFile = callSite;
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
            String string;
            this.executeType = string = EXECUTE_TYPE_GENERATE_ONLY;
        }
        return true;
    }

    private final boolean parseOperation(String operation) {
        try {
            CallSite op = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Operation.class, operation));
            if (ScriptBytecodeAdapter.compareEqual((Object)this.command, null)) {
                CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, Command.class);
                this.command = IndyInterface.bootstrap("cast", "()", 0, callSite);
            }
            IndyInterface.bootstrap("invoke", "setOperation", 0, this.command, op);
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
                String string;
                this.executeType = string = EXECUTE_TYPE_COMMAND;
            }
        }
        catch (IllegalArgumentException e) {
            IndyInterface.bootstrap("invoke", "error", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{operation}, new String[]{"invalid operation ", ".  Valid operations include "}), IndyInterface.bootstrap("invoke", "values", 0, Operation.class)));
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private final boolean parseResourceType(String rtype) {
        try {
            CallSite rt = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, ResourceType.class, rtype));
            if (ScriptBytecodeAdapter.compareEqual((Object)this.command, null)) {
                CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, Command.class);
                this.command = IndyInterface.bootstrap("cast", "()", 0, callSite);
            }
            IndyInterface.bootstrap("invoke", "setResourceType", 0, this.command, rt);
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
                String string;
                this.executeType = string = EXECUTE_TYPE_COMMAND;
            }
        }
        catch (IllegalArgumentException e) {
            IndyInterface.bootstrap("invoke", "error", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{rtype}, new String[]{"invalid resource type ", ".  Valid resource types include "}), IndyInterface.bootstrap("invoke", "values", 0, ResourceType.class)));
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private final boolean parseResourceName(String rname) {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.command, null)) {
            CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, Command.class);
            this.command = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        IndyInterface.bootstrap("invoke", "setResourceName", 0, this.command, rname);
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
            String string;
            this.executeType = string = EXECUTE_TYPE_COMMAND;
        }
        return true;
    }

    private final boolean parseTargetName(String context) {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.command, null)) {
            CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, Command.class);
            this.command = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        IndyInterface.bootstrap("invoke", "setTargetName", 0, this.command, context);
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
            String string;
            this.executeType = string = EXECUTE_TYPE_COMMAND;
        }
        return true;
    }

    private final boolean parseScope(String scope) {
        IndyInterface.bootstrap("invoke", "debug", 0, logger, new GStringImpl(new Object[]{scope}, new String[]{"parseScope called with ", ""}));
        try {
            CallSite s = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Scope.class, scope));
            if (ScriptBytecodeAdapter.compareEqual((Object)this.command, null)) {
                CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, Command.class);
                this.command = IndyInterface.bootstrap("cast", "()", 0, callSite);
            }
            IndyInterface.bootstrap("invoke", "setScope", 0, this.command, s);
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
                String string;
                this.executeType = string = EXECUTE_TYPE_COMMAND;
            }
        }
        catch (IllegalArgumentException e) {
            IndyInterface.bootstrap("invoke", "error", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{scope}, new String[]{"invalid scope ", ".  Valid scopes include "}), IndyInterface.bootstrap("invoke", "values", 0, Scope.class)));
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private final void throwParsingException(String message) {
        IndyInterface.bootstrap("invoke", "error", 0, logger, message);
        IndyInterface.bootstrap("invoke", "println", 2, this, message);
        IndyInterface.bootstrap("invoke", "usage", 0, cli);
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SDWException.class, message));
    }

    public static final void usage() {
        IndyInterface.bootstrap("invoke", "usage", 0, cli);
    }

    public final void parseCommandLine(String ... args) {
        String string;
        Object var2_2 = null;
        this.command = IndyInterface.bootstrap("cast", "()", 0, var2_2);
        this.executeType = string = EXECUTE_TYPE_NOT_SET;
        Object var4_4 = null;
        this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, var4_4);
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, CliBuilder.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"usage", "appsrvconfig -h\n[-e COMMAND] -o <op> -r <rtype> -s <scope> -t <target>\n[-e SCRIPT] -[afg] [taskfile]\n[-e SCRIPT] taskfile\n[-e RUN] operation resourcetype resource scope targetname"}));
        cli = IndyInterface.bootstrap("cast", "()", 0, callSite);
        IndyInterface.bootstrap("invoke", "a", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"argName", "allfile", "longOpt", "all", "required", false}), "configure all resources.");
        IndyInterface.bootstrap("invoke", "e", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"argName", "extype", "longOpt", "execute", "args", 1, "required", false}), "RUN|Command, FILE|Script, Interactive");
        IndyInterface.bootstrap("invoke", "h", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "help"}), "Show usage information");
        IndyInterface.bootstrap("invoke", "n", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"argName", "name", "longOpt", "resourcename", "args", 1, "required", false}), "resource name");
        IndyInterface.bootstrap("invoke", "o", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"argName", "op", "longOpt", "operation", "args", 1, "required", false}), "operation");
        IndyInterface.bootstrap("invoke", "r", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"argName", "rtype", "longOpt", "resourcetype", "args", 1, "required", false}), "resource type");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isScopeSupported", 2, this)) != false) {
            IndyInterface.bootstrap("invoke", "s", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"argName", "scope", "longOpt", "scopetype", "args", 1, "required", false}), "scope: CELL|NODE|SERVER");
        }
        IndyInterface.bootstrap("invoke", "t", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"argName", "target", "longOpt", "targetname", "args", 1, "required", false}), "target: name of target resource");
        IndyInterface.bootstrap("invoke", "f", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"argName", "file", "longOpt", DEFAULT_SCRIPT, "args", 1, "required", false}), "script file to execute");
        IndyInterface.bootstrap("invoke", "g", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"argName", "gen", "longOpt", "generate", "required", false}), "generate task file");
        IndyInterface.bootstrap("invoke", "x", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "start"}), "start all servers");
        IndyInterface.bootstrap("invoke", "y", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "stop"}), "stop all servers");
        IndyInterface.bootstrap("invoke", "z", 0, cli, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "restart"}), "restart all servers");
        IndyInterface.bootstrap("invoke", "debug", 0, logger, new GStringImpl(new Object[]{args}, new String[]{"args -> ", ""}));
        CallSite options = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, cli, args));
        if (IndyInterface.bootstrap("cast", "()", 0, options) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "Invalid option usage.");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "h", 4, options)) != false) {
            IndyInterface.bootstrap("invoke", "usage", 0, cli);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, HelpException.class, "Help option selected."));
        }
        if ((DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "f", 4, options)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "a", 4, options)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "g", 4, options))) && (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "o", 4, options)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "r", 4, options)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "s", 4, options)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "n", 4, options)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "t", 4, options)))) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "-a, -f, -g, not allowed with -o, -r, -s, -n, -t");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "f", 4, options)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "a", 4, options)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "f", 4, options)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "g", 4, options)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "a", 4, options)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "g", 4, options))) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "only one of options -a, -f, -g allowed");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isScopeSupported", 2, this)) != false) {
            if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "o", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "r", 4, options)) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "r", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "n", 4, options)) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "n", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "s", 4, options)) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "s", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "t", 4, options)) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "t", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "o", 4, options)) == false) {
                IndyInterface.bootstrap("invoke", "debug", 0, logger, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "o", 4, options), IndyInterface.bootstrap("getProperty", "r", 4, options), IndyInterface.bootstrap("getProperty", "n", 4, options), IndyInterface.bootstrap("getProperty", "s", 4, options), IndyInterface.bootstrap("getProperty", "t", 4, options)}, new String[]{"o=", " r=", " n=", " s=", " t=", ""}));
                IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "the options -o, -r, -s, -n, -t must all be set or not used on the command line.");
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "o", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "r", 4, options)) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "r", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "n", 4, options)) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "n", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "t", 4, options)) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "t", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "o", 4, options)) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "the options -o, -r, -n -t must all be set or not used on the command line.");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "execute", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseExecType", 2, this, IndyInterface.bootstrap("getProperty", "execute", 4, options))) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "execute", 4, options)}, new String[]{"invalid execute type: ", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", DEFAULT_SCRIPT, 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseTaskFile", 2, this, IndyInterface.bootstrap("getProperty", DEFAULT_SCRIPT, 4, options))) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", DEFAULT_SCRIPT, 4, options)}, new String[]{"invalid task file specified: ", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "all", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseAllOption", 2, this, options)) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "all", 4, options), IndyInterface.bootstrap("getProperty", "allfile", 4, options)}, new String[]{"invalid use of -a: ", " ", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "start", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseStartOption", 2, this, options)) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "start", 4, options)}, new String[]{"invalid use of --start: ", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "stop", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseStopOption", 2, this, options)) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "stop", 4, options)}, new String[]{"invalid use of --stop: ", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "restart", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseRestartOption", 2, this, options)) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "restart", 4, options)}, new String[]{"invalid use of --restart: ", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "generate", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseGenerateOption", 2, this, options)) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "generate", 4, options), IndyInterface.bootstrap("getProperty", "gen", 4, options)}, new String[]{"invalid use of -g: ", " ", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "operation", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseOperation", 2, this, IndyInterface.bootstrap("getProperty", "operation", 4, options))) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "operation", 4, options)}, new String[]{"invalid operation: ", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "resourcetype", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseResourceType", 2, this, IndyInterface.bootstrap("getProperty", "resourcetype", 4, options))) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "resourcetype", 4, options)}, new String[]{"invalid resource type: ", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "resourcename", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseResourceName", 2, this, IndyInterface.bootstrap("getProperty", "resourcename", 4, options))) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "invalid resource name");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "targetname", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseTargetName", 2, this, IndyInterface.bootstrap("getProperty", "targetname", 4, options))) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "invalid target name");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "scopetype", 4, options)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseScope", 2, this, IndyInterface.bootstrap("getProperty", "scopetype", 4, options))) == false) {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "scopetype", 4, options)}, new String[]{"invalid scope: ", ""}));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options)), (Object)0)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_COMMAND) && ScriptBytecodeAdapter.compareEqual((Object)this.command, null)) {
                IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "Requested to execute a command but no command was specified to execute.");
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_SCRIPT) && ScriptBytecodeAdapter.compareEqual((Object)this.scriptFile, null)) {
                IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "Requested to execute a script but no file was specified.");
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_INTERPRETER) && (DefaultTypeTransformation.booleanUnbox((Object)this.scriptFile) || DefaultTypeTransformation.booleanUnbox((Object)this.command))) {
                IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "Interactive option specified with script file or command.");
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_NOT_SET)) {
                IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "No command line. Displaying help.");
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options)), (Object)1)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_COMMAND) || ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_INTERPRETER)) {
                IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "script file positional parameters specified with a command line or interactive interpreter.");
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), false), false), (Object)"-")) {
                IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, "invalid option switch ", IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), false)));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "f", 4, options)) != false) {
                IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "both the -f option and a positional parameter specified a task file on the command line.  ");
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseTaskFile", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), false))) == false) {
                IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "task file missing");
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isScopeSupported", 2, this)) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options)), (Object)5)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_SCRIPT) || ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_INTERPRETER)) {
                IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "command line positional parameters are specified with a task script or interactive interpreter.");
            }
            IndyInterface.bootstrap("invoke", "parseOperation", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), false));
            IndyInterface.bootstrap("invoke", "parseResourceType", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), true));
            IndyInterface.bootstrap("invoke", "parseResourceName", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), 2));
            IndyInterface.bootstrap("invoke", "parseScope", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), 3));
            IndyInterface.bootstrap("invoke", "parseTargetName", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), 4));
        } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isScopeSupported", 2, this)) == false && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options)), (Object)4)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_SCRIPT) || ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_INTERPRETER)) {
                IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, "command line positional parameters are specified with a task script or interactive interpreter.");
            }
            IndyInterface.bootstrap("invoke", "parseOperation", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), false));
            IndyInterface.bootstrap("invoke", "parseResourceType", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), true));
            IndyInterface.bootstrap("invoke", "parseResourceName", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), 2));
            IndyInterface.bootstrap("invoke", "parseTargetName", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "arguments", 0, options), 3));
        } else {
            IndyInterface.bootstrap("invoke", "throwParsingException", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, "Unrecognized positional parameters: ", IndyInterface.bootstrap("invoke", "arguments", 0, options)));
        }
    }

    public final BufferedReader getCommandReader() {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_COMMAND)) {
            IndyInterface.bootstrap("invoke", "debug", 0, logger, "preparing reader for single command");
            CallSite commandInput = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, this.command));
            CallSite cmdReader = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringReader.class, commandInput));
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, BufferedReader.class, cmdReader));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_ALL_RESOURCES)) {
            IndyInterface.bootstrap("invoke", "debug", 0, logger, "preparing reader all command");
            CallSite callSite = IndyInterface.bootstrap("invoke", "createTaskFile", 2, this);
            this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, BufferedReader.class, IndyInterface.bootstrap("init", "<init>", 0, FileReader.class, this.scriptFile)));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_START_RESOURCES)) {
            IndyInterface.bootstrap("invoke", "debug", 0, logger, "preparing reader start command");
            CallSite callSite = IndyInterface.bootstrap("invoke", "createStartTaskFile", 2, this);
            this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, BufferedReader.class, IndyInterface.bootstrap("init", "<init>", 0, FileReader.class, this.scriptFile)));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_STOP_RESOURCES)) {
            IndyInterface.bootstrap("invoke", "debug", 0, logger, "preparing reader stop command");
            CallSite callSite = IndyInterface.bootstrap("invoke", "createStopTaskFile", 2, this);
            this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, BufferedReader.class, IndyInterface.bootstrap("init", "<init>", 0, FileReader.class, this.scriptFile)));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_RESTART_RESOURCES)) {
            IndyInterface.bootstrap("invoke", "debug", 0, logger, "preparing reader restart command");
            CallSite callSite = IndyInterface.bootstrap("invoke", "createRestartTaskFile", 2, this);
            this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, BufferedReader.class, IndyInterface.bootstrap("init", "<init>", 0, FileReader.class, this.scriptFile)));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_CLUSTERED_APP_RESOURCES)) {
            IndyInterface.bootstrap("invoke", "debug", 0, logger, "preparing reader configure_cluster command");
            CallSite callSite = IndyInterface.bootstrap("invoke", "createClusterConfigTaskFile", 2, this);
            this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, BufferedReader.class, IndyInterface.bootstrap("init", "<init>", 0, FileReader.class, this.scriptFile)));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_GENERATE_ONLY)) {
            IndyInterface.bootstrap("invoke", "debug", 0, logger, "preparing reader generate script only");
            CallSite callSite = IndyInterface.bootstrap("invoke", "createTaskFile", 2, this);
            this.scriptFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            return null;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_SCRIPT)) {
            IndyInterface.bootstrap("invoke", "debug", 0, logger, "preparing reader for script");
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, BufferedReader.class, IndyInterface.bootstrap("init", "<init>", 0, FileReader.class, this.scriptFile)));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.executeType, (Object)EXECUTE_TYPE_INTERPRETER)) {
            IndyInterface.bootstrap("invoke", "debug", 0, logger, "preparing reader for command line interpreter");
            CallSite cmdReader = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, InputStreamReader.class, IndyInterface.bootstrap("getProperty", "in", 0, System.class)));
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, BufferedReader.class, cmdReader));
        }
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "Failed to get command reader."));
    }

    public final File createTaskFile() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createTaskFile", 2, this, "getCommandTaskFile"));
    }

    public final File createStartTaskFile() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createTaskFile", 2, this, "getStartCommandTaskFile"));
    }

    public final File createStopTaskFile() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createTaskFile", 2, this, "getStopCommandTaskFile"));
    }

    public final File createRestartTaskFile() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createTaskFile", 2, this, "getRestartCommandTaskFile"));
    }

    public final File createClusterConfigTaskFile() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createUpdateTaskFile", 2, this, "getClusteredAppsCommandTaskFile"));
    }

    public final File createTaskFile(String taskMethod) {
        IndyInterface.bootstrap("invoke", "debug", 0, logger, "createTaskfile() >>>");
        CallSite resourceManager = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResourceManager", 2, this));
        CallSite globalResource = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResource", 0, resourceManager, IndyInterface.bootstrap("getProperty", "GLOBAL", 0, ResourceType.class)));
        CallSite templatePaths = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getVelocityTemplatePaths", 0, globalResource));
        CallSite templateFile = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethod0(AbstractScriptDriver.class, (Object)globalResource, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{taskMethod}, new String[]{"", "Template"})))));
        CallSite logDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getScriptingLogsDir", 0, globalResource));
        CallSite taskFile = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethod0(AbstractScriptDriver.class, (Object)globalResource, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{taskMethod}, new String[]{"", ""})))));
        CallSite context = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("init", "<init>", 0, AppServerContextBuilder.class, resourceManager)));
        IndyInterface.bootstrap("invoke", "debug", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "context keys = ", IndyInterface.bootstrap("invoke", "keySet", 0, context)));
        IndyInterface.bootstrap("invoke", "debug", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "taskFile = ", taskFile));
        IndyInterface.bootstrap("invoke", "debug", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "templateFile = ", templateFile));
        CallSite te = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, VelocityTemplateEngine.class, templatePaths, logDir));
        IndyInterface.bootstrap("invoke", "merge", 0, te, context, templateFile, taskFile);
        IndyInterface.bootstrap("invoke", "debug", 0, logger, "createTaskfile() <<<");
        return taskFile;
    }

    public final File createUpdateTaskFile(String taskMethod) {
        IndyInterface.bootstrap("invoke", "debug", 0, logger, "createUpdateTaskfile() >>>");
        CallSite resourceManager = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResourceManager", 2, this));
        CallSite globalResource = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResource", 0, resourceManager, IndyInterface.bootstrap("getProperty", "GLOBAL", 0, ResourceType.class)));
        CallSite templatePaths = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getVelocityTemplatePaths", 0, globalResource));
        CallSite templateFile = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethod0(AbstractScriptDriver.class, (Object)globalResource, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{taskMethod}, new String[]{"", "Template"})))));
        CallSite logDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getScriptingLogsDir", 0, globalResource));
        CallSite taskFile = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethod0(AbstractScriptDriver.class, (Object)globalResource, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{taskMethod}, new String[]{"", ""})))));
        CallSite context = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("init", "<init>", 0, AppServerUpdateContextBuilder.class, resourceManager)));
        IndyInterface.bootstrap("invoke", "debug", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "context keys = ", IndyInterface.bootstrap("invoke", "keySet", 0, context)));
        IndyInterface.bootstrap("invoke", "debug", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "taskFile = ", taskFile));
        IndyInterface.bootstrap("invoke", "debug", 0, logger, IndyInterface.bootstrap("invoke", "plus", 0, "templateFile = ", templateFile));
        CallSite te = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, VelocityTemplateEngine.class, templatePaths, logDir));
        IndyInterface.bootstrap("invoke", "merge", 0, te, context, templateFile, taskFile);
        IndyInterface.bootstrap("invoke", "debug", 0, logger, "createTaskfile() <<<");
        return taskFile;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractScriptDriver.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        boolean bl;
        hasException = bl = false;
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LogManager.class, AbstractScriptDriver.class);
        logger = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public static boolean getHasException() {
        return hasException;
    }

    @Generated
    public static boolean isHasException() {
        return hasException;
    }

    @Generated
    public static void setHasException(boolean bl) {
        hasException = bl;
    }
}

