/*
 * Decompiled with CFR 0.152.
 */
package com.sas.appserver.jboss.utils;

import com.sas.appserver.utils.JvmOption;
import com.sas.appserver.utils.OsType;
import groovy.ant.AntBuilder;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.text.SimpleTemplateEngine;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class DriverScriptHelper
implements GroovyObject {
    private static Logger logger;
    private File driverScript;
    private String servername;
    private String jbossVersion;
    private String jbossInstallDir;
    private String jbossServiceDependency;
    private String jdkHomeDir;
    private List<JvmOption> jvmOptions;
    private String multicastAuthToken;
    private String jbossBindHost;
    private OsType ostype;
    private String jbossNamingPort;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public DriverScriptHelper() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void setJvmOptions(List<JvmOption> jvmOptions) {
        List<JvmOption> list = jvmOptions;
        this.jvmOptions = list;
    }

    public void setJdkHome(File jdkHomeDir) {
        File file = jdkHomeDir;
        this.jdkHomeDir = IndyInterface.bootstrap("cast", "()", 0, file);
    }

    public void setJbossVersion(String jbossVersion) {
        String string;
        this.jbossVersion = string = jbossVersion;
    }

    public void setJbossInstalldir(File jbossInstallDir) {
        File file = jbossInstallDir;
        this.jbossInstallDir = IndyInterface.bootstrap("cast", "()", 0, file);
    }

    public void setJbossServiceDependency(String jbossServiceDependency) {
        String string;
        this.jbossServiceDependency = string = jbossServiceDependency;
    }

    public void setJbossBindHost(String jbossBindHost) {
        String string;
        this.jbossBindHost = string = jbossBindHost;
    }

    public void setServername(String servername) {
        String string;
        this.servername = string = servername;
    }

    public void setJbossNamingPort(String jbossNameingPort) {
        String string;
        this.jbossNamingPort = string = this.jbossNamingPort;
    }

    public void setOstype(OsType ostype) {
        OsType osType;
        this.ostype = osType = ostype;
    }

    public void setMulticastAuthToken(String multicastAuthToken) {
        String string;
        this.multicastAuthToken = string = multicastAuthToken;
    }

    public void setFile(File driverScript) {
        File file;
        this.driverScript = file = driverScript;
    }

    public void configure() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.driverScript) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, this.driverScript)) == false) {
            IndyInterface.bootstrap("invoke", "createScript", 2, this);
        }
    }

    public List<JvmOption> getJvmOptions() {
        CallSite options = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        IndyInterface.bootstrap("invoke", "info", 0, logger, new GStringImpl(new Object[]{this.driverScript}, new String[]{"driverScript=", ""}));
        CallSite lines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "getText", 0, this.driverScript), "\n"));
        CallSite line = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, lines));
        if (callSite != null) {
            while (callSite.hasNext()) {
                line = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)line, (Object)"^set JVM_OPTS=.*")) == false) continue;
                int equalsIndex = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, line, "="));
                CallSite property = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, line, false, equalsIndex));
                CallSite value = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, line, IndyInterface.bootstrap("invoke", "plus", 0, equalsIndex, true), IndyInterface.bootstrap("invoke", "length", 0, line)));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)value, null)) {
                    value = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "trim", 0, value));
                }
                IndyInterface.bootstrap("invoke", "addAll", 0, options, IndyInterface.bootstrap("invoke", "parseOptions", 0, JvmOption.class, value));
            }
        }
        return options;
    }

    public void writeJvmOptions(List<JvmOption> options) {
        CallSite lines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "getText", 0, this.driverScript), "\n"));
        CallSite updatedText = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
        CallSite line = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, lines));
        if (callSite != null) {
            while (callSite.hasNext()) {
                line = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                if (IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.findRegex((Object)line, (Object)"^set JVM_OPTS=.*")) != false) {
                    IndyInterface.bootstrap("invoke", "append", 0, updatedText, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "set JVM_OPTS=", IndyInterface.bootstrap("invoke", "toString", 0, JvmOption.class, options)), "\n"));
                    continue;
                }
                IndyInterface.bootstrap("invoke", "append", 0, updatedText, IndyInterface.bootstrap("invoke", "plus", 0, line, "\n"));
            }
        }
        IndyInterface.bootstrap("invoke", "setText", 0, this.driverScript, IndyInterface.bootstrap("invoke", "toString", 0, updatedText));
    }

    public void createScript() {
        String runBatScript = "\n@echo off\nrem -------------------------------------------------------------------------\nrem JBoss Bootstrap Script for Win32\nrem -------------------------------------------------------------------------\n\nsetlocal\n\nset SERVICENAME=JBoss - $servername\nset JBOSS_BIN_DIR=$jbossInstallDir\\\\bin\nset JBOSS_SERVER_DIR=$jbossInstallDir\\\\server\\\\$servername\nset WRAPPER_DIR=$jbossInstallDir\\\\service\n\nif x%1 EQU x goto start_as_script\nif %1 EQU install goto install\nif %1 EQU remove goto remove\nif %1 EQU start goto start\nif %1 EQU stop goto stop\nif %1 EQU restart goto restart\nif %1 EQU pause goto pause\nif %1 EQU resume goto resume\nif %1 EQU status goto status\nif %1 EQU -install goto install\nif %1 EQU -remove goto remove\nif %1 EQU -start goto start\nif %1 EQU -stop goto stop\nif %1 EQU -restart goto restart\nif %1 EQU -pause goto pause\nif %1 EQU -resume goto resume\nif %1 EQU -status goto status\ngoto usage\n\n\n:install\n start /b /wait \"JBoss - $servername\" \"%WRAPPER_DIR%\\\\Wrapper.exe\" -i \"%JBOSS_SERVER_DIR%\\\\wrapper.conf\"\n if %ERRORLEVEL% == 0 echo JBoss server installed as a service\n goto end\n:remove\n start /b /wait \"JBoss - $servername\" \"%WRAPPER_DIR%\\\\Wrapper.exe\" -r \"%JBOSS_SERVER_DIR%\\\\wrapper.conf\"\n if %ERRORLEVEL% == 0 echo JBoss server removed as a service\n goto end\n:start\n net start \"%SERVICENAME%\"\n if %ERRORLEVEL% == 0 echo JBoss server started as a service\n goto end\n:stop\n net stop \"%SERVICENAME%\"\n if %ERRORLEVEL% == 0 echo JBoss server stopped as a service\n goto end\n:restart\n net stop \"%SERVICENAME%\"\n if %ERRORLEVEL% == 0 echo JBoss server stopped as a service\n net start \"%SERVICENAME%\"\n if %ERRORLEVEL% == 0 echo JBoss server started as a service\n goto end\n:pause\n net pause \"%SERVICENAME%\"\n if %ERRORLEVEL% == 0 echo JBoss server paused as a service\n goto end\n:resume\n net continue \"%SERVICENAME%\"\n if %ERRORLEVEL% == 0 echo JBoss server resumed as a service\n goto end\n:status\n sc interrogate \"%SERVICENAME%\"\n goto end\n:usage\n echo USAGE:  %0 {install ^| start ^| stop ^| restart ^| pause ^| resume ^| remove ^| status}\n goto end\n \n:start_as_script\nset JAVA_HOME=$jdkInstallDir\nset $jvmOptionsVar=$jvmOptions\n\n$multicastAuthToken\n\n\"$jbossInstallDir\\\\bin\\\\run.bat\" -c $servername -b $jbossBindHost %*\n\n:end\nendlocal\nif [%2] EQU [exit] exit %ERRORLEVEL%\n";
        String runShScript = "#!/bin/sh -p\n### ====================================================================== ###\n##                                                                          ##\n##  JBoss Bootstrap Script                                                  ##\n##                                                                          ##\n### ====================================================================== ###\n\nJAVA_HOME=\"$jdkInstallDir\"\nexport JAVA_HOME\n\nJAVA_OPTS=\"$jvmOptions\"\nexport JAVA_OPTS\n\n$multicastAuthToken\n\nmkdir -p \"$jbossInstallDir/server/$servername/log\"\n\n# Get argument\nif [ \"\\$1\" = \"-start\" ]; then\n   arg=start ; shift\nelif [ \"\\$1\" = \"-stop\" ]; then\n   arg=stop ; shift\nelif [ \"\\$1\" = \"-statu\" ]; then\n   arg=status ; shift\nelif [ \"\\$1\" = \"-restart\" ]; then\n   arg=restart ; shift\nelif [ \"\\$1\" = \"-kill\" ]; then\n   arg=kill ; shift\nelif [ \"\\$1\" = \"start\" ]; then\n   arg=start ; shift\nelif [ \"\\$1\" = \"stop\" ]; then\n   arg=stop ; shift\nelif [ \"\\$1\" = \"status\" ]; then\n   arg=status ; shift\nelif [ \"\\$1\" = \"restart\" ]; then\n   arg=restart ; shift\nelif [ \"\\$1\" = \"kill\" ]; then\n   arg=kill ; shift\nelif [ \"x\\$1\" = \"x\" ]; then\n   arg=startForeground\nfi\n\ncase \"\\$arg\" in\n   start)\n\t  LAUNCH_JBOSS_IN_BACKGROUND=true\n\t  export LAUNCH_JBOSS_IN_BACKGROUND\n\t  nohup \"$jbossInstallDir/bin/run.sh\" -c $servername -b $jbossBindHost \\$@ >\"$jbossInstallDir/server/$servername/log/stdout.log\" 2>&1 &\n\t  pid=\\$!\n\t  echo \\$pid > \"$jbossInstallDir/server/$servername/log/jboss.pid\"\n\t  echo \"JBoss startup has begun (pid \\$pid)...\"\n   ;;\n   \n   stop)\n#        add args for username/password as in \"${servername}.sh stop -u username -p password\"\n\t  JAVA_OPTS=\"-d64 -Xms512M -Xmx512M\"\n\t  \"$jbossInstallDir/bin/shutdown.sh\" -s localhost:$jbossNamingPort \\$* -S\n   ;;\n   \n   kill)\n\t\t if [ -f $jbossInstallDir/server/$servername/log/jboss.pid ]; then\n\t\t\tpid=`cat $jbossInstallDir/server/$servername/log/jboss.pid`\n\t\t\tkill \\$* \\$pid\n\t\t\tif [ \\$? -ne 0 ]; then\n\t\t\t   echo \"pid: \\$pid\"\n\t\t\tfi\n\t\t else\n\t\t\t echo \"JBoss not running.\"\n\t\t\t exit 1\n\t\t fi\n   ;;\n   \n   status)\n\t\t  if [ -f $jbossInstallDir/server/$servername/log/jboss.pid ]; then\n\t\t\tpid=`cat $jbossInstallDir/server/$servername/log/jboss.pid`\n\t\t\tkill -0 \\$pid > /dev/null 2>&1\n\t\t\tif [ \\$? -eq 0 ]; then\n\t\t\t   echo \"JBoss running (pid \\$pid)\"\n\t\t\telse\n\t\t\t   echo \"JBoss is not running\"\n\t\t\tfi\n\t\t else\n\t\t\techo \"JBoss is not running\"\n\t\t fi\n   ;;\n   \n   restart)\n\t\t \\$0 -kill -9\n\t\t if [ \\$? -eq 0 ]; then\n\t\t\tsleep 10\n\t\t\t\\$0 -start\n\t\t fi\n   \n   ;;\n   \n   startForeground)\n\t\t\"$jbossInstallDir/bin/run.sh\" -c $servername -b $jbossBindHost \\$@\n   ;;\n   \n   *)\n\t\t echo \"USAGE:  \\$0 { start | stop | restart | status | kill | help}\"\n\t\t echo \"     :  start   - launch JBoss server in the background\"\n\t\t echo \"     :  stop    - issue [JBOSS-HOME]/bin/shutdown.sh to stop JBoss server\"\n\t\t echo \"     :  restart - kill JBoss server process, re-launch server in the background\"\n\t\t echo \"     :  status  - return JBoss server process status (via kill -0 <pid>)\"\n\t\t echo \"     :  help    - display these command options\"\n\t\t echo \"     :  [no arguments passed to the command results in launch of JBoss server in the foreground]\"\n\t\t echo \" \"\n\t\t \n   ;;\nesac\n\nexit 0\n\nexit 0\n";
        CallSite engine = IndyInterface.bootstrap("init", "<init>", 0, SimpleTemplateEngine.class);
        CallSite template = null;
        String subscript = null;
        String jvmOptionsVar = "JAVA_OPTS";
        CallSite options = null;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equals", 0, this.ostype, IndyInterface.bootstrap("getProperty", "WINDOWS", 0, OsType.class))) != false) {
            template = IndyInterface.bootstrap("invoke", "createTemplate", 0, engine, runBatScript);
            options = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, JvmOption.class, this.jvmOptions), "%", "%%"));
            subscript = ".bat";
        } else {
            template = IndyInterface.bootstrap("invoke", "createTemplate", 0, engine, runShScript);
            options = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, JvmOption.class, this.jvmOptions));
            subscript = ".sh";
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, this.jbossVersion, "4")) != false) {
            jvmOptionsVar = "SAS_JAVA_OPTS";
        }
        Map binding = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"servername", this.servername, "jbossInstallDir", this.jbossInstallDir, "jdkInstallDir", this.jdkHomeDir, "jvmOptions", options, "multicastAuthToken", this.multicastAuthToken, "jbossBindHost", this.jbossBindHost, "jbossNamingPort", this.jbossNamingPort, "jvmOptionsVar", jvmOptionsVar});
        CallSite scriptOut = IndyInterface.bootstrap("invoke", "make", 0, template, binding);
        CallSite filename = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, this.jbossInstallDir, "/bin/"), this.servername), subscript);
        CallSite outFile = IndyInterface.bootstrap("init", "<init>", 0, File.class, filename);
        CallSite rc = IndyInterface.bootstrap("invoke", "write", 0, outFile, IndyInterface.bootstrap("invoke", "toString", 0, scriptOut));
        IndyInterface.bootstrap("invoke", "debug", 0, logger, new GStringImpl(new Object[]{filename, rc}, new String[]{"createBatchScript - writing ", " returned ", ""}));
        CallSite ant = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AntBuilder.class));
        IndyInterface.bootstrap("invoke", "chmod", 0, ant, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"perm", "u+rx", "file", IndyInterface.bootstrap("invoke", "getCanonicalPath", 0, outFile)}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DriverScriptHelper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LogManager.class, DriverScriptHelper.class);
        logger = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public String getServername() {
        return this.servername;
    }

    @Generated
    public String getJbossVersion() {
        return this.jbossVersion;
    }

    @Generated
    public String getJbossInstallDir() {
        return this.jbossInstallDir;
    }

    @Generated
    public void setJbossInstallDir(String string) {
        this.jbossInstallDir = string;
    }

    @Generated
    public String getJbossServiceDependency() {
        return this.jbossServiceDependency;
    }

    @Generated
    public String getJdkHomeDir() {
        return this.jdkHomeDir;
    }

    @Generated
    public void setJdkHomeDir(String string) {
        this.jdkHomeDir = string;
    }

    @Generated
    public String getMulticastAuthToken() {
        return this.multicastAuthToken;
    }

    @Generated
    public String getJbossBindHost() {
        return this.jbossBindHost;
    }

    @Generated
    public OsType getOstype() {
        return this.ostype;
    }

    @Generated
    public String getJbossNamingPort() {
        return this.jbossNamingPort;
    }
}

