/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.config;

import com.sas.report.config.ConfigBuilder;
import com.sas.report.config.MetadataSourceDef;
import com.sas.report.config.OmiJaasEntry;
import com.sas.report.config.OmiJaasFile;
import com.sas.report.config.RB;
import com.sas.report.config.RBUtil;
import com.sas.report.config.ServiceDeploymentConfig;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.ServiceState;
import com.sas.services.connection.LoginException;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.OMRMetadataSource;
import com.sas.services.deployment.ServiceLoader;
import com.sas.services.deployment.URLMetadataSource;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.AutoConnectException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryDef;
import com.sas.services.information.ServerDef;
import com.sas.services.information.ServerInterface;
import com.sas.services.security.ConnectRefusedLoginServiceException;
import com.sas.services.session.LockingException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.text.Message;
import com.sas.util.ChainedException;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.UncheckedException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class StartPFS {
    private static final Logger LOG = Logger.getLogger(StartPFS.class.getName());
    public static final String DEBUG_LOGGING_PROPERTY = "sas.report.config.debugging";
    private static final String DEFAULT_SOFTWARECOMPONENT_NAME;
    private static final String DEFAULT_GROUP_NAME;
    private static final OmiJaasFile JAAS_FILE;
    private static String _originalJaasProp;
    private static String _loginModuleName;
    private static final Environment ENVIRONMENT;
    private static final int RECORD_LENGTH_IN_CHARS = 100;

    public static String getDefaultDeploymentFileURL() {
        File metaDataFile;
        LOG.fine("entering");
        String metaDataString = System.getProperty("PFS_CONFIG");
        if (metaDataString == null) {
            System.err.println(RB.getStringResource("StartPFSnoJFSSet.txt"));
            String filePath = File.separator + "config" + File.separator + "sas_service_deployment_export_queryandReporting_1.xml";
            String rootPath = System.getProperty("BIR_HOME");
            String string = metaDataString = rootPath != null ? rootPath + filePath : "C:" + File.separator + "BIReporting" + filePath;
        }
        if ((metaDataFile = new File(metaDataString)).exists() && metaDataFile.isFile()) {
            return metaDataString;
        }
        System.err.println(RB.getStringResource("StartPFSnoConfigFile.txt"));
        return null;
    }

    public static String getDefaultSoftwareComponentName() {
        LOG.fine("returning: " + DEFAULT_SOFTWARECOMPONENT_NAME);
        return DEFAULT_SOFTWARECOMPONENT_NAME;
    }

    public static String getDefaultGroupName() {
        LOG.fine("returning: " + DEFAULT_GROUP_NAME);
        return DEFAULT_GROUP_NAME;
    }

    public static void deployPlatformServices(String omrHostMachine, String omrHostPort, String omrUser, String omrUserPassword, String omrRepositoryName, String applicationDeploymentName) throws MalformedURLException, ServiceException, IOException {
        StringTokenizer stOmrHostMachine = new StringTokenizer(omrHostMachine);
        String _host = stOmrHostMachine.nextToken();
        StringTokenizer stOmrHostPort = new StringTokenizer(omrHostPort);
        String _port = stOmrHostPort.nextToken();
        String authenticationDomain = _host + '.' + _port;
        StartPFS.deployPlatformServicesViaTemplate(omrHostMachine, omrHostPort, omrRepositoryName, applicationDeploymentName, authenticationDomain);
    }

    static void deployPlatformServicesViaTemplate(String omrHostMachine, String omrHostPort, String omrRepositoryName, String applicationDeploymentName, String authenticationDomain) throws MalformedURLException, ServiceException, IOException {
        File configFile = null;
        LOG.fine("template-based deploy");
        File deploymentFile = File.createTempFile("SAS-QandR-", ".xml");
        String deploymentFilename = deploymentFile.getCanonicalPath();
        String jaasProp = System.getProperty("java.security.auth.login.config");
        if (jaasProp == null) {
            configFile = File.createTempFile("SAS-QandR-", ".config");
            String configFilename = configFile.getCanonicalPath();
            System.setProperty("java.security.auth.login.config", configFilename);
        }
        ConfigBuilder.generateFiles(deploymentFilename, omrRepositoryName, omrHostMachine, omrHostPort, authenticationDomain);
        StartPFS.setJAASConfiguration();
        StartPFS.deployPlatformServices(deploymentFilename, applicationDeploymentName);
        deploymentFile.delete();
        if (configFile != null) {
            configFile.delete();
        }
        if (null != System.getProperty("java.security.auth.login.config")) {
            File f = new File(System.getProperty("java.security.auth.login.config"));
            f.delete();
        }
    }

    public static MetadataSourceDef getMetadataSourceDef(String omrHostMachine, String omrHostPort, String omrRepositoryName, String authDomain) {
        return new MetadataSourceDef(omrHostMachine, omrHostPort, omrRepositoryName, authDomain);
    }

    public static MetadataSourceDef getMetadataSourceDef(String omrHostMachine, String omrHostPort, String omrRepositoryName) {
        String authDomain = omrHostMachine + '.' + omrHostPort;
        return StartPFS.getMetadataSourceDef(omrHostMachine, omrHostPort, omrRepositoryName, authDomain);
    }

    public static String getAbsoluteUrl(MetadataSourceDef sourceDef, String repositoryLocalUrl) {
        if (sourceDef == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("StartPFS.sourceDefIsNull.txt"));
        }
        return sourceDef.getAbsoluteUrl(repositoryLocalUrl);
    }

    public static SessionContextInterface openConnection(MetadataSourceDef mdSourceDef, String applicationDeploymentName, String omrUser, String omrUserPassword) throws MalformedURLException, ServiceException, IOException, InitializationException {
        return StartPFS.openConnection(mdSourceDef, applicationDeploymentName, omrUser, omrUserPassword, (Map)null);
    }

    public static SessionContextInterface openConnection(MetadataSourceDef mdSourceDef, String applicationDeploymentName, String omrUser, String omrUserPassword, Map properties) throws MalformedURLException, ServiceException, IOException, InitializationException {
        String omrHostMachine = mdSourceDef.getOmrHostMachine();
        String omrHostPort = mdSourceDef.getOmrHostPort();
        String omrRepositoryName = mdSourceDef.getOmrRepositoryName();
        String authDomain = mdSourceDef.getAuthDomain();
        String repositoryDefName = mdSourceDef.getRepositoryDefName();
        return StartPFS.openConnection(omrHostMachine, omrHostPort, omrRepositoryName, repositoryDefName, applicationDeploymentName, omrUser, omrUserPassword, authDomain, properties);
    }

    public static SessionContextInterface openConnection(MetadataSourceDef mdSourceDef, String applicationDeploymentName, String omrUser, String omrUserPassword, String[][] properties) throws MalformedURLException, ServiceException, IOException, InitializationException {
        String omrHostMachine = mdSourceDef.getOmrHostMachine();
        String omrHostPort = mdSourceDef.getOmrHostPort();
        String omrRepositoryName = mdSourceDef.getOmrRepositoryName();
        String authDomain = mdSourceDef.getAuthDomain();
        String repositoryDefName = mdSourceDef.getRepositoryDefName();
        return StartPFS.openConnection(omrHostMachine, omrHostPort, omrRepositoryName, repositoryDefName, applicationDeploymentName, omrUser, omrUserPassword, authDomain, properties);
    }

    public static SessionContextInterface openConnection(String omrHostMachine, String omrHostPort, String omrRepositoryName, String applicationDeploymentName, String omrUser, String omrUserPassword) throws MalformedURLException, ServiceException, IOException, InitializationException {
        return StartPFS.openConnection(omrHostMachine, omrHostPort, omrRepositoryName, applicationDeploymentName, omrUser, omrUserPassword, (Map)null);
    }

    public static SessionContextInterface openConnection(String omrHostMachine, String omrHostPort, String omrRepositoryName, String applicationDeploymentName, String omrUser, String omrUserPassword, Map properties) throws MalformedURLException, ServiceException, IOException, InitializationException {
        String authDomain = omrHostMachine + '.' + omrHostPort;
        return StartPFS.openConnection(omrHostMachine, omrHostPort, omrRepositoryName, applicationDeploymentName, omrUser, omrUserPassword, authDomain, properties);
    }

    public static SessionContextInterface openConnection(String omrHostMachine, String omrHostPort, String omrRepositoryName, String applicationDeploymentName, String omrUser, String omrUserPassword, String[][] properties) throws MalformedURLException, ServiceException, IOException, InitializationException {
        String authDomain = omrHostMachine + '.' + omrHostPort;
        return StartPFS.openConnection(omrHostMachine, omrHostPort, omrRepositoryName, applicationDeploymentName, omrUser, omrUserPassword, authDomain, properties);
    }

    public static SessionContextInterface openConnection(String omrHostMachine, String omrHostPort, String omrRepositoryName, String applicationDeploymentName, String omrUser, String omrUserPassword, String authDomain) throws MalformedURLException, ServiceException, IOException, InitializationException {
        return StartPFS.openConnection(omrHostMachine, omrHostPort, omrRepositoryName, applicationDeploymentName, omrUser, omrUserPassword, authDomain, (Map)null);
    }

    public static SessionContextInterface openConnection(String omrHostMachine, String omrHostPort, String omrRepositoryName, String applicationDeploymentName, String omrUser, String omrUserPassword, String authDomain, Map properties) throws MalformedURLException, ServiceException, IOException, InitializationException {
        String repositoryDefName = omrRepositoryName;
        return StartPFS.openConnection(omrHostMachine, omrHostPort, omrRepositoryName, repositoryDefName, applicationDeploymentName, omrUser, omrUserPassword, authDomain, properties);
    }

    public static SessionContextInterface openConnection(String omrHostMachine, String omrHostPort, String omrRepositoryName, String applicationDeploymentName, String omrUser, String omrUserPassword, String authDomain, String[][] properties) throws MalformedURLException, ServiceException, IOException, InitializationException {
        String repositoryDefName = omrRepositoryName;
        return StartPFS.openConnection(omrHostMachine, omrHostPort, omrRepositoryName, repositoryDefName, applicationDeploymentName, omrUser, omrUserPassword, authDomain, properties);
    }

    public static SessionContextInterface openConnection(String omrHostMachine, String omrHostPort, String omrRepositoryName, String repositoryDefName, String applicationDeploymentName, String omrUser, String omrUserPassword, String authDomain) throws MalformedURLException, ServiceException, IOException, InitializationException {
        return StartPFS.openConnection(omrHostMachine, omrHostPort, omrRepositoryName, repositoryDefName, applicationDeploymentName, omrUser, omrUserPassword, authDomain, (Map)null);
    }

    public static SessionContextInterface openConnection(String omrHostMachine, String omrHostPort, String omrRepositoryName, String repositoryDefName, String applicationDeploymentName, String omrUser, String omrUserPassword, String authDomain, String[][] properties) throws MalformedURLException, ServiceException, IOException, InitializationException {
        int numProperties = properties.length;
        HashMap<String, String> _properties = new HashMap<String, String>(numProperties);
        for (int i = 0; i < numProperties; ++i) {
            _properties.put(properties[i][0], properties[i][1]);
        }
        return StartPFS.openConnection(omrHostMachine, omrHostPort, omrRepositoryName, repositoryDefName, applicationDeploymentName, omrUser, omrUserPassword, authDomain, _properties);
    }

    public static SessionContextInterface openConnection(String omrHostMachine, String omrHostPort, String omrRepositoryName, String repositoryDefName, String applicationDeploymentName, String omrUser, String omrUserPassword, String authDomain, Map properties) throws MalformedURLException, ServiceException, IOException, InitializationException {
        InformationServiceInterface infoService;
        LOG.fine("template-based deploy + login");
        OmiJaasEntry jaasEntry = new OmiJaasEntry(omrHostMachine, omrHostPort, omrRepositoryName, authDomain, properties);
        Object reposDef = null;
        Object servDef = null;
        if (StartPFS.isActiveDeployment()) {
            LOG.fine("active deployment found");
            InformationServiceInterface infoService2 = (InformationServiceInterface)StartPFS.findService(InformationServiceInterface.class);
            infoService2.clearRepositoryDefs();
            infoService2.clearServerDefs();
            if (infoService2 == null) {
                throw new ServiceException("findService returned a null InformationServiceInterface");
            }
            JAAS_FILE.clear();
            LOG.fine("JAAS File cleared; adding current active deployment");
            StartPFS.addJAASEntry(jaasEntry);
        } else {
            LOG.fine("no existing deployment found; creating new one");
            JAAS_FILE.clear();
            StartPFS.addJAASEntry(jaasEntry);
            File deploymentFile = File.createTempFile("SAS-QandR-", ".xml");
            deploymentFile.deleteOnExit();
            String deploymentFilename = deploymentFile.getCanonicalPath();
            ConfigBuilder.generateDeploymentFile(deploymentFilename, omrRepositoryName, repositoryDefName, omrHostMachine, omrHostPort, authDomain);
            StartPFS.deployPlatformServices(deploymentFilename, applicationDeploymentName);
            deploymentFile.delete();
            infoService = (InformationServiceInterface)StartPFS.findService(InformationServiceInterface.class);
            infoService.clearRepositoryDefs();
            infoService.clearServerDefs();
        }
        LOG.fine("connect and obtain a session context");
        SessionContextInterface sc = null;
        UserContextInterface uc = null;
        infoService = null;
        try {
            infoService = (InformationServiceInterface)StartPFS.findService(InformationServiceInterface.class);
            sc = StartPFS.loginUser(omrUser, omrUserPassword, authDomain);
            uc = sc.getUserContext();
        }
        catch (Exception e) {
            infoService.clearRepositoryDefs();
            StartPFS.removeJAASEntry(jaasEntry);
            infoService.clearServerDefs();
            throw new ServiceException((Throwable)e, e.getMessage());
        }
        if (null != System.getProperty("java.security.auth.login.config")) {
            File f = new File(System.getProperty("java.security.auth.login.config"));
            f.delete();
        }
        Exception[] ucEx = uc.getExceptions();
        Exception ucExError_unconditional = null;
        String loginError = "false";
        if (ucEx != null) {
            Throwable ucExError = null;
            for (int i = 0; i < ucEx.length; ++i) {
                ucExError_unconditional = ucEx[i];
                String message = ucEx[i].getMessage();
                int index = -1;
                if (message != null) {
                    index = message.indexOf(omrHostMachine);
                }
                if (index == -1 || (index = message.indexOf(omrHostPort)) == -1) continue;
                ucExError = ucEx[i];
                loginError = "repositoryError";
                if (!(ucEx[i] instanceof ChainedException)) continue;
                if (ChainedException.chainContains((Throwable)ucEx[i], ConnectRefusedLoginServiceException.class)) {
                    loginError = "serverError";
                }
                if (ChainedException.chainContains((Throwable)ucEx[i], LoginException.class)) {
                    loginError = "serverError";
                }
                if (!ChainedException.chainContains((Throwable)ucEx[i], AutoConnectException.class)) continue;
                loginError = "serverError";
            }
            if (loginError.equals("false")) {
                loginError = "serverError";
                List ucServers = uc.getServers();
                for (ServerInterface _server : ucServers) {
                    if (!omrHostMachine.equals(_server.getHost()) || !omrHostPort.equals(Integer.toString(_server.getPort()))) continue;
                    loginError = "false";
                }
            }
            if (!loginError.equals("false")) {
                infoService.clearRepositoryDefs();
                if (loginError.equals("serverError")) {
                    StartPFS.removeJAASEntry(jaasEntry);
                    infoService.clearServerDefs();
                }
                if (ucExError == null) {
                    Object[] args = new Object[]{omrHostMachine, omrHostPort};
                    String pattern = RB.getStringResource("StartPFS.unableToConnect.fmt.txt");
                    String msg = MessageFormat.format(pattern, args);
                    throw new ServiceException((Throwable)ucExError_unconditional, ucExError_unconditional.getMessage() + " : " + msg);
                }
                throw new ServiceException(ucExError, ucExError.getMessage());
            }
        }
        return sc;
    }

    private static void addJAASEntry(OmiJaasEntry jaasEntry) throws IOException {
        JAAS_FILE.add(jaasEntry);
        File f = StartPFS.ensureJaasConfigFile();
        JAAS_FILE.write(f);
        Configuration.setConfiguration(null);
        Configuration loginConfig = Configuration.getConfiguration();
        loginConfig.refresh();
        StartPFS.setJAASConfiguration();
    }

    private static void removeJAASEntry(OmiJaasEntry jaasEntry) throws IOException {
        JAAS_FILE.remove(jaasEntry);
        File f = StartPFS.ensureJaasConfigFile();
        JAAS_FILE.write(f);
        Configuration.setConfiguration(null);
        Configuration loginConfig = Configuration.getConfiguration();
        loginConfig.refresh();
        StartPFS.setJAASConfiguration();
    }

    private static RepositoryDef getNewRepositoryDef(String reposDefName, String host, String port, String repository, String domain) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("new repos def: name='" + reposDefName + "', host='" + host + "', port='" + port + "', repository base='" + repository + "', domain='" + domain + '\'');
        }
        RepositoryDef reposDef = new RepositoryDef(host, port, domain, repository, "omi");
        reposDef.setDescription("Temporary definition created by sas.report.config.jar");
        reposDef.setName(reposDefName);
        reposDef.setAuto(true);
        return reposDef;
    }

    private static ServerDef createServerDef(RepositoryDef repositoryDef) {
        ServerDef serverDef = new ServerDef(ServiceDeploymentConfig.getServerDefName(repositoryDef.getName()), repositoryDef.getProtocol(), repositoryDef.getHost(), repositoryDef.getPort());
        serverDef.setDomain(repositoryDef.getDomain());
        serverDef.setDescription("Temporary definition created by sas.report.config.jar");
        serverDef.setAuto(repositoryDef.getAuto());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("new ServerDef: " + serverDef.toString());
        }
        return serverDef;
    }

    private static boolean addRepositoryDef(InformationServiceInterface infoService, RepositoryDef repositoryDef) throws ServiceException {
        boolean wasAdded = false;
        try {
            boolean isDefined = false;
            String serverDefName = repositoryDef.getName();
            RepositoryDef repository2 = null;
            for (RepositoryDef repository2 : infoService.getReposDefs()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found RepositoryDef: " + repository2.toString());
                }
                if (!serverDefName.equals(repository2.getName())) continue;
                isDefined = true;
                break;
            }
            if (!isDefined) {
                LOG.fine("no corresponding RepositoryDef found; adding new one");
                wasAdded = infoService.addRepositoryDef(repositoryDef);
            }
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        return wasAdded;
    }

    private static boolean removeRepositoryDef(InformationServiceInterface infoService, RepositoryDef repositoryDef) throws ServiceException {
        boolean wasRemoved = false;
        try {
            boolean isDefined = false;
            String serverDefName = repositoryDef.getName();
            RepositoryDef repository2 = null;
            for (RepositoryDef repository2 : infoService.getReposDefs()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found RepositoryDef: " + repository2.toString());
                }
                if (!serverDefName.equals(repository2.getName())) continue;
                isDefined = true;
                break;
            }
            if (isDefined) {
                LOG.fine("corresponding RepositoryDef found; removing it");
                wasRemoved = infoService.removeRepositoryDef(repositoryDef);
            }
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        return wasRemoved;
    }

    private static boolean addServerDef(InformationServiceInterface infoService, ServerDef serverDef) throws ServiceException {
        boolean wasAdded = false;
        try {
            boolean serverFound = false;
            String serverDefName = serverDef.getName();
            ServerDef server2 = null;
            for (ServerDef server2 : infoService.getServerDefs()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found ServerDef: " + server2.toString());
                }
                if (!serverDefName.equals(server2.getName())) continue;
                serverFound = true;
                break;
            }
            if (!serverFound) {
                LOG.fine("no corresponding ServerDef found; adding new one");
                wasAdded = infoService.addServerDef(serverDef);
            }
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        return wasAdded;
    }

    private static boolean removeServerDef(InformationServiceInterface infoService, ServerDef serverDef) throws ServiceException {
        boolean wasRemoved = false;
        try {
            boolean serverFound = false;
            String serverDefName = serverDef.getName();
            ServerDef server2 = null;
            for (ServerDef server2 : infoService.getServerDefs()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found ServerDef: " + server2.toString());
                }
                if (!serverDefName.equals(server2.getName())) continue;
                serverFound = true;
                break;
            }
            if (serverFound) {
                LOG.fine("corresponding ServerDef found; removing it");
                wasRemoved = infoService.removeServerDef(serverDef);
            }
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        return wasRemoved;
    }

    private static boolean removeServerDef(InformationServiceInterface infoService) throws ServiceException {
        boolean wasRemoved = false;
        try {
            ServerDef server2 = null;
            for (ServerDef server2 : infoService.getServerDefs()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found ServerDef: " + server2.toString());
                }
                LOG.fine("ServerDef found; removing it");
                wasRemoved = infoService.removeServerDef(server2);
            }
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        return wasRemoved;
    }

    private static boolean removeRepositoryDef(InformationServiceInterface infoService) throws ServiceException {
        boolean wasRemoved = false;
        try {
            RepositoryDef repository2 = null;
            for (RepositoryDef repository2 : infoService.getReposDefs()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found RepositoryDef: " + repository2.toString());
                }
                LOG.fine("corresponding RepositoryDef found; removing it");
                wasRemoved = infoService.removeRepositoryDef(repository2);
            }
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        return wasRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File ensureJaasConfigFile() throws IOException {
        LOG.fine("entering");
        if (_originalJaasProp == null) {
            _originalJaasProp = System.getProperty("java.security.auth.login.config");
            if (_originalJaasProp == null) {
                _originalJaasProp = "";
            }
        } else if (null != System.getProperty("java.security.auth.login.config")) {
            File f = new File(System.getProperty("java.security.auth.login.config"));
            f.delete();
        }
        File configFile = File.createTempFile("SAS-QandR-", ".config");
        configFile.deleteOnExit();
        String configFilename = configFile.getCanonicalPath();
        System.setProperty("java.security.auth.login.config", configFilename);
        if (_originalJaasProp.length() > 0) {
            BufferedReader rdr = null;
            BufferedWriter wrt = null;
            try {
                String aline;
                rdr = new BufferedReader(new FileReader(_originalJaasProp));
                wrt = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), "UTF-8"));
                while ((aline = rdr.readLine()) != null) {
                    wrt.write(aline);
                    wrt.newLine();
                }
            }
            finally {
                IOException ioException = null;
                if (rdr != null) {
                    try {
                        rdr.close();
                    }
                    catch (IOException e) {
                        ioException = e;
                    }
                }
                if (wrt != null) {
                    wrt.close();
                }
                if (ioException != null) {
                    throw ioException;
                }
            }
        }
        return configFile;
    }

    private static boolean isActiveDeployment() {
        LOG.fine("entering");
        try {
            SessionServiceInterface sessionService = (SessionServiceInterface)StartPFS.findService(SessionServiceInterface.class);
            if (sessionService == null) {
                LOG.fine("no session service exists");
                return false;
            }
            short svcState = sessionService.getServiceState();
            if (ServiceState.isStateDeactivated((short)svcState)) {
                LOG.fine("service exists, but it has been deactivated");
                return false;
            }
        }
        catch (Exception e) {
            LOG.fine("no valid deployment exists");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deployPlatformServices(String pfsDeploymentFileURL, String softwareComponentName) throws MalformedURLException, ServiceException {
        LOG.fine("file-based deploy");
        File metaDataFile = new File(pfsDeploymentFileURL);
        if (!metaDataFile.exists() && !metaDataFile.isFile()) {
            Object[] args = new Object[]{pfsDeploymentFileURL};
            String pattern = RB.getStringResource("StartPFSinvalid.fmt.txt");
            String msg = MessageFormat.format(pattern, args);
            throw new MalformedURLException(msg);
        }
        URLMetadataSource metadataSource = null;
        try {
            metadataSource = new URLMetadataSource(metaDataFile.toURL());
            ServiceLoader.deployServices((MetadataSourceInterface)metadataSource, (Environment)ENVIRONMENT, (DiscoveryServiceInterface)DiscoveryService.defaultInstance());
        }
        finally {
            if (metadataSource != null) {
                metadataSource.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deployPlatformServices(String omrHostMachine, String omrHostPort, String omrUser, String omrUserPassword, String omrRepositoryName, String applicationDeploymentName, String serviceDeploymentGroupName) throws ServiceException {
        String encryptedPassword;
        LOG.fine("OMR-based deploy");
        StringTokenizer stOmrHostMachine = new StringTokenizer(omrHostMachine);
        String _host = stOmrHostMachine.nextToken();
        StringTokenizer stOmrHostPort = new StringTokenizer(omrHostPort);
        String _port = stOmrHostPort.nextToken();
        try {
            encryptedPassword = SasPasswordString.encode((String)"sas001", (String)omrUserPassword);
        }
        catch (SasPasswordEncodingException e) {
            throw new ServiceException((Throwable)e, e.getMessage());
        }
        OMRMetadataSource metadataSource = null;
        try {
            LOG.fine("creating an OMRMetadataSource");
            metadataSource = new OMRMetadataSource(_host, _port, omrUser, encryptedPassword, omrRepositoryName, applicationDeploymentName, serviceDeploymentGroupName);
            LOG.fine("obtaining a reference to our discovery service");
            LOG.fine("deploying the defined services");
            ServiceLoader.deployServices((MetadataSourceInterface)metadataSource, (Environment)ENVIRONMENT, (DiscoveryServiceInterface)DiscoveryService.defaultInstance());
        }
        finally {
            if (metadataSource != null) {
                metadataSource.destroy();
            }
        }
    }

    public static SessionContextInterface loginUser(String userid, String password, String domain) throws InitializationException, ServiceException, RemoteException {
        LOG.fine("login user: " + userid + " in domain " + domain);
        UserServiceInterface userService = (UserServiceInterface)StartPFS.findService(UserServiceInterface.class);
        userService.setGroupLoginEnabled(true);
        UserContextInterface userContext = null;
        try {
            userContext = userid == null && password == null || userid.equals("") && password.equals("") ? userService.newUser(null, null) : userService.newUser(userid, password, domain);
        }
        catch (UserInitializationException uiex) {
            Exception[] exceptions = uiex.getExceptions();
            for (int i = 0; i < exceptions.length; ++i) {
                LOG.fine("==========loginUser calling userService.newUser()==========");
                Throwable th = ChainedException.getRootException((Throwable)exceptions[i]);
                LOG.log(Level.FINE, "userService.newUser", th);
                LOG.fine("===========================================================");
            }
            userContext = uiex.getUser();
        }
        SessionServiceInterface sessionService = (SessionServiceInterface)StartPFS.findService(SessionServiceInterface.class);
        SessionContextInterface sessionContext = sessionService.newSessionContext(userContext);
        userContext.setSessionContext(sessionContext);
        return sessionContext;
    }

    private static Object findService(Class theClass) throws ServiceNotAvailableException, InitializationException, RemoteException, ServiceException {
        LOG.fine("finding: " + theClass.getName());
        return DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{theClass}));
    }

    public static boolean dropDeployedServices() throws RemoteException, ServiceException {
        LOG.fine("entering");
        LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
        if (discoveryService == null) {
            return false;
        }
        discoveryService.removeAllServiceObservers();
        discoveryService.destroy();
        return true;
    }

    public static void dropSession(SessionContextInterface sessionContext) throws RemoteException, LockingException {
        LOG.fine("entering");
        if (sessionContext != null) {
            sessionContext.destroy();
        }
    }

    private static void setJAASConfiguration() {
        Configuration.setConfiguration(null);
        Configuration loginConfig = Configuration.getConfiguration();
        AppConfigurationEntry[] entries = loginConfig.getAppConfigurationEntry(StartPFS.getLoginModuleName());
        if (LOG.isLoggable(Level.FINE)) {
            int numEntries = entries == null ? 0 : entries.length;
            AppConfigurationEntry entry = null;
            Map.Entry<String, ?> mapEntry2 = null;
            for (int i = 0; i < numEntries; ++i) {
                entry = entries[i];
                LOG.fine(entry.getLoginModuleName());
                for (Map.Entry<String, ?> mapEntry2 : entry.getOptions().entrySet()) {
                    LOG.fine(Message.format((ResourceBundle)RB.getResources(), (String)"JaasLoginConfig.loginModuleEntryOption.fmt.txt", (Object)mapEntry2.getKey(), mapEntry2.getValue()));
                }
            }
        }
        loginConfig.refresh();
        ENVIRONMENT.setAppConfigurationEntry(entries);
    }

    public static final void setLoginModuleName(String loginModuleName) {
        _loginModuleName = loginModuleName;
    }

    private static final String getLoginModuleName() {
        return _loginModuleName;
    }

    private StartPFS() {
    }

    static {
        _originalJaasProp = null;
        _loginModuleName = "PFS";
        ENVIRONMENT = new Environment();
        try {
            if (Boolean.getBoolean(DEBUG_LOGGING_PROPERTY)) {
                Logger packageLogger = Logger.getLogger("com.sas.report.config");
                Level newLevel = Level.FINE;
                packageLogger.setLevel(newLevel);
                ConsoleHandler ch = new ConsoleHandler(){

                    @Override
                    public void publish(LogRecord record) {
                        StringBuffer buf = new StringBuffer(100);
                        buf.append(record.getMillis());
                        buf.append(", ");
                        buf.append(record.getSourceClassName());
                        buf.append(", ");
                        buf.append(record.getSourceMethodName());
                        buf.append(", ");
                        buf.append(record.getMessage());
                        System.out.println(buf.toString());
                    }
                };
                ch.setLevel(newLevel);
                packageLogger.addHandler(ch);
                packageLogger.setLevel(newLevel);
                packageLogger.setUseParentHandlers(false);
                LOG.fine("DEBUG LOGGING INITIALIZED");
            }
            DEFAULT_SOFTWARECOMPONENT_NAME = RB.getStringResource("StartPFSdeploymentApplicationName.notrans");
            DEFAULT_GROUP_NAME = RB.getStringResource("StartPFSdeploymentGroupName.notrans");
            JAAS_FILE = new OmiJaasFile();
            File f = StartPFS.ensureJaasConfigFile();
            JAAS_FILE.init(f);
        }
        catch (Exception e) {
            String msg = "FATAL ERROR: Initialization of com.sas.report.config.StartPFS failed!";
            System.err.println(msg);
            e.printStackTrace();
            throw new UncheckedException((Throwable)e, msg);
        }
    }
}

