/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.config;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;

class ServiceDeploymentConfig {
    public static final String REPOS_DEF_TAG = "<REPOSDEFTEMPLATE>";
    public static final String PRIMARY_HOST_DEF_TAG = "<PRIMARY_HOST_TEMPLATE>";
    public static final String ROOT_LOGGING_TAG = "<ROOT_LOGGING_LEVEL>";
    private static final int BUFFER_DEPLOYMENT_LENGTH_IN_CHARS = 1000;
    private String myTemplate;

    public static String getReposDef(String host, String port, String reposDefName, String domain, String protocol, String base, String auto) {
        String reposDefStr = "&lt;ServerDef   name=&quot;" + ServiceDeploymentConfig.getServerDefName(reposDefName) + "&quot;   protocol=&quot;" + protocol + "&quot;   host=&quot;" + host + "&quot;   port=&quot;" + port + "&quot;   auto=&quot;" + auto + "&quot;   domain=&quot;" + domain + "&quot;  description=&quot;Server definition for " + host + ':' + port + "&quot;/&gt;";
        if (base != null) {
            reposDefStr = reposDefStr + "&lt;ReposDef   name=&quot;" + reposDefName + "&quot;   protocol=&quot;" + protocol + "&quot;   host=&quot;" + host + "&quot;   port=&quot;" + port + "&quot;   base=&quot;" + base + "&quot;   auto=&quot;" + auto + "&quot;   domain=&quot;" + domain + "&quot;  description=&quot;Repository definition for " + reposDefName + " on " + host + ':' + port + "&quot;/&gt;";
        }
        return reposDefStr;
    }

    static final String getServerDefName(String reposDefName) {
        StringTokenizer tokenizer;
        String serverDefName = "";
        if (reposDefName != null) {
            serverDefName = reposDefName;
            tokenizer = new StringTokenizer(reposDefName, "@");
        } else {
            tokenizer = new StringTokenizer("");
            serverDefName = "METASERVER";
        }
        if (tokenizer.countTokens() == 4) {
            String host;
            tokenizer.nextToken();
            serverDefName = host = tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                serverDefName = serverDefName + '@' + tokenizer.nextToken();
            }
        }
        return serverDefName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceDeploymentConfig(String templatePathname) throws IOException {
        StringBuffer buf = new StringBuffer(1000);
        try (BufferedReader templateFile = null;){
            templateFile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(templatePathname), "UTF-8"));
            int inpChar = templateFile.read();
            while (inpChar != -1) {
                buf.append((char)inpChar);
                inpChar = templateFile.read();
            }
        }
        this.myTemplate = buf.toString();
    }

    public String getText(String reposDef, String rootLoggingLevel, String hostDef) {
        String text = this.myTemplate.replace(REPOS_DEF_TAG, "");
        text = text.replace(ROOT_LOGGING_TAG, rootLoggingLevel);
        text = text.replace(PRIMARY_HOST_DEF_TAG, "");
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String reposDef, String rootLoggingLevel, String outputPathname, String hostDef) throws IOException {
        try (OutputStreamWriter osw = null;){
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputPathname), "UTF-8");
            String deploymentText = this.getText(reposDef, rootLoggingLevel, hostDef);
            osw.write(deploymentText);
        }
    }

    public void write(String reposDef, String outputPathname, String hostDef) throws IOException {
        this.write(reposDef, "ERROR", outputPathname, hostDef);
    }
}

