/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.config;

import com.sas.report.config.RBUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

class JaasLoginConfig {
    private static final Logger log = Logger.getLogger(JaasLoginConfig.class.getName());
    public static final String HOST_TAG = "<PUT_JAAS_HOST_HERE>";
    public static final String PORT_TAG = "<PUT_JAAS_PORT_HERE>";
    public static final String REPOSITORY_TAG = "<PUT_JAAS_REPOSITORY_HERE>";
    public static final String DOMAIN_TAG = "<PUT_JAAS_DOMAIN_HERE>";
    public static final String DEFAULT_TEMPLATE = "/** Generated JAAS Login Configuration... do not edit **/\nPFS {\n   com.sas.services.security.login.OMILoginModule  optional\n   host=\"<PUT_JAAS_HOST_HERE>\"\n   port=\"<PUT_JAAS_PORT_HERE>\"\n   repository=\"<PUT_JAAS_REPOSITORY_HERE>\"\n   domain=\"<PUT_JAAS_DOMAIN_HERE>\";\n};";
    public static final String DEFAULT_TEMPLATE_NO_REPOSITORY = "/** Generated JAAS Login Configuration... do not edit **/\nPFS {\n   com.sas.services.security.login.OMILoginModule  optional\n   host=\"<PUT_JAAS_HOST_HERE>\"\n   port=\"<PUT_JAAS_PORT_HERE>\"\n   domain=\"<PUT_JAAS_DOMAIN_HERE>\";\n};";
    private String myTemplate;

    public JaasLoginConfig(String templatePathname) throws IOException {
        if (templatePathname == null) {
            this.myTemplate = DEFAULT_TEMPLATE;
        } else if (templatePathname == "-1") {
            this.myTemplate = DEFAULT_TEMPLATE_NO_REPOSITORY;
        } else {
            FileInputStream fis = new FileInputStream(templatePathname);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader templateFile = new BufferedReader(isr);
            StringBuffer buf = new StringBuffer();
            int inpChar = templateFile.read();
            while (inpChar != -1) {
                buf.append((char)inpChar);
                inpChar = templateFile.read();
            }
            templateFile.close();
            this.myTemplate = buf.toString();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Enabling debug logging in JAAS template");
            int hostEquals = this.myTemplate.indexOf("host=");
            if (hostEquals < 0) {
                throw new IllegalStateException(RBUtil.getStringResource("JaasLoginConfig.debugRequestedButNoCurly.txt"));
            }
            this.myTemplate = this.myTemplate.substring(0, hostEquals) + "debug=\"true\"\n   " + this.myTemplate.substring(hostEquals);
            log.fine("JAAS TEMPLATE:\n" + this.myTemplate);
        }
    }

    public String getText(String host, String port, String repository, String domain) {
        String text = this.myTemplate.replaceAll(HOST_TAG, host);
        text = text.replaceAll(PORT_TAG, port);
        if (repository != null) {
            text = text.replaceAll(REPOSITORY_TAG, repository);
        }
        text = text.replace(DOMAIN_TAG, domain);
        return text;
    }

    public void write(String host, String port, String repository, String domain, String outputPathname) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputPathname);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        String config = this.getText(host, port, repository, domain);
        osw.write(config);
        osw.close();
    }
}

