/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import EDU.oswego.cs.dl.util.concurrent.CondVar;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.Mutex;

public class CVBuffer
implements BoundedChannel {
    private final Mutex mutex;
    private final CondVar notFull;
    private final CondVar notEmpty;
    private int count = 0;
    private int takePtr = 0;
    private int putPtr = 0;
    private final Object[] array;

    public CVBuffer(int cap) {
        this.array = new Object[cap];
        this.mutex = new Mutex();
        this.notFull = new CondVar(this.mutex);
        this.notEmpty = new CondVar(this.mutex);
    }

    public CVBuffer() {
        this(DefaultChannelCapacity.get());
    }

    public int capacity() {
        return this.array.length;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(Object x) throws InterruptedException {
        this.mutex.acquire();
        try {
            while (true) {
                block4: {
                    if (this.count == this.array.length) break block4;
                    this.array[this.putPtr] = x;
                    this.putPtr = (this.putPtr + 1) % this.array.length;
                    ++this.count;
                    this.notEmpty.signal();
                    break;
                }
                this.notFull.await();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.mutex.release();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.mutex.release();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object take() throws InterruptedException {
        Object x = null;
        this.mutex.acquire();
        try {
            while (true) {
                block4: {
                    if (this.count == 0) break block4;
                    x = this.array[this.takePtr];
                    this.array[this.takePtr] = null;
                    this.takePtr = (this.takePtr + 1) % this.array.length;
                    --this.count;
                    this.notFull.signal();
                    break;
                }
                this.notEmpty.await();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.mutex.release();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.mutex.release();
            return x;
        }
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        block3: {
            this.mutex.acquire();
            try {
                if (this.count != this.array.length) break block3;
                this.notFull.timedwait(msecs);
                if (this.count != this.array.length) break block3;
                Object var4_3 = null;
                this.mutex.release();
                return false;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.mutex.release();
                throw throwable;
            }
        }
        this.array[this.putPtr] = x;
        this.putPtr = (this.putPtr + 1) % this.array.length;
        ++this.count;
        this.notEmpty.signal();
        Object var4_4 = null;
        this.mutex.release();
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object poll(long msecs) throws InterruptedException {
        Object x = null;
        this.mutex.acquire();
        try {
            if (this.count == 0) {
                this.notEmpty.timedwait(msecs);
                if (this.count == 0) {
                    Object var6_3 = null;
                    Object var4_4 = null;
                    this.mutex.release();
                    return var6_3;
                }
            }
            x = this.array[this.takePtr];
            this.array[this.takePtr] = null;
            this.takePtr = (this.takePtr + 1) % this.array.length;
            --this.count;
            this.notFull.signal();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.mutex.release();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.mutex.release();
            return x;
        }
    }

    public Object peek() {
        try {
            block5: {
                this.mutex.acquire();
                try {
                    if (this.count != 0) break block5;
                    Object var3_1 = null;
                    Object var1_3 = null;
                    this.mutex.release();
                    return var3_1;
                }
                catch (Throwable throwable) {
                    Object var1_5 = null;
                    this.mutex.release();
                    throw throwable;
                }
            }
            Object object = this.array[this.takePtr];
            Object var1_4 = null;
            this.mutex.release();
            return object;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

