/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deploymntreg;

import com.sas.deploymntreg.Database;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class Registry {
    protected static final Integer MACHINE = new Integer(0);
    protected static final Integer USERS = new Integer(1);
    protected static final Integer CURRENTUSER = new Integer(2);
    private static final int REGISTRY_VERSION = 3;
    private static final String ROOT = "Registry";
    private static final String MACHINE_LABEL = "Machine";
    private static final String USERS_LABEL = "Users";
    private static final String registryFile = "registry.xml";
    private static final String journalFile = "registry.jnl";
    private static final String lockFile = "registry.lck";
    private static final String propertyFile = "registry.properties";
    protected static String openRegistryRoot = null;
    private static File journal = null;
    private static Properties properties;

    private static void logAction(boolean success, String logEntry) {
        if (logEntry != null) {
            try {
                FileWriter writer = new FileWriter(journal, true);
                writer.write(MessageFormat.format("{0} ({1}): {2}\n", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), success ? "SUCCESS" : "FAILURE", logEntry));
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void logAction(boolean success, String action, String key, String value, String name) {
        String logEntry = null;
        if (action != null) {
            logEntry = (logEntry == null ? "" : logEntry + " ") + MessageFormat.format("{0}=\"{1}\"", "action", action);
        }
        if (key != null) {
            logEntry = (logEntry == null ? "" : logEntry + " ") + MessageFormat.format("{0}=\"{1}\"", "key", key);
        }
        if (value != null) {
            logEntry = (logEntry == null ? "" : logEntry + " ") + MessageFormat.format("{0}=\"{1}\"", "value", value);
        }
        if (name != null) {
            logEntry = (logEntry == null ? "" : logEntry + " ") + MessageFormat.format("{0}=\"{1}\"", "name", name);
        }
        Registry.logAction(success, logEntry);
    }

    private static String checkKey(Integer section, String key) {
        String retVal = null;
        if (section.equals(MACHINE)) {
            retVal = "Machine/" + key;
        } else if (section.equals(USERS)) {
            retVal = "Users/" + key;
        } else if (section.equals(CURRENTUSER)) {
            retVal = "Users/" + System.getProperty("user.name") + "/" + key;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initProperties(String registryRoot) {
        if (properties == null) {
            File file;
            URL url;
            properties = new Properties();
            if (registryRoot == null && (url = Registry.class.getProtectionDomain().getCodeSource().getLocation()) != null) {
                try {
                    registryRoot = new File(URLDecoder.decode(url.getFile(), "UTF-8")).getParent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (registryRoot != null && (file = new File(registryRoot, propertyFile)).isFile()) {
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(file);
                    properties.load(inputStream);
                }
                catch (Exception exception) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveProperties(String registryRoot) {
        URL url;
        if (registryRoot == null && (url = Registry.class.getProtectionDomain().getCodeSource().getLocation()) != null) {
            try {
                registryRoot = new File(URLDecoder.decode(url.getFile(), "UTF-8")).getParent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (properties != null && registryRoot != null) {
            File file = new File(registryRoot, propertyFile);
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(file);
                properties.store(outputStream, null);
            }
            catch (Exception exception) {
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static boolean close(boolean write) {
        boolean retVal = false;
        if (Database.close(write)) {
            openRegistryRoot = null;
            journal = null;
            retVal = true;
        }
        return retVal;
    }

    private static int getRegistryVersion() {
        int retVal = -1;
        String version = Database.getVersion();
        if ("1.0".equals(version)) {
            version = "1";
        }
        try {
            retVal = Integer.parseInt(version);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static boolean migrateOneToTwo() {
        boolean retVal = false;
        if (Registry.getRegistryVersion() == 1 && (retVal = Database.moveKey("Machine/INSTALL", "Machine/INSTALL/" + Registry.getProperty(openRegistryRoot, "default.host", "default")))) {
            Database.setVersion("2");
        }
        Registry.logAction(retVal, "Registry migrated from version 1 to version 2");
        return retVal;
    }

    private static boolean migrateTwoToThree() {
        boolean retVal = false;
        if (Registry.getRegistryVersion() == 2) {
            int i;
            retVal = true;
            if (retVal) {
                String[] hosts = Registry.enumKey(MACHINE, "INSTALL");
                for (i = 0; retVal && i < hosts.length; ++i) {
                    String[] products = Registry.enumKey(MACHINE, "INSTALL/" + hosts[i]);
                    for (int j = 0; retVal && j < products.length; ++j) {
                        String[] versions = Registry.enumKey(MACHINE, "INSTALL/" + hosts[i] + "/" + products[j]);
                        for (int k = 0; retVal && k < versions.length; ++k) {
                            if (Registry.setValue(MACHINE, "INSTALL/" + hosts[i] + "/" + products[j] + "/" + versions[k], "views", "9.3")) continue;
                            retVal = false;
                        }
                    }
                }
            }
            if (retVal) {
                String[] configs = Registry.enumKey(MACHINE, "CONFIG");
                for (i = 0; retVal && i < configs.length; ++i) {
                    if (Registry.setValue(MACHINE, "CONFIG/" + configs[i], "views", "9.3")) continue;
                    retVal = false;
                }
            }
            if (retVal) {
                Database.setVersion("3");
            }
        }
        Registry.logAction(retVal, "Registry migrated from version 2 to version 3");
        return retVal;
    }

    public static boolean open() {
        boolean retVal = false;
        URL url = Registry.class.getProtectionDomain().getCodeSource().getLocation();
        if (url != null) {
            try {
                retVal = Registry.open(new File(URLDecoder.decode(url.getFile(), "UTF-8")).getParent());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retVal;
    }

    public static boolean open(String registryRoot) {
        boolean retVal = false;
        if (registryRoot != null && Database.open(ROOT, "3", registryRoot + File.separator + registryFile, registryRoot + File.separator + lockFile)) {
            openRegistryRoot = registryRoot;
            journal = new File(registryRoot, journalFile);
            retVal = true;
        }
        if (retVal) {
            Registry.initProperties(registryRoot);
            switch (Registry.getRegistryVersion()) {
                case 1: {
                    if (!retVal) break;
                    retVal = Registry.migrateOneToTwo();
                }
                case 2: {
                    if (!retVal) break;
                    retVal = Registry.migrateTwoToThree();
                }
            }
            if (!retVal || Registry.getRegistryVersion() != 3) {
                retVal = false;
                Registry.close(false);
            }
        }
        return retVal;
    }

    public static boolean close() {
        return Registry.close(true);
    }

    public static boolean closeReadOnly() {
        return Registry.close(false);
    }

    public static void setProperty(String registryRoot, String key, String value) {
        Registry.initProperties(registryRoot);
        properties.setProperty(key, value);
        Registry.saveProperties(registryRoot);
    }

    public static String getProperty(String registryRoot, String key, String defaultValue) {
        Registry.initProperties(registryRoot);
        return properties.getProperty(key, defaultValue);
    }

    public static String getProperty(String registryRoot, String key) {
        return Registry.getProperty(registryRoot, key, null);
    }

    protected static boolean createKey(Integer section, String key) {
        boolean retVal = false;
        String fullKey = Registry.checkKey(section, key);
        if (fullKey != null) {
            retVal = Database.createKey(Registry.checkKey(section, key));
            Registry.logAction(retVal, "createKey", fullKey, null, null);
        }
        return retVal;
    }

    protected static boolean deleteKey(Integer section, String key) {
        boolean retVal = false;
        String fullKey = Registry.checkKey(section, key);
        if (fullKey != null) {
            retVal = Database.deleteKey(Registry.checkKey(section, key));
            Registry.logAction(retVal, "deleteKey", fullKey, null, null);
        }
        return retVal;
    }

    protected static boolean setValue(Integer section, String key, String name, String data) {
        boolean retVal = false;
        String fullKey = Registry.checkKey(section, key);
        if (fullKey != null) {
            retVal = Database.setValue(fullKey, name, data);
            Registry.logAction(retVal, "setValue", fullKey, name, data);
        }
        return retVal;
    }

    protected static boolean deleteValue(Integer section, String key, String name) {
        boolean retVal = false;
        String fullKey = Registry.checkKey(section, key);
        if (fullKey != null) {
            retVal = Database.deleteValue(Registry.checkKey(section, key), name);
            Registry.logAction(retVal, "deleteValue", fullKey, name, null);
        }
        return retVal;
    }

    protected static String getValue(Integer section, String key, String name) {
        return Database.getValue(Registry.checkKey(section, key), name);
    }

    protected static String[] enumKey(Integer section, String key) {
        return Database.enumKey(Registry.checkKey(section, key));
    }

    protected static String[] enumValue(Integer section, String key) {
        return Database.enumValue(Registry.checkKey(section, key));
    }
}

