/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deploymntreg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RegEdit {
    public RegEdit(String[] argv) {
        Method method = new Method();
        if ("--file".equals(argv[0])) {
            if (argv.length >= 2) {
                try {
                    this.parseXML(argv[1], method);
                }
                catch (FileNotFoundException e) {
                    System.err.println(e.getMessage());
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            } else {
                RegEdit.usage();
            }
        } else if ("--view".equals(argv[0])) {
            if (argv.length >= 3) {
                method.openView(argv[1]);
                method.setMethod(argv[2]);
                for (int i = 3; i < argv.length; ++i) {
                    method.addParameter(argv[i]);
                }
                RegEdit.displayOutput(method.execute());
            } else {
                RegEdit.usage();
            }
        } else {
            method.setMethod(argv[0]);
            for (int i = 1; i < argv.length; ++i) {
                method.addParameter(argv[i]);
            }
            RegEdit.displayOutput(method.execute());
        }
        method.close();
    }

    private void parseXML(String file, Method method) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this.parseXML(new File(file), method);
    }

    private void parseXML(File file, Method method) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new FileInputStream(file)).getDocumentElement();
        if ("deploymentRegistry".equals(root.getTagName())) {
            NodeList data;
            if (root.hasAttribute("view")) {
                method.openView(root.getAttribute("view"));
            }
            if ((data = root.getElementsByTagName("execute")) != null) {
                for (int i = 0; i < data.getLength(); ++i) {
                    Element element = (Element)data.item(i);
                    if (!element.hasAttribute("method")) continue;
                    method.reset();
                    method.setMethod(element.getAttribute("method"));
                    int j = 1;
                    while (element.hasAttribute("param" + j)) {
                        method.addParameter(element.getAttribute("param" + j));
                        ++j;
                    }
                    RegEdit.displayOutput(method.execute());
                }
            }
        }
    }

    private static void usage() {
        System.out.println("Usage Notes:");
        System.out.println("");
        System.out.println("   java RegEdit --view view method parameter1 parameter2 ... parameterN");
        System.out.println("   java RegEdit --file path/file.xml");
    }

    private static void displayOutput(Object output) {
        if (output instanceof String[]) {
            String displayText = "[";
            String[] array = (String[])output;
            for (int i = 0; i < array.length; ++i) {
                displayText = i == 0 ? displayText + array[i] : displayText + ", " + array[i];
            }
            displayText = displayText + "]";
            System.out.println(displayText);
        } else {
            System.out.println(output);
        }
    }

    public static void main(String[] argv) {
        if (argv.length < 1) {
            RegEdit.usage();
        } else {
            new RegEdit(argv);
        }
    }

    private class Method {
        private Class deployAPI;
        private String method;
        private ArrayList<Object> parameters;

        public Method() {
            this.reset();
            try {
                this.deployAPI = Class.forName("com.sas.deploymntreg.DeployAPI");
                if (this.deployAPI.getMethod("open", null).invoke(null, null).equals(Boolean.FALSE)) {
                    System.err.println(">> ERROR: Failed to open the registry.");
                    System.exit(0);
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }

        public void openView(String view) {
            try {
                if (view != null) {
                    this.close();
                    if (this.deployAPI.getMethod("openView", String.class).invoke(null, view).equals(Boolean.FALSE)) {
                        System.err.println(">> ERROR: Failed to open the registry.");
                        System.exit(0);
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }

        public void reset() {
            this.method = null;
            this.parameters = new ArrayList();
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void addParameter(Object parameter) {
            this.parameters.add(parameter);
        }

        public void close() {
            try {
                if (this.deployAPI.getMethod("close", null).invoke(null, null).equals(Boolean.FALSE)) {
                    System.err.println(">> ERROR: Failed to close the registry.");
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }

        public Object execute() {
            Object result = null;
            if (this.deployAPI != null) {
                Object[] obj = null;
                Class[] types = null;
                if (this.parameters.size() > 0) {
                    obj = new Object[this.parameters.size()];
                    types = new Class[this.parameters.size()];
                    for (int i = 0; i < this.parameters.size(); ++i) {
                        obj[i] = this.parameters.get(i);
                        types[i] = this.parameters.get(i).getClass();
                    }
                }
                try {
                    result = this.deployAPI.getMethod(this.method, types).invoke(null, obj);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            return result;
        }
    }
}

