/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deploymntreg;

import com.sas.deploymntreg.Registry;
import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeployAPI
extends Registry {
    private static final String COMMON = "COMMON";
    private static final String INSTALL = "INSTALL";
    private static final String CONFIG = "CONFIG";
    private static final String CONFIG_SECTION = "Configuration";
    private static final String SASHOME = "sashome";
    private static final String INSTALL_USER = "install_user";
    private static final String MAJOR_RELEASES = "major_releases";
    private static final String LAST_ORDER = "last_order";
    private static final String LOCATION = "location";
    private static final String DISPLAYNAME = "displayname";
    private static final String FAMILY = "family";
    private static final String LANGUAGES = "languages";
    private static final String KEYFILE = "keyfile";
    private static final String LOGFILE = "logfile";
    private static final String GUID = "guid";
    private static final String STATUS = "status";
    private static final String STATUS_DLGMSG = "status_dlgmsg";
    private static final String STATUS_LOGMSG = "status_logmsg";
    private static final String SERVICE_PACK = "sp";
    private static final String LAST_PORT_DATE = "last_port_date";
    private static final String VJR_CONSUMER = "vjr_consumer";
    private static final String ORDER = "order";
    private static final String SETNUMID = "setnumid";
    private static final String PLAN = "plan";
    private static final String PROPERTIES = "properties";
    private static final String TIMESTAMP = "timestamp";
    private static final String VIEWS = "views";
    private static final String MAINT_ID = "id";
    private static final String LAST_MAINT = "lastmaint";
    private static final String MAINT_LEVEL = "maintlevel";
    private static final String UNINSTALL_LOC = "uninstall_loc";
    private static final String SASHOME_LOCALE_NAME = "sashome.locale.name";
    private static final String SASHOME_ENCODING_NAME = "sashome.encoding.name";
    private static final String SASHOME_ENCODING_JAVA_NAME = "sashome.encoding.java.name";
    private static final String SASHOME_ZOS_ENCODING_IBM_NAME = "sashome.zos.encoding.ibm.name";
    private static final String SASHOME_ZOS_ENCODING_TYPE = "sashome.zos.encoding.type";
    private static final String SASHOME_ZOS_ENCODING_TWO_BYTE = "sashome.zos.encoding2";
    private static String currentView = null;

    private static boolean setCommonProperty(String property, String value) {
        boolean retVal = false;
        if (property != null && property.length() > 0 && value != null) {
            retVal = DeployAPI.setValue(MACHINE, COMMON, property, value);
        }
        return retVal;
    }

    private static String getCommonProperty(String property) {
        String retVal = null;
        if (property != null && property.length() > 0) {
            retVal = DeployAPI.getValue(MACHINE, COMMON, property);
        }
        return retVal;
    }

    private static boolean setInstallProperty(String product, String version, String host, String property, String value) {
        boolean retVal = false;
        if (product != null && product.length() > 0 && version != null && version.length() > 0 && host != null && host.length() > 0 && property != null && property.length() > 0 && value != null && (retVal = DeployAPI.setValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version, property, value)) && !DeployAPI.containsInstallView(product, version, host, currentView)) {
            retVal = DeployAPI.addInstallView(product, version, host);
        }
        return retVal;
    }

    private static String getInstallProperty(String product, String version, String host, String view, String property) {
        String retVal = null;
        if (product != null && product.length() > 0 && version != null && version.length() > 0 && host != null && host.length() > 0 && property != null && property.length() > 0 && DeployAPI.containsInstallView(product, version, host, view)) {
            retVal = DeployAPI.getValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version, property);
        }
        return retVal;
    }

    private static boolean setMaintProperty(String product, String version, String host, String maintVer, String property, String value) {
        String maintSection;
        boolean retVal = false;
        if (product != null && product.length() > 0 && version != null && version.length() > 0 && host != null && host.length() > 0 && maintVer != null && maintVer.length() > 0 && property != null && property.length() > 0 && value != null && (maintSection = DeployAPI.getMaintSection("INSTALL/" + host + "/" + product + "/" + version + "/maintenance", maintVer, true)) != null && (retVal = DeployAPI.setValue(MACHINE, maintSection, property, value)) && !DeployAPI.containsInstallView(product, version, host, currentView)) {
            retVal = DeployAPI.addInstallView(product, version, host);
        }
        return retVal;
    }

    private static boolean setMaintProperty(String product, String version, String host, String maintVer, String language, String property, String value) {
        String maintSection;
        boolean retVal = false;
        if (product != null && product.length() > 0 && version != null && version.length() > 0 && host != null && host.length() > 0 && maintVer != null && maintVer.length() > 0 && language != null && language.length() > 0 && property != null && property.length() > 0 && value != null && (maintSection = DeployAPI.getMaintSection("INSTALL/" + host + "/" + product + "/" + version + "/maintenance", maintVer, true)) != null && (retVal = DeployAPI.setValue(MACHINE, maintSection + "/languages/" + language, property, value)) && !DeployAPI.containsInstallView(product, version, host, currentView)) {
            retVal = DeployAPI.addInstallView(product, version, host);
        }
        return retVal;
    }

    private static String getMaintProperty(String product, String version, String host, String maintVer, String property) {
        String maintSection;
        String retVal = null;
        if (product != null && product.length() > 0 && version != null && version.length() > 0 && host != null && host.length() > 0 && maintVer != null && maintVer.length() > 0 && property != null && property.length() > 0 && DeployAPI.containsInstallView(product, version, host, currentView) && (maintSection = DeployAPI.getMaintSection("INSTALL/" + host + "/" + product + "/" + version + "/maintenance", maintVer, false)) != null) {
            retVal = DeployAPI.getValue(MACHINE, maintSection, property);
        }
        return retVal;
    }

    private static String getMaintProperty(String product, String version, String host, String maintVer, String language, String property) {
        String maintSection;
        String retVal = null;
        if (product != null && product.length() > 0 && version != null && version.length() > 0 && host != null && host.length() > 0 && maintVer != null && maintVer.length() > 0 && language != null && language.length() > 0 && property != null && property.length() > 0 && DeployAPI.containsInstallView(product, version, host, currentView) && (maintSection = DeployAPI.getMaintSection("INSTALL/" + host + "/" + product + "/" + version + "/maintenance", maintVer, false)) != null) {
            retVal = DeployAPI.getValue(MACHINE, maintSection + "/languages/" + language, property);
        }
        return retVal;
    }

    private static String getMaintIndex(String root, String version, boolean create) {
        String maintIndex = null;
        if (root != null && version != null && version.length() > 0) {
            for (int i = 1; i > 0 && maintIndex == null; ++i) {
                String currentVersion = DeployAPI.getValue(MACHINE, root + "/" + i, MAINT_ID);
                if (currentVersion == null) {
                    if (create) {
                        maintIndex = "" + i;
                        if (DeployAPI.setValue(MACHINE, root + "/" + maintIndex, MAINT_ID, version)) {
                            DeployAPI.setValue(MACHINE, root, LAST_MAINT, maintIndex);
                            continue;
                        }
                        maintIndex = null;
                        continue;
                    }
                    i = -1;
                    continue;
                }
                if (!version.equals(currentVersion)) continue;
                maintIndex = "" + i;
            }
        }
        return maintIndex;
    }

    private static String getMaintSection(String root, String version, boolean create) {
        String maintSection = null;
        String maintIndex = DeployAPI.getMaintIndex(root, version, create);
        if (maintIndex != null) {
            maintSection = root + "/" + maintIndex;
        }
        return maintSection;
    }

    public static boolean openView(String view) {
        if (view == null || view.length() == 0 || view.indexOf(" ") >= 0) {
            return false;
        }
        if (Registry.open()) {
            currentView = view;
            return true;
        }
        return false;
    }

    public static boolean openView(String view, String registryRoot) {
        if (view == null || view.length() == 0 || view.indexOf(" ") >= 0) {
            return false;
        }
        if (Registry.open(registryRoot)) {
            currentView = view;
            return true;
        }
        return false;
    }

    public static boolean open() {
        return DeployAPI.openView("9.4");
    }

    public static boolean open(String registryRoot) {
        return DeployAPI.openView("9.4", registryRoot);
    }

    public static boolean close() {
        if (Registry.close()) {
            currentView = null;
            return true;
        }
        return false;
    }

    public static boolean closeReadOnly() {
        if (Registry.closeReadOnly()) {
            currentView = null;
            return true;
        }
        return false;
    }

    public static String[] getMaintLanguages(String product, String version, String maintVer, String host) {
        String[] retVal = new String[]{};
        if (DeployAPI.containsInstallView(product, version, host, currentView)) {
            retVal = DeployAPI.enumKey(MACHINE, DeployAPI.getMaintSection("INSTALL/" + host + "/" + product + "/" + version + "/maintenance", maintVer, false) + "/languages");
        }
        return retVal;
    }

    private static boolean setConfigProperty(String configDir, String property, String value) {
        String configSection;
        boolean retVal = false;
        if (configDir != null && configDir.length() > 0 && property != null && property.length() > 0 && value != null && (configSection = DeployAPI.getConfigSection(CONFIG, configDir, "*", true)) != null && DeployAPI.containsView(configSection, currentView)) {
            retVal = DeployAPI.setValue(MACHINE, configSection, property, value);
        }
        return retVal;
    }

    private static String getConfigProperty(String configDir, String property) {
        String configSection;
        String retVal = null;
        if (configDir != null && configDir.length() > 0 && property != null && property.length() > 0 && (configSection = DeployAPI.getConfigSection(CONFIG, configDir, currentView, false)) != null) {
            retVal = DeployAPI.getValue(MACHINE, configSection, property);
        }
        return retVal;
    }

    private static String getConfigSection(String root, String configDir, String view, boolean create) {
        String[] keys;
        String configSection = null;
        if (root != null && configDir != null && configDir.length() > 0 && (keys = DeployAPI.enumKey(MACHINE, root)) != null) {
            int i;
            File directory = new File(configDir);
            Pattern pattern = Pattern.compile("^Configuration(\\d{3})$");
            Hashtable<Integer, String> numHash = new Hashtable<Integer, String>();
            for (i = 0; configSection == null && i < keys.length; ++i) {
                Matcher matcher = pattern.matcher(keys[i]);
                if (!matcher.find()) continue;
                if (directory.equals(new File(DeployAPI.getValue(MACHINE, root + "/" + keys[i], LOCATION)))) {
                    configSection = root + "/" + keys[i];
                    continue;
                }
                if (!create) continue;
                numHash.put(Integer.valueOf(matcher.group(1)), "");
            }
            if (configSection != null) {
                if (!DeployAPI.containsView(configSection, view)) {
                    configSection = null;
                }
            } else if (create) {
                for (i = 1; configSection == null && i < 1000; ++i) {
                    if (numHash.containsKey(new Integer(i))) continue;
                    configSection = root + "/" + CONFIG_SECTION + new DecimalFormat("000").format(i);
                    if (DeployAPI.setValue(MACHINE, configSection, LOCATION, configDir)) {
                        if (DeployAPI.addView(configSection, currentView)) continue;
                        configSection = null;
                        continue;
                    }
                    configSection = null;
                }
            }
        }
        return configSection;
    }

    public static boolean setSASHome(String sashome) {
        return DeployAPI.setCommonProperty(SASHOME, sashome);
    }

    public static String getSASHome() {
        return DeployAPI.getCommonProperty(SASHOME);
    }

    public static boolean setInstallUser(String user) {
        return DeployAPI.setCommonProperty(INSTALL_USER, user);
    }

    public static String getInstallUser() {
        return DeployAPI.getCommonProperty(INSTALL_USER);
    }

    public static boolean addMajorRelease(String release) {
        boolean retVal = false;
        if (release != null) {
            String releases = DeployAPI.getCommonProperty(MAJOR_RELEASES);
            boolean found = false;
            if (releases == null) {
                releases = "";
            } else {
                String token = null;
                StringTokenizer tokens = new StringTokenizer(releases);
                while (!found && tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    if (!release.equalsIgnoreCase(token)) continue;
                    found = true;
                }
            }
            if (!found) {
                retVal = releases.length() == 0 ? DeployAPI.setCommonProperty(MAJOR_RELEASES, release) : DeployAPI.setCommonProperty(MAJOR_RELEASES, releases + " " + release);
            }
        }
        return retVal;
    }

    public static boolean removeMajorRelease(String release) {
        boolean retVal = false;
        String releases = DeployAPI.getCommonProperty(MAJOR_RELEASES);
        if (release != null && releases != null) {
            boolean found = false;
            String token = null;
            StringTokenizer tokens = new StringTokenizer(releases);
            releases = "";
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (release.equalsIgnoreCase(token)) {
                    found = true;
                    continue;
                }
                if (releases.length() == 0) {
                    releases = token;
                    continue;
                }
                releases = releases + " " + token;
            }
            if (found) {
                retVal = DeployAPI.setCommonProperty(MAJOR_RELEASES, releases);
            }
        }
        return retVal;
    }

    public static String[] getMajorReleases() {
        String[] retVal = new String[]{};
        String releases = DeployAPI.getCommonProperty(MAJOR_RELEASES);
        if (releases != null) {
            StringTokenizer tokens = new StringTokenizer(releases);
            retVal = new String[tokens.countTokens()];
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = tokens.nextToken();
            }
        }
        return retVal;
    }

    public static boolean setSashomeLocaleName(String mvaPosixName) {
        return DeployAPI.setCommonProperty(SASHOME_LOCALE_NAME, mvaPosixName);
    }

    public static String getSashomeLocaleName() {
        return DeployAPI.getCommonProperty(SASHOME_LOCALE_NAME);
    }

    public static boolean setSashomeEncodingName(String encodingName) {
        return DeployAPI.setCommonProperty(SASHOME_ENCODING_NAME, encodingName);
    }

    public static String getSashomeEncodingName() {
        return DeployAPI.getCommonProperty(SASHOME_ENCODING_NAME);
    }

    public static boolean setSashomeEncodingJavaName(String encodingJavaName) {
        return DeployAPI.setCommonProperty(SASHOME_ENCODING_JAVA_NAME, encodingJavaName);
    }

    public static String getSashomeEncodingJavaName() {
        return DeployAPI.getCommonProperty(SASHOME_ENCODING_JAVA_NAME);
    }

    public static boolean setSashomeEncodingIbmName(String encodingIbmName) {
        return DeployAPI.setCommonProperty(SASHOME_ZOS_ENCODING_IBM_NAME, encodingIbmName);
    }

    public static String getSashomeEncodingIbmName() {
        return DeployAPI.getCommonProperty(SASHOME_ZOS_ENCODING_IBM_NAME);
    }

    public static boolean setSashomeEncodingType(String encodingType) {
        return DeployAPI.setCommonProperty(SASHOME_ZOS_ENCODING_TYPE, encodingType);
    }

    public static String getSashomeEncodingType() {
        return DeployAPI.getCommonProperty(SASHOME_ZOS_ENCODING_TYPE);
    }

    public static boolean setSashomeEncodingTwoByte(String encodingTwoByte) {
        return DeployAPI.setCommonProperty(SASHOME_ZOS_ENCODING_TWO_BYTE, encodingTwoByte);
    }

    public static String getSashomeEncodingTwoByte() {
        return DeployAPI.getCommonProperty(SASHOME_ZOS_ENCODING_TWO_BYTE);
    }

    public static boolean setLastOrder(String order) {
        return DeployAPI.setCommonProperty(LAST_ORDER, order);
    }

    public static String getLastOrder() {
        return DeployAPI.getCommonProperty(LAST_ORDER);
    }

    public static boolean updateInstallTime(String product, String version, String host) {
        return DeployAPI.setInstallProperty(product, version, host, TIMESTAMP, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
    }

    public static boolean updateInstallTime(String product, String version) {
        return DeployAPI.updateInstallTime(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static String getInstallTime(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, TIMESTAMP);
    }

    public static String getInstallTime(String product, String version) {
        return DeployAPI.getInstallTime(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallOrderNum(String product, String version, String host, String order) {
        return DeployAPI.setInstallProperty(product, version, host, ORDER, order);
    }

    public static boolean setInstallOrderNum(String product, String version, String order) {
        return DeployAPI.setInstallOrderNum(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), order);
    }

    public static String getInstallOrderNum(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, ORDER);
    }

    public static String getInstallOrderNum(String product, String version) {
        return DeployAPI.getInstallOrderNum(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallSetnumid(String product, String version, String host, String setnumid) {
        return DeployAPI.setInstallProperty(product, version, host, SETNUMID, setnumid);
    }

    public static boolean setInstallSetnumid(String product, String version, String setnumid) {
        return DeployAPI.setInstallSetnumid(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), setnumid);
    }

    public static String getInstallSetnumid(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, SETNUMID);
    }

    public static String getInstallSetnumid(String product, String version) {
        return DeployAPI.getInstallSetnumid(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean addInstallLanguage(String product, String version, String host, String lang) {
        boolean retVal = false;
        if (lang != null) {
            String languages = DeployAPI.getInstallProperty(product, version, host, "*", LANGUAGES);
            boolean found = false;
            if (languages == null) {
                languages = "";
            } else {
                String token = null;
                StringTokenizer tokens = new StringTokenizer(languages);
                while (!found && tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    if (!lang.equalsIgnoreCase(token)) continue;
                    found = true;
                }
            }
            retVal = found ? DeployAPI.addInstallView(product, version, host) : (languages.length() == 0 ? DeployAPI.setInstallProperty(product, version, host, LANGUAGES, lang.toLowerCase(Locale.ENGLISH)) : DeployAPI.setInstallProperty(product, version, host, LANGUAGES, languages + " " + lang.toLowerCase(Locale.ENGLISH)));
        }
        return retVal;
    }

    public static boolean addInstallLanguage(String product, String version, String lang) {
        return DeployAPI.addInstallLanguage(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), lang);
    }

    public static boolean removeInstallLanguage(String product, String version, String host, String lang) {
        boolean retVal = false;
        String languages = DeployAPI.getInstallProperty(product, version, host, currentView, LANGUAGES);
        if (lang != null && languages != null) {
            boolean found = false;
            String token = null;
            StringTokenizer tokens = new StringTokenizer(languages);
            languages = "";
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (lang.equalsIgnoreCase(token)) {
                    found = true;
                    continue;
                }
                if (languages.length() == 0) {
                    languages = token;
                    continue;
                }
                languages = languages + " " + token;
            }
            if (found) {
                retVal = DeployAPI.setInstallProperty(product, version, host, LANGUAGES, languages);
            }
        }
        return retVal;
    }

    public static boolean removeInstallLanguage(String product, String version, String lang) {
        return DeployAPI.removeInstallLanguage(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), lang);
    }

    public static String[] getInstallLanguages(String product, String version, String host) {
        String[] retVal = new String[]{};
        String languages = DeployAPI.getInstallProperty(product, version, host, currentView, LANGUAGES);
        if (languages != null) {
            StringTokenizer tokens = new StringTokenizer(languages);
            retVal = new String[tokens.countTokens()];
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = tokens.nextToken();
            }
        }
        return retVal;
    }

    public static String[] getInstallLanguages(String product, String version) {
        return DeployAPI.getInstallLanguages(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallDisplayName(String product, String version, String host, String name) {
        return DeployAPI.setInstallProperty(product, version, host, DISPLAYNAME, name);
    }

    public static boolean setInstallDisplayName(String product, String version, String name) {
        return DeployAPI.setInstallDisplayName(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), name);
    }

    public static String getInstallDisplayName(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, DISPLAYNAME);
    }

    public static String getInstallDisplayName(String product, String version) {
        return DeployAPI.getInstallDisplayName(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallFamily(String product, String version, String host, String name) {
        return DeployAPI.setInstallProperty(product, version, host, FAMILY, name);
    }

    public static boolean setInstallFamily(String product, String version, String name) {
        return DeployAPI.setInstallFamily(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), name);
    }

    public static String getInstallFamily(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, FAMILY);
    }

    public static String getInstallFamily(String product, String version) {
        return DeployAPI.getInstallFamily(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallLoc(String product, String version, String host, String path) {
        return DeployAPI.setInstallProperty(product, version, host, LOCATION, path);
    }

    public static boolean setInstallLoc(String product, String version, String path) {
        return DeployAPI.setInstallLoc(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), path);
    }

    public static String getInstallLoc(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, LOCATION);
    }

    public static String getInstallLoc(String product, String version) {
        return DeployAPI.getInstallLoc(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallKeyFile(String product, String version, String host, String keyFile) {
        return DeployAPI.setInstallProperty(product, version, host, KEYFILE, keyFile);
    }

    public static boolean setInstallKeyFile(String product, String version, String keyFile) {
        return DeployAPI.setInstallKeyFile(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), keyFile);
    }

    public static String getInstallKeyFile(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, KEYFILE);
    }

    public static String getInstallKeyFile(String product, String version) {
        return DeployAPI.getInstallKeyFile(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallLogFile(String product, String version, String host, String logFile) {
        return DeployAPI.setInstallProperty(product, version, host, LOGFILE, logFile);
    }

    public static boolean setInstallLogFile(String product, String version, String logFile) {
        return DeployAPI.setInstallLogFile(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), logFile);
    }

    public static String getInstallLogFile(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, LOGFILE);
    }

    public static String getInstallLogFile(String product, String version) {
        return DeployAPI.getInstallLogFile(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallGUID(String product, String version, String host, String guid) {
        return DeployAPI.setInstallProperty(product, version, host, GUID, guid);
    }

    public static boolean setInstallGUID(String product, String version, String guid) {
        return DeployAPI.setInstallGUID(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), guid);
    }

    public static String getInstallGUID(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, GUID);
    }

    public static String getInstallGUID(String product, String version) {
        return DeployAPI.getInstallGUID(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallStatus(String product, String version, String host, String status) {
        return DeployAPI.setInstallProperty(product, version, host, STATUS, status);
    }

    public static boolean setInstallStatus(String product, String version, String status) {
        return DeployAPI.setInstallStatus(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), status);
    }

    public static boolean setInstallStatus(String product, String version, String host, String status, String dlgMsg, String logMsg) {
        boolean retVal = true;
        retVal &= DeployAPI.setInstallStatus(product, version, host, status);
        retVal &= DeployAPI.setInstallProperty(product, version, host, STATUS_DLGMSG, dlgMsg);
        return retVal &= DeployAPI.setInstallProperty(product, version, host, STATUS_LOGMSG, logMsg);
    }

    public static boolean setInstallStatus(String product, String version, String status, String dlgMsg, String logMsg) {
        return DeployAPI.setInstallStatus(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), status, dlgMsg, logMsg);
    }

    public static String getInstallStatus(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, STATUS);
    }

    public static String getInstallStatus(String product, String version) {
        return DeployAPI.getInstallStatus(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static String getInstallStatusDlgMsg(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, STATUS_DLGMSG);
    }

    public static String getInstallStatusDlgMsg(String product, String version) {
        return DeployAPI.getInstallStatusDlgMsg(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static String getInstallStatusLogMsg(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, STATUS_LOGMSG);
    }

    public static String getInstallStatusLogMsg(String product, String version) {
        return DeployAPI.getInstallStatusLogMsg(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallLastPortDate(String product, String version, String host, String date) {
        return DeployAPI.setInstallProperty(product, version, host, LAST_PORT_DATE, date);
    }

    public static boolean setInstallLastPortDate(String product, String version, String date) {
        return DeployAPI.setInstallLastPortDate(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), date);
    }

    public static String getInstallLastPortDate(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, LAST_PORT_DATE);
    }

    public static String getInstallLastPortDate(String product, String version) {
        return DeployAPI.getInstallLastPortDate(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallServicePack(String product, String version, String host, String servicePack) {
        return DeployAPI.setInstallProperty(product, version, host, SERVICE_PACK, servicePack);
    }

    public static boolean setInstallServicePack(String product, String version, String servicePack) {
        return DeployAPI.setInstallServicePack(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), servicePack);
    }

    public static String getInstallServicePack(String product, String version, String host) {
        return DeployAPI.getInstallProperty(product, version, host, currentView, SERVICE_PACK);
    }

    public static String getInstallServicePack(String product, String version) {
        return DeployAPI.getInstallServicePack(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setInstallVJRConsumer(String product, String version, String host, Boolean consumer) {
        return DeployAPI.setInstallProperty(product, version, host, VJR_CONSUMER, consumer != false ? "true" : "false");
    }

    public static boolean setInstallVJRConsumer(String product, String version, Boolean consumer) {
        return DeployAPI.setInstallVJRConsumer(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), consumer);
    }

    public static boolean setInstallVJRConsumer(String product, String version, String host, String consumer) {
        boolean retVal = true;
        retVal = "true".equalsIgnoreCase(consumer) ? DeployAPI.setInstallVJRConsumer(product, version, host, Boolean.TRUE) : ("false".equalsIgnoreCase(consumer) ? DeployAPI.setInstallVJRConsumer(product, version, host, Boolean.FALSE) : false);
        return retVal;
    }

    public static boolean setInstallVJRConsumer(String product, String version, String consumer) {
        return DeployAPI.setInstallVJRConsumer(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), consumer);
    }

    public static boolean getInstallVJRConsumer(String product, String version, String host) {
        return "true".equalsIgnoreCase(DeployAPI.getInstallProperty(product, version, host, currentView, VJR_CONSUMER));
    }

    public static boolean getInstallVJRConsumer(String product, String version) {
        return DeployAPI.getInstallVJRConsumer(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean removeInstall(String product, String version, String host) {
        boolean retVal = false;
        if (DeployAPI.containsInstallView(product, version, host, currentView) && (retVal = DeployAPI.deleteKey(MACHINE, "INSTALL/" + host + "/" + product + "/" + version)) && DeployAPI.enumKey(MACHINE, "INSTALL/" + host + "/" + product).length == 0 && DeployAPI.enumValue(MACHINE, "INSTALL/" + host + "/" + product).length == 0) {
            retVal = DeployAPI.deleteKey(MACHINE, "INSTALL/" + host + "/" + product);
        }
        return retVal;
    }

    public static boolean removeInstall(String product, String version) {
        return DeployAPI.removeInstall(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static String[] getInstallHosts() {
        String[] keys = DeployAPI.enumKey(MACHINE, INSTALL);
        if (keys == null) {
            return null;
        }
        Vector<String> hosts = new Vector<String>();
        for (int i = 0; i < keys.length; ++i) {
            if (DeployAPI.getInstallCodes(keys[i]).length <= 0) continue;
            hosts.add(keys[i]);
        }
        return hosts.toArray(new String[0]);
    }

    public static String[] getInstallCodes(String host) {
        String[] keys = DeployAPI.enumKey(MACHINE, "INSTALL/" + host);
        if (keys == null) {
            return null;
        }
        Vector<String> products = new Vector<String>();
        for (int i = 0; i < keys.length; ++i) {
            if (DeployAPI.getInstallVersions(keys[i], host).length <= 0) continue;
            products.add(keys[i]);
        }
        return products.toArray(new String[0]);
    }

    public static String[] getInstallCodes() {
        return DeployAPI.getInstallCodes(DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static String[] getInstallVersions(String product, String host) {
        String[] keys = DeployAPI.enumKey(MACHINE, "INSTALL/" + host + "/" + product);
        if (keys == null) {
            return null;
        }
        Vector<String> versions = new Vector<String>();
        for (int i = 0; i < keys.length; ++i) {
            if (!DeployAPI.containsInstallView(product, keys[i], host, currentView)) continue;
            versions.add(keys[i]);
        }
        return versions.toArray(new String[0]);
    }

    public static String[] getInstallVersions(String product) {
        return DeployAPI.getInstallVersions(product, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setMaintLevel(String product, String version, String host, String maintVer) {
        String maintIndex;
        boolean retVal = false;
        if (product != null && product.length() > 0 && version != null && version.length() > 0 && host != null && host.length() > 0 && maintVer != null && (maintIndex = DeployAPI.getMaintIndex("INSTALL/" + host + "/" + product + "/" + version + "/maintenance", maintVer, false)) != null && (retVal = DeployAPI.setValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance", MAINT_LEVEL, maintIndex)) && !DeployAPI.containsInstallView(product, version, host, currentView)) {
            retVal = DeployAPI.addInstallView(product, version, host);
        }
        return retVal;
    }

    public static boolean setMaintLevel(String product, String version, String maintVer) {
        return DeployAPI.setMaintLevel(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), maintVer);
    }

    public static String getMaintLevel(String product, String version, String host) {
        String maintIndex;
        String maintLevel = null;
        if (DeployAPI.containsInstallView(product, version, host, currentView) && (maintIndex = DeployAPI.getValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance", MAINT_LEVEL)) != null) {
            maintLevel = DeployAPI.getValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance/" + maintIndex, MAINT_ID);
        }
        return maintLevel;
    }

    public static String getMaintLevel(String product, String version) {
        return DeployAPI.getMaintLevel(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setMaintUninstallLoc(String product, String version, String host, String maintVer, String path) {
        return DeployAPI.setMaintProperty(product, version, host, maintVer, UNINSTALL_LOC, path);
    }

    public static boolean setMaintUninstallLoc(String product, String version, String maintVer, String path) {
        return DeployAPI.setMaintUninstallLoc(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), maintVer, path);
    }

    public static boolean setMaintUninstallLoc(String product, String version, String host, String maintVer, String language, String path) {
        return DeployAPI.setMaintProperty(product, version, host, maintVer, language, UNINSTALL_LOC, path);
    }

    public static String getMaintUninstallLoc(String product, String version, String host, String maintVer) {
        return DeployAPI.getMaintProperty(product, version, host, maintVer, UNINSTALL_LOC);
    }

    public static String getMaintUninstallLoc(String product, String version, String host, String maintVer, String language) {
        return DeployAPI.getMaintProperty(product, version, host, maintVer, language, UNINSTALL_LOC);
    }

    public static String getMaintUninstallLoc(String product, String version, String maintVer) {
        return DeployAPI.getMaintUninstallLoc(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), maintVer);
    }

    public static boolean setMaintDisplayName(String product, String version, String host, String maintVer, String name) {
        return DeployAPI.setMaintProperty(product, version, host, maintVer, DISPLAYNAME, name);
    }

    public static boolean setMaintDisplayName(String product, String version, String maintVer, String name) {
        return DeployAPI.setMaintDisplayName(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), maintVer, name);
    }

    public static String getMaintDisplayName(String product, String version, String host, String maintVer) {
        return DeployAPI.getMaintProperty(product, version, host, maintVer, DISPLAYNAME);
    }

    public static String getMaintDisplayName(String product, String version, String maintVer) {
        return DeployAPI.getMaintDisplayName(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), maintVer);
    }

    public static String getMaintLastApplied(String product, String version, String host) {
        String maintIndex;
        String lastMaint = null;
        if (DeployAPI.containsInstallView(product, version, host, currentView) && (maintIndex = DeployAPI.getValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance", LAST_MAINT)) != null) {
            lastMaint = DeployAPI.getValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance/" + maintIndex, MAINT_ID);
        }
        return lastMaint;
    }

    public static String getMaintLastApplied(String product, String version) {
        return DeployAPI.getMaintLastApplied(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean removeMaint(String product, String version, String host, String maintVer) {
        boolean retVal = false;
        if (maintVer != null && DeployAPI.containsInstallView(product, version, host, currentView) && maintVer.equals(DeployAPI.getMaintLastApplied(product, version, host))) {
            String maintIndex = DeployAPI.getMaintIndex("INSTALL/" + host + "/" + product + "/" + version + "/maintenance", maintVer, false);
            String maintSection = DeployAPI.getMaintSection("INSTALL/" + host + "/" + product + "/" + version + "/maintenance", maintVer, false);
            String maintLevel = DeployAPI.getMaintLevel(product, version, host);
            if (maintIndex != null && maintSection != null && DeployAPI.deleteKey(MACHINE, maintSection) && (retVal = (maintIndex = "" + (Integer.parseInt(maintIndex) - 1)).equals("0") ? DeployAPI.deleteValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance", LAST_MAINT) : DeployAPI.setValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance", LAST_MAINT, maintIndex)) && maintLevel != null && maintLevel.equals(maintVer)) {
                retVal = DeployAPI.deleteValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance", MAINT_LEVEL);
            }
            if (retVal && DeployAPI.enumKey(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance").length == 0 && DeployAPI.enumValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance").length == 0) {
                retVal = DeployAPI.deleteKey(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance");
            }
        }
        return retVal;
    }

    public static boolean removeMaint(String product, String version, String maintVer) {
        return DeployAPI.removeMaint(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"), maintVer);
    }

    public static String[] getMaintVersions(String product, String version, String host) {
        String lastMaint;
        String[] retVal = new String[]{};
        if (product != null && product.length() > 0 && version != null && version.length() > 0 && host != null && host.length() > 0 && DeployAPI.containsInstallView(product, version, host, currentView) && (lastMaint = DeployAPI.getValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance", LAST_MAINT)) != null) {
            int count = Integer.parseInt(lastMaint);
            retVal = new String[count];
            for (int i = 1; i <= count; ++i) {
                retVal[i - 1] = DeployAPI.getValue(MACHINE, "INSTALL/" + host + "/" + product + "/" + version + "/maintenance/" + i, MAINT_ID);
            }
        }
        return retVal;
    }

    public static String[] getMaintVersions(String product, String version) {
        return DeployAPI.getMaintVersions(product, version, DeployAPI.getProperty(openRegistryRoot, "default.host", "default"));
    }

    public static boolean setConfigLoc(String configDir, String path) {
        boolean retVal = false;
        if (configDir != null && path != null && (DeployAPI.getConfigLoc(configDir) != null || new File(configDir).equals(new File(path))) && DeployAPI.getConfigLoc(path) == null) {
            retVal = DeployAPI.setConfigProperty(configDir, LOCATION, path);
        }
        return retVal;
    }

    public static String getConfigLoc(String configDir) {
        return DeployAPI.getConfigProperty(configDir, LOCATION);
    }

    public static boolean setConfigOrderNum(String configDir, String order) {
        return DeployAPI.setConfigProperty(configDir, ORDER, order);
    }

    public static String getConfigOrderNum(String configDir) {
        return DeployAPI.getConfigProperty(configDir, ORDER);
    }

    public static boolean setConfigPlanFile(String configDir, String planFile) {
        return DeployAPI.setConfigProperty(configDir, PLAN, planFile);
    }

    public static String getConfigPlanFile(String configDir) {
        return DeployAPI.getConfigProperty(configDir, PLAN);
    }

    public static boolean setConfigPropFile(String configDir, String propFile) {
        return DeployAPI.setConfigProperty(configDir, PROPERTIES, propFile);
    }

    public static String getConfigPropFile(String configDir) {
        return DeployAPI.getConfigProperty(configDir, PROPERTIES);
    }

    public static boolean removeConfig(String configDir) {
        String configSection;
        boolean removed = false;
        if (configDir != null && configDir.length() > 0 && (configSection = DeployAPI.getConfigSection(CONFIG, configDir, currentView, false)) != null) {
            removed = DeployAPI.deleteKey(MACHINE, configSection);
        }
        return removed;
    }

    public static String[] getConfigLocs() {
        Vector<String> directories = new Vector<String>();
        String[] keys = DeployAPI.enumKey(MACHINE, CONFIG);
        if (keys != null) {
            Pattern pattern = Pattern.compile("^Configuration(\\d{3})$");
            for (int i = 0; i < keys.length; ++i) {
                if (!pattern.matcher(keys[i]).matches() || !DeployAPI.containsView("CONFIG/" + keys[i], currentView)) continue;
                directories.add(DeployAPI.getValue(MACHINE, "CONFIG/" + keys[i], LOCATION));
            }
        }
        return directories.toArray(new String[0]);
    }

    private static boolean addView(String key, String view) {
        boolean retVal = false;
        if ("*".equals(view)) {
            retVal = true;
        } else if (view != null) {
            String views = DeployAPI.getValue(MACHINE, key, VIEWS);
            boolean found = false;
            if (views == null) {
                views = "";
            } else {
                String token = null;
                StringTokenizer tokens = new StringTokenizer(views);
                while (!found && tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    if (!view.equals(token)) continue;
                    found = true;
                }
            }
            if (!found) {
                retVal = views.length() == 0 ? DeployAPI.setValue(MACHINE, key, VIEWS, view) : DeployAPI.setValue(MACHINE, key, VIEWS, views + " " + view);
            }
        }
        return retVal;
    }

    public static boolean addInstallView(String product, String version, String host) {
        return DeployAPI.addView("INSTALL/" + host + "/" + product + "/" + version, currentView);
    }

    private static boolean removeView(String key, String view) {
        boolean retVal = false;
        if ("*".equals(view)) {
            retVal = true;
        } else {
            String views = DeployAPI.getValue(MACHINE, key, VIEWS);
            if (view != null && views != null) {
                boolean found = false;
                String token = null;
                StringTokenizer tokens = new StringTokenizer(views);
                views = "";
                while (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    if (view.equals(token)) {
                        found = true;
                        continue;
                    }
                    if (views.length() == 0) {
                        views = token;
                        continue;
                    }
                    views = views + " " + token;
                }
                if (found) {
                    retVal = DeployAPI.setValue(MACHINE, key, VIEWS, views);
                }
            }
        }
        return retVal;
    }

    public static boolean removeInstallView(String product, String version, String host) {
        return DeployAPI.removeView("INSTALL/" + host + "/" + product + "/" + version, currentView);
    }

    public static String[] getInstallViews(String product, String version, String host) {
        String[] retVal = new String[]{};
        String views = DeployAPI.getInstallProperty(product, version, host, currentView, VIEWS);
        if (views != null) {
            StringTokenizer tokens = new StringTokenizer(views);
            retVal = new String[tokens.countTokens()];
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = tokens.nextToken();
            }
        }
        return retVal;
    }

    private static boolean containsInstallView(String product, String version, String host, String view) {
        return DeployAPI.containsView("INSTALL/" + host + "/" + product + "/" + version, view);
    }

    private static boolean containsView(String key, String view) {
        boolean retVal = false;
        if ("*".equals(view)) {
            retVal = true;
        } else {
            String views = DeployAPI.getValue(MACHINE, key, VIEWS);
            if (views != null) {
                String token = null;
                StringTokenizer tokens = new StringTokenizer(views);
                while (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    if (!view.equals(token)) continue;
                    retVal = true;
                }
            }
        }
        return retVal;
    }
}

