/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.calculateditems;

import com.sas.dataselectors.calculateditems.BaseCalculatedObjectFactory;
import com.sas.dataselectors.filters.DefaultFilterValue;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.swing.dataselectors.editors.EditorInterface;
import com.sas.swing.visuals.dataselectors.calculateditems.AdvancedCalculatedItemEditorInterface;
import com.sas.swing.visuals.dataselectors.calculateditems.AdvancedExpressionEditDialog;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;

public class BaseEditorAdapter
implements EditorInterface {
    protected String docsetId = null;
    protected BusinessModel _businessModel = null;
    protected ResourceScope _resourceScope = ResourceScope.BUSINESS_SCOPE;
    protected int _expressionType = 0;
    protected Object _expressionObject = null;
    protected ExpressionInterface _expression = null;
    protected AdvancedCalculatedItemEditorInterface _editDialog = null;
    protected FilterValueInterface _returnValue = null;
    protected boolean _userSetMaxOutputObservations = false;
    protected int _maxMaxOutputObservations = -1;

    public BaseEditorAdapter(BusinessModel businessModel, String docsetId) {
        this._businessModel = businessModel;
        this.docsetId = docsetId;
        this._resourceScope = BaseEditorAdapter.findScope(businessModel, null);
    }

    static ResourceScope findScope(BusinessModel businessModel, ExpressionInterface expression) {
        ResourceScope scope = ResourceScope.BUSINESS_SCOPE;
        if (expression instanceof ResourceAwareStringExpression) {
            scope = ((ResourceAwareStringExpression)expression).getResourceScope();
        } else if (businessModel != null) {
            scope = businessModel instanceof BusinessQuery ? ResourceScope.BUSINESS_SCOPE : ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE;
        }
        return scope;
    }

    public void setExpression(Object expressionObject) {
        if (expressionObject instanceof FilterValueInterface) {
            FilterValueInterface fvi = (FilterValueInterface)expressionObject;
            Object data = fvi.getData();
            Object unformatted = fvi.getUnformattedValue();
            if (data instanceof ExpressionInterface) {
                expressionObject = data;
            } else if (unformatted instanceof ExpressionInterface) {
                expressionObject = unformatted;
            } else if (data != null) {
                expressionObject = data;
            } else if (unformatted != null) {
                expressionObject = unformatted;
            }
        }
        this._expressionObject = expressionObject;
        ExpressionInterface expression = null;
        if (expressionObject instanceof ExpressionInterface) {
            expression = (ExpressionInterface)expressionObject;
            this._resourceScope = BaseEditorAdapter.findScope(this._businessModel, expression);
        } else {
            this._resourceScope = BaseEditorAdapter.findScope(this._businessModel, null);
            String text = expressionObject == null ? "" : expressionObject.toString();
            int type = this._expressionType;
            expression = this.newExpression(text, type);
        }
        this._expression = expression;
    }

    public Object getExpression() {
        if (this._returnValue == null) {
            this._returnValue = this.wrapperResult(this._expression);
        }
        return this._returnValue;
    }

    public void setExpressionType(int type) {
        if (type != this._expressionType) {
            this._expressionType = type;
            if (!(this._expressionObject instanceof ExpressionInterface)) {
                this.setExpression(this._expressionObject);
            }
        }
    }

    public int getExpressionType() {
        return this._expressionType;
    }

    public void showEditor(Object userData) {
        Frame parent = null;
        if (userData instanceof Frame) {
            parent = (Frame)userData;
        } else if (userData instanceof Component) {
            parent = Util.getParentFrame((Component)((Component)userData));
        } else {
            return;
        }
        this._returnValue = null;
        this._editDialog = this.newAdvancedCalculatedItemEditorInterface(parent);
        if (this._editDialog instanceof Window) {
            this.layoutDialog(parent);
            ((Window)this._editDialog).setVisible(true);
        }
    }

    protected void layoutDialog(Frame parent) {
        if (this._userSetMaxOutputObservations) {
            this._editDialog.setMaxOutputObservations(this.getMaxOutputObservations());
        }
        ((Window)this._editDialog).pack();
        if (parent.isVisible()) {
            Util.centerOverWindow((Window)((Window)this._editDialog), (Component)parent);
        }
    }

    public boolean isEditOK() {
        boolean success;
        if (this._editDialog == null) {
            return false;
        }
        int rc = this._editDialog.getReturnValue();
        boolean bl = success = rc == 1;
        if (success) {
            this._expression = this.getExpressionFromDialog();
            this._returnValue = null;
        }
        return success;
    }

    private ExpressionInterface newExpression(String text, int type) {
        ExpressionInterface expression = null;
        try {
            expression = StringExpressionUtil.getInstance().newExpression(this._businessModel, text, type, this._resourceScope);
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return expression;
    }

    private FilterValueInterface wrapperResult(ExpressionInterface expression) {
        if (expression == null) {
            return null;
        }
        ExpressionInterface value = expression;
        ExpressionInterface unformattedValue = expression;
        int dataType = expression.getExpressionType();
        String formattedValue = null;
        try {
            formattedValue = expression instanceof ResourceAwareStringExpression ? StringExpressionUtil.getInstance().getText(expression, ResourceScope.BUSINESS_SCOPE, null) : StringExpressionUtil.getInstance().getReadableText(expression);
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        Object format = null;
        DefaultFilterValue fvi = new DefaultFilterValue((Object)value, formattedValue, dataType, format, (Object)unformattedValue);
        return fvi;
    }

    protected AdvancedCalculatedItemEditorInterface newAdvancedCalculatedItemEditorInterface(Frame parent) {
        return new AdvancedExpressionEditDialog(parent, true, this._expression, this._businessModel, this.docsetId);
    }

    protected ExpressionInterface getExpressionFromDialog() {
        return ((AdvancedExpressionEditDialog)this._editDialog).getExpression();
    }

    public int getMaxOutputObservations() {
        if (!this._userSetMaxOutputObservations) {
            return BaseCalculatedObjectFactory.DEFAULT_GOVERNING_LIMIT;
        }
        return this._maxMaxOutputObservations;
    }

    public void setMaxOutputObservations(int max) {
        this._maxMaxOutputObservations = max;
        this._userSetMaxOutputObservations = true;
    }
}

