/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.dataselectors.filterandrank.FilterAndRankModel;
import com.sas.dataselectors.filterandrank.RankOrderEnum;
import com.sas.dataselectors.filterandrank.RankTypeEnum;
import com.sas.dataselectors.filters.BaseAdvancedFilterObjectFactory;
import com.sas.dataselectors.filters.BaseFilterObjectFactory;
import com.sas.dataselectors.filters.BusinessQueryToAdvancedFilterModelAdapter;
import com.sas.dataselectors.filters.DefaultFilterItem;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.dataselectors.filters.FilterValueFormatter;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.dataselectors.filters.Util;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterValueFormatter;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeFilterUtil;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.convenience.ByGroupCreator;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesFactory;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberPropertiesFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFirstLastPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNParallelPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.business.step.relational.DataItemRankFilter;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression_Between;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MemberLevelComparator;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.swing.models.DataItemRoleProvider;
import com.sas.swing.models.RB;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import com.sas.util.Strings;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AppliedFiltersUtil {
    public static final String RB_KEY = "AppliedFiltersUtil.";
    private static StringExpressionUtil expressionUtil = StringExpressionUtil.getInstance();
    private static final String START_SPAN_BEGIN = "XAF_#$%$#";
    private static final String START_SPAN_END = "XAF_!!789";
    private static final String END_SPAN = "XAF_$$**";
    private static final String NBSPACE = "XAF_%@$x$*";
    public static final String OLAPFILTERS_BUSINESSQUERY_STEPS_ONLY = "olapFiltersBusinessQueryStepsOnly";
    public static final String OLAPFILTERS_IGNORE_BUSINESSQUERY_STEPS = "olapFiltersIgnoreBusinessQuerySteps";
    public static final String OLAPFILTERS_ALL = "olapFiltersAll";
    public static final String CONDITION_FORMAT_SYMBOL = "CONDITION_FORMAT_SYMBOL";
    public static final String CONDITION_FORMAT_TEXT = "CONDITION_FORMAT_TEXT";
    public static final String CONDITION_FORMAT_SYMBOL_NO_LABEL = "CONDITION_FORMAT_SYMBOL_NO_LABEL";
    public static final String CONDITION_FORMAT_TEXT_NO_LABEL = "CONDITION_FORMAT_TEXT_NO_LABEL";
    public static final String IS_EQUALS = "IS_EQUALS";
    public static final String IS_NOT_EQUALS = "IS_NOT_EQUALS";
    public static final String IS_IN_LIST = "IS_IN_LIST";
    public static final String IS_NOT_IN_LIST = "IS_NOT_IN_LIST";
    public static final String IS_LESS_THAN = "IS_LESS_THAN";
    public static final String IS_LESS_THAN_OR_EQUAL = "IS_LESS_THAN_OR_EQUAL";
    public static final String IS_GREATER_THAN = "IS_GREATER_THAN";
    public static final String IS_GREATER_THAN_OR_EQUAL = "IS_GREATER_THAN_OR_EQUAL";
    public static final String IS_BEFORE = "IS_BEFORE";
    public static final String IS_BEFORE_OR_EQUAL = "IS_BEFORE_OR_EQUAL";
    public static final String IS_AFTER = "IS_AFTER";
    public static final String IS_AFTER_OR_EQUAL = "IS_AFTER_OR_EQUAL";
    public static final String IS_BETWEEN = "IS_BETWEEN";
    public static final String IS_NOT_BETWEEN = "IS_NOT_BETWEEN";
    public static final String IS_NULL = "IS_NULL";
    public static final String IS_NOT_NULL = "IS_NOT_NULL";
    public static final String IS_MISSING_VALUE = "IS_MISSING_VALUE";
    public static final String IS_NOT_MISSING_VALUE = "IS_NOT_MISSING_VALUE";
    public static final String CONTAINS = "CONTAINS";
    public static final String DOES_NOT_CONTAIN = "DOES_NOT_CONTAIN";
    public static final String LIKE = "LIKE";
    public static final String NOT_LIKE = "NOT_LIKE";
    public static final String IS_IN_LIST_OR_EQUAL_TO = "IS_IN_LIST_OR_EQUAL_TO";
    public static final String IS_NOT_IN_LIST_OR_EQUAL_TO = "IS_NOT_IN_LIST_OR_EQUAL_TO";
    public static final String OLAP_EQUAL_TO = "OLAP_EQUAL_TO";
    public static final String OLAP_IS_NOT_EQUAL_TO = "OLAP_IS_NOT_EQUAL_TO";
    public static final String RANK_WITH_TIES = "RANK_WITH_TIES";
    public static final String RANK_WITHOUT_TIES = "RANK_WITHOUT_TIES";
    public static final String RANK_SUM_WITH_TIES = "RANK_SUM_WITH_TIES";
    public static final String RANK_SUM_WITHOUT_TIES = "RANK_SUM_WITHOUT_TIES";
    public static final String ROW_COLUMN_FILTER = "ROW_COLUMN_FILTER";
    public static final String STEP_FILTER = "STEP_FILTER";
    public static final String FILTER_TEXT_SPAN = "Filter_Text_Span";
    public static final String LOGICAL_OPERATOR_SPAN = "Logical_Operator_Span";
    public static final String FILTER_LABEL_SPAN = "Filter_Label_Span";
    public static final String TIME_LAST_PERIODS_RELATIVE_FILTER = "Time_Last_Periods_Relative_Filter";
    public static final String TIME_FIRST_PERIODS_RELATIVE_FILTER = "Time_First_Periods_Relative_Filter";
    public static final String TIME_LAST_PERIODS_FILTER = "Time_Last_Periods_Filter";
    public static final String TIME_FIRST_PERIODS_FILTER = "Time_First_Periods_Filter";
    public static final String TIME_PARALLEL_PERIODS_ABSOLUTE_TO_ABSOLUTE_FILTER = "Time_Parallel_Periods_Asolute_To_Absolute_Filter";
    public static final String TIME_PARALLEL_PERIODS_RELATIVE_TO_RELATIVE_FILTER = "Time_Parallel_Periods_Relative_To_Relative_Filter";
    public static final String TIME_PARALLEL_PERIODS_RELATIVE_TO_ABSOLUTE_FILTER = "Time_Parallel_Periods_Relative_To_Absolute_Filter";
    public static final String TIME_PARALLEL_PERIODS_ABSOLUTE_TO_RELATIVE_FILTER = "Time_Parallel_Periods_Asolute_To_Relative_Filter";
    public static final String TIME_RANGE_ABSOLUTE_TO_ABSOLUTE_FILTER = "Time_Range_Absolute_To_Absolute_Filter";
    public static final String TIME_RANGE_RELATIVE_TO_RELATIVE_FILTER = "Time_Range_Relative_To_Relative_Filter";
    public static final String TIME_RANGE_RELATIVE_TO_ABSOLUTE_FILTER = "Time_Range_Relative_To_Absolute_Filter";
    public static final String TIME_RANGE_ABSOLUTE_TO_RELATIVE_FILTER = "Time_Range_Absolute_To_Relative_Filter";
    public static final String OUTPUT_TYPE = "outputType";
    public static final String OUTPUT_TYPE_HTML = "outputTypeHTML";
    public static final String OUTPUT_TYPE_TEXT = "outputTypeTEXT";
    public static final String PROMPT_FORMAT = "PromptFormat";

    private static Map getConditionSymbolFormats(Locale locale) {
        HashMap<String, String> conditionSymbolMap = new HashMap<String, String>();
        conditionSymbolMap.put(IS_EQUALS, RB.getStringResource((String)RB_KEY, (String)"IS_EQUALS.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_EQUALS, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_EQUALS.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_IN_LIST, RB.getStringResource((String)RB_KEY, (String)"IS_IN_LIST.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_IN_LIST, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_IN_LIST.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_LESS_THAN, RB.getStringResource((String)RB_KEY, (String)"IS_LESS_THAN.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_LESS_THAN_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_LESS_THAN_OR_EQUAL.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_GREATER_THAN, RB.getStringResource((String)RB_KEY, (String)"IS_GREATER_THAN.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_GREATER_THAN_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_GREATER_THAN_OR_EQUAL.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_BETWEEN, RB.getStringResource((String)RB_KEY, (String)"IS_BETWEEN.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_BETWEEN, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_BETWEEN.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NULL, RB.getStringResource((String)RB_KEY, (String)"IS_NULL.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_NULL, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_NULL.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_MISSING_VALUE, RB.getStringResource((String)RB_KEY, (String)"IS_MISSING_VALUE.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_MISSING_VALUE, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_MISSING_VALUE.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(CONTAINS, RB.getStringResource((String)RB_KEY, (String)"CONTAINS.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(DOES_NOT_CONTAIN, RB.getStringResource((String)RB_KEY, (String)"DOES_NOT_CONTAIN.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(LIKE, RB.getStringResource((String)RB_KEY, (String)"LIKE.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(NOT_LIKE, RB.getStringResource((String)RB_KEY, (String)"NOT_LIKE.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_IN_LIST_OR_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"IS_IN_LIST_OR_EQUAL_TO.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_IN_LIST_OR_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_IN_LIST_OR_EQUAL_TO.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(OLAP_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"OLAP_EQUAL_TO.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(OLAP_IS_NOT_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"OLAP_IS_NOT_EQUAL_TO.SymbolFormat.txt", (Locale)locale));
        conditionSymbolMap.put(ROW_COLUMN_FILTER, RB.getStringResource((String)RB_KEY, (String)"ROW_COLUMN_FILTER.fmt.txt", (Locale)locale));
        conditionSymbolMap.put(STEP_FILTER, RB.getStringResource((String)RB_KEY, (String)"STEP_FILTER.fmt.txt", (Locale)locale));
        conditionSymbolMap.put(RANK_WITH_TIES, com.sas.dataselectors.filterandrank.RB.getStringResource((String)"FilterAndRankModel.", (String)"rankWithTiesFormat.txt.fmt", (Locale)locale));
        conditionSymbolMap.put(RANK_WITHOUT_TIES, com.sas.dataselectors.filterandrank.RB.getStringResource((String)"FilterAndRankModel.", (String)"rankWithoutTiesFormat.txt.fmt", (Locale)locale));
        conditionSymbolMap.put(RANK_SUM_WITH_TIES, com.sas.dataselectors.filterandrank.RB.getStringResource((String)"FilterAndRankModel.", (String)"rankSumWithTiesFormat.txt.fmt", (Locale)locale));
        conditionSymbolMap.put(RANK_SUM_WITHOUT_TIES, com.sas.dataselectors.filterandrank.RB.getStringResource((String)"FilterAndRankModel.", (String)"rankSumWithoutTiesFormat.txt.fmt", (Locale)locale));
        conditionSymbolMap.put(IS_BEFORE, com.sas.dataselectors.filters.RB.getStringResource((String)"DefaultFilterCondition.", (String)"IS_BEFORE.fmt.txt", (Locale)locale));
        conditionSymbolMap.put(IS_BEFORE_OR_EQUAL, com.sas.dataselectors.filters.RB.getStringResource((String)"DefaultFilterCondition.", (String)"IS_BEFORE_OR_EQUAL.fmt.txt", (Locale)locale));
        conditionSymbolMap.put(IS_AFTER, com.sas.dataselectors.filters.RB.getStringResource((String)"DefaultFilterCondition.", (String)"IS_AFTER.fmt.txt", (Locale)locale));
        conditionSymbolMap.put(IS_AFTER_OR_EQUAL, com.sas.dataselectors.filters.RB.getStringResource((String)"DefaultFilterCondition.", (String)"IS_AFTER_OR_EQUAL.fmt.txt", (Locale)locale));
        conditionSymbolMap.put(PROMPT_FORMAT, RB.getStringResource((String)RB_KEY, (String)"PROMPT_VALUES.fmt.txt", (Locale)locale));
        return conditionSymbolMap;
    }

    private static Map getConditionSymbolFormatsNoLabel(Locale locale) {
        HashMap<String, String> conditionSymbolMap = new HashMap<String, String>();
        conditionSymbolMap.put(IS_EQUALS, RB.getStringResource((String)RB_KEY, (String)"IS_EQUALS.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_EQUALS, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_EQUALS.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_IN_LIST, RB.getStringResource((String)RB_KEY, (String)"IS_IN_LIST.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_IN_LIST, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_IN_LIST.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_LESS_THAN, RB.getStringResource((String)RB_KEY, (String)"IS_LESS_THAN.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_LESS_THAN_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_LESS_THAN_OR_EQUAL.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_GREATER_THAN, RB.getStringResource((String)RB_KEY, (String)"IS_GREATER_THAN.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_GREATER_THAN_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_GREATER_THAN_OR_EQUAL.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_BETWEEN, RB.getStringResource((String)RB_KEY, (String)"IS_BETWEEN.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_BETWEEN, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_BETWEEN.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NULL, RB.getStringResource((String)RB_KEY, (String)"IS_NULL.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_NULL, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_NULL.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_MISSING_VALUE, RB.getStringResource((String)RB_KEY, (String)"IS_MISSING_VALUE.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_MISSING_VALUE, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_MISSING_VALUE.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(CONTAINS, RB.getStringResource((String)RB_KEY, (String)"CONTAINS.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(DOES_NOT_CONTAIN, RB.getStringResource((String)RB_KEY, (String)"DOES_NOT_CONTAIN.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(LIKE, RB.getStringResource((String)RB_KEY, (String)"LIKE.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(NOT_LIKE, RB.getStringResource((String)RB_KEY, (String)"NOT_LIKE.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_IN_LIST_OR_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"IS_IN_LIST_OR_EQUAL_TO.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(IS_NOT_IN_LIST_OR_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_IN_LIST_OR_EQUAL_TO.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(OLAP_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"OLAP_EQUAL_TO.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(OLAP_IS_NOT_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"OLAP_IS_NOT_EQUAL_TO.SymbolFormat_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(ROW_COLUMN_FILTER, RB.getStringResource((String)RB_KEY, (String)"ROW_COLUMN_FILTER.fmt_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(STEP_FILTER, RB.getStringResource((String)RB_KEY, (String)"STEP_FILTER.fmt_NoLabel.txt", (Locale)locale));
        conditionSymbolMap.put(RANK_WITH_TIES, RB.getStringResource((String)RB_KEY, (String)"rankWithTiesFormat_NoLabel.txt.fmt", (Locale)locale));
        conditionSymbolMap.put(RANK_WITHOUT_TIES, RB.getStringResource((String)RB_KEY, (String)"rankWithoutTiesFormat_NoLabel.txt.fmt", (Locale)locale));
        conditionSymbolMap.put(RANK_SUM_WITH_TIES, RB.getStringResource((String)RB_KEY, (String)"rankSumWithTiesFormat_NoLabel.txt.fmt", (Locale)locale));
        conditionSymbolMap.put(RANK_SUM_WITHOUT_TIES, RB.getStringResource((String)RB_KEY, (String)"rankSumWithoutTiesFormat_NoLabel.txt.fmt", (Locale)locale));
        conditionSymbolMap.put(IS_BEFORE, RB.getStringResource((String)RB_KEY, (String)"IS_BEFORE_NoLabel.fmt.txt", (Locale)locale));
        conditionSymbolMap.put(IS_BEFORE_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_BEFORE_OR_EQUAL_NoLabel.fmt.txt", (Locale)locale));
        conditionSymbolMap.put(IS_AFTER, RB.getStringResource((String)RB_KEY, (String)"IS_AFTER_NoLabel.fmt.txt", (Locale)locale));
        conditionSymbolMap.put(IS_AFTER_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_AFTER_OR_EQUAL_NoLabel.fmt.txt", (Locale)locale));
        conditionSymbolMap.put(PROMPT_FORMAT, RB.getStringResource((String)RB_KEY, (String)"PROMPT_VALUES.fmt.txt", (Locale)locale));
        return conditionSymbolMap;
    }

    private static Map getConditionTextFormats(Locale locale) {
        HashMap<String, String> conditionTextMap = new HashMap<String, String>();
        conditionTextMap.put(IS_EQUALS, RB.getStringResource((String)RB_KEY, (String)"IS_EQUALS.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_EQUALS, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_EQUALS.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_IN_LIST, RB.getStringResource((String)RB_KEY, (String)"IS_IN_LIST.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_IN_LIST, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_IN_LIST.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_LESS_THAN, RB.getStringResource((String)RB_KEY, (String)"IS_LESS_THAN.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_LESS_THAN_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_LESS_THAN_OR_EQUAL.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_GREATER_THAN, RB.getStringResource((String)RB_KEY, (String)"IS_GREATER_THAN.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_GREATER_THAN_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_GREATER_THAN_OR_EQUAL.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_BETWEEN, RB.getStringResource((String)RB_KEY, (String)"IS_BETWEEN.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_BETWEEN, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_BETWEEN.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_NULL, RB.getStringResource((String)RB_KEY, (String)"IS_NULL.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_NULL, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_NULL.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_MISSING_VALUE, RB.getStringResource((String)RB_KEY, (String)"IS_MISSING_VALUE.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_MISSING_VALUE, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_MISSING_VALUE.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(CONTAINS, RB.getStringResource((String)RB_KEY, (String)"CONTAINS.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(DOES_NOT_CONTAIN, RB.getStringResource((String)RB_KEY, (String)"DOES_NOT_CONTAIN.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(LIKE, RB.getStringResource((String)RB_KEY, (String)"LIKE.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(NOT_LIKE, RB.getStringResource((String)RB_KEY, (String)"NOT_LIKE.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_IN_LIST_OR_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"IS_IN_LIST_OR_EQUAL_TO.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_IN_LIST_OR_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_IN_LIST_OR_EQUAL_TO.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(OLAP_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"OLAP_EQUAL_TO.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(OLAP_IS_NOT_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"OLAP_IS_NOT_EQUAL_TO.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(ROW_COLUMN_FILTER, RB.getStringResource((String)RB_KEY, (String)"ROW_COLUMN_FILTER.fmt.txt", (Locale)locale));
        conditionTextMap.put(STEP_FILTER, RB.getStringResource((String)RB_KEY, (String)"STEP_FILTER.fmt.txt", (Locale)locale));
        conditionTextMap.put(RANK_WITH_TIES, com.sas.dataselectors.filterandrank.RB.getStringResource((String)"FilterAndRankModel.", (String)"rankWithTiesFormat.txt.fmt", (Locale)locale));
        conditionTextMap.put(RANK_WITHOUT_TIES, com.sas.dataselectors.filterandrank.RB.getStringResource((String)"FilterAndRankModel.", (String)"rankWithoutTiesFormat.txt.fmt", (Locale)locale));
        conditionTextMap.put(RANK_SUM_WITH_TIES, com.sas.dataselectors.filterandrank.RB.getStringResource((String)"FilterAndRankModel.", (String)"rankSumWithTiesFormat.txt.fmt", (Locale)locale));
        conditionTextMap.put(RANK_SUM_WITHOUT_TIES, com.sas.dataselectors.filterandrank.RB.getStringResource((String)"FilterAndRankModel.", (String)"rankSumWithoutTiesFormat.txt.fmt", (Locale)locale));
        conditionTextMap.put(IS_BEFORE, com.sas.dataselectors.filters.RB.getStringResource((String)"DefaultFilterCondition.", (String)"IS_BEFORE.fmt.txt", (Locale)locale));
        conditionTextMap.put(IS_BEFORE_OR_EQUAL, com.sas.dataselectors.filters.RB.getStringResource((String)"DefaultFilterCondition.", (String)"IS_BEFORE_OR_EQUAL.fmt.txt", (Locale)locale));
        conditionTextMap.put(IS_AFTER, com.sas.dataselectors.filters.RB.getStringResource((String)"DefaultFilterCondition.", (String)"IS_AFTER.fmt.txt", (Locale)locale));
        conditionTextMap.put(IS_AFTER_OR_EQUAL, com.sas.dataselectors.filters.RB.getStringResource((String)"DefaultFilterCondition.", (String)"IS_AFTER_OR_EQUAL.fmt.txt", (Locale)locale));
        conditionTextMap.put(PROMPT_FORMAT, RB.getStringResource((String)RB_KEY, (String)"PROMPT_VALUES.fmt.txt", (Locale)locale));
        return conditionTextMap;
    }

    private static Map getConditionTextFormatsNoLabel(Locale locale) {
        HashMap<String, String> conditionTextMap = new HashMap<String, String>();
        conditionTextMap.put(IS_EQUALS, RB.getStringResource((String)RB_KEY, (String)"IS_EQUALS.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_EQUALS, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_EQUALS.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_IN_LIST, RB.getStringResource((String)RB_KEY, (String)"IS_IN_LIST.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_IN_LIST, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_IN_LIST.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_LESS_THAN, RB.getStringResource((String)RB_KEY, (String)"IS_LESS_THAN.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_LESS_THAN_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_LESS_THAN_OR_EQUAL.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_GREATER_THAN, RB.getStringResource((String)RB_KEY, (String)"IS_GREATER_THAN.TextFormat.txt", (Locale)locale));
        conditionTextMap.put(IS_GREATER_THAN_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_GREATER_THAN_OR_EQUAL.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_BETWEEN, RB.getStringResource((String)RB_KEY, (String)"IS_BETWEEN.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_BETWEEN, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_BETWEEN.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_NULL, RB.getStringResource((String)RB_KEY, (String)"IS_NULL.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_NULL, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_NULL.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_MISSING_VALUE, RB.getStringResource((String)RB_KEY, (String)"IS_MISSING_VALUE.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_MISSING_VALUE, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_MISSING_VALUE.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(CONTAINS, RB.getStringResource((String)RB_KEY, (String)"CONTAINS.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(DOES_NOT_CONTAIN, RB.getStringResource((String)RB_KEY, (String)"DOES_NOT_CONTAIN.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(LIKE, RB.getStringResource((String)RB_KEY, (String)"LIKE.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(NOT_LIKE, RB.getStringResource((String)RB_KEY, (String)"NOT_LIKE.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_IN_LIST_OR_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"IS_IN_LIST_OR_EQUAL_TO.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(IS_NOT_IN_LIST_OR_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"IS_NOT_IN_LIST_OR_EQUAL_TO.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(OLAP_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"OLAP_EQUAL_TO.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(OLAP_IS_NOT_EQUAL_TO, RB.getStringResource((String)RB_KEY, (String)"OLAP_IS_NOT_EQUAL_TO.TextFormat_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(ROW_COLUMN_FILTER, RB.getStringResource((String)RB_KEY, (String)"ROW_COLUMN_FILTER.fmt_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(STEP_FILTER, RB.getStringResource((String)RB_KEY, (String)"STEP_FILTER.fmt_NoLabel.txt", (Locale)locale));
        conditionTextMap.put(RANK_WITH_TIES, RB.getStringResource((String)RB_KEY, (String)"rankWithTiesFormat_NoLabel.txt.fmt", (Locale)locale));
        conditionTextMap.put(RANK_WITHOUT_TIES, RB.getStringResource((String)RB_KEY, (String)"rankWithoutTiesFormat_NoLabel.txt.fmt", (Locale)locale));
        conditionTextMap.put(RANK_SUM_WITH_TIES, RB.getStringResource((String)RB_KEY, (String)"rankSumWithTiesFormat_NoLabel.txt.fmt", (Locale)locale));
        conditionTextMap.put(RANK_SUM_WITHOUT_TIES, RB.getStringResource((String)RB_KEY, (String)"rankSumWithoutTiesFormat_NoLabel.txt.fmt", (Locale)locale));
        conditionTextMap.put(IS_BEFORE, RB.getStringResource((String)RB_KEY, (String)"IS_BEFORE_NoLabel.fmt.txt", (Locale)locale));
        conditionTextMap.put(IS_BEFORE_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_BEFORE_OR_EQUAL_NoLabel.fmt.txt", (Locale)locale));
        conditionTextMap.put(IS_AFTER, RB.getStringResource((String)RB_KEY, (String)"IS_AFTER_NoLabel.fmt.txt", (Locale)locale));
        conditionTextMap.put(IS_AFTER_OR_EQUAL, RB.getStringResource((String)RB_KEY, (String)"IS_AFTER_OR_EQUAL_NoLabel.fmt.txt", (Locale)locale));
        conditionTextMap.put(PROMPT_FORMAT, RB.getStringResource((String)RB_KEY, (String)"PROMPT_VALUES.fmt.txt", (Locale)locale));
        return conditionTextMap;
    }

    public static Map getFormatMap(Locale locale, String conditionFormatType, String outputType) {
        HashMap<String, String> formatMap = new HashMap<String, String>();
        formatMap.put(TIME_FIRST_PERIODS_FILTER, RB.getStringResource((String)RB_KEY, (String)"TIME_FIRST_PERIODS_FILTER.fmt.txt", (Locale)locale));
        formatMap.put(TIME_FIRST_PERIODS_RELATIVE_FILTER, RB.getStringResource((String)RB_KEY, (String)"TIME_FIRST_PERIODS_RELATIVE_FILTER.fmt.txt", (Locale)locale));
        formatMap.put(TIME_LAST_PERIODS_FILTER, RB.getStringResource((String)RB_KEY, (String)"TIME_LAST_PERIODS_FILTER.fmt.txt", (Locale)locale));
        formatMap.put(TIME_LAST_PERIODS_RELATIVE_FILTER, RB.getStringResource((String)RB_KEY, (String)"TIME_LAST_PERIODS_RELATIVE_FILTER.fmt.txt", (Locale)locale));
        formatMap.put(TIME_RANGE_ABSOLUTE_TO_ABSOLUTE_FILTER, RB.getStringResource((String)RB_KEY, (String)"TIME_RANGE_ABSOLUTE_TO_ABSOLUTE_FILTER.fmt.txt", (Locale)locale));
        formatMap.put(TIME_RANGE_ABSOLUTE_TO_RELATIVE_FILTER, RB.getStringResource((String)RB_KEY, (String)"TIME_RANGE_ABSOLUTE_TO_RELATIVE_FILTER.fmt.txt", (Locale)locale));
        formatMap.put(TIME_RANGE_RELATIVE_TO_ABSOLUTE_FILTER, RB.getStringResource((String)RB_KEY, (String)"TIME_RANGE_RELATIVE_TO_ABSOLUTE_FILTER.fmt.txt", (Locale)locale));
        formatMap.put(TIME_RANGE_RELATIVE_TO_RELATIVE_FILTER, RB.getStringResource((String)RB_KEY, (String)"TIME_RANGE_RELATIVE_TO_RELATIVE_FILTER.fmt.txt", (Locale)locale));
        if (conditionFormatType == CONDITION_FORMAT_TEXT) {
            formatMap.putAll(AppliedFiltersUtil.getConditionTextFormats(locale));
        } else if (conditionFormatType == CONDITION_FORMAT_SYMBOL) {
            formatMap.putAll(AppliedFiltersUtil.getConditionSymbolFormats(locale));
        }
        if (conditionFormatType == CONDITION_FORMAT_TEXT_NO_LABEL) {
            formatMap.putAll(AppliedFiltersUtil.getConditionTextFormatsNoLabel(locale));
        } else if (conditionFormatType == CONDITION_FORMAT_SYMBOL_NO_LABEL) {
            formatMap.putAll(AppliedFiltersUtil.getConditionSymbolFormatsNoLabel(locale));
        }
        formatMap.put(OUTPUT_TYPE, outputType);
        return formatMap;
    }

    public static Map getFormatMap(Locale locale, String conditionFormatType) {
        return AppliedFiltersUtil.getFormatMap(locale, conditionFormatType, OUTPUT_TYPE_TEXT);
    }

    public static List getAppliedFilters(Object model) {
        return AppliedFiltersUtil.getAppliedFilters(model, Locale.getDefault(), true);
    }

    public static List getAppliedFilters(Object model, Locale locale, boolean wrapText) {
        return AppliedFiltersUtil.getAppliedFilters(model, locale, wrapText, null, AppliedFiltersUtil.getFormatMap(locale, CONDITION_FORMAT_SYMBOL), null, ":");
    }

    public static List getAppliedFilters(Object model, Locale locale, boolean wrapText, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, String labelSeparator) {
        return AppliedFiltersUtil.getAppliedFilters(model, locale, wrapText, spanInfo, conditionFormatMap, relationalFilterValueFormatter, labelSeparator, 0);
    }

    public static List getAppliedFilters(Object model, Locale locale, boolean wrapText, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, String labelSeparator, int relationalOutputType) {
        return AppliedFiltersUtil.getAppliedFilters(model, null, locale, wrapText, spanInfo, conditionFormatMap, relationalFilterValueFormatter, labelSeparator, relationalOutputType);
    }

    public static List getAppliedFilters(Object model, DataItemRoleProvider dataItemRoleProvider, Locale locale, boolean wrapText, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, String labelSeparator, int relationalOutputType) {
        return AppliedFiltersUtil.getAppliedFilters(model, dataItemRoleProvider, locale, wrapText, spanInfo, conditionFormatMap, relationalFilterValueFormatter, labelSeparator, relationalOutputType, false);
    }

    public static List getAppliedFilters(Object model, DataItemRoleProvider dataItemRoleProvider, Locale locale, boolean wrapText, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, String labelSeparator, int relationalOutputType, boolean useUnfilteredMetadata) {
        return AppliedFiltersUtil.getAppliedFilters(model, false, dataItemRoleProvider, locale, wrapText, spanInfo, conditionFormatMap, relationalFilterValueFormatter, labelSeparator, relationalOutputType, useUnfilteredMetadata, true, true, OLAPFILTERS_ALL);
    }

    public static List getAppliedFilters(Object model, boolean treatAsAncestorQuery, DataItemRoleProvider dataItemRoleProvider, Locale locale, boolean wrapText, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, String labelSeparator, int relationalOutputType, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames, boolean displayHiddenOLAPFilterItems, String olapFilterOutputType) {
        List filters = null;
        if (model instanceof BusinessQueryProviderInterface) {
            BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            if (bq != null && bq.getBusinessModel() != null) {
                boolean olap = bq.getBusinessModel().getStructure().isOLAP();
                boolean rolap = false;
                try {
                    rolap = AppliedFiltersUtil.isROLAP(bq);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!olap && !rolap) {
                    List relFilters = AppliedFiltersUtil.getAppliedRelationalFilters(bq, locale, wrapText, spanInfo, conditionFormatMap, relationalFilterValueFormatter, relationalOutputType);
                    return (List)AppliedFiltersUtil.encodeFilterText(relFilters, conditionFormatMap);
                }
                if (rolap) {
                    filters = AppliedFiltersUtil.getAppliedOLAPFilters(bq, treatAsAncestorQuery, dataItemRoleProvider, locale, wrapText, spanInfo, conditionFormatMap, labelSeparator, rolap, relationalOutputType, useUnfilteredMetadata, fullyQualifyMemberNames, displayHiddenOLAPFilterItems, olapFilterOutputType);
                } else if (model instanceof OLAPDataSetInterface) {
                    filters = AppliedFiltersUtil.getAppliedOLAPFilters(model, treatAsAncestorQuery, dataItemRoleProvider, locale, wrapText, spanInfo, conditionFormatMap, labelSeparator, rolap, relationalOutputType, useUnfilteredMetadata, fullyQualifyMemberNames, displayHiddenOLAPFilterItems, olapFilterOutputType);
                }
            }
        } else if (model instanceof DataSelection) {
            DataSelection ds = (DataSelection)model;
            boolean olap = ds.getStructure().isOLAP();
            boolean rolap = false;
            try {
                rolap = AppliedFiltersUtil.isROLAP((BusinessQuery)ds);
            }
            catch (Exception exception) {
                // empty catch block
            }
            filters = !olap && !rolap ? AppliedFiltersUtil.getAppliedRelationalFilters((BusinessQuery)ds, locale, wrapText, spanInfo, conditionFormatMap, relationalFilterValueFormatter, relationalOutputType) : AppliedFiltersUtil.getAppliedOLAPFilters(ds, treatAsAncestorQuery, dataItemRoleProvider, locale, wrapText, spanInfo, conditionFormatMap, labelSeparator, rolap, relationalOutputType, useUnfilteredMetadata, fullyQualifyMemberNames, displayHiddenOLAPFilterItems, olapFilterOutputType);
        }
        if (filters == null) {
            filters = new ArrayList();
        }
        filters = (List)AppliedFiltersUtil.encodeFilterText(filters, conditionFormatMap);
        return filters;
    }

    public static String getFilterItemDescription(BusinessQuery bq, Map formatMap, Locale locale, FilterItem filterItem) {
        return AppliedFiltersUtil.getFilterItemDescription(bq, formatMap, locale, filterItem, false);
    }

    public static String getFilterItemDescription(BusinessQuery bq, Map formatMap, Locale locale, FilterItem filterItem, boolean useUnfilteredMetadata) {
        return AppliedFiltersUtil.getFilterItemDescription(bq, formatMap, locale, filterItem, useUnfilteredMetadata, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFilterItemDescription(BusinessQuery bq, Map formatMap, Locale locale, FilterItem filterItem, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        String description = "";
        MetadataInterface metadata = null;
        if (bq != null && bq.getBusinessModel() != null && filterItem != null) {
            boolean olap = bq.getBusinessModel().getStructure().isOLAP();
            boolean rolap = false;
            try {
                rolap = AppliedFiltersUtil.isROLAP(bq);
                if (!olap && !rolap) {
                    if (bq instanceof DataSelection) {
                        DataSelection ds = (DataSelection)bq;
                        DataSelection copy = ds.copy();
                        ArrayList<FilterItem> filters = new ArrayList<FilterItem>(1);
                        filters.add(filterItem);
                        copy.setFilters(filters);
                        FilterValueFormatter formatter = FilterValueFormatter.getInstance(locale);
                        Object promptFormat = formatMap.get(PROMPT_FORMAT);
                        if (promptFormat != null) {
                            formatter.setPromptFormatString(promptFormat.toString());
                        }
                        formatter.setBusinessQuery((BusinessQuery)copy);
                        List list = AppliedFiltersUtil.getRelationalFilterMap((BusinessQuery)copy, formatMap, formatter, 1, locale);
                        if (list != null && list.size() > 0) {
                            description = AppliedFiltersUtil.getFormattedExpressionString(list, 1, 0, list.size() - 1, null, true);
                        }
                    }
                } else if (rolap) {
                    ArrayList<FilterItem> filters = new ArrayList<FilterItem>(1);
                    filters.add(filterItem);
                    List output = AppliedFiltersUtil.processRolapBusinessQueryFilters(bq, filters, locale, formatMap, null, 1);
                    if (output != null && output.size() > 0 && output.get(0) != null) {
                        description = output.get(0).toString();
                    }
                } else if (bq instanceof DataSelection) {
                    String cubeName = "";
                    List dataSources = ((DataSelection)bq).getObjects(true, DataSourceCube.class);
                    if (dataSources.size() > 0) {
                        cubeName = ((DataSourceCube)dataSources.get(0)).getCube().getCubeName();
                    }
                    metadata = AppliedFiltersUtil.getMetadata(bq, useUnfilteredMetadata);
                    String expressionText = AppliedFiltersUtil.getTextForExpression(bq, cubeName, filterItem.getExpression(), metadata, locale, formatMap, 1, useUnfilteredMetadata, fullyQualifyMemberNames);
                    List dataItems = filterItem.getDataItems(1);
                    Iterator dataItemIter = dataItems.iterator();
                    DataItem dataItem = null;
                    while (dataItemIter.hasNext()) {
                        DataItem di = (DataItem)dataItemIter.next();
                        if (di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) continue;
                        dataItem = di;
                        break;
                    }
                    String dataItemLabel = dataItem != null ? dataItem.getLabel() : null;
                    description = AppliedFiltersUtil.addLabelTextToFilterText(expressionText, dataItemLabel, "", formatMap, null);
                }
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
            catch (IQueryServicesException e) {
                LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (metadata != null) {
                    BusinessQueryOLAPUtil.releaseMetadataInterface(metadata);
                }
            }
        }
        description = (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
        return description;
    }

    private static MetadataInterface getMetadata(BusinessQuery bq, boolean useUnfilteredModel) throws IQueryServicesException {
        if (bq != null) {
            if (useUnfilteredModel) {
                BusinessModel unfilteredModel = AppliedFiltersUtil.getUnfilteredBusinessModel(bq.getBusinessModel());
                return BusinessQueryOLAPUtil.getMetadataInterface((Object)unfilteredModel);
            }
            return BusinessQueryOLAPUtil.getMetadataInterface((Object)bq);
        }
        return null;
    }

    private static BusinessModel getUnfilteredBusinessModel(BusinessModel model) {
        while (model != null) {
            if (AppliedFiltersUtil.isNotFiltered(model)) {
                return model;
            }
            model = model.getParentBusinessModel();
        }
        return null;
    }

    private static boolean isNotFiltered(BusinessModel businessModel) {
        BusinessQuery query;
        List filters;
        return !(businessModel instanceof BusinessQuery) || (filters = (query = (BusinessQuery)businessModel).getEffectiveFilters()) == null || filters.isEmpty();
    }

    public static String getAxisFilterDescription(BusinessQuery bq, Map formatMap, Locale locale, Role role, StepInterface step) {
        return AppliedFiltersUtil.getAxisFilterDescription(bq, formatMap, locale, role, step, false);
    }

    public static String getAxisFilterDescription(BusinessQuery bq, Map formatMap, Locale locale, Role role, StepInterface step, boolean useUnfilteredMetadata) {
        return AppliedFiltersUtil.getAxisFilterDescription(bq, formatMap, locale, role, step, useUnfilteredMetadata, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAxisFilterDescription(BusinessQuery bq, Map formatMap, Locale locale, Role role, StepInterface step, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        String description = "";
        MetadataInterface metadata = null;
        if (!(bq instanceof DataSelection)) return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
        try {
            String cubeName = "";
            List dataSources = ((DataSelection)bq).getObjects(true, DataSourceCube.class);
            if (dataSources.size() > 0) {
                cubeName = ((DataSourceCube)dataSources.get(0)).getCube().getCubeName();
            }
            metadata = AppliedFiltersUtil.getMetadata(bq, useUnfilteredMetadata);
            description = AppliedFiltersUtil.getBusinessQueryStepFilterDescription(bq, cubeName, metadata, formatMap, locale, role, step, "", null, useUnfilteredMetadata, fullyQualifyMemberNames);
            if (metadata == null) return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            if (metadata == null) return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
            BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
            return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
        }
        catch (IQueryServicesException e2) {
            LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e2.getMessage(), (Throwable)e2);
            if (metadata == null) return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
            {
                catch (Throwable throwable) {
                    if (metadata == null) throw throwable;
                    BusinessQueryOLAPUtil.releaseMetadataInterface(metadata);
                    throw throwable;
                }
            }
            BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
            return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
        }
        BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
        return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
    }

    public static String getDataItemStepFilterDescription(BusinessQuery bq, Map formatMap, Locale locale, DataItem dataItem, StepInterface step) {
        return AppliedFiltersUtil.getDataItemStepFilterDescription(bq, formatMap, locale, dataItem, step, false);
    }

    public static String getDataItemStepFilterDescription(BusinessQuery bq, Map formatMap, Locale locale, DataItem dataItem, StepInterface step, boolean useUnfilteredMetadata) {
        return AppliedFiltersUtil.getDataItemStepFilterDescription(bq, formatMap, locale, dataItem, step, useUnfilteredMetadata, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getDataItemStepFilterDescription(BusinessQuery bq, Map formatMap, Locale locale, DataItem dataItem, StepInterface step, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        String description = "";
        MetadataInterface metadata = null;
        if (!(bq instanceof DataSelection)) return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
        try {
            String cubeName = "";
            List dataSources = ((DataSelection)bq).getObjects(true, DataSourceCube.class);
            if (dataSources.size() > 0) {
                cubeName = ((DataSourceCube)dataSources.get(0)).getCube().getCubeName();
            }
            metadata = AppliedFiltersUtil.getMetadata(bq, useUnfilteredMetadata);
            String stepText = AppliedFiltersUtil.getTextForStepUnencoded(bq, cubeName, step, metadata, locale, formatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
            String dataItemLabel = dataItem != null ? dataItem.getLabel() : null;
            description = AppliedFiltersUtil.addLabelTextToFilterText(stepText, dataItemLabel, "", formatMap, null);
            if (metadata == null) return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            if (metadata == null) return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
            BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
            return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
        }
        catch (IQueryServicesException e2) {
            LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), null).error(e2.getMessage(), (Throwable)e2);
            if (metadata == null) return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
            {
                catch (Throwable throwable) {
                    if (metadata == null) throw throwable;
                    BusinessQueryOLAPUtil.releaseMetadataInterface(metadata);
                    throw throwable;
                }
            }
            BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
            return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
        }
        BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
        return (String)AppliedFiltersUtil.encodeFilterText(description, formatMap);
    }

    private static String getTextForExpression(Object model, String cubeName, ExpressionInterface expression, MetadataInterface metadata, Locale locale, Map conditionFormatMap, int outputType, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        String text = null;
        if (expression instanceof MemberFilterExpression) {
            List members = ((MemberFilterExpression)expression).getMemberNames();
            text = AppliedFiltersUtil.getReadableTextForMembers(model, cubeName, members, metadata, locale, ", ", conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
            if (((MemberFilterExpression)expression).isNegated()) {
                String format = conditionFormatMap.get(OLAP_IS_NOT_EQUAL_TO).toString();
                text = Message.format((String)format, (Object)text);
            } else {
                String format = conditionFormatMap.get(OLAP_EQUAL_TO).toString();
                text = Message.format((String)format, (Object)text);
            }
        } else if (expression instanceof DataBasedFilterExpression) {
            String defaultFormat = RB.getStringResource((String)RB_KEY, (String)"textFormat.fmt.txt", (Locale)locale);
            String leftText = AppliedFiltersUtil.getReadableTextForMembers(model, cubeName, ((DataBasedFilterExpression)expression).getLeftExpression(), metadata, locale, ".", conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
            String rightText = AppliedFiltersUtil.getReadableText(((DataBasedFilterExpression)expression).getRightExpression(), locale);
            ComparisonOperator operator = ((DataBasedFilterExpression)expression).getComparisonOperator();
            String operatorText = ((DataBasedFilterExpression)expression).getComparisonOperator().toString();
            String format = AppliedFiltersUtil.getFormatForOperator(operator, conditionFormatMap);
            text = format != null ? Message.format((String)format, (Object)leftText, (Object)rightText) : Message.format((String)defaultFormat, (Object)leftText, (Object)operatorText, (Object)rightText);
        } else if (expression instanceof DataBasedFilterExpression_Between) {
            String format;
            String defaultFormat = RB.getStringResource((String)RB_KEY, (String)"textFormat.fmt.txt", (Locale)locale);
            String whatToFilterText = AppliedFiltersUtil.getReadableTextForMembers(model, cubeName, ((DataBasedFilterExpression_Between)expression).getWhatToCompare(), metadata, locale, ".", conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
            List lowerBoundExpressionList = ((DataBasedFilterExpression_Between)expression).getLowerBound();
            String lowerBoundExpressionText = AppliedFiltersUtil.getReadableText(((DataBasedFilterExpression_Between)expression).getLowerBound(), locale);
            String upperBoundExpressionText = AppliedFiltersUtil.getReadableText(((DataBasedFilterExpression_Between)expression).getUpperBound(), locale);
            String string = format = ((DataBasedFilterExpression_Between)expression).isNegated() ? conditionFormatMap.get(IS_NOT_BETWEEN).toString() : conditionFormatMap.get(IS_BETWEEN).toString();
            text = format != null ? Message.format((String)format, (Object)whatToFilterText, (Object)lowerBoundExpressionText, (Object)upperBoundExpressionText) : Message.format((String)defaultFormat, (Object)whatToFilterText, (Object)lowerBoundExpressionText, (Object)upperBoundExpressionText);
        } else if (expression instanceof TimeFilterNPeriodsExpression) {
            TimeFilterNPeriodsExpression timeFilter = (TimeFilterNPeriodsExpression)expression;
            int n = timeFilter.getnPeriods();
            String searchDirection = timeFilter.getSearchDirection();
            String dateMember = timeFilter.getDateMember();
            text = AppliedFiltersUtil.getOLAPTimeFilterNPeriodsText(model, cubeName, metadata, locale, conditionFormatMap, n, searchDirection, dateMember, useUnfilteredMetadata, fullyQualifyMemberNames);
        } else if (expression instanceof TimeFilterFirstLastPeriodsExpression) {
            TimeFilterFirstLastPeriodsExpression timeFilter = (TimeFilterFirstLastPeriodsExpression)expression;
            int n = timeFilter.getnPeriods();
            String searchDirection = timeFilter.getSearchDirection();
            String levelName = timeFilter.getLevelName();
            text = AppliedFiltersUtil.getOLAPTimeFilterFirstLastPeriodsText(model, cubeName, metadata, locale, conditionFormatMap, n, searchDirection, levelName, useUnfilteredMetadata, fullyQualifyMemberNames);
        } else if (!(expression instanceof TimeFilterNParallelPeriodsExpression) && expression instanceof TimeRangeFilterExpression) {
            TimeRangeFilterExpression timeFilter = (TimeRangeFilterExpression)expression;
            String startDateMember = timeFilter.getStartDateMember();
            String endDateMember = timeFilter.getEndDateMember();
            String levelName = timeFilter.getLevel();
            text = AppliedFiltersUtil.getOLAPTimeRangeFilterText(model, cubeName, metadata, locale, conditionFormatMap, startDateMember, endDateMember, levelName, useUnfilteredMetadata, fullyQualifyMemberNames);
        }
        return text;
    }

    public static String getTextForStep(Object model, String cubeName, StepInterface step, MetadataInterface metadata, Locale locale, Map conditionFormatMap) {
        return AppliedFiltersUtil.getTextForStep(model, cubeName, step, metadata, locale, conditionFormatMap, false);
    }

    public static String getTextForStep(Object model, String cubeName, StepInterface step, MetadataInterface metadata, Locale locale, Map conditionFormatMap, boolean useUnfilteredMetadata) {
        return AppliedFiltersUtil.getTextForStep(model, cubeName, step, metadata, locale, conditionFormatMap, useUnfilteredMetadata, true);
    }

    public static String getTextForStep(Object model, String cubeName, StepInterface step, MetadataInterface metadata, Locale locale, Map conditionFormatMap, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        String text = AppliedFiltersUtil.getTextForStepUnencoded(model, cubeName, step, metadata, locale, conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
        text = (String)AppliedFiltersUtil.encodeFilterText(text, conditionFormatMap);
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTextForStepUnencoded(Object model, String cubeName, StepInterface step, MetadataInterface metadata, Locale locale, Map conditionFormatMap, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        String text;
        block32: {
            text = null;
            boolean iqCreatedMetadata = false;
            try {
                if (step instanceof CompoundStep) {
                    List steps = ((CompoundStep)step).getSteps();
                    List stepConditions = ((CompoundStep)step).getStepsConditions();
                    int conditionSize = stepConditions.size();
                    int kSize = steps.size();
                    for (int k = 0; k < kSize; ++k) {
                        StepInterface cStep = (StepInterface)steps.get(k);
                        String newText = AppliedFiltersUtil.getTextForStepUnencoded(model, cubeName, cStep, metadata, locale, conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
                        if (newText == null) continue;
                        if (kSize > 1) {
                            newText = "(" + newText + ")";
                        }
                        text = text == null ? newText : text + newText;
                        if (conditionSize <= k) continue;
                        text = text + " " + stepConditions.get(k) + " ";
                    }
                    break block32;
                }
                if (step instanceof DataItemMemberFilter) {
                    List members = ((DataItemMemberFilter)step).getMemberNames();
                    text = AppliedFiltersUtil.getReadableTextForMembers(model, cubeName, members, metadata, locale, ", ", conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
                    if (((DataItemMemberFilter)step).isNegated()) {
                        String format = conditionFormatMap.get(OLAP_IS_NOT_EQUAL_TO).toString();
                        text = Message.format((String)format, (Object)text);
                    } else {
                        String format = conditionFormatMap.get(OLAP_EQUAL_TO).toString();
                        text = Message.format((String)format, (Object)text);
                    }
                    break block32;
                }
                if (step instanceof DataItemRankFilter) {
                    DataItemRankFilter filter = (DataItemRankFilter)step;
                    text = com.sas.swing.visuals.dataselectors.Util.getLocalizedRankStatus((String)(filter.getRankOrder() == 0 ? "T" : "B"), (int)filter.getValue(), (String)"C", (String)(filter.isIncludeTies() ? "1" : "0"), null, (Locale)locale);
                    break block32;
                }
                if (step instanceof com.sas.iquery.metadata.business.step.olap.DataItemRankFilter) {
                    text = AppliedFiltersUtil.getRankStepText(model, (com.sas.iquery.metadata.business.step.olap.DataItemRankFilter)step, locale, fullyQualifyMemberNames);
                    break block32;
                }
                if (step instanceof DataItemMemberPropertiesFilter) {
                    String propertyName = ((DataItemMemberPropertiesFilter)step).getmemberPropertyNameExpression();
                    Filter filter = new Filter();
                    filter.setPropertyName(propertyName);
                    filter.setCubeName(cubeName);
                    try {
                        if (metadata == null && model instanceof BusinessQuery) {
                            metadata = AppliedFiltersUtil.getMetadata((BusinessQuery)model, useUnfilteredMetadata);
                            iqCreatedMetadata = true;
                        }
                        String propertyLabel = "";
                        if (metadata != null) {
                            PropertyInterface[] properties = metadata.getProperties(filter);
                            propertyLabel = properties[0].getLabel();
                        }
                        String rightText = AppliedFiltersUtil.getReadableText(((DataItemMemberPropertiesFilter)step).getRightExpression(), locale);
                        ComparisonOperator operator = ((DataItemMemberPropertiesFilter)step).getOperator();
                        String operatorText = ((DataItemMemberPropertiesFilter)step).getOperator().toString();
                        String format = AppliedFiltersUtil.getFormatForOperator(operator, conditionFormatMap);
                        if (format != null) {
                            text = Message.format((String)format, (Object)propertyLabel, (Object)rightText);
                            break block32;
                        }
                        String defaultFormat = RB.getStringResource((String)RB_KEY, (String)"textFormat.fmt.txt", (Locale)locale);
                        text = Message.format((String)defaultFormat, (Object)propertyLabel, (Object)operatorText, (Object)rightText);
                    }
                    catch (OLAPException e) {
                        LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
                    }
                    catch (MetadataException e) {
                        LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
                    }
                    break block32;
                }
                if (step instanceof DataItemDataBasedFilter) {
                    String leftText = AppliedFiltersUtil.getReadableTextForMembers(model, cubeName, ((DataItemDataBasedFilter)step).getLeftExpression(), metadata, locale, ".", conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
                    String rightText = AppliedFiltersUtil.getFormattedDataValueFromExpression((DataItemDataBasedFilter)step, locale);
                    ComparisonOperator operator = ((DataItemDataBasedFilter)step).getOperator();
                    String operatorText = ((DataItemDataBasedFilter)step).getOperator().toString();
                    String format = AppliedFiltersUtil.getFormatForOperator(operator, conditionFormatMap);
                    if (format != null) {
                        text = Message.format((String)format, (Object)leftText, (Object)rightText);
                    } else {
                        String defaultFormat = RB.getStringResource((String)RB_KEY, (String)"textFormat.fmt.txt", (Locale)locale);
                        text = Message.format((String)defaultFormat, (Object)leftText, (Object)operatorText, (Object)rightText);
                    }
                } else if (step instanceof DataItemTimeNPeriodsFilter) {
                    DataItemTimeNPeriodsFilter timeFilter = (DataItemTimeNPeriodsFilter)step;
                    int n = timeFilter.getnPeriods();
                    String searchDirection = timeFilter.getSearchDirection();
                    String dateMember = timeFilter.getDateMember();
                    text = AppliedFiltersUtil.getOLAPTimeFilterNPeriodsText(model, cubeName, metadata, locale, conditionFormatMap, n, searchDirection, dateMember, useUnfilteredMetadata, fullyQualifyMemberNames);
                } else if (step instanceof DataItemTimeFirstLastPeriodsFilter) {
                    DataItemTimeFirstLastPeriodsFilter timeFilter = (DataItemTimeFirstLastPeriodsFilter)step;
                    int n = timeFilter.getnPeriods();
                    String searchDirection = timeFilter.getSearchDirection();
                    String levelName = timeFilter.getLevelName();
                    text = AppliedFiltersUtil.getOLAPTimeFilterFirstLastPeriodsText(model, cubeName, metadata, locale, conditionFormatMap, n, searchDirection, levelName, useUnfilteredMetadata, fullyQualifyMemberNames);
                } else if (step instanceof DataItemTimeNParallelPeriodsFilter) {
                } else if (step instanceof DataItemTimeRangeFilter) {
                    DataItemTimeRangeFilter timeFilter = (DataItemTimeRangeFilter)step;
                    String startDateMember = timeFilter.getStartDateMember();
                    String endDateMember = timeFilter.getEndDateMember();
                    String levelName = timeFilter.getLevel();
                    text = AppliedFiltersUtil.getOLAPTimeRangeFilterText(model, cubeName, metadata, locale, conditionFormatMap, startDateMember, endDateMember, levelName, useUnfilteredMetadata, fullyQualifyMemberNames);
                }
            }
            catch (IQueryServicesException e) {
                LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (iqCreatedMetadata && metadata != null) {
                    BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
                }
            }
        }
        return text;
    }

    private static SASFormat newSASFormat(String formatName, Locale locale) {
        SASFormat theSASFormat = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (formatName != null && (formatName = formatName.trim()).length() > 0) {
            try {
                theSASFormat = SASFormat.getInstance((String)formatName, (Locale)locale);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return theSASFormat;
    }

    private static String getFormattedDataValueFromExpression(Object filter, Locale locale) {
        SASFormat sasFormat;
        if (filter == null) {
            return "";
        }
        List leftExps = null;
        if (filter instanceof DataItemDataBasedFilter) {
            leftExps = ((DataItemDataBasedFilter)filter).getLeftExpression();
        } else if (filter instanceof BusinessQueryDataBasedFilter) {
            leftExps = ((BusinessQueryDataBasedFilter)filter).getLeftExpression();
        } else if (filter instanceof DataBasedFilterExpression) {
            leftExps = ((DataBasedFilterExpression)filter).getLeftExpression();
        }
        List rightExps = null;
        if (filter instanceof DataItemDataBasedFilter) {
            rightExps = ((DataItemDataBasedFilter)filter).getRightExpression();
        } else if (filter instanceof BusinessQueryDataBasedFilter) {
            rightExps = ((BusinessQueryDataBasedFilter)filter).getRightExpression();
        } else if (filter instanceof DataBasedFilterExpression) {
            rightExps = ((DataBasedFilterExpression)filter).getRightExpression();
        }
        DataItem di = null;
        if (leftExps != null) {
            if (leftExps.size() == 1 && leftExps.get(0) instanceof DataItem) {
                di = (DataItem)leftExps.get(0);
            } else if (leftExps.size() == 2 && leftExps.get(1) instanceof DataItem) {
                di = (DataItem)leftExps.get(1);
            }
        }
        if (di != null && (sasFormat = AppliedFiltersUtil.newSASFormat(di.getFormat(), locale)) != null && rightExps != null && rightExps.size() == 1 && rightExps.get(0) instanceof StringExpression) {
            try {
                String valueAsString = ((StringExpression)rightExps.get(0)).getText();
                Double doubleValue = new Double(valueAsString);
                return sasFormat.format((Object)doubleValue).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rightExps != null) {
            return AppliedFiltersUtil.getReadableText(rightExps, locale);
        }
        return "";
    }

    private static String getOLAPTimeFilterNPeriodsText(Object model, String cubeName, MetadataInterface metadata, Locale locale, Map conditionFormatMap, int n, String searchDirection, String dateMember, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        String levelStringText;
        String text = "";
        ArrayList<String> memberList = new ArrayList<String>(1);
        memberList.add(dateMember);
        String memberText = AppliedFiltersUtil.getReadableTextForMembers(model, cubeName, memberList, metadata, locale, ",", conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
        List levelTextNames = OLAPTimeFilterUtil.getReadableTextForTimeLevel(model, metadata, cubeName, null, dateMember, locale);
        String singularLevelName = "";
        String pluralLevelName = "";
        if (levelTextNames != null && levelTextNames.size() == 2) {
            singularLevelName = (String)levelTextNames.get(0);
            pluralLevelName = (String)levelTextNames.get(1);
        }
        Object format = searchDirection.equals("BACKWARD") ? conditionFormatMap.get(TIME_LAST_PERIODS_FILTER) : conditionFormatMap.get(TIME_FIRST_PERIODS_FILTER);
        String string = levelStringText = n > 1 ? pluralLevelName : singularLevelName;
        if (format != null) {
            text = Message.format((String)format.toString(), (Object)Integer.toString(n), (Object)levelStringText, (Object)memberText);
        }
        return text;
    }

    private static String getOLAPTimeFilterFirstLastPeriodsText(Object model, String cubeName, MetadataInterface metadata, Locale locale, Map conditionFormatMap, int n, String searchDirection, String levelName, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        String text = "";
        BusinessQuery bq = null;
        if (model instanceof BusinessQuery) {
            bq = (BusinessQuery)model;
        } else if (model instanceof BusinessQueryProviderInterface) {
            bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        }
        try {
            String levelString1;
            List levelTextNames = OLAPTimeFilterUtil.getReadableTextForTimeLevel(model, metadata, cubeName, levelName, null, locale);
            String currentMemberText = AppliedFiltersUtil.queryMetadataForRelativeMemberText(bq, metadata, cubeName, levelName, searchDirection, useUnfilteredMetadata, fullyQualifyMemberNames);
            String singularLevelName = "";
            String pluralLevelName = "";
            if (levelTextNames != null && levelTextNames.size() == 2) {
                singularLevelName = (String)levelTextNames.get(0);
                pluralLevelName = (String)levelTextNames.get(1);
            }
            LevelInterface level = OLAPTimeFilterUtil.getLevel(model, metadata, cubeName, levelName, null);
            int type = 32768;
            if (level != null) {
                try {
                    type = level.getType();
                }
                catch (OLAPException e) {
                    LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            }
            String firstLevelText = RelativeTimeFilterValueFormatter.getReadableTextForTimeLevel((int)type, (int)0, (Locale)locale);
            String lastLevelText = RelativeTimeFilterValueFormatter.getReadableTextForTimeLevel((int)type, (int)1, (Locale)locale);
            Object format = null;
            String string = levelString1 = n > 1 ? pluralLevelName : singularLevelName;
            if (searchDirection.equals("BACKWARD")) {
                format = conditionFormatMap.get(TIME_LAST_PERIODS_RELATIVE_FILTER);
                if (format != null) {
                    text = Message.format((String)format.toString(), (Object)Integer.toString(n), (Object)levelString1, (Object)lastLevelText, (Object)currentMemberText);
                }
            } else {
                format = conditionFormatMap.get(TIME_FIRST_PERIODS_RELATIVE_FILTER);
                if (format != null) {
                    text = Message.format((String)format.toString(), (Object)Integer.toString(n), (Object)levelString1, (Object)firstLevelText, (Object)currentMemberText);
                }
            }
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return text;
    }

    private static String getOLAPTimeRangeFilterText(Object model, String cubeName, MetadataInterface metadata, Locale locale, Map conditionFormatMap, String startDateMember, String endDateMember, String levelName, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        boolean isStartMemberRelative = startDateMember == null;
        boolean isEndMemberRelative = endDateMember == null;
        String text = "";
        BusinessQuery bq = null;
        if (model instanceof BusinessQuery) {
            bq = (BusinessQuery)model;
        } else if (model instanceof BusinessQueryProviderInterface) {
            bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        }
        try {
            Object format;
            String singularLevelText = "";
            String pluralLevelText = "";
            List levelTextNames = null;
            LevelInterface level = null;
            if (levelName != null) {
                levelTextNames = OLAPTimeFilterUtil.getReadableTextForTimeLevel(model, metadata, cubeName, levelName, null, locale);
                level = OLAPTimeFilterUtil.getLevel(model, metadata, cubeName, levelName, null);
            } else {
                String memberName = startDateMember != null ? startDateMember : endDateMember;
                levelTextNames = OLAPTimeFilterUtil.getReadableTextForTimeLevel(model, metadata, cubeName, null, memberName, locale);
                level = OLAPTimeFilterUtil.getLevel(model, metadata, cubeName, null, memberName);
            }
            if (levelTextNames != null && levelTextNames.size() == 2) {
                singularLevelText = levelTextNames.get(0).toString();
                pluralLevelText = levelTextNames.get(1).toString();
            }
            int type = 32768;
            if (level != null) {
                try {
                    type = level.getType();
                }
                catch (OLAPException e) {
                    LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            }
            String firstLevelText = RelativeTimeFilterValueFormatter.getReadableTextForTimeLevel((int)type, (int)0, (Locale)locale);
            String lastLevelText = RelativeTimeFilterValueFormatter.getReadableTextForTimeLevel((int)type, (int)1, (Locale)locale);
            String startDateMemberText = "";
            if (isStartMemberRelative) {
                startDateMemberText = AppliedFiltersUtil.queryMetadataForRelativeMemberText(bq, metadata, cubeName, levelName, "FORWARD", useUnfilteredMetadata, fullyQualifyMemberNames);
            } else {
                ArrayList<String> startMemberList = new ArrayList<String>(1);
                startMemberList.add(startDateMember);
                startDateMemberText = AppliedFiltersUtil.getReadableTextForMembers(model, cubeName, startMemberList, metadata, locale, ",", conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
            }
            String endDateMemberText = "";
            if (isEndMemberRelative) {
                endDateMemberText = AppliedFiltersUtil.queryMetadataForRelativeMemberText(bq, metadata, cubeName, levelName, "BACKWARD", useUnfilteredMetadata, fullyQualifyMemberNames);
            } else {
                ArrayList<String> endMemberList = new ArrayList<String>(1);
                endMemberList.add(endDateMember);
                endDateMemberText = AppliedFiltersUtil.getReadableTextForMembers(model, cubeName, endMemberList, metadata, locale, ",", conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
            }
            if (!isStartMemberRelative && !isEndMemberRelative) {
                format = conditionFormatMap.get(TIME_RANGE_ABSOLUTE_TO_ABSOLUTE_FILTER);
                if (format != null) {
                    text = Message.format((String)format.toString(), (Object)pluralLevelText, (Object)startDateMemberText, (Object)endDateMemberText);
                }
            } else if (isStartMemberRelative && isEndMemberRelative) {
                format = conditionFormatMap.get(TIME_RANGE_RELATIVE_TO_RELATIVE_FILTER);
                if (format != null) {
                    text = Message.format((String)format.toString(), (Object)pluralLevelText, (Object)firstLevelText, (Object)startDateMemberText, (Object)lastLevelText, (Object)endDateMemberText);
                }
            } else if (isStartMemberRelative && !isEndMemberRelative) {
                format = conditionFormatMap.get(TIME_RANGE_RELATIVE_TO_ABSOLUTE_FILTER);
                if (format != null) {
                    text = Message.format((String)format.toString(), (Object)pluralLevelText, (Object)firstLevelText, (Object)startDateMemberText, (Object)endDateMemberText);
                }
            } else if (!isStartMemberRelative && isEndMemberRelative && (format = conditionFormatMap.get(TIME_RANGE_ABSOLUTE_TO_RELATIVE_FILTER)) != null) {
                text = Message.format((String)format.toString(), (Object)pluralLevelText, (Object)startDateMemberText, (Object)lastLevelText, (Object)endDateMemberText);
            }
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return text;
    }

    private static List getBusinessQueryFiltersForRole(Object model, String cubeName, Role role, MetadataInterface metadata, Locale locale, boolean wrapText, Map spanInfo, Map conditionFormatMap, String labelSeparator, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        BusinessQuery bq = null;
        ArrayList<String> filters = new ArrayList<String>();
        if (model instanceof BusinessQuery) {
            bq = (BusinessQuery)model;
        } else if (model instanceof BusinessQueryProviderInterface) {
            bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        }
        if (bq != null) {
            List steps = bq.getSteps(role);
            int size = steps.size();
            for (int i = 0; i < size; ++i) {
                StepInterface step = (StepInterface)steps.get(i);
                String messageText = AppliedFiltersUtil.getBusinessQueryStepFilterDescription(bq, cubeName, metadata, conditionFormatMap, locale, role, step, labelSeparator, spanInfo, useUnfilteredMetadata, fullyQualifyMemberNames);
                if (messageText == null || messageText.length() <= 0) continue;
                filters.add(messageText);
                break;
            }
        }
        return filters;
    }

    private static String getBusinessQueryStepFilterDescription(Object model, String cubeName, MetadataInterface metadata, Map conditionFormatMap, Locale locale, Role role, StepInterface step, String labelSeparator, Map spanInfo, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        String defaultFormat = RB.getStringResource((String)RB_KEY, (String)"textFormat.fmt.txt", (Locale)locale);
        String messageText = null;
        String filterDescriptionText = "";
        if (step instanceof BusinessQueryDataBasedFilter) {
            String leftText = AppliedFiltersUtil.getReadableTextForMembers(model, cubeName, ((BusinessQueryDataBasedFilter)step).getLeftExpression(), metadata, locale, ".", conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
            String rightText = AppliedFiltersUtil.getFormattedDataValueFromExpression((BusinessQueryDataBasedFilter)step, locale);
            ComparisonOperator operator = ((BusinessQueryDataBasedFilter)step).getOperator();
            String operatorText = ((BusinessQueryDataBasedFilter)step).getOperator().toString();
            String format = AppliedFiltersUtil.getFormatForOperator(operator, conditionFormatMap);
            messageText = format != null ? Message.format((String)format, (Object)leftText, (Object)rightText) : Message.format((String)defaultFormat, (Object)leftText, (Object)operatorText, (Object)rightText);
        } else if (step instanceof BusinessQueryRankFilter) {
            messageText = AppliedFiltersUtil.getRankStepText(model, cubeName, (BusinessQueryRankFilter)step, metadata, locale, conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
        }
        if (messageText != null && messageText.length() > 0) {
            String label = "";
            if (role == Role.ROW) {
                label = RB.getStringResource((String)RB_KEY, (String)"rows.txt", (Locale)locale);
            } else if (role == Role.COLUMN) {
                label = RB.getStringResource((String)RB_KEY, (String)"columns.txt", (Locale)locale);
            }
            if (labelSeparator != null) {
                label = label + labelSeparator;
            }
            label = AppliedFiltersUtil.addStyleInfo(label, spanInfo, FILTER_LABEL_SPAN);
            String filterText = AppliedFiltersUtil.addStyleInfo(messageText, spanInfo, FILTER_TEXT_SPAN);
            Object format = conditionFormatMap.get(ROW_COLUMN_FILTER);
            filterDescriptionText = format != null ? Message.format((String)format.toString(), (Object)label, (Object)filterText) : label + " " + filterText;
        }
        return filterDescriptionText;
    }

    private static String getFormatForOperator(ComparisonOperator operator, Map conditionFormatMap) {
        String format = null;
        if (operator != null && conditionFormatMap != null) {
            if (operator == ComparisonOperator.COMPARE_EQ) {
                if (conditionFormatMap.containsKey(IS_EQUALS)) {
                    format = conditionFormatMap.get(IS_EQUALS).toString();
                }
            } else if (operator == ComparisonOperator.COMPARE_NEQ) {
                if (conditionFormatMap.containsKey(IS_NOT_EQUALS)) {
                    format = conditionFormatMap.get(IS_NOT_EQUALS).toString();
                }
            } else if (operator == ComparisonOperator.COMPARE_GT) {
                if (conditionFormatMap.containsKey(IS_GREATER_THAN)) {
                    format = conditionFormatMap.get(IS_GREATER_THAN).toString();
                }
            } else if (operator == ComparisonOperator.COMPARE_GE) {
                if (conditionFormatMap.containsKey(IS_GREATER_THAN_OR_EQUAL)) {
                    format = conditionFormatMap.get(IS_GREATER_THAN_OR_EQUAL).toString();
                }
            } else if (operator == ComparisonOperator.COMPARE_LT) {
                if (conditionFormatMap.containsKey(IS_LESS_THAN)) {
                    format = conditionFormatMap.get(IS_LESS_THAN).toString();
                }
            } else if (operator == ComparisonOperator.COMPARE_LE && conditionFormatMap.containsKey(IS_LESS_THAN_OR_EQUAL)) {
                format = conditionFormatMap.get(IS_LESS_THAN_OR_EQUAL).toString();
            }
        }
        return format;
    }

    private static String getRankStepText(Object model, String cubeName, BusinessQueryRankFilter filter, MetadataInterface metadata, Locale locale, Map conditionFormatMap, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        String rankOrderString = null;
        String rankTypeString = null;
        RankOrderEnum roe = FilterAndRankModel.getRankOrder(filter.getRankOrder());
        if (roe == RankOrderEnum.TOP) {
            rankOrderString = "T";
        } else if (roe == RankOrderEnum.BOTTOM) {
            rankOrderString = "B";
        }
        RankTypeEnum rte = FilterAndRankModel.getRankType(filter.getRankType());
        if (rte == RankTypeEnum.COUNT) {
            rankTypeString = "C";
        } else if (rte == RankTypeEnum.PERCENT) {
            rankTypeString = "P";
        } else if (rte == RankTypeEnum.SUM) {
            rankTypeString = "S";
        }
        String text = com.sas.swing.visuals.dataselectors.Util.getLocalizedRankStatus((String)rankOrderString, (int)filter.getValue(), (String)rankTypeString, (String)(filter.isIncludeTies() ? "1" : "0"), (String)AppliedFiltersUtil.getReadableTextForMembers(model, cubeName, filter.getRankQualifiers(), metadata, locale, ".", conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames), (Locale)locale);
        return text;
    }

    private static String getRankStepText(Object model, com.sas.iquery.metadata.business.step.olap.DataItemRankFilter filter, Locale locale, boolean fullyQualifyMemberNames) {
        String rankTypeString = null;
        switch (filter.getRankType()) {
            case 0: {
                rankTypeString = "C";
                break;
            }
            case 1: {
                rankTypeString = "P";
                break;
            }
            case 2: {
                rankTypeString = "S";
            }
        }
        String text = com.sas.swing.visuals.dataselectors.Util.getLocalizedRankStatus((String)(filter.getRankOrder() == 0 ? "T" : "B"), (int)filter.getValue(), (String)rankTypeString, (String)(filter.isIncludeTies() ? "1" : "0"), (String)AppliedFiltersUtil.getReadableTextForMembers(model, null, filter.getRankQualifiers(), null, locale, ".", null, false, fullyQualifyMemberNames), (Locale)locale);
        return text;
    }

    private static String getReadableTextForMembers(Object model, String cubeName, List list, MetadataInterface metadata, Locale locale, String separator, Map conditionFormatMap, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        String text = "";
        BusinessQuery bq = null;
        if (model instanceof BusinessQuery) {
            bq = (BusinessQuery)model;
        } else if (model instanceof BusinessQueryProviderInterface) {
            bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        }
        boolean isRolap = false;
        try {
            isRolap = AppliedFiltersUtil.isROLAP(bq);
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        if (list != null) {
            int kSize = list.size();
            for (int k = 0; k < kSize; ++k) {
                try {
                    String memberText = null;
                    Object obj = list.get(k);
                    if (obj instanceof StringExpression) {
                        if (isRolap) {
                            String expressionText = ((StringExpression)obj).getText();
                            if (expressionText != null) {
                                int startIndex = expressionText.lastIndexOf("[");
                                int endIndex = expressionText.lastIndexOf("]");
                                if (startIndex != -1 && endIndex != -1 && (memberText = expressionText.substring(startIndex + 1, endIndex).trim()).length() >= 2 && (memberText.startsWith("&T") || memberText.startsWith("&S"))) {
                                    memberText = memberText.substring(2);
                                }
                            }
                        } else {
                            String readableText = expressionUtil.getReadableText((ExpressionInterface)((StringExpression)obj));
                            memberText = AppliedFiltersUtil.queryMetadataForMemberText(bq, metadata, cubeName, readableText, useUnfilteredMetadata, fullyQualifyMemberNames);
                        }
                    } else if (obj instanceof DataItem) {
                        memberText = ((DataItem)obj).getLabel();
                    } else if (obj instanceof String) {
                        String uniqueMemberName = (String)obj;
                        if (uniqueMemberName.length() > 0) {
                            memberText = AppliedFiltersUtil.queryMetadataForMemberText(bq, metadata, cubeName, uniqueMemberName, useUnfilteredMetadata, fullyQualifyMemberNames);
                        }
                    } else if (obj instanceof Prompt) {
                        String formatString = null;
                        if (conditionFormatMap != null && conditionFormatMap.get(PROMPT_FORMAT) != null) {
                            formatString = conditionFormatMap.get(PROMPT_FORMAT).toString();
                        }
                        memberText = FilterValueFormatter.getPromptDescription((Prompt)obj, bq, formatString, locale);
                    }
                    if (memberText == null || memberText.length() <= 0) continue;
                    if (k != 0) {
                        text = text + separator;
                    }
                    text = text + memberText;
                    continue;
                }
                catch (MetadataException e) {
                    LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (OLAPException e) {
                    LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String queryMetadataForMemberText(BusinessQuery bq, MetadataInterface metadata, String cubeName, String uniqueMemberName, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) throws MetadataException, OLAPException {
        String memberText;
        block12: {
            memberText = "";
            Filter filter = new Filter();
            filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
            filter.setUniqueMemberName(uniqueMemberName);
            filter.setCubeName(cubeName);
            boolean iqCreatedMetadata = false;
            try {
                MemberInterface member;
                if (metadata == null && bq != null) {
                    metadata = AppliedFiltersUtil.getMetadata(bq, useUnfilteredMetadata);
                    iqCreatedMetadata = true;
                }
                if (metadata == null) break block12;
                MemberInterface[] members = metadata.getMembers(filter, 0, -1);
                Arrays.sort(members, MemberLevelComparator.defaultInstance);
                if (fullyQualifyMemberNames) {
                    for (int i = 0; i < members.length; ++i) {
                        if (members[i].getType() == 2 && members.length != 1) continue;
                        String label = members[i].getLabel().trim();
                        if (memberText != null) {
                            if (memberText.length() > 0) {
                                memberText = memberText + ".";
                            }
                            memberText = memberText + label;
                            continue;
                        }
                        memberText = label;
                    }
                    break block12;
                }
                if (members.length > 0 && ((member = members[members.length - 1]).getType() != 2 || members.length == 1)) {
                    memberText = member.getLabel().trim();
                }
                String string = memberText;
                return string;
            }
            catch (IQueryServicesException ie) {
                LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(ie.getMessage(), (Throwable)ie);
            }
            finally {
                if (iqCreatedMetadata && metadata != null) {
                    BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
                }
            }
        }
        return memberText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String queryMetadataForRelativeMemberText(BusinessQuery bq, MetadataInterface metadata, String cubeName, String uniqueLevelName, String direction, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) throws MetadataException, OLAPException {
        String memberUniqueName;
        String memberText;
        block15: {
            memberText = "";
            memberUniqueName = null;
            Object member = null;
            Filter filter = new Filter();
            filter.setUniqueLevelName(uniqueLevelName);
            filter.setCubeName(cubeName);
            boolean iqCreatedMetadata = false;
            try {
                LevelInterface level;
                if (metadata == null) {
                    metadata = AppliedFiltersUtil.getMetadata(bq, useUnfilteredMetadata);
                    iqCreatedMetadata = true;
                }
                if (metadata == null || (level = metadata.getLevel(filter)) == null || direction == null) break block15;
                MemberInterface[] members = null;
                int index = 0;
                if (direction.equals("BACKWARD")) {
                    try {
                        index = level.getMemberCount() - 1;
                    }
                    catch (OLAPException e) {
                        index = -1;
                        memberUniqueName = IQUeryUtil.getFirstLastMemberUniqueNameViaMDX(false, cubeName, uniqueLevelName, metadata.getConnection());
                    }
                }
                if (index >= 0) {
                    try {
                        members = metadata.getMembers(filter, index, 1);
                    }
                    catch (OLAPException e) {
                        String string = memberUniqueName = direction.equals("BACKWARD") ? IQUeryUtil.getFirstLastMemberUniqueNameViaMDX(false, cubeName, uniqueLevelName, metadata.getConnection()) : IQUeryUtil.getFirstLastMemberUniqueNameViaMDX(true, cubeName, uniqueLevelName, metadata.getConnection());
                    }
                }
                if (members != null && members.length > 0) {
                    memberUniqueName = members[0].getUniqueName();
                }
            }
            catch (IQueryServicesException ie) {
                LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(ie.getMessage(), (Throwable)ie);
            }
            finally {
                if (iqCreatedMetadata && metadata != null) {
                    BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
                }
            }
        }
        if (memberUniqueName != null) {
            memberText = AppliedFiltersUtil.queryMetadataForMemberText(bq, metadata, cubeName, memberUniqueName, useUnfilteredMetadata, fullyQualifyMemberNames);
        }
        return memberText;
    }

    private static String getReadableText(List list, Locale locale) {
        String text = "";
        int kSize = list.size();
        for (int k = 0; k < kSize; ++k) {
            try {
                ExpressionInterface stringExpression = (ExpressionInterface)list.get(k);
                String readableText = stringExpression instanceof FunctionCall ? BaseFilterObjectFactory.formatFunctionCall((FunctionCall)stringExpression) : expressionUtil.getReadableText(stringExpression);
                if (readableText == null) continue;
                if (k != 0) {
                    text = text + ", ";
                }
                text = text + readableText;
                continue;
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return text;
    }

    private static List getAppliedOLAPFilters(Object model, boolean treatAsAncestorQuery, DataItemRoleProvider dataItemRoleProvider, Locale locale, boolean wrapText, Map spanInfo, Map conditionFormatMap, String labelSeparator, boolean isRolap, int outputType, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames, boolean displayHiddenOLAPFilterItems, String olapFilterOutputType) {
        ArrayList<String> filters = new ArrayList<String>();
        BusinessQuery bq = null;
        String cubeName = "";
        MetadataInterface metadata = null;
        if (model instanceof BusinessQueryProviderInterface) {
            bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            if (model instanceof OLAPDataSetInterface) {
                try {
                    cubeName = ((OLAPDataSetInterface)model).getCubeName();
                    metadata = ((OLAPDataSetInterface)model).getDatabaseMetadata();
                }
                catch (OLAPException e) {
                    LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            }
        } else if (model instanceof DataSelection) {
            bq = (DataSelection)model;
            try {
                List dataSources = ((DataSelection)bq).getObjects(true, DataSourceCube.class);
                if (dataSources.size() > 0) {
                    cubeName = ((DataSourceCube)dataSources.get(0)).getCube().getCubeName();
                }
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        if (bq != null) {
            if (isRolap) {
                filters.addAll(AppliedFiltersUtil.processRolapBusinessQueryFilters(bq, bq.getFilters(), locale, conditionFormatMap, spanInfo, outputType));
            } else if (olapFilterOutputType != OLAPFILTERS_BUSINESSQUERY_STEPS_ONLY) {
                List filterItems = bq.getFilters();
                for (FilterItem filter : filterItems) {
                    String dataItemLabel;
                    String description;
                    if (!displayHiddenOLAPFilterItems && filter.isHidden() || ByGroupCreator.isByGroupFilter((BusinessQuery)bq, (FilterItem)filter)) continue;
                    String expressionText = AppliedFiltersUtil.getTextForExpression(bq, cubeName, filter.getExpression(), metadata, locale, conditionFormatMap, 1, useUnfilteredMetadata, fullyQualifyMemberNames);
                    List dataItems = filter.getDataItems(1);
                    Iterator dataItemIter = dataItems.iterator();
                    DataItem dataItem = null;
                    while (dataItemIter.hasNext()) {
                        DataItem di = (DataItem)dataItemIter.next();
                        if (di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) continue;
                        dataItem = di;
                        break;
                    }
                    if ((description = AppliedFiltersUtil.addLabelTextToFilterText(expressionText, dataItemLabel = dataItem != null ? dataItem.getLabel() : null, "", conditionFormatMap, null)) == null) continue;
                    filters.add(description);
                }
            }
            if (treatAsAncestorQuery) {
                return filters;
            }
            if (olapFilterOutputType != OLAPFILTERS_BUSINESSQUERY_STEPS_ONLY) {
                List items = bq.getResultItems();
                List slicerAndHiddenItems = null;
                if (dataItemRoleProvider != null) {
                    slicerAndHiddenItems = dataItemRoleProvider.getSlicerDataItems();
                    slicerAndHiddenItems.addAll(dataItemRoleProvider.getHiddenDataItems());
                }
                int size = items.size();
                for (int i = 0; i < size; ++i) {
                    BusinessItem bi = (BusinessItem)items.get(i);
                    if (!(bi instanceof DataItem)) continue;
                    DataItem di = (DataItem)bi;
                    String text = null;
                    List diSteps = di.getSteps();
                    ArrayList<Class> stepTypesList = new ArrayList<Class>(4);
                    boolean ignoreDataItemFilter = false;
                    if (diSteps.size() > 1 && slicerAndHiddenItems != null && slicerAndHiddenItems.contains(di) && diSteps.get(diSteps.size() - 1) instanceof DataItemNavigationFilter) {
                        ignoreDataItemFilter = true;
                    }
                    if (ignoreDataItemFilter) continue;
                    for (int j = diSteps.size() - 1; j >= 0; --j) {
                        StepInterface step = (StepInterface)diSteps.get(j);
                        Class stepClass = step.getClass();
                        if (stepTypesList.contains(stepClass) || step instanceof DataItemNavigationFilter) continue;
                        stepTypesList.add(stepClass);
                        text = AppliedFiltersUtil.getTextForStepUnencoded(model, cubeName, step, metadata, locale, conditionFormatMap, useUnfilteredMetadata, fullyQualifyMemberNames);
                        String dataItemLabel = di != null ? di.getLabel() : null;
                        String completeText = AppliedFiltersUtil.addLabelTextToFilterText(text, dataItemLabel, labelSeparator, conditionFormatMap, spanInfo);
                        if (completeText == null) continue;
                        filters.add(completeText);
                    }
                }
            }
            if (olapFilterOutputType != OLAPFILTERS_IGNORE_BUSINESSQUERY_STEPS) {
                filters.addAll(AppliedFiltersUtil.getBusinessQueryFiltersForRole(model, cubeName, Role.COLUMN, metadata, locale, wrapText, spanInfo, conditionFormatMap, labelSeparator, useUnfilteredMetadata, fullyQualifyMemberNames));
                filters.addAll(AppliedFiltersUtil.getBusinessQueryFiltersForRole(model, cubeName, Role.ROW, metadata, locale, wrapText, spanInfo, conditionFormatMap, labelSeparator, useUnfilteredMetadata, fullyQualifyMemberNames));
            }
            OLAPDataSetInterface dsi = model instanceof OLAPDataSetInterface ? (OLAPDataSetInterface)model : null;
            filters.addAll(AppliedFiltersUtil.getSlicerContentUnencoded(dataItemRoleProvider, bq, dsi, spanInfo, conditionFormatMap, labelSeparator, locale, useUnfilteredMetadata, fullyQualifyMemberNames));
        }
        return filters;
    }

    private static Object encodeFilterText(Object toEncode, Map formatMap) {
        boolean encodingRequired = false;
        if (formatMap != null && formatMap.get(OUTPUT_TYPE) == OUTPUT_TYPE_HTML) {
            encodingRequired = true;
        }
        if (toEncode instanceof String) {
            return AppliedFiltersUtil.encodeSpecialCharacters((String)toEncode, encodingRequired);
        }
        if (toEncode instanceof List) {
            List listToEncode = (List)toEncode;
            ArrayList<String> encodedList = new ArrayList<String>(listToEncode.size());
            int size = listToEncode.size();
            for (int i = 0; i < size; ++i) {
                Object obj = listToEncode.get(i);
                if (obj instanceof String && ((String)obj).length() > 0) {
                    encodedList.add(AppliedFiltersUtil.encodeSpecialCharacters((String)obj, encodingRequired));
                    continue;
                }
                encodedList.add((String)obj);
            }
            return encodedList;
        }
        return toEncode;
    }

    private static String encodeSpecialCharacters(String string, boolean encodingRequired) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (encodingRequired) {
            string = Strings.quoteForXML((String)string);
        }
        int length = string.length();
        string = Strings.replace((String)string, (int)0, (int)(length - 1), (String)START_SPAN_BEGIN, (String)"<span ");
        string = Strings.replace((String)string, (int)0, (int)(length - 1), (String)START_SPAN_END, (String)">");
        string = Strings.replace((String)string, (int)0, (int)(length - 1), (String)END_SPAN, (String)"</span>");
        string = Strings.replace((String)string, (int)0, (int)(length - 1), (String)NBSPACE, (String)"&#160;");
        return string;
    }

    private static Map getSecuredSlicerInfo(BusinessQuery bq, OLAPDataSetInterface dsi, MetadataInterface metadata, String cubeName) {
        Map map = new HashMap<String, String>();
        try {
            List ri = new ArrayList();
            if (dsi == null) {
                Filter f = new Filter();
                f.setCubeName(cubeName);
                HierarchyInterface[] hiers = metadata.getHierarchies(f);
                for (int k = 0; k < hiers.length; ++k) {
                    map.put(hiers[k].getUniqueName(), null);
                }
                ri = bq.getResultItems();
            } else {
                AxisInterface slicerAxis = dsi.getResultSetMetadata().getAxis(-1);
                String[] hierNames = slicerAxis.getHierarchyNames();
                TupleInterface[] tuples = slicerAxis.getTuples(0, -1);
                for (int k = 0; k < hierNames.length; ++k) {
                    map.put(hierNames[k], tuples[0].getElement(k).getLabel().trim());
                }
                ri = bq.getResultItems(Role.BACKGROUND);
                List l = bq.getResultItems(Role.HIDDEN);
                Iterator iter = l.iterator();
                while (iter.hasNext()) {
                    ri.add(iter.next());
                }
            }
            List filterList = bq.getEffectiveFilters();
            for (FilterItem fi : filterList) {
                List diList = fi.getDataItems(0);
                Iterator iter2 = diList.iterator();
                while (iter2.hasNext()) {
                    ri.add(iter2.next());
                }
            }
            int size = ri.size();
            for (int i = 0; i < size; ++i) {
                String riName = BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)bq.getBusinessModel(), (DataItem)((DataItem)ri.get(i)));
                if (!map.containsKey(riName)) continue;
                map.remove(riName);
            }
            if (metadata == null) {
                metadata = dsi.getDatabaseMetadata();
                cubeName = dsi.getCubeName();
            }
            map = AppliedFiltersUtil.resolveTopMembers(metadata, cubeName, map);
        }
        catch (OLAPException oLAPException) {
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return map;
    }

    private static Map resolveTopMembers(MetadataInterface metadata, String cubeName, Map hierMap) throws OLAPException {
        HashMap returnMap = new HashMap();
        for (String hierName : hierMap.keySet()) {
            Filter f = new Filter();
            f.setCubeName(cubeName);
            f.setUniqueHierarchyName(hierName);
            HierarchyInterface hier = metadata.getHierarchy(f);
            if (hier == null) continue;
            try {
                MemberInterface memberInterface = hier.getTopMember();
            }
            catch (Exception e) {
                Object memName = hierMap.get(hierName);
                if (memName == null) {
                    try {
                        memName = hier.getDefaultMember().getLabel().trim();
                    }
                    catch (Exception ex) {
                        continue;
                    }
                }
                returnMap.put(hier.getLabel(), memName);
            }
        }
        return returnMap;
    }

    public static List getSlicerContent(DataItemRoleProvider provider, BusinessQuery bq, OLAPDataSetInterface dsi, Map spanInfo, Map conditionFormatMap, String labelSeparator, Locale locale) {
        return AppliedFiltersUtil.getSlicerContent(provider, bq, dsi, spanInfo, conditionFormatMap, labelSeparator, locale, false);
    }

    public static List getSlicerContent(DataItemRoleProvider provider, BusinessQuery bq, OLAPDataSetInterface dsi, Map spanInfo, Map conditionFormatMap, String labelSeparator, Locale locale, boolean useUnfilteredMetadata) {
        return AppliedFiltersUtil.getSlicerContent(provider, bq, dsi, spanInfo, conditionFormatMap, labelSeparator, locale, useUnfilteredMetadata, true);
    }

    public static List getSlicerContent(DataItemRoleProvider provider, BusinessQuery bq, OLAPDataSetInterface dsi, Map spanInfo, Map conditionFormatMap, String labelSeparator, Locale locale, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        List filters = AppliedFiltersUtil.getSlicerContentUnencoded(provider, bq, dsi, spanInfo, conditionFormatMap, labelSeparator, locale, useUnfilteredMetadata, fullyQualifyMemberNames);
        filters = (List)AppliedFiltersUtil.encodeFilterText(filters, conditionFormatMap);
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getSlicerContentUnencoded(DataItemRoleProvider provider, BusinessQuery bq, OLAPDataSetInterface dsi, Map spanInfo, Map conditionFormatMap, String labelSeparator, Locale locale, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames) {
        ArrayList<String> filters = new ArrayList<String>();
        if (bq == null || !bq.getInputStructure().isOLAP() || provider == null) {
            return filters;
        }
        List ri = new ArrayList();
        ri = provider.getSlicerDataItems();
        List hiddenResultItems = provider.getHiddenDataItems();
        ri.addAll(hiddenResultItems);
        if (ri.size() == 0) {
            return filters;
        }
        boolean iqCreatedMetadata = false;
        MetadataInterface metadata = null;
        String cubeName = null;
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
        try {
            if (dsi != null) {
                try {
                    metadata = dsi.getDatabaseMetadata();
                    cubeName = dsi.getCubeName();
                }
                catch (OLAPException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                List dataSources;
                metadata = AppliedFiltersUtil.getMetadata(bq, useUnfilteredMetadata);
                iqCreatedMetadata = true;
                if (bq instanceof DataSelection && (dataSources = ((DataSelection)bq).getObjects(true, DataSourceCube.class)).size() > 0) {
                    cubeName = ((DataSourceCube)dataSources.get(0)).getCube().getCubeName();
                }
            }
            String measuresText = RB.getStringResource((String)RB_KEY, (String)"measures.txt", (Locale)locale);
            String allMembersText = RB.getStringResource((String)RB_KEY, (String)"allMembers.txt", (Locale)locale);
            IQDataServices dataService = IQDataServicesFactory.newService();
            int size = ri.size();
            for (int i = 0; i < size; ++i) {
                List diSteps;
                String text = "";
                String labelText = "";
                DataItem di = (DataItem)ri.get(i);
                if (di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE && (di.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE || hiddenResultItems.contains(di)) || (diSteps = di.getSteps()).size() > 0 && !(diSteps.get(diSteps.size() - 1) instanceof DataItemNavigationFilter)) continue;
                if (di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) {
                    labelText = measuresText;
                    text = di.getLabel();
                } else {
                    labelText = di.getLabel();
                    List steps = di.getSteps();
                    ExpressionInterface expression = di.getExpression();
                    if (expression instanceof Hierarchy && steps.size() == 0) continue;
                    List tupleElements = dataService.getMembers(di, -999);
                    int kSize = tupleElements.size();
                    for (int k = 0; k < kSize; ++k) {
                        TupleElementInterface element = (TupleElementInterface)tupleElements.get(k);
                        String memberText = null;
                        String memberUniqueName = element.getName();
                        if (memberUniqueName != null) {
                            memberText = AppliedFiltersUtil.queryMetadataForMemberText(bq, metadata, cubeName, memberUniqueName, useUnfilteredMetadata, fullyQualifyMemberNames);
                        }
                        if (memberText == null || memberText.length() <= 0) continue;
                        if (k != 0) {
                            text = text + ", ";
                        }
                        text = text + memberText;
                    }
                }
                String completeText = AppliedFiltersUtil.addLabelTextToFilterText(text, labelText, labelSeparator, conditionFormatMap, spanInfo);
                if (completeText == null) continue;
                filters.add(completeText);
            }
        }
        catch (DataServicesException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (OLAPException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IQueryServicesException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (iqCreatedMetadata && metadata != null) {
                BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
            }
        }
        return filters;
    }

    public static List getSecuredSlicerMembersFilters(BusinessQuery bq, OLAPDataSetInterface dsi, Map spanInfo, Map conditionFormatMap, String labelSeparator) {
        return AppliedFiltersUtil.getSecuredSlicerMembersFilters(bq, dsi, spanInfo, conditionFormatMap, labelSeparator, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSecuredSlicerMembersFilters(BusinessQuery bq, OLAPDataSetInterface dsi, Map spanInfo, Map conditionFormatMap, String labelSeparator, boolean useUnfilteredMetadata) {
        if (bq != null && !bq.getInputStructure().isOLAP()) {
            return new ArrayList();
        }
        List<String> filters = new ArrayList();
        MetadataInterface metadata = null;
        String cubeName = null;
        boolean iqCreatedMetadata = false;
        try {
            Map securedMap;
            if (dsi != null) {
                try {
                    metadata = dsi.getDatabaseMetadata();
                    cubeName = dsi.getCubeName();
                }
                catch (OLAPException e) {
                    LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            } else if (bq != null) {
                List dataSources;
                metadata = AppliedFiltersUtil.getMetadata(bq, useUnfilteredMetadata);
                iqCreatedMetadata = true;
                if (bq instanceof DataSelection && (dataSources = ((DataSelection)bq).getObjects(true, DataSourceCube.class)).size() > 0) {
                    cubeName = ((DataSourceCube)dataSources.get(0)).getCube().getCubeName();
                }
            }
            if ((securedMap = AppliedFiltersUtil.getSecuredSlicerInfo(bq, dsi, metadata, cubeName)) != null && securedMap.size() > 0) {
                for (String dimensionLabel : securedMap.keySet()) {
                    String memberName = (String)securedMap.get(dimensionLabel);
                    String format = conditionFormatMap.get(OLAP_EQUAL_TO).toString();
                    String memberText = Message.format((String)format, (Object)memberName);
                    String completeText = AppliedFiltersUtil.addLabelTextToFilterText(memberText, dimensionLabel, labelSeparator, conditionFormatMap, spanInfo);
                    if (completeText == null) continue;
                    filters.add(completeText);
                }
            }
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (IQueryServicesException e) {
            LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (iqCreatedMetadata && metadata != null) {
                BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
            }
        }
        filters = (List)AppliedFiltersUtil.encodeFilterText(filters, conditionFormatMap);
        return filters;
    }

    private static String addLabelTextToFilterText(String filterText, String label, String labelSeparator, Map conditionFormatMap, Map spanInfo) {
        String completeText = null;
        if (filterText != null) {
            if (label != null && label.length() > 0 && labelSeparator != null) {
                label = label + labelSeparator;
            }
            Object format = conditionFormatMap.get(STEP_FILTER);
            String labelText = AppliedFiltersUtil.addStyleInfo(label, spanInfo, FILTER_LABEL_SPAN);
            String filterDescriptionText = AppliedFiltersUtil.addStyleInfo(filterText, spanInfo, FILTER_TEXT_SPAN);
            if (format != null) {
                completeText = Message.format((String)format.toString(), (Object)labelText, (Object)filterDescriptionText);
            } else {
                if (labelText != null && labelText.length() > 0) {
                    completeText = labelText;
                }
                if (filterDescriptionText != null && filterDescriptionText.length() > 0) {
                    if (completeText != null && completeText.length() > 0) {
                        completeText = completeText + " ";
                    }
                    completeText = completeText + filterDescriptionText;
                }
            }
        }
        return completeText;
    }

    private static String addStyleInfo(String text, Map spanInfoMap, String type) {
        String newText = text;
        if (text != null && spanInfoMap != null) {
            boolean addSpan = false;
            StringBuffer sb = new StringBuffer();
            Object s = spanInfoMap.get(type);
            if (s instanceof String && ((String)s).length() > 0) {
                addSpan = true;
                sb.append(START_SPAN_BEGIN).append(s).append(START_SPAN_END);
            }
            sb.append(text);
            if (addSpan) {
                sb.append(END_SPAN);
            }
            newText = sb.toString();
        }
        return newText;
    }

    public static List getAppliedFiltersAndOperatorsList(BusinessQuery bq, Locale locale, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, String labelSeparator) {
        return AppliedFiltersUtil.getAppliedFiltersAndOperatorsList(bq, null, locale, spanInfo, conditionFormatMap, relationalFilterValueFormatter, labelSeparator);
    }

    public static List getAppliedFiltersAndOperatorsList(BusinessQuery bq, DataItemRoleProvider dataItemRoleProvider, Locale locale, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, String labelSeparator) {
        return AppliedFiltersUtil.getAppliedFiltersAndOperatorsList(bq, dataItemRoleProvider, locale, spanInfo, conditionFormatMap, relationalFilterValueFormatter, labelSeparator, false);
    }

    public static List getAppliedFiltersAndOperatorsList(BusinessQuery bq, DataItemRoleProvider dataItemRoleProvider, Locale locale, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, String labelSeparator, boolean useUnfilteredMetadata) {
        return AppliedFiltersUtil.getAppliedFiltersAndOperatorsList(bq, false, dataItemRoleProvider, locale, spanInfo, conditionFormatMap, relationalFilterValueFormatter, labelSeparator, useUnfilteredMetadata);
    }

    public static List getAppliedFiltersAndOperatorsList(BusinessQuery bq, boolean treatAsAncestorQuery, DataItemRoleProvider dataItemRoleProvider, Locale locale, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, String labelSeparator, boolean useUnfilteredMetadata) {
        return AppliedFiltersUtil.getAppliedFiltersAndOperatorsList(bq, treatAsAncestorQuery, dataItemRoleProvider, locale, spanInfo, conditionFormatMap, relationalFilterValueFormatter, labelSeparator, useUnfilteredMetadata, true, true, OLAPFILTERS_ALL);
    }

    public static List getAppliedFiltersAndOperatorsList(BusinessQuery bq, boolean treatAsAncestorQuery, DataItemRoleProvider dataItemRoleProvider, Locale locale, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, String labelSeparator, boolean useUnfilteredMetadata, boolean fullyQualifyMemberNames, boolean displayHiddenOLAPFilterItems, String olapFilterOutputType) {
        List<String> filters = new ArrayList();
        if (bq != null && bq.getBusinessModel() != null) {
            boolean isRolap = false;
            try {
                isRolap = AppliedFiltersUtil.isROLAP(bq);
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
            if (isRolap || bq.getBusinessModel().getStructure().isOLAP()) {
                List olapFilters = AppliedFiltersUtil.getAppliedOLAPFilters(bq, treatAsAncestorQuery, dataItemRoleProvider, locale, false, spanInfo, conditionFormatMap, labelSeparator, isRolap, 1, useUnfilteredMetadata, fullyQualifyMemberNames, displayHiddenOLAPFilterItems, olapFilterOutputType);
                String andString = com.sas.dataselectors.filters.RB.getStringResource((String)"Util.", (String)"Boolean.AND.Label.txt", (Locale)locale);
                andString = AppliedFiltersUtil.addStyleInfo(andString, spanInfo, LOGICAL_OPERATOR_SPAN);
                int size = olapFilters.size();
                for (int i = 0; i < size; ++i) {
                    Object obj = olapFilters.get(i);
                    if (!(obj instanceof String) || ((String)obj).length() <= 0) continue;
                    if (filters.size() > 0) {
                        filters.add(andString);
                    }
                    filters.add((String)obj);
                }
            } else {
                filters = AppliedFiltersUtil.getAppliedRelationalFilterAndOperatorList(bq, locale, spanInfo, conditionFormatMap, relationalFilterValueFormatter, 1);
            }
        }
        filters = (List)AppliedFiltersUtil.encodeFilterText(filters, conditionFormatMap);
        return filters;
    }

    private static List getAppliedRelationalFilterAndOperatorList(BusinessQuery bq, Locale locale, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, int outputType) {
        ArrayList<String> filters = new ArrayList<String>();
        if (bq != null) {
            List stepFilters;
            List list = AppliedFiltersUtil.getRelationalFilterMap(bq, conditionFormatMap, relationalFilterValueFormatter, outputType, locale);
            if (list != null) {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    Map currentFilter = (Map)list.get(i);
                    String expText = (String)currentFilter.get("Text");
                    expText = AppliedFiltersUtil.addStyleInfo(expText, spanInfo, FILTER_TEXT_SPAN);
                    filters.add(expText);
                    String logicalOperator = (String)currentFilter.get("Cond");
                    logicalOperator = AppliedFiltersUtil.addStyleInfo(logicalOperator, spanInfo, LOGICAL_OPERATOR_SPAN);
                    if (logicalOperator == null || logicalOperator.length() <= 0) continue;
                    filters.add(logicalOperator);
                }
            }
            if ((stepFilters = AppliedFiltersUtil.getRelationalStepFiltersUnencoded(bq, locale, spanInfo, conditionFormatMap)) != null) {
                String andString = com.sas.dataselectors.filters.RB.getStringResource((String)"Util.", (String)"Boolean.AND.Label.txt", (Locale)locale);
                andString = AppliedFiltersUtil.addStyleInfo(andString, spanInfo, LOGICAL_OPERATOR_SPAN);
                int stepsSize = stepFilters.size();
                for (int i = 0; i < stepsSize; ++i) {
                    String currStepFilter = (String)stepFilters.get(i);
                    if (currStepFilter == null || currStepFilter.length() <= 0) continue;
                    if (filters.size() > 0) {
                        filters.add(andString);
                    }
                    filters.add(currStepFilter);
                }
            }
        }
        return filters;
    }

    private static List getRelationalFilterMap(BusinessQuery bq, Map conditionFormatMap, Format relationalFilterValueFormatter, int outputType, Locale locale) {
        List list = new ArrayList();
        if (bq != null) {
            FilterObjectFactoryInterface obj;
            List currFilters = bq.getFilters();
            if (currFilters.size() == 1 && ByGroupCreator.isByGroupFilter((BusinessQuery)bq, (FilterItem)((FilterItem)currFilters.get(0)))) {
                return list;
            }
            BusinessModel bm = bq.getBusinessModel();
            Locale dataLocale = bm != null ? bm.getDataLocale() : locale;
            BusinessQueryToAdvancedFilterModelAdapter adapter = new BusinessQueryToAdvancedFilterModelAdapter(bq, null, dataLocale);
            if (relationalFilterValueFormatter != null) {
                for (FilterLogicTestNodeInterface filterNode : adapter.getSelectionTree().getUnderstoodTestNodeList()) {
                    FilterItemInterface filterItem = filterNode.getFilterItem();
                    if (!(filterItem instanceof DefaultFilterItem)) continue;
                    DefaultFilterItem item = (DefaultFilterItem)filterItem;
                    item.setUserValueFormatter(relationalFilterValueFormatter);
                }
            }
            if ((obj = adapter.getFilterObjectFactory()) instanceof BaseAdvancedFilterObjectFactory) {
                BaseAdvancedFilterObjectFactory filterObjectFactory = (BaseAdvancedFilterObjectFactory)obj;
                AppliedFiltersUtil.setConditionMessageFormats(filterObjectFactory, conditionFormatMap);
            }
            list = Util.getExpressionInfo((SimpleFilterLogicTreeInterface)adapter.getSelectionTree(), (int)outputType, (Locale)locale, (boolean)false);
        }
        return list;
    }

    private static List getAppliedRelationalFilters(BusinessQuery bq, Locale locale, boolean wrapText, Map spanInfo, Map conditionFormatMap, Format relationalFilterValueFormatter, int outputType) {
        ArrayList<String> filters = new ArrayList<String>();
        List list = AppliedFiltersUtil.getRelationalFilterMap(bq, conditionFormatMap, relationalFilterValueFormatter, outputType, locale);
        if (list != null && list.size() > 0) {
            String formattedText = AppliedFiltersUtil.getFormattedExpressionString(list, outputType, 0, list.size() - 1, spanInfo, wrapText);
            filters.add(formattedText);
        }
        List stepFilters = AppliedFiltersUtil.getRelationalStepFiltersUnencoded(bq, locale, spanInfo, conditionFormatMap);
        filters.addAll(stepFilters);
        return filters;
    }

    public static List getRelationalStepFilters(BusinessQuery bq, Locale locale, Map spanInfo, Map conditionFormatMap) {
        List filters = AppliedFiltersUtil.getRelationalStepFiltersUnencoded(bq, locale, spanInfo, conditionFormatMap);
        filters = (List)AppliedFiltersUtil.encodeFilterText(filters, conditionFormatMap);
        return filters;
    }

    private static List getRelationalStepFiltersUnencoded(BusinessQuery bq, Locale locale, Map spanInfo, Map conditionFormatMap) {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (bq != null) {
            List items = bq.getResultItems();
            int size = items.size();
            block0: for (int i = 0; i < size; ++i) {
                BusinessItem bi = (BusinessItem)items.get(i);
                if (!(bi instanceof DataItem)) continue;
                DataItem di = (DataItem)bi;
                List diSteps = di.getSteps();
                for (int j = diSteps.size() - 1; j >= 0; --j) {
                    StepInterface step = (StepInterface)diSteps.get(j);
                    String text = AppliedFiltersUtil.getTextForStepUnencoded(bq, null, step, null, locale, conditionFormatMap, false, true);
                    if (text == null) continue;
                    String label = AppliedFiltersUtil.addStyleInfo(di.getLabel() + " ", spanInfo, FILTER_TEXT_SPAN);
                    String filterText = AppliedFiltersUtil.addStyleInfo(text, spanInfo, FILTER_TEXT_SPAN);
                    Object format = conditionFormatMap.get(STEP_FILTER);
                    if (format != null) {
                        text = Message.format((String)format.toString(), (Object)label, (Object)filterText);
                        filters.add(text);
                        continue block0;
                    }
                    filters.add(new String[]{label + " ", text});
                    continue block0;
                }
            }
        }
        return filters;
    }

    private static boolean isROLAP(BusinessQuery model) throws MetadataException {
        if (model == null || !model.getInputStructure().isRelational()) {
            return false;
        }
        List dataItems = model.getResultItems();
        for (DataItem dataItem : dataItems) {
            if (!AppliedFiltersUtil._isRolapRole(model.getResultItemRole(dataItem))) continue;
            return true;
        }
        return false;
    }

    private static boolean _isRolapRole(Role role) {
        if (role != null) {
            return role.equals(Role.ROW) || role.equals(Role.BACKGROUND);
        }
        return false;
    }

    private static List processRolapBusinessQueryFilters(BusinessQuery bq, List bqFilters, Locale locale, Map conditionFormatMap, Map spanInfo, int outputType) {
        ArrayList<String> filters = new ArrayList<String>();
        if (bq != null && bqFilters != null) {
            for (FilterItem filter : bqFilters) {
                String rightText;
                String text;
                ExpressionInterface exp = filter.getExpression();
                if (exp instanceof DataBasedFilterExpression) {
                    text = null;
                    ExpressionInterface whatToFilterExpression = ((DataBasedFilterExpression)exp).getWhatToFilter();
                    String leftText = AppliedFiltersUtil.getReadableTextForMembers(bq, null, ((DataBasedFilterExpression)exp).getLeftExpression(), null, locale, ".", conditionFormatMap, false, true);
                    if (whatToFilterExpression instanceof DataItem) {
                        leftText = ((DataItem)whatToFilterExpression).getLabel() + "." + leftText;
                    }
                    rightText = AppliedFiltersUtil.getFormattedDataValueFromExpression(exp, locale);
                    ComparisonOperator operator = ((DataBasedFilterExpression)exp).getComparisonOperator();
                    String operatorText = ((DataBasedFilterExpression)exp).getComparisonOperator().toString();
                    String format = AppliedFiltersUtil.getFormatForOperator(operator, conditionFormatMap);
                    if (format != null) {
                        text = Message.format((String)format, (Object)leftText, (Object)rightText);
                    } else {
                        String defaultFormat = RB.getStringResource((String)RB_KEY, (String)"textFormat.fmt.txt", (Locale)locale);
                        text = Message.format((String)defaultFormat, (Object)leftText, (Object)operatorText, (Object)rightText);
                    }
                    String filterText = AppliedFiltersUtil.addStyleInfo(text, spanInfo, FILTER_TEXT_SPAN);
                    filters.add(filterText);
                    continue;
                }
                if (exp instanceof SimpleConditionalExpression_In) {
                    text = null;
                    String leftText = "";
                    ExpressionInterface whatToCompareExpression = ((SimpleConditionalExpression_In)exp).getWhatToCompare();
                    if (whatToCompareExpression instanceof DataItem) {
                        leftText = ((DataItem)whatToCompareExpression).getLabel();
                    } else if (whatToCompareExpression instanceof FunctionCall) {
                        leftText = BaseFilterObjectFactory.formatFunctionCall((FunctionCall)whatToCompareExpression);
                    } else {
                        try {
                            leftText = expressionUtil.getReadableText(whatToCompareExpression);
                        }
                        catch (MetadataException e) {
                            LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                        }
                    }
                    rightText = AppliedFiltersUtil.getReadableText(((SimpleConditionalExpression_In)exp).getComparisonList(), locale);
                    String format = (String)conditionFormatMap.get(IS_IN_LIST_OR_EQUAL_TO);
                    if (format != null) {
                        text = Message.format((String)format, (Object)leftText, (Object)rightText);
                    } else {
                        String defaultFormat = RB.getStringResource((String)RB_KEY, (String)"textFormat.fmt.txt", (Locale)locale);
                        text = Message.format((String)defaultFormat, (Object)leftText, (Object)"", (Object)rightText);
                    }
                    String filterText = AppliedFiltersUtil.addStyleInfo(text, spanInfo, FILTER_TEXT_SPAN);
                    filters.add(filterText);
                    continue;
                }
                if (!(exp instanceof SimpleConditionalExpression_Between) && !(exp instanceof SimpleConditionalExpression_Comparison) && !(exp instanceof CompoundConditionalExpression)) continue;
                text = null;
                if (text == null) {
                    try {
                        if (bq instanceof DataSelection) {
                            DataSelection ds = (DataSelection)bq;
                            DataSelection copy = ds.copy();
                            ArrayList<FilterItem> filterList = new ArrayList<FilterItem>(1);
                            filterList.add(filter);
                            copy.setFilters(filterList);
                            FilterValueFormatter formatter = FilterValueFormatter.getInstance(locale);
                            if (conditionFormatMap != null && conditionFormatMap.get(PROMPT_FORMAT) != null) {
                                formatter.setPromptFormatString(conditionFormatMap.get(PROMPT_FORMAT).toString());
                            }
                            formatter.setBusinessQuery((BusinessQuery)copy);
                            List list = AppliedFiltersUtil.getRelationalFilterMap((BusinessQuery)copy, conditionFormatMap, formatter, 1, locale);
                            if (list != null && list.size() > 0) {
                                text = AppliedFiltersUtil.getFormattedExpressionString(list, 1, 0, list.size() - 1, null, true);
                            }
                        }
                    }
                    catch (Exception e) {
                        LoggerRepository2.getLogger((String)AppliedFiltersUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                }
                if (text == null || text.length() <= 0) continue;
                filters.add(text);
            }
        }
        return filters;
    }

    private static void setConditionMessageFormats(BaseAdvancedFilterObjectFactory filterObjectFactory, Map conditionMessageFormats) {
        if (filterObjectFactory != null) {
            if (conditionMessageFormats.containsKey(IS_EQUALS)) {
                filterObjectFactory.IS_EQUALS.setConditionMessageFormat(conditionMessageFormats.get(IS_EQUALS).toString());
            }
            if (conditionMessageFormats.containsKey(IS_NOT_EQUALS)) {
                filterObjectFactory.IS_NOT_EQUALS.setConditionMessageFormat(conditionMessageFormats.get(IS_NOT_EQUALS).toString());
            }
            if (conditionMessageFormats.containsKey(IS_IN_LIST)) {
                filterObjectFactory.IS_IN_LIST.setConditionMessageFormat(conditionMessageFormats.get(IS_IN_LIST).toString());
            }
            if (conditionMessageFormats.containsKey(IS_NOT_IN_LIST)) {
                filterObjectFactory.IS_NOT_IN_LIST.setConditionMessageFormat(conditionMessageFormats.get(IS_NOT_IN_LIST).toString());
            }
            if (conditionMessageFormats.containsKey(IS_LESS_THAN)) {
                filterObjectFactory.IS_LESS_THAN.setConditionMessageFormat(conditionMessageFormats.get(IS_LESS_THAN).toString());
            }
            if (conditionMessageFormats.containsKey(IS_LESS_THAN_OR_EQUAL)) {
                filterObjectFactory.IS_LESS_THAN_OR_EQUAL.setConditionMessageFormat(conditionMessageFormats.get(IS_LESS_THAN_OR_EQUAL).toString());
            }
            if (conditionMessageFormats.containsKey(IS_GREATER_THAN)) {
                filterObjectFactory.IS_GREATER_THAN.setConditionMessageFormat(conditionMessageFormats.get(IS_GREATER_THAN).toString());
            }
            if (conditionMessageFormats.containsKey(IS_GREATER_THAN_OR_EQUAL)) {
                filterObjectFactory.IS_GREATER_THAN_OR_EQUAL.setConditionMessageFormat(conditionMessageFormats.get(IS_GREATER_THAN_OR_EQUAL).toString());
            }
            if (conditionMessageFormats.containsKey(IS_BEFORE)) {
                filterObjectFactory.IS_BEFORE.setConditionMessageFormat(conditionMessageFormats.get(IS_BEFORE).toString());
            }
            if (conditionMessageFormats.containsKey(IS_BEFORE_OR_EQUAL)) {
                filterObjectFactory.IS_BEFORE_OR_EQUAL.setConditionMessageFormat(conditionMessageFormats.get(IS_BEFORE_OR_EQUAL).toString());
            }
            if (conditionMessageFormats.containsKey(IS_AFTER)) {
                filterObjectFactory.IS_AFTER.setConditionMessageFormat(conditionMessageFormats.get(IS_AFTER).toString());
            }
            if (conditionMessageFormats.containsKey(IS_AFTER_OR_EQUAL)) {
                filterObjectFactory.IS_AFTER_OR_EQUAL.setConditionMessageFormat(conditionMessageFormats.get(IS_AFTER_OR_EQUAL).toString());
            }
            if (conditionMessageFormats.containsKey(IS_BETWEEN)) {
                filterObjectFactory.IS_BETWEEN.setConditionMessageFormat(conditionMessageFormats.get(IS_BETWEEN).toString());
            }
            if (conditionMessageFormats.containsKey(IS_NOT_BETWEEN)) {
                filterObjectFactory.IS_NOT_BETWEEN.setConditionMessageFormat(conditionMessageFormats.get(IS_NOT_BETWEEN).toString());
            }
            if (conditionMessageFormats.containsKey(IS_NULL)) {
                filterObjectFactory.IS_NULL.setConditionMessageFormat(conditionMessageFormats.get(IS_NULL).toString());
            }
            if (conditionMessageFormats.containsKey(IS_NOT_NULL)) {
                filterObjectFactory.IS_NOT_NULL.setConditionMessageFormat(conditionMessageFormats.get(IS_NOT_NULL).toString());
            }
            if (conditionMessageFormats.containsKey(CONTAINS)) {
                filterObjectFactory.CONTAINS.setConditionMessageFormat(conditionMessageFormats.get(CONTAINS).toString());
                filterObjectFactory.ALT_CONTAINS.setConditionMessageFormat(conditionMessageFormats.get(CONTAINS).toString());
            }
            if (conditionMessageFormats.containsKey(DOES_NOT_CONTAIN)) {
                filterObjectFactory.DOES_NOT_CONTAIN.setConditionMessageFormat(conditionMessageFormats.get(DOES_NOT_CONTAIN).toString());
                filterObjectFactory.ALT_NOT_CONTAINS.setConditionMessageFormat(conditionMessageFormats.get(DOES_NOT_CONTAIN).toString());
            }
            if (conditionMessageFormats.containsKey(LIKE)) {
                filterObjectFactory.LIKE.setConditionMessageFormat(conditionMessageFormats.get(LIKE).toString());
                filterObjectFactory.ALT_LIKE.setConditionMessageFormat(conditionMessageFormats.get(LIKE).toString());
            }
            if (conditionMessageFormats.containsKey(NOT_LIKE)) {
                filterObjectFactory.ALT_NOT_LIKE.setConditionMessageFormat(conditionMessageFormats.get(NOT_LIKE).toString());
            }
            if (conditionMessageFormats.containsKey(IS_NOT_IN_LIST_OR_EQUAL_TO)) {
                filterObjectFactory.IS_NOT_IN_LIST_OR_EQUAL_TO.setConditionMessageFormat(conditionMessageFormats.get(IS_NOT_IN_LIST_OR_EQUAL_TO).toString());
            }
            if (conditionMessageFormats.containsKey(IS_IN_LIST_OR_EQUAL_TO)) {
                filterObjectFactory.IS_IN_LIST_OR_EQUAL_TO.setConditionMessageFormat(conditionMessageFormats.get(IS_IN_LIST_OR_EQUAL_TO).toString());
            }
        }
    }

    private static String getFormattedExpressionString(List expressionList, int outputType, int startSelection, int endSelection, Map spanInfoMap, boolean wrapText) {
        Object s;
        int indent;
        Map endMap;
        int endIndent;
        Map startMap;
        int startIndent;
        String newline;
        String space;
        if (expressionList == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (outputType == 0) {
            space = NBSPACE;
            newline = Util.HTML_BREAK;
        } else {
            space = Util.TEXT_SPACE;
            newline = Util.TEXT_NEWLINE;
        }
        int max = expressionList.size() - 1;
        int start = startSelection;
        int end = endSelection;
        if (start < 0) {
            start = 0;
        }
        if (start > max) {
            start = max;
        }
        if (end < 0) {
            end = max;
        }
        if (end > max) {
            end = max;
        }
        if (start > end) {
            int swap = start;
            start = end;
            end = swap;
        }
        if ((startIndent = ((Integer)(startMap = (Map)expressionList.get(start)).get("Nest")).intValue()) > 0) {
            while (start > 0) {
                if ((startIndent = ((Integer)(startMap = (Map)expressionList.get(--start)).get("Nest")).intValue()) != 0) continue;
                ++start;
                break;
            }
        }
        if ((endIndent = ((Integer)(endMap = (Map)expressionList.get(end)).get("Nest")).intValue()) > 0) {
            while (end < max) {
                if ((endIndent = ((Integer)(endMap = (Map)expressionList.get(++end)).get("Nest")).intValue()) != 0) continue;
                --end;
                break;
            }
        }
        int prevIndent = 0;
        for (int i = start; i < end; ++i) {
            Object s2;
            int indent2;
            Map currentFilter = (Map)expressionList.get(i);
            int currentIndent = (Integer)currentFilter.get("Nest");
            int n = indent2 = currentIndent > prevIndent ? prevIndent : currentIndent;
            if (!wrapText) {
                for (int j = 0; j < indent2; ++j) {
                    sb.append(space);
                    sb.append(space);
                }
            }
            boolean addSpan = false;
            if (spanInfoMap != null && spanInfoMap.containsKey(FILTER_TEXT_SPAN) && (s2 = spanInfoMap.get(FILTER_TEXT_SPAN)) instanceof String && ((String)s2).length() > 0) {
                addSpan = true;
                sb.append(START_SPAN_BEGIN).append(s2).append(START_SPAN_END);
            }
            String expText = (String)currentFilter.get("Text");
            if (outputType == 0) {
                expText = AppliedFiltersUtil.replaceSpecialChars(expText);
            }
            sb.append(expText.trim());
            if (addSpan) {
                sb.append(END_SPAN);
                addSpan = false;
            }
            if (!wrapText) {
                sb.append(newline);
            }
            if (i <= end - 1) {
                Object s3;
                Map nextFilter = (Map)expressionList.get(i + 1);
                int nextIndent = (Integer)nextFilter.get("Nest");
                int n2 = indent2 = currentIndent > nextIndent ? nextIndent : currentIndent;
                if (!wrapText) {
                    for (int j = 0; j < indent2; ++j) {
                        sb.append(space);
                        sb.append(space);
                    }
                } else {
                    sb.append(space);
                }
                addSpan = false;
                if (spanInfoMap != null && spanInfoMap.containsKey(LOGICAL_OPERATOR_SPAN) && (s3 = spanInfoMap.get(LOGICAL_OPERATOR_SPAN)) instanceof String && ((String)s3).length() > 0) {
                    addSpan = true;
                    sb.append(START_SPAN_BEGIN).append(s3).append(START_SPAN_END);
                }
                sb.append((String)currentFilter.get("Cond"));
                if (addSpan) {
                    sb.append(END_SPAN);
                    addSpan = false;
                }
                if (!wrapText) {
                    sb.append(newline);
                } else {
                    sb.append(space);
                }
            }
            prevIndent = currentIndent;
        }
        Map lastFilter = (Map)expressionList.get(end);
        int lastIndent = (Integer)lastFilter.get("Nest");
        int n = indent = lastIndent > prevIndent ? prevIndent : lastIndent;
        if (!wrapText) {
            for (int j = 0; j < indent; ++j) {
                sb.append(space);
                sb.append(space);
            }
        }
        boolean addSpan = false;
        if (spanInfoMap != null && spanInfoMap.containsKey(FILTER_TEXT_SPAN) && (s = spanInfoMap.get(FILTER_TEXT_SPAN)) instanceof String && ((String)s).length() > 0) {
            addSpan = true;
            sb.append(START_SPAN_BEGIN).append(s).append(START_SPAN_END);
        }
        String lastExpText = (String)lastFilter.get("Text");
        if (outputType == 0) {
            lastExpText = AppliedFiltersUtil.replaceSpecialChars(lastExpText);
        }
        sb.append(lastExpText);
        if (addSpan) {
            sb.append(END_SPAN);
        }
        return sb.toString();
    }

    private static String replaceSpecialChars(String inputString) {
        return Strings.replace((String)inputString, (int)0, (int)(inputString.length() - 1), (String)"  ", (String)NBSPACE);
    }
}

