/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.iquery;

import com.sas.beans.Util;
import com.sas.entities.EntityInterface;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.OfflineResultSetConfiguration;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.intelligentquery.QueryConnectionInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.storage.iquery.RB;
import com.sas.storage.jdbc.JDBCAdapter;
import com.sas.table.FormattedDataReturnedInterface;
import com.sas.util.transforms.DisplayTransformInterface;
import com.sas.util.transforms.TransformInterface;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class BusinessQueryAdapter
implements DisplayTransformInterface,
BusinessQueryProviderInterface,
FormattedDataReturnedInterface {
    public static final String RB_KEY = "BusinessQueryAdapter.";
    protected boolean initialized;
    protected BusinessQuery businessQueryModel;
    protected JDBCAdapter delegateAdapter;
    protected boolean designTime = Util.isDesignTime();
    protected SwingPropertyChangeSupport spcs = new SwingPropertyChangeSupport(this);
    protected QueryConnectionInterface connector;
    protected boolean readOnly;
    protected TransformInterface displayTransform;
    protected boolean autoCommit;
    protected boolean resultSetRequeryUsed;
    protected boolean trimUsed;
    protected boolean printWarnings;
    protected EntityInterface entity;
    protected boolean formattedDataReturned;
    protected ResultSetInterface iqResultSet;
    protected RetrievalPolicy retrievalPolicy;
    protected boolean retrieveNumericTypesAsDouble;
    protected boolean isRefreshingBusinessQuery;

    public BusinessQueryAdapter() {
        this(null, null);
    }

    public BusinessQueryAdapter(BusinessQuery businessQuery) {
        this(businessQuery, null);
    }

    public BusinessQueryAdapter(BusinessQuery businessQuery, QueryConnectionInterface queryConnector) {
        this.businessQueryModel = businessQuery;
        this.connector = queryConnector == null ? new QueryConnector() : queryConnector;
        this.autoCommit = true;
        this.resultSetRequeryUsed = true;
        this.readOnly = true;
        this.formattedDataReturned = true;
        this.retrieveNumericTypesAsDouble = true;
        this.isRefreshingBusinessQuery = false;
    }

    public BusinessQueryAdapter(BusinessQuery businessQuery, QueryConnectorInterface queryConnector, RetrievalPolicy retrievalPolicy) {
        this(businessQuery, (QueryConnectionInterface)queryConnector);
        this.retrievalPolicy = retrievalPolicy;
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        if (this.businessQueryModel == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "modelNull.ex.txt"));
        }
        try {
            String modelID;
            if (this.iqResultSet != null) {
                this.iqResultSet.close();
            }
            if ((modelID = this.businessQueryModel.getID()) == null) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "modelIDNull.ex.txt"));
            }
            boolean returnUnformattedProperty = this.businessQueryModel.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
            if (returnUnformattedProperty != !this.isFormattedDataReturned()) {
                this.businessQueryModel.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, !this.isFormattedDataReturned());
            }
            ArrayList<BusinessQuery> selectionList = new ArrayList<BusinessQuery>();
            selectionList.add(this.businessQueryModel);
            Map results = null;
            results = this.connector instanceof QueryConnectorInterface && this.retrievalPolicy != null ? ((QueryConnectorInterface)this.connector).retrieveQueryResultMap(selectionList, this.retrievalPolicy) : this.connector.retrieveQueryResultMap(selectionList);
            this.iqResultSet = (ResultSetInterface)results.get(modelID);
            Object resultSet = this.iqResultSet.getResultSet();
            if (!(resultSet instanceof ResultSet)) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalModel.ex.txt"));
            }
            this.delegateAdapter = this.createDelegateAdapter((ResultSet)resultSet);
            this.initializeAdapterProperties(this.delegateAdapter);
            this.initialized = true;
        }
        catch (Exception e) {
            this.initialized = false;
            IllegalStateException ise = new IllegalStateException(RB.getStringResource(RB_KEY, "resultSetGeneration.ex.txt"));
            ise.initCause(e);
            throw ise;
        }
    }

    protected void initializeAdapterProperties(JDBCAdapter delegateAdapter) {
        if (this.displayTransform != null) {
            delegateAdapter.setDisplayTransform(this.displayTransform);
        }
        delegateAdapter.setReadOnly(this.readOnly);
        delegateAdapter.setAutoCommit(this.autoCommit);
        delegateAdapter.setTrimUsed(this.trimUsed);
        delegateAdapter.setRetrieveNumericTypesAsDouble(this.retrieveNumericTypesAsDouble);
        delegateAdapter.setPrintWarnings(this.printWarnings);
    }

    public void setFormattedDataReturned(boolean formattedDataReturned) {
        if (this.formattedDataReturned != formattedDataReturned) {
            this.formattedDataReturned = formattedDataReturned;
            if (this.initialized) {
                this.initialized = false;
                this.init();
                this.fireModelEvent();
            }
            this.spcs.firePropertyChange("formattedDataReturned", formattedDataReturned ? Boolean.FALSE : Boolean.TRUE, formattedDataReturned ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isFormattedDataReturned() {
        return this.formattedDataReturned;
    }

    public void setRetrieveNumericTypesAsDouble(boolean retrieveAsDouble) {
        if (this.retrieveNumericTypesAsDouble != retrieveAsDouble) {
            this.retrieveNumericTypesAsDouble = retrieveAsDouble;
            if (this.initialized) {
                this.delegateAdapter.setRetrieveNumericTypesAsDouble(this.retrieveNumericTypesAsDouble);
                this.fireModelEvent();
            }
            this.spcs.firePropertyChange("retrieveNumericTypesAsDouble", this.retrieveNumericTypesAsDouble ? Boolean.FALSE : Boolean.TRUE, this.retrieveNumericTypesAsDouble ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isRetrieveNumericTypesAsDouble() {
        return this.retrieveNumericTypesAsDouble;
    }

    protected abstract JDBCAdapter createDelegateAdapter(ResultSet var1);

    public boolean isReadOnly() {
        if (this.initialized) {
            return this.delegateAdapter.isReadOnly();
        }
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.readOnly != readOnly) {
            this.readOnly = readOnly;
            if (this.initialized) {
                this.delegateAdapter.setReadOnly(readOnly);
            }
            this.spcs.firePropertyChange("readOnly", readOnly ? Boolean.FALSE : Boolean.TRUE, readOnly ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        boolean oldCommit = this.isAutoCommit();
        if (oldCommit != autoCommit) {
            this.autoCommit = autoCommit;
            if (this.initialized) {
                this.delegateAdapter.setAutoCommit(autoCommit);
            }
            this.spcs.firePropertyChange("autoCommit", autoCommit ? Boolean.FALSE : Boolean.TRUE, autoCommit ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public BusinessQuery getModel() {
        return this.businessQueryModel;
    }

    public void setModel(BusinessQuery businessQuery) {
        BusinessQuery oldModel = this.getModel();
        if (oldModel != businessQuery) {
            this.businessQueryModel = businessQuery;
            if (!this.isRefreshingBusinessQuery) {
                this.initialized = false;
                this.fireModelEvent();
            }
            this.spcs.firePropertyChange("model", oldModel, businessQuery);
        }
    }

    public boolean isResultSetRequeryUsed() {
        if (!this.designTime) {
            this.init();
            return this.delegateAdapter.isResultSetRequeryUsed();
        }
        return this.resultSetRequeryUsed;
    }

    public void setResultSetRequeryUsed(boolean resultSetRequeryUsed) {
        boolean oldRequery = this.isResultSetRequeryUsed();
        if (oldRequery != resultSetRequeryUsed) {
            if (!this.designTime) {
                this.init();
                this.delegateAdapter.setResultSetRequeryUsed(resultSetRequeryUsed);
            }
            this.resultSetRequeryUsed = resultSetRequeryUsed;
            this.spcs.firePropertyChange("resultSetRequeryUsed", resultSetRequeryUsed ? Boolean.FALSE : Boolean.TRUE, resultSetRequeryUsed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isTrimUsed() {
        return this.trimUsed;
    }

    public void setTrimUsed(boolean trimUsed) {
        boolean oldTrimUsed = this.isTrimUsed();
        if (!oldTrimUsed == trimUsed) {
            this.trimUsed = trimUsed;
            if (this.initialized) {
                this.delegateAdapter.setTrimUsed(trimUsed);
                this.fireModelEvent();
            }
            this.spcs.firePropertyChange("trimUsed", trimUsed ? Boolean.FALSE : Boolean.TRUE, trimUsed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public void setDisplayTransform(TransformInterface newTransform) {
        TransformInterface oldTransform = this.getDisplayTransform();
        if (oldTransform != newTransform) {
            this.displayTransform = newTransform;
            if (!this.designTime) {
                this.init();
                this.delegateAdapter.setDisplayTransform(newTransform);
            }
            this.spcs.firePropertyChange("displayTransform", oldTransform, newTransform);
        }
    }

    public boolean isPrintWarnings() {
        return this.printWarnings;
    }

    public void setPrintWarnings(boolean printWarnings) {
        boolean oldWarnings = this.isPrintWarnings();
        if (oldWarnings != printWarnings) {
            this.printWarnings = printWarnings;
            if (this.initialized) {
                this.delegateAdapter.setPrintWarnings(printWarnings);
            }
            this.spcs.firePropertyChange("printWarnings", printWarnings ? Boolean.FALSE : Boolean.TRUE, printWarnings ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setEntity(EntityInterface entity) {
        EntityInterface oldEntity = this.getEntity();
        if (oldEntity != entity) {
            this.entity = entity;
            this.initialized = false;
            this.spcs.firePropertyChange("entity", oldEntity, entity);
            this.fireModelEvent();
        }
    }

    public EntityInterface getEntity() {
        return this.entity;
    }

    public void refresh() {
        this.initialized = false;
        this.init();
        this.fireModelEvent();
    }

    public BusinessQuery getBusinessQuery() {
        return this.getModel();
    }

    public void refreshBusinessQuery(BusinessQuery businessQuery) throws IntelligentQueryException {
        this.setModel(businessQuery);
        this.initialized = false;
        this.init();
        this.fireModelEvent();
    }

    public ResultSetInterface getResultSetInterface() {
        this.init();
        return this.iqResultSet;
    }

    public void close() throws ExecutionException {
        try {
            if (this.iqResultSet != null) {
                if (this.connector != null && this.connector instanceof QueryConnectorInterface) {
                    ((QueryConnectorInterface)this.connector).closeResult(this.iqResultSet);
                } else {
                    this.iqResultSet.close();
                }
                this.initialized = false;
            }
        }
        catch (DataRetrievalException de) {
            throw new ExecutionException((Throwable)de, "");
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(propertyName, listener);
    }

    protected abstract void fireModelEvent();

    public boolean isOfflineResultSetsEnabled() {
        OfflineResultSetConfiguration offlineResultSetConfiguration;
        boolean isOfflineResultSetsEnabled = false;
        RetrievalPolicy retrievalPolicy = this.retrievalPolicy;
        if (retrievalPolicy == null && this.connector instanceof QueryConnectorInterface) {
            retrievalPolicy = ((QueryConnectorInterface)this.connector).getRetrievalPolicy();
        }
        if (retrievalPolicy != null && (offlineResultSetConfiguration = retrievalPolicy.getOfflineResultSetConfiguration()) != null) {
            isOfflineResultSetsEnabled = offlineResultSetConfiguration.isOfflineResultSetsEnabled();
        }
        return isOfflineResultSetsEnabled;
    }

    public QueryConnectionInterface getQueryConnector() {
        return this.connector;
    }
}

