/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.workspace;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdLibGenInterface;
import com.sas.metadata.remote.MdModelUtil;
import com.sas.metadata.remote.SASLibrary;
import com.sas.models.CacheException;
import com.sas.models.SequentialCache;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicListSearchInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.util.iquery.PromptIQueryUtil;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.valueprovider.dynamic.workspace.RB;
import com.sas.rio.MVAConnection;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.metadata.ColumnAttributes;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.PhysicalTableAttributes;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.simplesqlmodel.ColumnInfo;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueType;
import com.sas.storage.valueprovider.workspace.ColumnValueProvider;
import com.sas.text.SASFormat;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import org.omg.CORBA.Object;
import org.w3c.dom.Element;

public class PromptColumnValueProvider
extends ColumnValueProvider
implements DynamicValueProviderInterface,
DynamicListSearchInterface {
    private static final long serialVersionUID = -9180225292929874614L;
    private String tableUrl;
    private String logicalServerName;
    private boolean isFormatResolved;
    private String resolvedLabelFormat;
    private String resolvedValueFormat;
    private ConnectionInterface _factoryConnection;
    private IWorkspace _workspace;
    private PhysicalTableInterface physicalTable;

    public PromptColumnValueProvider() {
    }

    public PromptColumnValueProvider(Connection connection) {
        super(connection);
        this.isUserConnection = true;
        this.setThreshold(DataProviderUtil.DEFAULT_RELATIONAL_THRESHOLD);
    }

    public PromptColumnValueProvider(String sbipUrl) {
        this.setTableUrl(sbipUrl);
        this.setThreshold(DataProviderUtil.DEFAULT_RELATIONAL_THRESHOLD);
    }

    public String getTableUrl() {
        return this.tableUrl;
    }

    public void setTableUrl(String sbipUrl) {
        String tempTableUrl = PersistHelper.parseSBIPUrl((String)sbipUrl);
        String oldValue = this.tableUrl;
        if (Util.unequal((java.lang.Object)tempTableUrl, (java.lang.Object)this.tableUrl)) {
            this.tableUrl = tempTableUrl;
            this.getLogger2().debug("setTableUrl()", this.tableUrl);
            this.propertyChangeSupport.firePropertyChange("sbipUrl", oldValue, tempTableUrl);
            if (!this.isUserConnection) {
                this.closeConnections();
            }
        }
    }

    public void setLogicalServerName(String logicalServerName) {
        this.logicalServerName = logicalServerName;
    }

    public String getLogicalServerName() {
        return this.logicalServerName;
    }

    public String getDefinitionElementName() {
        return "PromptColumnValueProvider";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        if (this.labelDataType == null) {
            try {
                this.setConnection(dynamicPromptValueContext, locale);
                this.labelDataType = this.findDataType(locale, this.getSearchColumn());
                this.getLogger2().debug("getDataType:DataType=" + this.labelDataType);
            }
            catch (ServerConnectionException se) {
                this.getLogger2().warn("Cannot resolve data type");
            }
            catch (ValueProviderException se) {
                this.getLogger2().warn("Cannot resolve data type");
            }
            finally {
                if (!this.isUserConnection) {
                    this.closeConnections();
                }
            }
        }
        return this.labelDataType == null ? false : this.labelDataType instanceof StringType;
    }

    public DataTypeInterface getDataType(DynamicPromptValueContextInterface dynamicContext) throws ValueProviderException {
        if (this.valueDataType == null) {
            try {
                this.setConnection(dynamicContext, Locale.getDefault());
                this.valueDataType = this.findDataType(Locale.getDefault(), this.getValueColumn());
                this.getLogger2().debug("getDataType:DataType=" + this.valueDataType);
            }
            catch (ServerConnectionException se) {
                this.getLogger2().warn("Cannot resolve data type");
            }
            catch (ValueProviderException se) {
                this.getLogger2().warn("Cannot resolve data type");
            }
            finally {
                if (!this.isUserConnection) {
                    this.closeConnections();
                }
            }
        }
        return this.valueDataType;
    }

    private DataTypeInterface findDataType(Locale locale, ColumnInfo searchColumn) throws ValueProviderException {
        DataTypeInterface searchDataType = null;
        if (this.physicalTable != null) {
            try {
                List cols = this.physicalTable.getColumns();
                for (ColumnInterface col : cols) {
                    ColumnAttributes ca;
                    if (!Strings.equal((String)col.getName(), (String)searchColumn.getName(), (boolean)true, (boolean)true) && !Strings.equal((String)(this.physicalTable.getName() + "." + col.getName()), (String)searchColumn.getName(), (boolean)true, (boolean)true) || (ca = col.getColumnAttributes()) == null) continue;
                    String ct = ca.getSasColumnType();
                    String format = ca.getSasFormat();
                    long columnType = -1L;
                    if (ct.equals("C")) {
                        searchDataType = StringType.DEFAULT_INSTANCE;
                        continue;
                    }
                    if (!ct.equals("N")) continue;
                    SASFormat sasFormat = null;
                    if (format != null && format.length() > 0) {
                        sasFormat = SASFormat.getInstance((String)format, (Locale)locale);
                    }
                    if (sasFormat != null && sasFormat.isDateFormat()) {
                        searchDataType = DateType.DEFAULT_INSTANCE;
                        continue;
                    }
                    if (sasFormat != null && sasFormat.isTimeFormat()) {
                        searchDataType = TimeType.DEFAULT_INSTANCE;
                        continue;
                    }
                    if (sasFormat != null && sasFormat.isDateTimeFormat()) {
                        searchDataType = TimeStampType.DEFAULT_INSTANCE;
                        continue;
                    }
                    searchDataType = IntegerType.DEFAULT_INSTANCE;
                }
            }
            catch (RemoteException e) {
                searchDataType = null;
            }
            catch (ServiceException e) {
                searchDataType = null;
            }
        }
        if (searchDataType == null) {
            searchDataType = super.findDataType(searchColumn);
        }
        return searchDataType;
    }

    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) {
        OperandInterface op;
        ArrayList<PromptDefinitionInterface> dependentPrompts = new ArrayList<PromptDefinitionInterface>();
        if (this.whereClause != null && (op = this.whereClause.getCondition()) instanceof Expression) {
            PromptIQueryUtil.promptsFromExpression((Expression)op, dependentPrompts);
        }
        return dependentPrompts;
    }

    private boolean isAllDependentPromptValuesSet(DynamicPromptValueContextInterface dynamicPromptValueContext, Locale locale) {
        Collection dependentPrompts = this.getDependentPrompts(locale, dynamicPromptValueContext);
        if (dependentPrompts == null || dependentPrompts.isEmpty()) {
            return true;
        }
        if (dynamicPromptValueContext == null || dynamicPromptValueContext.getPromptValues() == null) {
            return false;
        }
        PromptValuesInterface promptValues = dynamicPromptValueContext.getPromptValues();
        Iterator iter = dependentPrompts.iterator();
        while (iter.hasNext()) {
            PromptDefinitionInterface dependentPrompt = null;
            java.lang.Object obj = iter.next();
            dependentPrompt = obj instanceof String ? promptValues.getPromptDefinition((String)obj, true) : (PromptDefinitionInterface)obj;
            if (dependentPrompt == null || promptValues.isPromptValueAvailable(dependentPrompt)) continue;
            return false;
        }
        return true;
    }

    public java.lang.Object getValues(Locale locale) throws ValueProviderException {
        return this.getValues(locale, null, null, ValueType.LIST, 0, this.getThreshold());
    }

    public java.lang.Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, null, ValueType.LIST, index, count);
    }

    public java.lang.Object getValues(Locale locale, SearchCriteria searchCriterion) throws ValueProviderException {
        return this.getValues(locale, null, null, searchCriterion, 0, this.getThreshold());
    }

    public java.lang.Object getValues(Locale locale, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, null, searchCriteria, index, count);
    }

    public java.lang.Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, null, returnType, index, count);
    }

    public java.lang.Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, null, dynamicPromptValueContext, returnType, 0, this.getThreshold());
    }

    public java.lang.Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, dynamicPromptValueContext, returnType, index, count);
    }

    public java.lang.Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria) throws ValueProviderException {
        return this.getValues(locale, null, dynamicPromptValueContext, searchCriteria, 0, this.getThreshold());
    }

    public java.lang.Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, dynamicPromptValueContext, searchCriteria, index, count);
    }

    public java.lang.Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriterion, int index, int count) throws ValueProviderException {
        return this.getValuesAsList(locale, promptView, dynamicPromptValueContext, searchCriterion, index, count);
    }

    public java.lang.Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, promptView, dynamicPromptValueContext, returnType, 0, this.getThreshold());
    }

    public java.lang.Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, null, returnType);
    }

    public java.lang.Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        if (returnType == ValueType.TREE) {
            throw new ValueProviderException(RB.getStringResource("RelationalDataItemValueProvider.UnsupportedMethodError.log"));
        }
        return this.getValuesAsList(locale, promptView, dynamicPromptValueContext, null, index, count);
    }

    private Collection getValuesAsList(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        try {
            List<java.lang.Object> l;
            if (count == 0) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            PromptValuesInterface promptValues = this.populateDefinitionValueMap(promptView, dynamicPromptValueContext);
            if (promptValues == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            HashMap<String, PromptValuesInterface> context = new HashMap<String, PromptValuesInterface>(1);
            context.put("PROMPT_VALUES_OPERAND_CONTEXT", promptValues);
            this.setConnection(dynamicPromptValueContext, locale);
            String query = super.buildQuery(context, searchCriteria);
            int serverCount = this.getThreshold() < 0 ? this.getThreshold() : count;
            java.lang.Object[] values = super.getValuesFromServer(locale, query, index, serverCount);
            List<java.lang.Object> list = l = Arrays.asList(values);
            return list;
        }
        catch (SQLException se) {
            LoggerRepository2.getLogger((String)PromptColumnValueProvider.class.getName(), null).error(se.getMessage(), (Throwable)se);
            throw new ValueProviderException((Throwable)se, se.getMessage());
        }
        catch (InvalidPromptValueException me) {
            LoggerRepository2.getLogger((String)PromptColumnValueProvider.class.getName(), null).error(me.getMessage(), (Throwable)me);
            throw new ValueProviderException((Throwable)me, me.getMessage());
        }
        catch (CacheException ce) {
            LoggerRepository2.getLogger((String)PromptColumnValueProvider.class.getName(), null).error(ce.getMessage(), (Throwable)ce);
            throw new ValueProviderException((Throwable)ce, ce.getMessage());
        }
        catch (ServerConnectionException ce) {
            LoggerRepository2.getLogger((String)PromptColumnValueProvider.class.getName(), null).error(ce.getMessage(), (Throwable)ce);
            throw new ValueProviderException((Throwable)ce, ce.getMessage());
        }
        finally {
            if (!this.isUserConnection) {
                this.closeConnections();
            }
        }
    }

    PromptValuesInterface populateDefinitionValueMap(PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext) throws InvalidPromptValueException {
        PromptGroup promptGroup = new PromptGroup();
        PromptValues promptValues = new PromptValues((PromptGroupInterface)promptGroup);
        if (promptView == null && dynamicPromptValueContext != null) {
            if (!this.isAllDependentPromptValuesSet(dynamicPromptValueContext, Locale.getDefault())) {
                return null;
            }
            PromptValuesInterface pv = dynamicPromptValueContext.getPromptValues();
            if (pv != null) {
                promptValues = pv;
            }
        } else if (promptView != null && dynamicPromptValueContext != null) {
            if (!dynamicPromptValueContext.isValueSetForAllDependentPromptViews(promptView)) {
                return null;
            }
            Collection dpv = dynamicPromptValueContext.getDependentPromptViews(promptView);
            for (PromptViewInterface dependentPromptView : dpv) {
                promptValues.getPromptGroup().addPromptDefinition(dependentPromptView.getPromptDefinition());
                if (dependentPromptView.getPromptDefinition().isFixed()) continue;
                java.lang.Object obj = dependentPromptView.getPromptValue();
                promptValues.setPromptValue(dependentPromptView.getPromptDefinition(), obj);
            }
        }
        return promptValues;
    }

    protected void calculateThreshold(SequentialCache primaryCache, DynamicPromptValueContextInterface dyp) {
        Map thresholdMap;
        DataProviderInterface dp;
        int userThreshold = this.getThreshold();
        if (dyp != null && (dp = dyp.getDataProvider()) instanceof DataProvider && (thresholdMap = ((DataProvider)dp).getThresholdMap()) != null && thresholdMap.containsKey(DataProviderUtil.RELATIONAL_LIST_THRESHOLD)) {
            userThreshold = (Integer)thresholdMap.get(DataProviderUtil.RELATIONAL_LIST_THRESHOLD);
        }
        int maxCacheSize = userThreshold;
        int bufferLookAhead = userThreshold;
        try {
            primaryCache.configureCache(maxCacheSize, bufferLookAhead, -1, -1, -1);
        }
        catch (CacheException ce) {
            this.getLogger2().warn("Error trying to configure cache, default lookahed and size will be used");
        }
    }

    private void closeConnections() {
        try {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            try {
                if (this._workspace != null) {
                    this._workspace.Close();
                }
            }
            catch (GenericError e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            if (this._factoryConnection != null) {
                this._factoryConnection.close();
            }
        }
        finally {
            this._workspace = null;
            this.connection = null;
            this._factoryConnection = null;
        }
    }

    private void setConnection(DynamicPromptValueContextInterface dynamicPromptValueContext, Locale locale) throws ServerConnectionException, ValueProviderException {
        try {
            DataProviderInterface dataprovider;
            if (dynamicPromptValueContext != null && (this.connection == null || this.connection.isClosed()) && (dataprovider = dynamicPromptValueContext.getDataProvider()) != null) {
                if (!this.isEmpty(this.tableUrl)) {
                    String sasTableName;
                    this.physicalTable = ((DataProvider)dataprovider).getPhysicalTable(this.tableUrl);
                    SASLibraryInterface library = DataProviderUtil.getLibrary(this.physicalTable, locale);
                    this.setNeedQuoting(DataProviderUtil.needQuoting(this.physicalTable));
                    if (!this.isFormatResolved) {
                        this.resolveColumnFormats(this.physicalTable);
                    }
                    this.libref = library.getLibref();
                    this.tableName = this.physicalTable.getTableName();
                    PhysicalTableAttributes pa = this.physicalTable.getPhysicalTableAttributes();
                    if (pa != null && (sasTableName = pa.getSasTableName()) != null && sasTableName.length() > 0) {
                        this.tableName = sasTableName;
                    }
                    this.createMVAConnection((DataProvider)dataprovider, library, locale);
                } else if (!this.isEmpty(this.getLogicalServerName())) {
                    this.connection = (Connection)((DataProvider)dataprovider).getConnection(this.getLogicalServerName());
                }
            }
        }
        catch (ServiceException re) {
            this.getLogger2().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        catch (RemoteException re) {
            this.getLogger2().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        catch (SQLException re) {
            this.getLogger2().error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        catch (GenericError e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (ConnectionFactoryException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (MdException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
    }

    private void createMVAConnection(DataProvider dp, SASLibraryInterface library, Locale locale) throws ServerConnectionException, ServiceException, RemoteException, ConnectionFactoryException, MdException, GenericError, SQLException {
        this.createWorkspace(dp, library);
        Properties connectionProps = new Properties();
        if (!library.isPreassigned()) {
            String libname = this.getLibName(library, dp);
            try {
                this._workspace.LanguageService().Submit(libname);
            }
            catch (GenericError e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
                throw new ServerConnectionException((Throwable)e, e.getMessage());
            }
        }
        this.connection = new MVAConnection(this._workspace, connectionProps);
        if (null == this.connection) {
            String msg = MessageFormat.format(RB.getStringResource("DataProvider.noConnection.fmt", locale), library.getName());
            throw new ServerConnectionException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createWorkspace(DataProvider dp, SASLibraryInterface library) throws ServerConnectionException, ConnectionFactoryException, ServiceException, RemoteException {
        LogicalServerInterface ls;
        LogicalServerInterface logicalServerInterface = ls = dp.getLogicalServerForLibrary(library);
        synchronized (logicalServerInterface) {
            PlatformConnectionFactoryConfiguration config = PlatformConnectionFactoryConfiguration.createFactoryConfiguration((LogicalServerInterface)ls, (SessionContextInterface)dp.getUserContext().getSessionContext());
            PlatformConnectionFactoryInterface _factory = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)config);
            this._factoryConnection = _factory.getConnection(dp.getUserContext());
            Object obj = this._factoryConnection.getObject();
            this._workspace = IWorkspaceHelper.narrow((Object)obj);
        }
    }

    private String getLibName(SASLibraryInterface library, DataProvider dp) throws ServiceException, RemoteException, MdException {
        SASLibrary sl = (SASLibrary)library.getRepositoryEntity();
        MdLibGenInterface libUtil = MdModelUtil.getInstance((CredentialResolver)dp.getUserContext());
        String libname = libUtil.genLibname(sl);
        return libname;
    }

    protected String getLabelFormat() {
        String format = null;
        if (this.labelColumn != null) {
            format = this.resolvedLabelFormat != null ? this.resolvedLabelFormat : this.labelColumn.getFormat();
        }
        return format;
    }

    protected String getValueFormat() {
        String format = null;
        if (this.valueColumn != null) {
            format = this.resolvedValueFormat != null ? this.resolvedValueFormat : this.valueColumn.getFormat();
        }
        return format;
    }

    private void resolveColumnFormats(PhysicalTableInterface physicalTable) throws ServiceException, RemoteException, ValueProviderException {
        ColumnInterface vc;
        List columns = physicalTable.getColumns();
        ColumnInterface lc = null;
        if (this.labelColumn != null) {
            String columnName = this.labelColumn.getName();
            if (columnName == null || columnName.length() == 0) {
                columnName = this.valueColumn.getName();
            }
            if ((lc = this.getColumn(columns, columnName)) == null) {
                String msg = MessageFormat.format(RB.getStringResource("PromptColumnValueProvider.invalidColumnError.fmt"), columnName);
                throw new ValueProviderException(msg);
            }
        }
        if ((vc = this.getColumn(columns, this.valueColumn.getName())) == null) {
            String msg = MessageFormat.format(RB.getStringResource("PromptColumnValueProvider.invalidColumnError.fmt"), this.valueColumn.getName());
            throw new ValueProviderException(msg);
        }
        if (this.isFormatLabels() && this.labelColumn != null && this.labelColumn.getFormat().indexOf(ColumnInfo.DEFAULT_FORMAT) >= 0) {
            this.resolvedLabelFormat = this.getDefaultFormatFromMetadata(lc);
        }
        if (this.isFormatValues() && this.valueColumn.getFormat().indexOf(ColumnInfo.DEFAULT_FORMAT) >= 0) {
            this.resolvedValueFormat = this.getDefaultFormatFromMetadata(vc);
        }
        this.isFormatResolved = true;
    }

    private String getDefaultFormatFromMetadata(ColumnInterface c) throws ServiceException, RemoteException {
        ColumnAttributes ca = c.getColumnAttributes();
        String format = ca.getSasFormat();
        return format;
    }

    private ColumnInterface getColumn(List columns, String columnName) throws RemoteException {
        ColumnInterface mc = null;
        for (ColumnInterface c : columns) {
            if (!c.getName().equalsIgnoreCase(columnName)) continue;
            mc = c;
            break;
        }
        return mc;
    }

    public java.lang.Object clone() throws CloneNotSupportedException {
        PromptColumnValueProvider clone = (PromptColumnValueProvider)((java.lang.Object)super.clone());
        clone.tableUrl = this.tableUrl;
        clone.logicalServerName = this.logicalServerName;
        return clone;
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setTableUrl(PersistHelper.parseSBIPUrl((String)provider.consumeAttr("tableUrl")));
        this.getLogger2().debug("Running consumeAttributes().");
        this.setLogicalServerName(provider.consumeAttr("logicalServerName"));
        this.isFormatResolved = false;
        this.resolvedLabelFormat = null;
        this.resolvedValueFormat = null;
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr((Element)element, (String)"logicalServerName", (String)this.getLogicalServerName());
        if (null != this.getTableUrl()) {
            XmlUtil.setAttr((Element)element, (String)"tableUrl", (String)("URL::" + this.getTableUrl()));
        }
    }

    protected void writeMetadataDescriptor(PromptsWritingContext writingContext) {
        if (null != this.getTableUrl()) {
            this.getLogger2().debug("writing metadata descriptor for table URL");
            MetadataDescriptor md = PersistenceFactory.newMetadataDescriptor(null);
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("SBIP_URL", this.getTableUrl());
            md.setAdditionalInfo(info);
            md.setType("PHYSICAL_TABLE");
            writingContext.addMetadataDescriptor(md);
        }
    }
}

