/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.olap;

import com.sas.datatypes.DataTypeInterface;
import com.sas.iom.SASMDX.ISession;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.MemberValueValidatorInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.DynamicValueProviderConstants;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;
import com.sas.storage.olap.tree.MetadataTreeModel;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueType;
import com.sas.storage.valueprovider.olap.MemberValueProvider;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class PromptMemberValueProvider
extends MemberValueProvider
implements DynamicValueProviderInterface,
MemberValueValidatorInterface {
    private String logicalServerName;
    private String sbipUrl;

    public PromptMemberValueProvider() {
    }

    public PromptMemberValueProvider(String sbipUrl) {
        this.sbipUrl = sbipUrl;
    }

    public PromptMemberValueProvider(ISession isession) {
        super(isession);
    }

    public void setLogicalServerName(String logicalServername) {
        this.logicalServerName = logicalServername;
    }

    public String getLogicalServerName() {
        return this.logicalServerName;
    }

    public DataTypeInterface getDataType(DynamicPromptValueContextInterface dynamicContext) throws ValueProviderException {
        return this.getDataType();
    }

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return super.isSearchable();
    }

    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) {
        ArrayList dependentPrompts = new ArrayList();
        return dependentPrompts;
    }

    public int count(DynamicPromptValueContextInterface dynamicPromptValueContext) {
        return 0;
    }

    public boolean isValid(String memberName, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        boolean isValid;
        block16: {
            isValid = false;
            try {
                MetadataInterface m;
                if (this.uniqueHierarchyName == null && this.uniqueLevelName == null && this.uniqueMemberName == null) {
                    return isValid;
                }
                Metadata metadata = null;
                DataProviderInterface dataprovider = dynamicPromptValueContext.getDataProvider();
                if (this.sbipUrl != null && dataprovider instanceof PromptDataProviderInterface && (m = ((PromptDataProviderInterface)dataprovider).getPhysicalCube(this.sbipUrl)) != null) {
                    this.cubeName = m.getName();
                    LogicalServerInterface logicalServer = ((DataProvider)dataprovider).getOLAPServer(this.sbipUrl);
                    this.isession = (ISession)((DataProvider)dataprovider).getConnection(logicalServer);
                }
                if (this.isession != null) {
                    metadata = new Metadata(this.isession);
                }
                if (metadata == null) {
                    return false;
                }
                Filter inFilter = new Filter();
                inFilter.setCubeName(this.cubeName);
                if (memberName == null) break block16;
                inFilter.setUniqueMemberName(memberName);
                MemberInterface member = null;
                try {
                    member = metadata.getMembers(inFilter, 0, 1)[0];
                }
                catch (OLAPException oe) {
                    return isValid;
                }
                if (member.getUniqueName().equalsIgnoreCase(memberName)) {
                    LevelInterface level = member.getLevel();
                    if (level.getHierarchy().getUniqueName().equalsIgnoreCase(this.uniqueHierarchyName) || level.getHierarchy().getDimension().getUniqueName().equalsIgnoreCase(this.uniqueHierarchyName)) {
                        isValid = true;
                    } else if (level.getUniqueName().equalsIgnoreCase(this.uniqueLevelName)) {
                        isValid = true;
                    } else if (member.getUniqueName().equalsIgnoreCase(this.uniqueMemberName)) {
                        isValid = true;
                    }
                }
            }
            catch (ServerConnectionException se) {
                throw new ValueProviderException((Throwable)se, se.getMessage());
            }
            catch (OLAPException se) {
                throw new ValueProviderException((Throwable)se, se.getMessage());
            }
            catch (RemoteException se) {
                throw new ValueProviderException((Throwable)se, se.getMessage());
            }
        }
        return isValid;
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, null, dynamicPromptValueContext, returnType, null, 0, this.threshold);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria) throws ValueProviderException {
        return this.getValues(locale, null, dynamicPromptValueContext, ValueType.LIST, searchCriteria, 0, this.threshold);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, dynamicPromptValueContext, returnType, null, index, count);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, dynamicPromptValueContext, ValueType.LIST, searchCriteria, 0, this.threshold);
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, promptView, dynamicPromptValueContext, returnType, null, 0, this.threshold);
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, promptView, dynamicPromptValueContext, returnType, null, 0, this.threshold);
    }

    public boolean isValueDisplayed() {
        return false;
    }

    private Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        if (returnType == ValueType.LIST || searchCriteria != null) {
            return this.getValuesAsList(locale, promptView, dynamicPromptValueContext, searchCriteria, index, count);
        }
        if (returnType == ValueType.TREE) {
            return this.getValuesAsTree(locale, promptView, dynamicPromptValueContext);
        }
        Object returnObject = this.getValuesAsTree(locale, promptView, dynamicPromptValueContext);
        if (returnObject == null) {
            returnObject = this.getValuesAsList(locale, promptView, dynamicPromptValueContext, searchCriteria, index, count);
        }
        return returnObject;
    }

    private Object getValuesAsList(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        try {
            MetadataInterface m;
            if (promptView != null && !dynamicPromptValueContext.isValueSetForAllDependentPromptViews(promptView)) {
                return Collections.EMPTY_LIST;
            }
            DataProviderInterface dataprovider = dynamicPromptValueContext.getDataProvider();
            if (this.sbipUrl != null && dataprovider instanceof PromptDataProviderInterface && (m = ((PromptDataProviderInterface)dataprovider).getPhysicalCube(this.sbipUrl)) != null) {
                this.cubeName = m.getName();
                LogicalServerInterface logicalServer = ((DataProvider)dataprovider).getOLAPServer(this.sbipUrl);
                this.isession = (ISession)((DataProvider)dataprovider).getConnection(logicalServer);
            }
            return super.getValues(locale, searchCriteria, index, count);
        }
        catch (ServerConnectionException se) {
            throw new ValueProviderException((Throwable)se, se.getMessage());
        }
        catch (RemoteException se) {
            throw new ValueProviderException((Throwable)se, se.getMessage());
        }
    }

    private Object getValuesAsTree(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        try {
            MetadataInterface m;
            if (promptView != null && !dynamicPromptValueContext.isValueSetForAllDependentPromptViews(promptView)) {
                return new MetadataTreeModel(new MetadataEntityTreeNode(""));
            }
            DataProviderInterface dataprovider = dynamicPromptValueContext.getDataProvider();
            if (this.sbipUrl != null && dataprovider instanceof PromptDataProviderInterface && (m = ((PromptDataProviderInterface)dataprovider).getPhysicalCube(this.sbipUrl)) != null) {
                this.cubeName = m.getName();
                LogicalServerInterface logicalServer = ((DataProvider)dataprovider).getOLAPServer(this.sbipUrl);
                this.isession = (ISession)((DataProvider)dataprovider).getConnection(logicalServer);
            }
            Object treeModel = super.getValues(locale, ValueType.TREE);
            return treeModel;
        }
        catch (ServerConnectionException se) {
            throw new ValueProviderException((Throwable)se, null);
        }
        catch (RemoteException se) {
            throw new ValueProviderException((Throwable)se, null);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PromptMemberValueProvider clone = (PromptMemberValueProvider)((Object)super.clone());
        return clone;
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setLogicalServerName(provider.consumeAttr(DynamicValueProviderConstants.logicalServerName));
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr((Element)element, (String)DynamicValueProviderConstants.logicalServerName, (String)this.getLogicalServerName());
    }

    public String getDefinitionElementName() {
        return "PromptMemberValueProvider";
    }
}

