/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.jdbc;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueType;
import com.sas.storage.valueprovider.jdbc.JDBCValueProvider;
import com.sas.util.SimpleTemplate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class JDBCDynamicValueProvider
extends JDBCValueProvider
implements DynamicValueProviderInterface {
    private List values;

    public JDBCDynamicValueProvider() {
        this.query = null;
        this.values = null;
        this.lastExpandedQuery = null;
    }

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return false;
    }

    public DataTypeInterface getDataType(DynamicPromptValueContextInterface dynamicContext) {
        return StringType.DEFAULT_INSTANCE;
    }

    public int getNumberOfDynamicEntries(Locale locale) {
        return this.getDependentPrompts(locale, null).size();
    }

    public Collection getDependentPromptNames(Locale locale) {
        SimpleTemplate template = new SimpleTemplate(this.query);
        Map dependentNames = template.getNameDictionary();
        ArrayList dependentPrompts = new ArrayList();
        dependentPrompts.addAll(dependentNames.keySet());
        return dependentPrompts;
    }

    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) {
        SimpleTemplate template = new SimpleTemplate(this.query);
        Map dependentNames = template.getNameDictionary();
        ArrayList dependentPrompts = new ArrayList();
        dependentPrompts.addAll(dependentNames.keySet());
        return dependentPrompts;
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, null, 0, -1);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, null, index, count);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, searchCriteria, 0, -1);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, searchCriteria, 0, -1);
    }

    private Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        if (this.query == null || this.query.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        List labels = this.getChoiceLabels(dynamicPromptValueContext, searchCriteria, index, count);
        return labels;
    }

    private List getChoiceLabels(DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        if (this.query == null || this.query.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        this.values = this.getQueryResults(dynamicPromptValueContext, this.values, Locale.getDefault());
        ArrayList labels = new ArrayList();
        labels.addAll(this.values);
        return labels;
    }

    private boolean isAllDependentPromptValuesSet(DynamicPromptValueContextInterface dynamicPromptValueContext, Locale locale) {
        Collection dependentPromptNames = this.getDependentPrompts(locale, dynamicPromptValueContext);
        Object promptValues = null;
        Iterator iter = dependentPromptNames.iterator();
        while (iter.hasNext()) {
            if (promptValues == null) {
                return false;
            }
            String dependentPromptName = (String)iter.next();
            PromptDefinitionInterface pd = promptValues.getPromptDefinition(dependentPromptName, true);
            if (pd == null || promptValues.isPromptValueAvailable(pd)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getQueryResults(DynamicPromptValueContextInterface dynamicPromptValueContext, List values, Locale locale) {
        Connection connection = null;
        try {
            if (!this.isAllDependentPromptValuesSet(dynamicPromptValueContext, locale)) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            Map promptValues = new HashMap();
            SimpleTemplate template = new SimpleTemplate(this.query);
            String expandedQuery = template.format(promptValues = PromptUtil.convertMapToNameValueMap(promptValues));
            if (expandedQuery.equals(this.lastExpandedQuery) && values != null) {
                ArrayList<Object> arrayList = values;
                return arrayList;
            }
            this.lastExpandedQuery = expandedQuery;
            DataProviderInterface dataprovider = dynamicPromptValueContext.getDataProvider();
            if (connection == null) {
                connection = ((DataProvider)dataprovider).getJDBCConnection(this);
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(expandedQuery);
                values = new ArrayList();
                while (resultSet.next()) {
                    Object obj = resultSet.getObject(1);
                    values.add(obj);
                }
                statement.close();
            }
            ArrayList<Object> arrayList = values;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void configureProvider(Map configurationData) {
        String newQuery = (String)configurationData.get("QUERY");
        if (newQuery != null && !newQuery.equals(this.query)) {
            this.query = newQuery;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JDBCDynamicValueProvider clone = (JDBCDynamicValueProvider)((Object)super.clone());
        clone.values = this.values instanceof Vector ? (List)((Vector)this.values).clone() : this.values;
        return clone;
    }

    public String getDefinitionElementName() {
        return "JDBCDynamicValueProvider";
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return null;
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return null;
    }

    public Object getValues(Locale locale) throws ValueProviderException {
        return null;
    }

    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        return null;
    }

    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        return null;
    }

    public boolean isValueDisplayed() {
        return false;
    }
}

