/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.iq;

import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.prompts.definitions.BaseDefinitionRangeInterface;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.simplesqlmodel.PromptValueOperand;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.simplesqlmodel.ColumnOperand;
import com.sas.storage.simplesqlmodel.DoubleOperand;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.FormattedOperator;
import com.sas.storage.simplesqlmodel.IntegerOperand;
import com.sas.storage.simplesqlmodel.MultiValueFormattedOperator;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.OperatorInterface;
import com.sas.storage.simplesqlmodel.StringOperand;
import com.sas.storage.simplesqlmodel.WhereClause;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import java.util.ArrayList;
import java.util.List;

public class WhereToFilterUtil {
    static CommonLoggerInterface logger;

    private WhereToFilterUtil() {
    }

    private static CommonLoggerInterface getLogger() {
        if (null == logger) {
            logger = LoggerRepository2.getLogger((String)WhereToFilterUtil.class.getName(), null);
        }
        return logger;
    }

    public static ExpressionInterface[] convertWhereToFilterItemExpressions(WhereClause where, BusinessModel informationMap) throws ValueProviderException {
        OperandInterface whereOperands = where.getCondition();
        ExpressionInterface[] filterExpressions = new ExpressionInterface[]{};
        ArrayList<ExpressionInterface> expList = new ArrayList<ExpressionInterface>();
        if (whereOperands instanceof Expression) {
            List l = Expression.getListFromAndedExpression((Expression)((Expression)whereOperands), (LoggerFactoryInterface)new Log4JFactory2());
            int size = l.size();
            filterExpressions = new ExpressionInterface[1];
            for (int i = 0; i < size; ++i) {
                try {
                    expList.add(WhereToFilterUtil.convertWhereExpressionToFilterExpression((Expression)l.get(i), informationMap));
                    continue;
                }
                catch (ServerConnectionException se) {
                    throw new ValueProviderException((Throwable)se, se.getMessage());
                }
                catch (MetadataException se) {
                    throw new ValueProviderException((Throwable)se, se.getMessage());
                }
            }
        }
        MultipleConditionalExpression mce = new MultipleConditionalExpression();
        mce.setRelationType(ConditionalRelationType.AND);
        mce.setExpressionList(expList);
        filterExpressions[0] = mce;
        return filterExpressions;
    }

    public static ExpressionInterface convertWhereToFilterItemExpression(WhereClause where, BusinessModel informationMap) throws ValueProviderException {
        OperandInterface whereOperands = where.getCondition();
        ExpressionInterface filterExpression = null;
        if (whereOperands instanceof Expression) {
            try {
                filterExpression = WhereToFilterUtil.convertWhereExpressionToFilterExpression((Expression)whereOperands, informationMap);
            }
            catch (ServerConnectionException se) {
                throw new ValueProviderException((Throwable)se, se.getMessage());
            }
            catch (MetadataException se) {
                throw new ValueProviderException((Throwable)se, se.getMessage());
            }
        }
        return filterExpression;
    }

    private static ExpressionInterface convertWhereExpressionToFilterExpression(Expression whereExpression, BusinessModel informationMap) throws ServerConnectionException, MetadataException {
        ExpressionInterface filterExp = null;
        OperatorInterface operator = whereExpression.getOperator();
        filterExp = WhereToFilterUtil.convertOperatorToExpression(whereExpression, informationMap, filterExp, operator);
        return filterExp;
    }

    private static ExpressionInterface convertOperatorToExpression(Expression whereExpression, BusinessModel informationMap, ExpressionInterface filterExp, OperatorInterface operator) throws ServerConnectionException, MetadataException {
        if (operator instanceof MultiValueFormattedOperator) {
            MultiValueFormattedOperator mvo = (MultiValueFormattedOperator)operator;
            operator = mvo.getOperator();
            String combination = mvo.getCombination();
            if (operator instanceof MultiValueFormattedOperator) {
                filterExp = WhereToFilterUtil.convertOperatorToExpression(whereExpression, informationMap, filterExp, operator);
            }
        }
        if (operator instanceof FormattedOperator) {
            if (operator == FormattedOperator.BETWEEN_OPERATOR_EXCLUSIVE || operator == FormattedOperator.NOT_BETWEEN_OPERATOR || operator == FormattedOperator.BETWEEN_OPERATOR || operator == FormattedOperator.NOT_BETWEEN_OPERATOR_INCLUSIVE) {
                filterExp = WhereToFilterUtil.convertBetweenOperator(whereExpression, operator, informationMap);
            } else if (WhereToFilterUtil.isMultiSelectEqualOperator(operator, whereExpression)) {
                filterExp = WhereToFilterUtil.convertInOperator(whereExpression, informationMap);
            } else if (WhereToFilterUtil.isComparisonOperator(operator)) {
                filterExp = WhereToFilterUtil.convertComparisonOperator(whereExpression, informationMap);
            } else if (operator == FormattedOperator.CONTAINS_OPERATOR || operator == MultiValueFormattedOperator.CONTAINS_OPERATOR) {
                filterExp = WhereToFilterUtil.convertContainsOperator(whereExpression, informationMap);
            } else if (operator == FormattedOperator.IN_OPERATOR) {
                filterExp = WhereToFilterUtil.convertInOperator(whereExpression, informationMap);
            } else if (operator == FormattedOperator.LIKE_OPERATOR || operator == MultiValueFormattedOperator.LIKE_OPERATOR) {
                filterExp = WhereToFilterUtil.convertLikeOperator(whereExpression, informationMap);
            }
        }
        return filterExp;
    }

    private static boolean isMultiSelectEqualOperator(OperatorInterface comparisonOperator, Expression whereExpression) {
        PromptDefinitionInterface pd;
        OperandInterface op;
        List operands;
        int max_operands;
        boolean isEqual;
        boolean bl = isEqual = comparisonOperator == FormattedOperator.EQUAL_OPERATOR || comparisonOperator == MultiValueFormattedOperator.EQUAL_OPERATOR;
        if (isEqual && (max_operands = (operands = whereExpression.getOperands()).size()) == 2 && (op = (OperandInterface)operands.get(1)) instanceof PromptValueOperand && (pd = ((PromptValueOperand)op).getPromptDefinition()) instanceof SelectableDefinitionInterface) {
            isEqual = ((SelectableDefinitionInterface)pd).getSelectionType() == 301 || ((SelectableDefinitionInterface)pd).getSelectionType() == 302;
        }
        return isEqual;
    }

    private static boolean isComparisonOperator(OperatorInterface comparisonOperator) {
        return comparisonOperator == FormattedOperator.EQUAL_OPERATOR || comparisonOperator == FormattedOperator.NOT_EQUAL_OPERATOR || comparisonOperator == FormattedOperator.GREATER_THAN_EQUAL_OPERATOR || comparisonOperator == FormattedOperator.GREATER_THAN_OPERATOR || comparisonOperator == FormattedOperator.LESS_THAN_EQUAL_OPERATOR || comparisonOperator == FormattedOperator.LESS_THAN_OPERATOR || comparisonOperator == FormattedOperator.LESS_THAN_DATE_START_OPERATOR || comparisonOperator == FormattedOperator.GREATER_THAN_EQUAL_DATE_START_OPERATOR || comparisonOperator == FormattedOperator.LESS_THAN_EQUAL_DATE_END_OPERATOR || comparisonOperator == FormattedOperator.GREATER_THAN_DATE_END_OPERATOR || comparisonOperator == MultiValueFormattedOperator.EQUAL_OPERATOR || comparisonOperator == MultiValueFormattedOperator.NOT_EQUAL_OPERATOR || comparisonOperator == MultiValueFormattedOperator.GREATER_THAN_EQUAL_OPERATOR || comparisonOperator == MultiValueFormattedOperator.GREATER_THAN_OPERATOR || comparisonOperator == MultiValueFormattedOperator.LESS_THAN_EQUAL_OPERATOR || comparisonOperator == MultiValueFormattedOperator.LESS_THAN_OPERATOR;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static ExpressionInterface convertBetweenOperator(Expression whereExpression, OperatorInterface operator, BusinessModel informationMap) throws ServerConnectionException, MetadataException {
        SimpleConditionalExpression_Between betweenExp = new SimpleConditionalExpression_Between();
        List operands = whereExpression.getOperands();
        int max_operands = operands.size();
        for (int i = 0; i < max_operands; ++i) {
            OperandInterface op = (OperandInterface)operands.get(i);
            if (op instanceof ColumnOperand) {
                DataItemFormattingExpression diFormatRep;
                DataItemFormattingExpression whatToCompare = diFormatRep = WhereToFilterUtil.getDataItemExpressionFromColumn(informationMap, op);
                betweenExp.setWhatToCompare((ExpressionInterface)whatToCompare);
                continue;
            }
            if (!(op instanceof PromptValueOperand)) continue;
            PromptDefinitionInterface pd = ((PromptValueOperand)op).getPromptDefinition();
            if (pd instanceof BaseDefinitionRangeInterface || pd instanceof DateDefinitionInterface) {
                try {
                    Expression tempWhere = (Expression)whereExpression.clone();
                    tempWhere.setOperator(WhereToFilterUtil.convertRangeOperandToOperator(operator));
                    return WhereToFilterUtil.convertComparisonOperator(tempWhere, informationMap);
                }
                catch (CloneNotSupportedException ce) {
                    ce.printStackTrace();
                    continue;
                }
            }
            betweenExp.setLeftExpression(WhereToFilterUtil.convertOperandToExpression((OperandInterface)operands.get(1), informationMap));
            betweenExp.setRightExpression(WhereToFilterUtil.convertOperandToExpression((OperandInterface)operands.get(2), informationMap));
        }
        return betweenExp;
    }

    private static OperatorInterface convertRangeOperandToOperator(OperatorInterface operator) throws MetadataException {
        if (operator == FormattedOperator.BETWEEN_OPERATOR_EXCLUSIVE || operator == FormattedOperator.BETWEEN_OPERATOR) {
            return FormattedOperator.EQUAL_OPERATOR;
        }
        if (operator == FormattedOperator.NOT_BETWEEN_OPERATOR || operator == FormattedOperator.NOT_BETWEEN_OPERATOR_INCLUSIVE) {
            return FormattedOperator.NOT_EQUAL_OPERATOR;
        }
        return null;
    }

    private static ExpressionInterface convertContainsOperator(Expression whereExpression, BusinessModel informationMap) throws ServerConnectionException, MetadataException {
        SimpleConditionalExpression_Contains containsExp = new SimpleConditionalExpression_Contains();
        List operands = whereExpression.getOperands();
        int max_operands = 2;
        if (operands.size() != max_operands) {
            return null;
        }
        for (int i = 0; i < max_operands; ++i) {
            OperandInterface op = (OperandInterface)operands.get(i);
            if (op instanceof ColumnOperand) {
                DataItemFormattingExpression diFormatRep;
                DataItemFormattingExpression whatToCompare = diFormatRep = WhereToFilterUtil.getDataItemExpressionFromColumn(informationMap, op);
                containsExp.setWhatToCompare((ExpressionInterface)whatToCompare);
                continue;
            }
            containsExp.setWhatToContain(WhereToFilterUtil.convertOperandToExpression((OperandInterface)operands.get(1), informationMap));
        }
        return containsExp;
    }

    private static ExpressionInterface convertInOperator(Expression whereExpression, BusinessModel informationMap) throws ServerConnectionException, MetadataException {
        SimpleConditionalExpression_In inExp = new SimpleConditionalExpression_In();
        List operands = whereExpression.getOperands();
        int size = operands.size();
        ArrayList<ExpressionInterface> expList = new ArrayList<ExpressionInterface>(size);
        for (int i = 0; i < size; ++i) {
            OperandInterface op = (OperandInterface)operands.get(i);
            if (op instanceof ColumnOperand) {
                DataItemFormattingExpression diFormatRep;
                DataItemFormattingExpression whatToCompare = diFormatRep = WhereToFilterUtil.getDataItemExpressionFromColumn(informationMap, op);
                inExp.setWhatToCompare((ExpressionInterface)whatToCompare);
                continue;
            }
            expList.add(WhereToFilterUtil.convertOperandToExpression(op, informationMap));
            inExp.setComparisonList(expList);
        }
        return inExp;
    }

    private static ExpressionInterface convertLikeOperator(Expression whereExpression, BusinessModel informationMap) throws ServerConnectionException, MetadataException {
        SimpleConditionalExpression_Like likeExp = new SimpleConditionalExpression_Like();
        List operands = whereExpression.getOperands();
        int max_operands = 2;
        if (operands.size() != max_operands) {
            return null;
        }
        for (int i = 0; i < max_operands; ++i) {
            OperandInterface op = (OperandInterface)operands.get(i);
            if (op instanceof ColumnOperand) {
                DataItemFormattingExpression diFormatRep;
                DataItemFormattingExpression whatToCompare = diFormatRep = WhereToFilterUtil.getDataItemExpressionFromColumn(informationMap, op);
                likeExp.setWhatToCompare((ExpressionInterface)whatToCompare);
                continue;
            }
            likeExp.setPatternExpression(WhereToFilterUtil.convertOperandToExpression((OperandInterface)operands.get(1), informationMap));
        }
        return likeExp;
    }

    private static ExpressionInterface convertComparisonOperator(Expression whereExpression, BusinessModel informationMap) throws MetadataException, ServerConnectionException {
        SimpleConditionalExpression_Comparison comparisonExp = new SimpleConditionalExpression_Comparison();
        OperatorInterface operator = whereExpression.getOperator();
        comparisonExp.setComparisonOperator(WhereToFilterUtil.convertOperator(operator));
        List operands = whereExpression.getOperands();
        int max_operands = 2;
        if (operands.size() != max_operands) {
            return null;
        }
        for (int i = 0; i < max_operands; ++i) {
            OperandInterface op = (OperandInterface)operands.get(i);
            if (op instanceof ColumnOperand) {
                DataItemFormattingExpression diFormatRep;
                DataItemFormattingExpression whatToCompare = diFormatRep = WhereToFilterUtil.getDataItemExpressionFromColumn(informationMap, op);
                comparisonExp.setLeftExpression((ExpressionInterface)whatToCompare);
                continue;
            }
            comparisonExp.setRightExpression(WhereToFilterUtil.convertOperandToExpression(op, informationMap));
        }
        return comparisonExp;
    }

    private static DataItemFormattingExpression getDataItemExpressionFromColumn(BusinessModel informationMap, OperandInterface op) throws ServerConnectionException, MetadataException {
        DataItemFormattingExpression diFormatRep = new DataItemFormattingExpression();
        String dataItemId = ((ColumnOperand)op).getColumnName();
        DataItem di = WhereToFilterUtil.getDataItemFromId(informationMap, dataItemId);
        DataItemReference dataItemRef = null;
        if (di != null) {
            dataItemRef = informationMap.newDataItemReference(di);
            ExpressionInterface exp = dataItemRef.getExpression();
            if (exp.getExpressionType() == 2 && dataItemRef.getValidActions().contains(DataItemActionType.USAGE_DETAIL)) {
                dataItemRef.setUsage(DataItemActionType.USAGE_DETAIL);
            }
            informationMap.addBusinessItem((BusinessItem)dataItemRef);
        }
        diFormatRep.setDataItem(dataItemRef);
        diFormatRep.setIsFormatted(!WhereToFilterUtil.isEmpty(((ColumnOperand)op).getFormat()));
        return diFormatRep;
    }

    private static ComparisonOperator convertOperator(OperatorInterface operator) {
        if (operator == FormattedOperator.EQUAL_OPERATOR || operator == MultiValueFormattedOperator.EQUAL_OPERATOR || operator == MultiValueFormattedOperator.DATE_EQUAL_OPERATOR) {
            return ComparisonOperator.COMPARE_EQ;
        }
        if (operator == FormattedOperator.NOT_EQUAL_OPERATOR || operator == MultiValueFormattedOperator.NOT_EQUAL_OPERATOR || operator == MultiValueFormattedOperator.DATE_NOT_EQUAL_OPERATOR) {
            return ComparisonOperator.COMPARE_NEQ;
        }
        if (operator == FormattedOperator.GREATER_THAN_EQUAL_OPERATOR || operator == MultiValueFormattedOperator.GREATER_THAN_EQUAL_OPERATOR || operator == MultiValueFormattedOperator.DATE_GREATER_THAN_EQUAL_OPERATOR) {
            return ComparisonOperator.COMPARE_GE;
        }
        if (operator == FormattedOperator.GREATER_THAN_OPERATOR || operator == MultiValueFormattedOperator.GREATER_THAN_OPERATOR || operator == MultiValueFormattedOperator.DATE_GREATER_THAN_OPERATOR) {
            return ComparisonOperator.COMPARE_GT;
        }
        if (operator == FormattedOperator.LESS_THAN_EQUAL_OPERATOR || operator == MultiValueFormattedOperator.LESS_THAN_EQUAL_OPERATOR || operator == MultiValueFormattedOperator.DATE_LESS_THAN_EQUAL_OPERATOR) {
            return ComparisonOperator.COMPARE_LE;
        }
        if (operator == FormattedOperator.LESS_THAN_OPERATOR || operator == MultiValueFormattedOperator.LESS_THAN_OPERATOR || operator == MultiValueFormattedOperator.DATE_LESS_THAN_OPERATOR) {
            return ComparisonOperator.COMPARE_LT;
        }
        return null;
    }

    private static ExpressionInterface convertOperandToExpression(OperandInterface operand, BusinessModel informationMap) throws MetadataException {
        if (operand instanceof StringOperand) {
            ConstantExpression valueExpression = new ConstantExpression();
            valueExpression.setExpressionType(3);
            valueExpression.setValue(((StringOperand)operand).getValueAsString());
            return valueExpression;
        }
        if (operand instanceof IntegerOperand || operand instanceof DoubleOperand) {
            ConstantExpression valueExpression = new ConstantExpression();
            valueExpression.setExpressionType(2);
            valueExpression.setValue(((IntegerOperand)operand).getOperandAsString(null));
            return valueExpression;
        }
        if (operand instanceof PromptValueOperand) {
            PromptDefinitionInterface pd = ((PromptValueOperand)operand).getPromptDefinition();
            Prompt p = informationMap.newPrompt();
            p.setLabel(pd.getPromptName());
            p.setPromptDefinition(pd);
            informationMap.addBusinessItem((BusinessItem)p);
            return p;
        }
        return null;
    }

    private static DataItem getDataItemFromId(BusinessModel im, String dataItemName) throws ServerConnectionException {
        if (dataItemName != null) {
            List diList = im.getObjects(true, DataItem.class);
            for (DataItem di : diList) {
                try {
                    if (!di.getID().equals(dataItemName) && !di.getLabel().equals(dataItemName)) continue;
                    return di;
                }
                catch (InvalidIDException invalidIDException) {
                }
            }
        }
        return null;
    }
}

