/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.iq;

import com.sas.datatypes.DataTypeInterface;
import com.sas.prompts.DynamicListSearchInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.util.iquery.PromptIQueryUtil;
import com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.WhereClause;
import com.sas.storage.valueprovider.ListSearchInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.storage.vr.dto.DataSource;
import com.sas.storage.vr.dto.DynamicValueRetrieverConfiguration;
import com.sas.storage.vr.dto.QueryItem;
import com.sas.storage.vr.dto.QueryItemSearchCriteria;
import com.sas.storage.vr.dto.QueryProperty;
import com.sas.storage.vr.dto.Search;
import com.sas.storage.vr.dto.SearchOperatorEnum;
import com.sas.storage.vr.dto.ValueDataTypeEnum;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.svcs.formvr.client.ValueRetrieverExceptionHolder;
import com.sas.svcs.formvr.client.ValueRetrieverServiceInterface;
import com.sas.svcs.formvr.client.types.GetValuesAsListParameters;
import com.sas.util.ValidateArg;
import com.sas.util.ValueItem;
import com.sas.util.anno.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RelationalDataItemVPtoVRConverter
implements ValueProviderInterface,
DynamicValueProviderInterface,
ListSearchInterface,
DynamicListSearchInterface {
    private static Logger logger = LogManager.getLogger(RelationalDataItemVPtoVRConverter.class);
    private RelationalDataItemValueProvider delegate = null;
    private ValueRetrieverServiceInterface valueRetrieverProxy;

    public RelationalDataItemVPtoVRConverter(@NotNull ValueRetrieverServiceInterface proxy, @NotNull RelationalDataItemValueProvider valueProvider) {
        ValidateArg.notNull((Object)proxy, (String)"proxy");
        ValidateArg.notNull((Object)((Object)valueProvider), (String)"valueProvider");
        this.valueRetrieverProxy = proxy;
        this.delegate = valueProvider;
    }

    private RelationalDataItemVPtoVRConverter() {
    }

    public DataTypeInterface getDataType() throws ValueProviderException {
        return this.delegate.getDataType();
    }

    public Object getValues(Locale locale) throws ValueProviderException {
        return this.ultimateGetValues(locale, null, null, null, 0, -1);
    }

    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        return this.ultimateGetValues(locale, null, null, null, index, count);
    }

    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        return this.ultimateGetValues(locale, null, returnType, null, 0, -1);
    }

    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.ultimateGetValues(locale, null, returnType, null, index, count);
    }

    public boolean isValueDisplayed() {
        return this.delegate.isValueDisplayed();
    }

    public DataTypeInterface getDataType(DynamicPromptValueContextInterface dynamicValuesContext) throws ValueProviderException {
        return this.delegate.getDataType(dynamicValuesContext);
    }

    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValuesContext) throws ValueProviderException {
        return this.delegate.getDependentPrompts(locale, dynamicValuesContext);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.ultimateGetValues(locale, dynamicPromptValueContext, returnType, null, 0, -1);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.ultimateGetValues(locale, dynamicPromptValueContext, returnType, null, index, count);
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.ultimateGetValues(locale, dynamicPromptValueContext, returnType, null, 0, -1);
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.ultimateGetValues(locale, dynamicPromptValueContext, returnType, null, index, count);
    }

    public Object getValues(Locale locale, SearchCriteria searchCriterion) throws ValueProviderException {
        return this.ultimateGetValues(locale, null, null, searchCriterion, 0, -1);
    }

    public Object getValues(Locale locale, SearchCriteria searchCriterion, int index, int count) throws ValueProviderException {
        return this.ultimateGetValues(locale, null, null, searchCriterion, index, count);
    }

    public boolean isSearchable() throws ValueProviderException {
        return this.delegate.isFormattedLabels();
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriterion) throws ValueProviderException {
        return this.ultimateGetValues(locale, dynamicPromptValueContext, null, searchCriterion, 0, -1);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriterion, int index, int count) throws ValueProviderException {
        return this.ultimateGetValues(locale, dynamicPromptValueContext, null, searchCriterion, index, count);
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriterion, int index, int count) throws ValueProviderException {
        return this.ultimateGetValues(locale, dynamicPromptValueContext, null, searchCriterion, index, count);
    }

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return this.delegate.isFormattedLabels();
    }

    public Object clone() throws CloneNotSupportedException {
        RelationalDataItemVPtoVRConverter obj = (RelationalDataItemVPtoVRConverter)super.clone();
        try {
            obj.delegate = (RelationalDataItemValueProvider)((Object)this.delegate.clone());
            obj.valueRetrieverProxy = this.valueRetrieverProxy;
            return obj;
        }
        catch (CloneNotSupportedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return obj;
        }
    }

    private List<QueryItem> getQueryItemsForVP() {
        ArrayList<QueryItem> queryItems = new ArrayList<QueryItem>();
        logger.debug("getQueryItemsForVP() start ");
        DataSource dataSource = new DataSource();
        dataSource.setDataSourceType(4L);
        dataSource.setDataSourceLocation(this.delegate.getInfoMapUrl());
        if (this.delegate.labelDataItemId != null) {
            QueryItem qi = new QueryItem();
            qi.setUniqueName(this.delegate.labelDataItemId);
            qi.setDataSource(dataSource);
            qi.setTrimValues(true);
            qi.setFormattedValues(this.delegate.isFormattedLabels());
            if (this.delegate.isFormattedLabels()) {
                qi.setFormat(this.delegate.getLabelFormatString());
                qi.setDataType(ValueDataTypeEnum.STRING);
            }
            qi.setSortDirection(PromptIQueryUtil.getSortDirectionForDI(this.delegate, false));
            queryItems.add(qi);
            logger.debug("added label data item :" + this.delegate.labelDataItemId);
        }
        ValidateArg.notNull((Object)this.delegate.getDataItemId(), (String)"delegate.getDataItemId()");
        QueryItem qiValue = new QueryItem();
        qiValue.setUniqueName(this.delegate.getDataItemId());
        qiValue.setDataSource(dataSource);
        qiValue.setFormattedValues(this.delegate.isFormattedValues());
        if (this.delegate.isFormattedValues()) {
            qiValue.setFormat(this.delegate.getValueFormatString());
            qiValue.setDataType(ValueDataTypeEnum.STRING);
        }
        qiValue.setSortDirection(PromptIQueryUtil.getSortDirectionForDI(this.delegate, true));
        qiValue.setTrimValues(false);
        queryItems.add(qiValue);
        logger.debug("added value data item :" + this.delegate.getDataItemId());
        return queryItems;
    }

    private DynamicValueRetrieverConfiguration convertValueProviderToValueRetrieverConfiguration() {
        DynamicValueRetrieverConfiguration valueRetrieverConfiguration = new DynamicValueRetrieverConfiguration();
        valueRetrieverConfiguration.setDynamicSource(true);
        List<QueryItem> queryItems = this.getQueryItemsForVP();
        valueRetrieverConfiguration.getQueryItems().addAll(queryItems);
        QueryProperty queryProperty = new QueryProperty();
        queryProperty.setName("distinct");
        queryProperty.setValue(Boolean.toString(this.delegate.isDistinct()));
        valueRetrieverConfiguration.getQueryProperties().add(queryProperty);
        QueryProperty property = new QueryProperty();
        property.setName("DISPLAY_VALUE");
        property.setValue(Boolean.toString(this.delegate.isValueDisplayed()));
        valueRetrieverConfiguration.getQueryProperties().add(property);
        return valueRetrieverConfiguration;
    }

    private List<ValueItem> getValuesAsList(Locale locale, int index, int count) throws ValueRetrieverExceptionHolder {
        if (index < 0) {
            index = 0;
        }
        DynamicValueRetrieverConfiguration vrc = this.convertValueProviderToValueRetrieverConfiguration();
        vrc.setDynamicSource(true);
        GetValuesAsListParameters parameters = new GetValuesAsListParameters();
        parameters.setCount(count);
        parameters.setIndex(index);
        if (null != locale) {
            parameters.setLocale(locale.toString());
        }
        parameters.setValueRetrieverConfiguration((ValueRetrieverConfiguration)vrc);
        if (logger.isDebugEnabled()) {
            logger.debug("getValuesAsList(), calling same method on valueRetrieverProxy");
            logger.debug(PromptIQueryUtil.prettyPrintGetValuesAsListParameters(parameters));
        }
        List result = this.valueRetrieverProxy.getValuesAsList(parameters);
        return PromptIQueryUtil.convertResults(result);
    }

    private List<ValueItem> getSearchValuesAsList(Locale locale, SearchCriteria searchCriteria, int index, int count) throws ValueRetrieverExceptionHolder {
        if (index < 0) {
            index = 0;
        }
        DynamicValueRetrieverConfiguration vrc = this.convertValueProviderToValueRetrieverConfiguration();
        vrc.setDynamicSource(true);
        GetValuesAsListParameters parameters = new GetValuesAsListParameters();
        parameters.setCount(count);
        parameters.setIndex(index);
        if (null != locale) {
            parameters.setLocale(locale.toString());
        }
        parameters.setValueRetrieverConfiguration((ValueRetrieverConfiguration)vrc);
        Search search = new Search();
        QueryItemSearchCriteria qic = PromptIQueryUtil.newQueryItemSearchCriteria(searchCriteria, vrc.getQueryItems());
        ArrayList<QueryItemSearchCriteria> searchCriteriaList = new ArrayList<QueryItemSearchCriteria>();
        searchCriteriaList.add(qic);
        search.setSearchCriteriaList(searchCriteriaList);
        search.setOperator(SearchOperatorEnum.AND_OPERATOR);
        vrc.setSearch(search);
        if (logger.isDebugEnabled()) {
            logger.debug(PromptIQueryUtil.prettyPrintGetMultiSearchValuesAsListParameters(parameters));
            logger.debug("getSearchValuesAsList(), now calling getSearchValuesAsList on valueRetrieverProxy");
        }
        List result = this.valueRetrieverProxy.getValuesAsList(parameters);
        return PromptIQueryUtil.convertResults(result);
    }

    private List<ValueItem> getMultiSearchValuesAsList(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueRetrieverExceptionHolder, ValueProviderException {
        if (index < 0) {
            index = 0;
        }
        DynamicValueRetrieverConfiguration vrc = this.convertValueProviderToValueRetrieverConfiguration();
        vrc.setDynamicSource(true);
        logger.debug("getMultiSearchValuesAsList(), processsing searchCriterion");
        GetValuesAsListParameters parameters = new GetValuesAsListParameters();
        parameters.setCount(count);
        parameters.setIndex(index);
        if (null != locale) {
            parameters.setLocale(locale.toString());
        }
        Search search = new Search();
        search.setOperator(SearchOperatorEnum.AND_OPERATOR);
        vrc.setSearch(search);
        parameters.setValueRetrieverConfiguration((ValueRetrieverConfiguration)vrc);
        if (null != this.delegate.getWhereClause()) {
            WhereClause wc;
            OperandInterface operand;
            logger.debug("getMultiSearchValuesAsList(), processsing Where clause");
            if (!this.delegate.populateDefinitionValueMap(locale, null, dynamicPromptValueContext, new HashMap())) {
                return Collections.emptyList();
            }
            PromptValuesInterface promptValues = null;
            if (null != dynamicPromptValueContext) {
                promptValues = dynamicPromptValueContext.getPromptValues();
            }
            if ((operand = (wc = this.delegate.getWhereClause()).getCondition()) instanceof Expression) {
                try {
                    search.getSearchCriteriaList().addAll(PromptIQueryUtil.getSearchCriteriaForExpression((Expression)operand, PromptIQueryUtil.getDataSource(this.delegate), promptValues, locale));
                }
                catch (PromptValueNotFoundException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new ValueRetrieverExceptionHolder(e.getMessage());
                }
            }
        }
        if (null != searchCriteria) {
            QueryItemSearchCriteria qisc = PromptIQueryUtil.newQueryItemSearchCriteria(searchCriteria, vrc.getQueryItems());
            search.getSearchCriteriaList().add(qisc);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(PromptIQueryUtil.prettyPrintGetMultiSearchValuesAsListParameters(parameters));
            logger.debug("getSearchValuesAsList(), now calling getSearchValuesAsList on valueRetrieverProxy");
        }
        List result = this.valueRetrieverProxy.getValuesAsList(parameters);
        return PromptIQueryUtil.convertResults(result);
    }

    private Object ultimateGetValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        List<ValueItem> returnObject = null;
        if (count == 0) {
            return Collections.EMPTY_LIST;
        }
        try {
            if (null == returnType || returnType == ValueType.LIST || returnType == ValueType.TREETHENLIST) {
                returnObject = this.delegate.getWhereClause() == null ? (null == searchCriteria ? this.getValuesAsList(locale, index, count) : this.getSearchValuesAsList(locale, searchCriteria, index, count)) : this.getMultiSearchValuesAsList(locale, dynamicPromptValueContext, searchCriteria, index, count);
            }
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
        return returnObject;
    }
}

