/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.iq;

import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.valueprovider.dynamic.BasePromptDynamicValueProvider;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.ValueItem;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.TreeModel;

public class InfoMapsValueProvider
extends BasePromptDynamicValueProvider {
    protected boolean isOLAP = false;

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return false;
    }

    public void setIsOLAP(boolean isOLAP) {
        this.isOLAP = isOLAP;
    }

    public boolean isOLAP() {
        return this.isOLAP;
    }

    public Collection getDependentPromptNames(Locale locale) {
        ArrayList dependentPrompts = new ArrayList();
        return dependentPrompts;
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, null, 0, -1);
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, searchCriteria, 0, -1);
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, null, 0, -1);
    }

    @Override
    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, returnType, index, count);
    }

    @Override
    public Object getValues(Locale locale, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, searchCriteria, index, count);
    }

    private Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Object returnObject = null;
        if (returnType == ValueType.LIST || returnType == ValueType.TREETHENLIST) {
            returnObject = this.getValuesAndLabels(locale, dynamicPromptValueContext, searchCriteria, index, count);
        } else if (returnType == ValueType.TREE) {
            returnObject = this.getValuesAsTree(locale, dynamicPromptValueContext, searchCriteria, index, count);
        }
        return returnObject;
    }

    public TreeModel getValuesAsTree(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        throw new UnsupportedOperationException("This method is not supported for Info Maps");
    }

    protected Collection getValuesAndLabels(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Vector<ValueItem> valueAndLabels = new Vector<ValueItem>();
        try {
            LinkedHashMap mapList = new LinkedHashMap();
            LinkedHashMap olapMapList = new LinkedHashMap();
            DataProviderInterface dataProivder = null;
            if (dynamicPromptValueContext != null) {
                dataProivder = dynamicPromptValueContext.getDataProvider();
            }
            if (dataProivder != null) {
                UserContextInterface userContext = ((DataProvider)dataProivder).getUserContext();
                List repositories = userContext.getRepositories();
                for (RepositoryInterface repository : repositories) {
                    if (repository == null) continue;
                    List folders = repository.getRootFolders();
                    int cnt = folders.size();
                    for (int j = 0; j < cnt; ++j) {
                        InfoMapsValueProvider.listItems((MetadataInterface)folders.get(j), olapMapList, mapList);
                    }
                    Set keyset = mapList.keySet();
                    if (this.isOLAP) {
                        keyset = olapMapList.keySet();
                    }
                    for (String mapLabel : keyset) {
                        String mapName = (String)mapList.get(mapLabel);
                        if (this.isOLAP) {
                            mapName = (String)olapMapList.get(mapLabel);
                        }
                        valueAndLabels.add(new ValueItem((Object)mapLabel, (Object)mapName));
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new ValueProviderException((Throwable)e, null);
        }
        catch (RemoteException e) {
            throw new ValueProviderException((Throwable)e, null);
        }
        return valueAndLabels;
    }

    private static void listItems(MetadataInterface item, Map olapMapList, Map mapList) {
        try {
            if (item.getType().equals("Folder")) {
                List items = ((FolderInterface)item).getSubfolders();
                if (items.size() == 0) {
                    items = ((FolderInterface)item).getItems();
                }
                int cnt2 = items.size();
                for (int k = 0; k < cnt2; ++k) {
                    InfoMapsValueProvider.listItems((MetadataInterface)items.get(k), olapMapList, mapList);
                }
            } else if (item instanceof BriefInformationMap) {
                String pathUrl = item.getPathUrl().toString();
                if (((BriefInformationMap)item).getStructure().isOLAP()) {
                    olapMapList.put(item.getName(), pathUrl);
                } else if (!((BriefInformationMap)item).getStructure().isOLAP()) {
                    mapList.put(item.getName(), pathUrl);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        InfoMapsValueProvider clone = (InfoMapsValueProvider)((Object)super.clone());
        clone.isOLAP = this.isOLAP;
        return clone;
    }

    public String getDefinitionElementName() {
        return "InfoMapsValueProvider";
    }
}

