/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.iq;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInitializationInterface;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueProviderValueRetrievalInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.ValidateArg;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IQIdentityValueProvider
extends AbstractPersistence
implements ValueProviderInterface,
ValueProviderInitializationInterface,
ValueProviderValueRetrievalInterface {
    private MetadataServerInterface server = null;
    private transient String name = null;
    private boolean initialized = false;
    protected boolean displayValue;

    public void setValueDisplayed(boolean displayValue) {
        this.displayValue = displayValue;
    }

    public boolean isValueDisplayed() {
        return this.displayValue;
    }

    public Object getValue() throws ValueProviderException {
        if (this.initialized) {
            try {
                if ("SAS.IdentityGroups".equals(this.name)) {
                    this.getLogger2().debug("getValue() for name=SAS.IdentityGroups");
                    return IQUeryUtil.getIdentityGroups(this.server, null);
                }
                return IQUeryUtil.getIdentityDrivenPropertyValue(this.server, null, this.name);
            }
            catch (ServiceException e) {
                throw new ValueProviderException((Throwable)e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new ValueProviderException((Throwable)e, e.getMessage());
            }
        }
        throw new ValueProviderException("You must call initialize() first.");
    }

    public Object getValues(Locale locale) throws ValueProviderException {
        ArrayList<ValueItem> list = Collections.EMPTY_LIST;
        Object retVal = this.getValue();
        if (retVal instanceof List && !((List)retVal).isEmpty()) {
            list = new ArrayList<ValueItem>();
            Iterator it = ((List)retVal).iterator();
            while (it.hasNext()) {
                ValueItem vi = new ValueItem();
                vi.setValue(it.next());
                list.add(vi);
            }
        } else if (null != retVal) {
            ValueItem vi = new ValueItem();
            vi.setValue(retVal);
            list = new ArrayList();
            list.add(vi);
        }
        return list;
    }

    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        return this.getValues(locale);
    }

    public DataTypeInterface getDataType() throws ValueProviderException {
        return StringType.DEFAULT_INSTANCE;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final void initialize(OMIRepositoryInterface repository, String name) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        try {
            options.put("SERVER", repository.getUserContext().getAuthServer());
        }
        catch (ServiceException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
        options.put("NAME", name);
        this.initialize(options);
    }

    public void initialize(Map options) {
        ValidateArg.notNull((Object)options, (String)"options");
        Object o = options.get("SERVER");
        ValidateArg.notNull(o, (String)"SERVER");
        if (!(o instanceof MetadataServerInterface)) {
            throw new IllegalArgumentException("The SERVER key needs to have an MetadataServerInterface instance set as the value");
        }
        this.server = (MetadataServerInterface)o;
        o = options.get("NAME");
        if (o instanceof String) {
            this.name = (String)o;
        } else {
            o = options.get("PROMPT_DEFINITION");
            if (o instanceof PromptDefinitionInterface) {
                this.name = ((PromptDefinitionInterface)o).getPromptName();
            }
        }
        ValidateArg.notNull((Object)this.name, (String)"NAME");
        this.initialized = true;
        this.getLogger2().debug("initialize() for name=", this.name);
    }

    public String getDefinitionElementName() {
        return "IQIdentityValueProvider";
    }

    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale);
    }

    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale);
    }
}

