/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.iq;

import com.sas.datatypes.DataTypeInterface;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.models.MutableThresholdInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicListSearchInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.datatypes.values.StringValue;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.valueprovider.dynamic.iq.RB;
import com.sas.services.information.ServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.ListSearchInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.ResourceReferencesInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.IntegratedReadingContext;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class DataItemValueProvider
extends AbstractPersistence
implements ValueProviderInterface,
DynamicValueProviderInterface,
ListSearchInterface,
DynamicListSearchInterface,
ResourceReferencesInterface,
MutableThresholdInterface {
    static final String RB_KEY = "DataItemValueProvider.";
    public static int DEFAULT_THRESHOLD = DataProviderUtil.DEFAULT_RELATIONAL_THRESHOLD;
    private String infoMapUrl;
    private String dataItemId;
    protected DataTypeInterface dataType;
    protected boolean displayValue;
    protected BusinessQuery businessQuery;
    private transient DataItem valueDataItem;
    private int threshold;
    private List filterList;
    protected List allFilterList;
    private QueryConnectorInterface queryConnector;
    private DataProvider dataProvider = null;
    protected List dependentPrompts = new LinkedList();
    public static final int _DIRECT_PROMPT_REFERENCE_SEARCH_FLAG;

    protected DataItemValueProvider() {
        this.setThreshold(DEFAULT_THRESHOLD);
    }

    public final void setThreshold(int userThreshold) {
        this.threshold = userThreshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setValueDisplayed(boolean displayValue) {
        this.displayValue = displayValue;
    }

    public boolean isValueDisplayed() {
        return this.displayValue;
    }

    public String getInfoMapUrl() {
        return this.infoMapUrl;
    }

    public void setDataItemId(String dataItemId) {
        this.dataItemId = dataItemId;
        this.clearConnection();
    }

    public void setInfoMapUrl(String infoMapUrl) {
        this.infoMapUrl = infoMapUrl;
        this.clearConnection();
    }

    protected void clearConnection() {
    }

    protected String getDataItemId() {
        return this.dataItemId;
    }

    public void setQueryConnector(QueryConnectorInterface queryConnector) {
        this.queryConnector = queryConnector;
    }

    public QueryConnectorInterface getQueryConnector() {
        return this.queryConnector;
    }

    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, returnType, null, 0, this.getThreshold());
    }

    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, returnType, null, index, count);
    }

    public Object getValues(Locale locale) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, null, 0, this.getThreshold());
    }

    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, null, index, count);
    }

    public Object getValues(Locale locale, SearchCriteria searchCriteria) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, searchCriteria, 0, this.getThreshold());
    }

    public Object getValues(Locale locale, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Collection c = (Collection)this.getValues(locale, ValueType.LIST, searchCriteria, index, count);
        return c;
    }

    protected Object getValues(Locale locale, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, null, returnType, searchCriteria, index, count);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, searchCriteria, index, count);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, null, index, count);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, null, 0, this.getThreshold());
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriteria) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, ValueType.LIST, searchCriteria, 0, this.getThreshold());
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, promptView, dynamicPromptValueContext, returnType, null, 0, this.getThreshold());
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, promptView, dynamicPromptValueContext, returnType, null, index, count);
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriterion, int index, int count) throws ValueProviderException {
        return this.getValues(locale, promptView, dynamicPromptValueContext, ValueType.LIST, searchCriterion, index, count);
    }

    protected abstract Object getValues(Locale var1, PromptViewInterface var2, DynamicPromptValueContextInterface var3, ValueType var4, SearchCriteria var5, int var6, int var7) throws ValueProviderException;

    protected abstract Object getValues(Locale var1, DynamicPromptValueContextInterface var2, ValueType var3, SearchCriteria var4, int var5, int var6) throws ValueProviderException;

    public void setFilterList(List filters) {
        this.filterList = filters;
        this.dependentPrompts.clear();
    }

    public List getFilterList() {
        if (null == this.filterList) {
            this.filterList = new ArrayList();
        }
        return this.filterList;
    }

    public void setDataItem(DataItem dataItem) {
        this.valueDataItem = dataItem;
        this.dataType = null;
        this.clearConnection();
    }

    public DataItem getDataItem() {
        if (null == this.valueDataItem && null != this.getInfoMapUrl() && null != this.getDataItemId() && null != this.getDataProvider()) {
            try {
                this.valueDataItem = this.dataProvider.getDataItemFromId(this.getInfoMapUrl(), this.getDataItemId());
                if (this.valueDataItem == null) {
                    String msg = MessageFormat.format(RB.getStringResource("DataItemValueProvider.invalidDataItemID.txt.fmt"), this.getDataItemId());
                    throw new IllegalStateException(msg);
                }
            }
            catch (ServerConnectionException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        return this.valueDataItem;
    }

    protected DataItem getDataItemFromID() throws ValueProviderException {
        if (null == this.valueDataItem && null != this.getInfoMapUrl() && null != this.getDataItemId() && null != this.getDataProvider()) {
            try {
                this.valueDataItem = this.dataProvider.getDataItemFromId(this.getInfoMapUrl(), this.getDataItemId());
                if (this.valueDataItem == null) {
                    String msg = MessageFormat.format(RB.getStringResource("DataItemValueProvider.invalidDataItemID.txt.fmt"), this.getDataItemId());
                    throw new ValueProviderException(msg);
                }
            }
            catch (ServerConnectionException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        return this.valueDataItem;
    }

    public void setBusinessQuery(BusinessQuery bq) {
        this.businessQuery = bq;
    }

    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) {
        try {
            this.allFilterList = new ArrayList();
            this.addFilterPrompts(dynamicPromptValueContext);
        }
        catch (ServerConnectionException se) {
            this.getLogger2().error(se.getMessage(), (Throwable)se);
        }
        return this.dependentPrompts;
    }

    private void addFilterPrompts(DynamicPromptValueContextInterface dynamicPromptValueContext) throws ServerConnectionException {
        if (this.filterList == null || this.filterList.isEmpty()) {
            return;
        }
        this.addFilterPrompts(this.filterList, dynamicPromptValueContext);
    }

    protected void addFilterPrompts(Collection filters, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ServerConnectionException {
        for (Object fi : filters) {
            FilterItem filterItem = null;
            if (fi instanceof ExpressionInterface) {
                ExpressionInterface exp = (ExpressionInterface)fi;
                try {
                    filterItem = this.getDataItem().getBusinessModel().newFilterItem();
                    filterItem.setExpression(exp);
                    this.allFilterList.add(filterItem);
                }
                catch (MetadataException me) {
                    this.getLogger2().warn(RB.getStringResource("DataItemValueProvider.InvalidFilterItemError.txt"));
                }
            } else if (fi instanceof FilterItem) {
                filterItem = (FilterItem)fi;
                this.allFilterList.add(filterItem);
            } else if (fi instanceof String && dynamicPromptValueContext != null) {
                DataProviderInterface dp = dynamicPromptValueContext.getDataProvider();
                if (dp instanceof DataProvider && this.infoMapUrl != null) {
                    filterItem = ((DataProvider)dynamicPromptValueContext.getDataProvider()).getFilterItemFromId(this.infoMapUrl, (String)fi);
                }
                this.allFilterList.add(filterItem);
            }
            if (null == filterItem) continue;
            List prompts = filterItem.getPrompts(_DIRECT_PROMPT_REFERENCE_SEARCH_FLAG);
            for (Prompt p : prompts) {
                this.dependentPrompts.add(p.getPromptDefinition());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataItemValueProvider clone = (DataItemValueProvider)((Object)super.clone());
        clone.threshold = this.threshold;
        clone.valueDataItem = this.valueDataItem;
        clone.dataType = this.dataType;
        return clone;
    }

    public List getReferencedResources(Class type, boolean recursive) {
        List currentFilterList;
        ArrayList<Object> list = new ArrayList<Object>(2);
        DataItem di = this.getDataItem();
        if (di != null) {
            if (null != type && type.isInstance(di)) {
                list.add(di);
            } else if (null == type) {
                list.add(di);
            }
        }
        if ((currentFilterList = this.getFilterList()) != null && currentFilterList.size() > 0) {
            if (null != type) {
                for (Object element : currentFilterList) {
                    if (!type.isInstance(element)) continue;
                    list.add(element);
                }
            } else if (null == type) {
                list.addAll(currentFilterList);
            }
        }
        return list;
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        this.getLogger2().debug("consumeRelObjects, processing filters.");
        ArrayList filterIdList = roHolder.consumeObjects("FilterList");
        if (!filterIdList.isEmpty()) {
            PromptsReadingContext rc = roHolder.getReadingContext();
            this.processFilterIdList(filterIdList, rc);
        }
    }

    private void processFilterIdList(List filterIdList, PromptsReadingContext rc) {
        this.filterList = new ArrayList(filterIdList.size());
        if (null != rc && null != rc.getReadingContext()) {
            this.getLogger2().debug("processFilterIdList(), handling reference id's from outer reading context.");
            IntegratedReadingContext irc = rc.getReadingContext();
            int cnt = filterIdList.size();
            for (int i = 0; i < cnt; ++i) {
                String referenceId = (String)((StringValue)filterIdList.get(i)).getValue();
                this.getLogger2().debug("Looking for this filter id in outer context:", referenceId);
                Object out = irc.getObject(referenceId);
                if (out == null || !(out instanceof FilterItem)) {
                    String msg = MessageFormat.format(RB.getStringResource("DataItemValueProvider.noFilterItem.txt.fmt"), referenceId);
                    throw new IllegalStateException(msg);
                }
                this.filterList.add(out);
            }
        } else {
            this.getLogger2().debug("processFilterIdList(), handling string id's.");
            for (StringValue element : filterIdList) {
                this.filterList.add(element.getValue());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void consumeAttributes(AttributesProvider provider) {
        PromptsReadingContext rc;
        block7: {
            super.consumeAttributes(provider);
            this.getLogger2().debug("Running consumeAttributes().");
            this.setThreshold(provider.consumeIntAttr("threshold", DEFAULT_THRESHOLD));
            this.setValueDisplayed(provider.consumeBooleanAttr("valueDisplayed", false));
            this.dataItemId = provider.consumeAttr("dataItemId");
            this.infoMapUrl = PersistHelper.parseSBIPUrl((String)provider.consumeAttr("infoMapUrl"));
            String refId = provider.consumeAttr("referenceId");
            if (null != refId) {
                rc = provider.getReadingContext();
                if (null != rc) {
                    Object obj = rc.getObject(refId);
                    if (null != obj && obj instanceof DataItem) {
                        this.setDataItem((DataItem)obj);
                        this.getLogger2().debug("Found a DataItem for this id:", refId);
                        break block7;
                    } else {
                        String msg = MessageFormat.format(RB.getStringResource("DataItemValueProvider.noDataItem.txt.fmt"), refId);
                        throw new IllegalStateException(msg);
                    }
                }
                this.getLogger2().warn(RB.getStringResource("DataItemValueProvider.noReadingContext.txt"));
            }
        }
        if (null == this.valueDataItem) {
            Map optionsMap;
            UserContextInterface userContext;
            this.getLogger2().debug("The valueDataItem is still null.");
            rc = provider.getReadingContext();
            if (null != rc && null != rc.getOptionsMap() && null != (userContext = (UserContextInterface)(optionsMap = rc.getOptionsMap()).get("USER_CONTEXT"))) {
                this.getLogger2().debug("Found a user context, so can make a DataProvider.");
                this.dataProvider = new DataProvider(userContext);
                ServerInterface server = (ServerInterface)rc.getServer();
                if (null != server) {
                    this.dataProvider.setMetadataServer(server);
                    this.getLogger2().debug("found a server from the reading context, set it on dataprovider");
                }
            }
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing definition.");
        XmlUtil.setIntAttr((Element)element, (String)"threshold", (int)this.getThreshold(), (int)DEFAULT_THRESHOLD);
        XmlUtil.setBooleanAttr((Element)element, (String)"valueDisplayed", (boolean)this.isValueDisplayed(), (boolean)false);
        List list2 = this.getWritableFilterIds(writingContext);
        if (list2 != null) {
            DataItemValueProvider.writeRelatedObjects((List)list2, (Node)element, (PromptsWritingContext)writingContext, (String)"FilterList");
        }
        IntegratedWritingContext outer = writingContext.getOuterContext();
        DataItem di = null;
        try {
            di = this.getDataItem();
        }
        catch (IllegalStateException ie) {
            String msg = MessageFormat.format(RB.getStringResource("DataItemValueProvider.invalidDataItemIDInDataSource.txt.fmt"), this.getDataItemId());
            this.getLogger2().warn(msg);
        }
        if (null != outer && null != di) {
            String refId = outer.getReference((Object)di);
            if (null != refId) {
                this.getLogger2().debug("Writing DataItem reference:", refId);
                XmlUtil.setAttr((Element)element, (String)"referenceId", (String)refId);
            } else {
                this.getLogger2().error(RB.getStringResource("DataItemValueProvider.noRefID.txt"));
            }
        } else {
            this.getLogger2().debug("Writing dataItemId and infoMapUrl for web service and shared prompt cases.");
            if (null != di) {
                try {
                    this.getLogger2().debug("Writing id and url for real DataItem.");
                    XmlUtil.setAttr((Element)element, (String)"dataItemId", (String)di.getID());
                    XmlUtil.setAttr((Element)element, (String)"infoMapUrl", (String)("URL::" + DataProvider.getPathUrl(di)));
                    this.createMetadataDescriptor(di, writingContext);
                }
                catch (InvalidIDException e) {
                    throw new BackingStoreException(e);
                }
            } else {
                this.getLogger2().debug("Writing local fields for id and url. dataItemId= ", this.dataItemId);
                XmlUtil.setAttr((Element)element, (String)"dataItemId", (String)this.dataItemId);
                if (null != this.infoMapUrl) {
                    XmlUtil.setAttr((Element)element, (String)"infoMapUrl", (String)("URL::" + this.infoMapUrl));
                }
            }
        }
    }

    protected final void createMetadataDescriptor(DataItem dataItem, PromptsWritingContext writingContext) {
        try {
            String url = DataProvider.getPathUrl(dataItem);
            MetadataDescriptor md = PersistenceFactory.newMetadataDescriptor(null);
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("SBIP_URL", url);
            md.setAdditionalInfo(info);
            md.setType("INFORMATION_MAP");
            writingContext.addMetadataDescriptor(md);
        }
        catch (IllegalStateException e) {
            this.getLogger2().warn(RB.getStringResource("DataItemValueProvider.noDescriptor.txt"), null, (Throwable)e);
        }
    }

    private List getWritableFilterIds(PromptsWritingContext writingContext) throws BackingStoreException {
        if (this.filterList == null) {
            return null;
        }
        int count = this.filterList.size();
        ArrayList<StringValue> idList = new ArrayList<StringValue>(count);
        for (int i = 0; i < count; ++i) {
            StringValue value = new StringValue();
            Object obj = this.filterList.get(i);
            if (obj instanceof String) {
                value.setValue(obj);
                idList.add(value);
                continue;
            }
            IntegratedWritingContext outer = writingContext.getOuterContext();
            if (null != outer) {
                String refId = outer.getReference(obj);
                if (null != refId) {
                    this.getLogger2().debug("Writing FilterItem reference:", refId);
                    value.setValue((Object)refId);
                    idList.add(value);
                    continue;
                }
                this.getLogger2().error(RB.getStringResource("DataItemValueProvider.noRefID.txt"));
                continue;
            }
            if (!(obj instanceof FilterItem)) continue;
            try {
                FilterItem fi = (FilterItem)obj;
                BusinessModel busModel = this.valueDataItem.getBusinessModel();
                if (!(busModel instanceof InformationMap) || null == DataProvider.getFilterItemFromId((InformationMap)busModel, fi.getID())) continue;
                value.setValue((Object)fi.getID());
                idList.add(value);
                continue;
            }
            catch (InvalidIDException ie) {
                this.getLogger2().error(RB.getStringResource("DataItemValueProvider.noRefID.txt"));
                continue;
            }
            catch (ServerConnectionException e) {
                e.printStackTrace();
            }
        }
        return idList;
    }

    public void replace(Object referencedObject, Object replacementObject) {
        if (null != this.getDataItem() && this.getDataItem() == referencedObject) {
            this.setDataItem((DataItem)replacementObject);
        }
    }

    protected final DataProvider getDataProvider() {
        return this.dataProvider;
    }

    protected final void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    static {
        int prSearchFlags = 65535;
        prSearchFlags &= 0xFFFFFFFD;
        _DIRECT_PROMPT_REFERENCE_SEARCH_FLAG = prSearchFlags &= 0xFFFFFFFE;
    }
}

