/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic;

import com.sas.metadata.remote.SASLibrary;
import com.sas.prompts.valueprovider.dynamic.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.PropertySetInterface;
import com.sas.services.information.metadata.RelationalSchemaInterface;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.text.Message;
import com.sas.util.log.LoggerRepository2;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;

public abstract class DataProviderUtil {
    public static String OLAP_LIST_THRESHOLD = "OLAP_LIST_THREHOLD";
    public static String RELATIONAL_LIST_THRESHOLD = "RELATIONAL_LIST_THRESHOLD";
    public static String STATIC_LIST_THRESHOLD = "STATIC_LIST_THRESHOLD";
    public static Integer DEFAULT_OLAP_THRESHOLD = 2500;
    public static Integer DEFAULT_RELATIONAL_THRESHOLD = 1000;
    public static Integer DEFAULT_STATIC_THRESHOLD = 5000;
    public static Integer ALL_VALUES = -1;

    public static boolean isOLAPServer(LogicalServerInterface logicalServer) throws RemoteException, ServiceException {
        String serverId = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
        return logicalServer.getClassIdentifier().equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6");
    }

    public static boolean isWorkspaceServer(LogicalServerInterface logicalServer) throws RemoteException, ServiceException {
        String serverId = "440196d4-90f0-11d0-9f41-00a024bb830c";
        return logicalServer.getClassIdentifier().equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c");
    }

    public static boolean isPooledServer(LogicalServerInterface logicalServer) throws RemoteException, ServiceException {
        String serverId = "620963ee-32bf-4128-bf5f-4b0df8ff90eb";
        return logicalServer.getClassIdentifier().equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb");
    }

    public static boolean isStoredProcessServer(LogicalServerInterface logicalServer) throws RemoteException, ServiceException {
        String serverId = "15931e31-667f-11d5-8804-00c04f35ac8c".toLowerCase();
        return logicalServer.getClassIdentifier().equalsIgnoreCase(serverId);
    }

    public static boolean needQuoting(PhysicalTableInterface physicalTable) throws RemoteException, ServiceException {
        List l = physicalTable.getPropertySets();
        for (int i = 0; i < l.size(); ++i) {
            PropertySetInterface li = (PropertySetInterface)l.get(i);
            String setRole = li.getSetRole();
            if (!setRole.equalsIgnoreCase("DBMSNAMES")) continue;
            List ls = li.getObjectProperties();
            for (int j = 0; j < ls.size(); ++j) {
                PropertyInterface prop = (PropertyInterface)ls.get(j);
                if (!prop.getName().equalsIgnoreCase("case") && !prop.getName().equalsIgnoreCase("SpecChar") || !prop.getValue().equalsIgnoreCase("Y")) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static SASLibraryInterface getLibrary(PhysicalTableInterface physicalTable) throws ServerConnectionException {
        return DataProviderUtil.getLibrary(physicalTable, Locale.getDefault());
    }

    public static SASLibraryInterface getLibrary(PhysicalTableInterface physicalTable, Locale locale) throws ServerConnectionException {
        SASLibraryInterface library = null;
        try {
            if (physicalTable == null) {
                throw new ServerConnectionException(RB.getStringResource("DataProviderUtil.noTable.txt", locale));
            }
            RelationalSchemaInterface schema = physicalTable.getSchema();
            if (schema == null) {
                throw new ServerConnectionException(Message.format((String)RB.getStringResource("DataProviderUtil.noLibrary.fmt", locale), (Object)physicalTable.getName()));
            }
            if (schema instanceof SASLibraryInterface) {
                library = (SASLibraryInterface)schema;
                List dl = schema.getUsedByPackages();
                int size = dl.size();
                for (int j = 0; j < size; ++j) {
                    Object libObj;
                    Object lib = dl.get(j);
                    if (lib == null || !(lib instanceof SASLibraryInterface) || (libObj = ((SASLibraryInterface)lib).getRepositoryEntity()) == null || !(libObj instanceof SASLibrary) || !((SASLibrary)libObj).getEngine().equals("REMOTE")) continue;
                    library = (SASLibraryInterface)lib;
                }
            } else {
                List dl = schema.getUsedByPackages();
                int size = dl.size();
                for (int j = 0; j < size; ++j) {
                    Object lib = dl.get(j);
                    if (!(lib instanceof SASLibraryInterface)) continue;
                    library = (SASLibraryInterface)dl.get(j);
                }
            }
        }
        catch (ServiceException e) {
            LoggerRepository2.getLogger((String)DataProviderUtil.class.getName(), null).error(e.getMessage(), (Throwable)e);
            throw new ServerConnectionException((Throwable)e, e.getMessage());
        }
        catch (RemoteException re) {
            LoggerRepository2.getLogger((String)DataProviderUtil.class.getName(), null).error(re.getMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getMessage());
        }
        return library;
    }
}

