/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.util.iquery;

import com.sas.iom.SAS.IFileInfoPackage.Status;
import com.sas.iom.SAS.IFileInfo_1_1;
import com.sas.iom.SAS.IFileInfo_1_1Helper;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iquery.metadata.IntelligentQueryMetadataService;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.models.SASLibraryLocation;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.ColumnAttributes;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.iquery.InformationMapMetaData;
import com.sas.util.Strings;
import java.rmi.RemoteException;
import java.util.List;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public final class DataSourceUtil {
    private DataSourceUtil() {
    }

    public static DataSourceInterface getDataSource(UserContextInterface userContext, String path) throws ServiceException, RemoteException {
        if (path != null && null != userContext) {
            MetadataInterface mi;
            ServerInterface server = userContext.getAuthServer();
            PathUrl pathUrl = null;
            try {
                pathUrl = PathUrl.newPathUrlFromExistingUrl((ServerInterface)server, (PathUrl)new PathUrl(path));
            }
            catch (IllegalArgumentException e) {
                pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)path);
            }
            if (pathUrl != null && (mi = server.getObjectByPath(pathUrl)) != null) {
                long type = DataSourceUtil.getDataSourceType(userContext, mi);
                if (pathUrl.getType() == null) {
                    if (!pathUrl.isWritable()) {
                        pathUrl = new PathUrl(pathUrl.toString());
                    }
                    if (type == 2L) {
                        pathUrl.setType("Cube");
                    } else if (type == 1L) {
                        pathUrl.setType("Table");
                    } else if (type == 8L) {
                        pathUrl.setType("InformationMap");
                    } else if (type == 4L) {
                        pathUrl.setType("InformationMap");
                    }
                }
                BaseDataSource ds = new BaseDataSource(type, pathUrl.getAbsolutePath());
                return ds;
            }
        }
        return null;
    }

    private static long getDataSourceType(UserContextInterface userContext, MetadataInterface mi) throws ServiceException, RemoteException {
        String type = mi.getType();
        if ("InformationMap".equals(type)) {
            InformationMapMetaData metaData;
            if (userContext != null && (metaData = IQUeryUtil.getInfoMapMetaData(mi.getEntityKey(), mi.getModifyDate().getTime(), userContext.getAuthServer())) != null && metaData.isOLAP()) {
                return 8L;
            }
            return 4L;
        }
        if ("InformationMap.Relational".equals(type)) {
            return 4L;
        }
        if ("InformationMap.OLAP".equals(type)) {
            return 8L;
        }
        if ("Table".equals(type) || "PhysicalTable".equals(type)) {
            return 1L;
        }
        if ("Cube".equals(type)) {
            return 2L;
        }
        return -1L;
    }

    static long getColumnType(UserContextInterface userContext, PromptDataProviderInterface pdp, DataSourceInterface ds, String column) throws ServiceException, RemoteException, IllegalArgumentException, ServerConnectionException, MetadataException {
        block14: {
            ServerInterface server;
            if (ds == null || column == null || (server = userContext.getAuthServer()) == null) break block14;
            String location = ds.getDataSourceLocation();
            PathUrl pathUrl = null;
            try {
                pathUrl = PathUrl.newPathUrlFromExistingUrl((ServerInterface)server, (PathUrl)new PathUrl(location));
            }
            catch (IllegalArgumentException e) {
                pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)location);
            }
            if (pathUrl != null) {
                MetadataInterface mi;
                if (pathUrl.getType() == null) {
                    pathUrl.setType("");
                }
                if ((mi = server.getObjectByPath(pathUrl)) instanceof DataTableInterface) {
                    List cols = ((DataTableInterface)mi).getColumns();
                    for (ColumnInterface c : cols) {
                        ColumnAttributes ca;
                        if (!Strings.equal((String)column, (String)c.getName(), (boolean)false, (boolean)false) || (ca = c.getColumnAttributes()) == null) continue;
                        return ca.getColumnType();
                    }
                } else if (mi instanceof BriefInformationMap) {
                    InformationMap im = null;
                    if (pdp != null) {
                        im = pdp.getInformationMap(location);
                    } else {
                        IntelligentQueryMetadataService queryService = (IntelligentQueryMetadataService)IntelligentQueryMetadataServiceFactory.newService();
                        SessionContextInterface sessionContext = userContext.getSessionContext();
                        im = queryService.getInformationMap(sessionContext, pathUrl);
                    }
                    if (im != null) {
                        List diList = im.getObjects(true, DataItem.class);
                        for (DataItem di : diList) {
                            try {
                                if (!di.getID().equals(column) && !di.getLabel().equals(column)) continue;
                                return InfoMapItemsValueProvider.getDataSourceColumnType(di);
                            }
                            catch (InvalidIDException invalidIDException) {
                            }
                        }
                    }
                }
            }
        }
        return -1L;
    }

    static SASLibraryLocationInterface getSASLibrary(UserContextInterface userContext, String path) throws ServiceException, RemoteException, IllegalArgumentException {
        if (path != null) {
            ServerInterface server = userContext.getAuthServer();
            PathUrl pathUrl = null;
            try {
                pathUrl = PathUrl.newPathUrlFromExistingUrl((ServerInterface)server, (PathUrl)new PathUrl(path));
            }
            catch (IllegalArgumentException e) {
                pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)path);
            }
            if (pathUrl != null) {
                MetadataInterface mi;
                if (pathUrl.getType() == null) {
                    if (!pathUrl.isWritable()) {
                        pathUrl = new PathUrl(pathUrl.toString());
                    }
                    pathUrl.setType("SASLibrary");
                }
                if (server != null && (mi = server.getObjectByPath(pathUrl)) instanceof SASLibraryInterface) {
                    return new SASLibraryLocation(pathUrl.getAbsolutePath(), ((SASLibraryInterface)mi).getLibref());
                }
            }
        }
        return null;
    }

    static boolean isExistingFile(IWorkspace workspace, String fileNameWithPath) {
        if (workspace != null) {
            try {
                StringHolder assignedName = new StringHolder();
                IFileref fileRef = workspace.FileService().AssignFileref("", "DISK", fileNameWithPath, "", assignedName);
                IFileInfo_1_1 fileInfo = IFileInfo_1_1Helper.narrow((Object)fileRef);
                IntHolder intHolder = new IntHolder();
                StringHolder stringHolder = new StringHolder();
                fileInfo.StatusValueEx(intHolder, stringHolder);
                if (intHolder.value == Status.StatusFileExists.value() || intHolder.value == 9) {
                    workspace.FileService().DeassignFileref(assignedName.value);
                    return true;
                }
                workspace.FileService().DeassignFileref(assignedName.value);
                return false;
            }
            catch (GenericError ge) {
                return false;
            }
        }
        return false;
    }
}

