/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.remote;

import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.OLAPMemberNameType;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.models.OLAPMemberName;
import com.sas.models.OLAPMemberNameInterface;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.CollectionValue;
import com.sas.prompts.datatypes.values.DataSourceValue;
import com.sas.prompts.datatypes.values.OLAPMemberNameValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.prompts.definitions.MutableOLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.MutableValueRetrieverDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionSupport;
import com.sas.prompts.definitions.SelectableDefinitionV2Interface;
import com.sas.prompts.definitions.SupportedSpecialValuesDefinitionSupport;
import com.sas.prompts.definitions.ValueProviderDefinitionSupport;
import com.sas.prompts.definitions.ValueRetrieverDefinitionSupport;
import com.sas.prompts.definitions.remote.RB;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.olap.PromptMemberValueProvider;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.vr.dto.DataSource;
import com.sas.storage.vr.dto.DynamicValueRetrieverConfiguration;
import com.sas.storage.vr.dto.QueryItem;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.text.Message;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.Util;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OLAPMemberNameDefinition
extends PromptDefinition
implements MutableOLAPMemberNameDefinitionInterface,
MutableValueRetrieverDefinitionInterface,
SelectableDefinitionV2Interface {
    private static final long serialVersionUID = 7529380833656520081L;
    public static final String RB_KEY = "OLAPMemberNameDefinition.";
    public static String CONFIG_ATTRIBUTE_DATAITEM = "OLAPMemberNameDefinition.CONFIG_ATTRIBUTE_DATAITEM";
    public static String CONFIG_ATTRIBUTE_UNIQUE_HIERARCHY_NAME = "OLAPMemberNameDefinition.CONFIG_ATTRIBUTE_UNIQUE_HIERARCHY_NAME";
    public static String CONFIG_ATTRIBUTE_LEVEL_NAME = "OLAPMemberNameDefinition.CONFIG_ATTRIBUTE_LEVEL_NAME";
    public static String CONFIG_ATTRIBUTE_LEVEL_DEPTH = "OLAPMemberNameDefinition.CONFIG_ATTRIBUTE_LEVEL_DEPTH";
    private SelectableDefinitionSupport selectableSupport;
    private ValueProviderDefinitionSupport valueProviderSupport;
    private SupportedSpecialValuesDefinitionSupport specialValueSupport;
    private ValueRetrieverDefinitionSupport vrDefSupport;
    private DataSourceInterface dataSource;
    private String uniqueHierarchyName;
    private String levelName;
    private DataItem dataItem;
    private String dataItemId;
    private int level;
    private boolean newVPNeeded;

    public OLAPMemberNameDefinition() {
        this.init();
    }

    public OLAPMemberNameDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.selectableSupport = new SelectableDefinitionSupport((SelectableDefinitionInterface)this);
        this.valueProviderSupport = new ValueProviderDefinitionSupport();
        this.specialValueSupport = new SupportedSpecialValuesDefinitionSupport();
        this.specialValueSupport.setAllowMissing(true);
        this.vrDefSupport = new ValueRetrieverDefinitionSupport();
        this.level = -1;
        this.newVPNeeded = false;
    }

    public boolean isPromptValueValid(Object value, Locale locale) {
        return super.isPromptValueValid(value, locale) && this.selectableSupport.isPromptValueValid(value) && this.specialValueSupport.isPromptValueValid(value);
    }

    public boolean validIndividualValue(Object value) {
        return this.validIndividualValue(value, Locale.getDefault());
    }

    public Collection<ValidationEntry> getIndivdualPromptValueValidationErrors(Object value, Locale locale) {
        long returnValue = this.validateIndividualValue(value);
        return this.populateMapWithErrors(null, returnValue, value, false, locale);
    }

    private long validateIndividualValue(Object value) {
        long returnValue = 0L;
        if (value != null && !(value instanceof OLAPMemberNameInterface)) {
            returnValue |= 1L;
        } else if (value instanceof OLAPMemberNameInterface) {
            OLAPMemberNameInterface olap = (OLAPMemberNameInterface)value;
            if (this.getDataSource() != null && olap.getDataSource() != null && !olap.getDataSource().equals((Object)this.getDataSource())) {
                returnValue |= 0x20000000L;
            }
        }
        return returnValue;
    }

    private long validateValue(Object value) {
        long returnValue = 0L;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                returnValue |= this.validateIndividualValue(array[i]);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                returnValue |= this.validateIndividualValue(element);
            }
        } else {
            returnValue |= this.validateIndividualValue(value);
        }
        return returnValue;
    }

    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        errors = PromptUtil.addErrors((Collection)errors, (Collection)this.selectableSupport.getPromptValueValidationErrors(value, locale));
        errors = PromptUtil.addErrors((Collection)errors, (Collection)this.specialValueSupport.getPromptValueValidationErrors(value, locale));
        long returnValue = this.validateValue(value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, (long)1L, (String)Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotAnOLAPMemberName.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, (long)1L, (String)Message.format((String)RB.getStringResource(RB_KEY, "notAnOLAPMemberName.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 0x20000000L) == 0x20000000L) {
            errors = defaultValue ? PromptUtil.addError((Collection)errors, (long)0x20000000L, (String)Message.format((String)RB.getStringResource(RB_KEY, "defaultValueInvalidDataSource.fmt.txt", locale), (Object)value)) : PromptUtil.addError((Collection)errors, (long)0x20000000L, (String)Message.format((String)RB.getStringResource(RB_KEY, "invalidDataSource.fmt.txt", locale), (Object)value));
        }
        return errors;
    }

    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        errors = PromptUtil.addErrors((Collection)errors, (Collection)this.selectableSupport.validateDefinition(dv, locale));
        errors = PromptUtil.addErrors((Collection)errors, (Collection)this.specialValueSupport.validateDefinition(dv, locale));
        errors = PromptUtil.addErrors((Collection)errors, (Collection)this.valueProviderSupport.validateDefinition((PromptDefinitionInterface)this, null, locale));
        errors = PromptUtil.addErrors((Collection)errors, (Collection)this.vrDefSupport.validateDefinitionWithDefinition((PromptDefinitionInterface)this, locale));
        long returnValue = 0L;
        DataSourceInterface dataSource1 = this.getDataSource();
        if (dataSource1 != null) {
            String dataSourceLocation = dataSource1.getDataSourceLocation();
            if (dataSourceLocation == null) {
                returnValue |= 0x20000L;
                errors = PromptUtil.addError((Collection)errors, (long)131072L, (String)RB.getStringResource(RB_KEY, "noDataSource.txt", locale));
            } else if (this.getDataItem() == null && (this.vrDefSupport == null || this.vrDefSupport.getValueRetrieverConfiguration() == null || !(this.vrDefSupport.getValueRetrieverConfiguration() instanceof DynamicValueRetrieverConfiguration) || ((DynamicValueRetrieverConfiguration)this.vrDefSupport.getValueRetrieverConfiguration()).getQueryItems() == null || ((DynamicValueRetrieverConfiguration)this.vrDefSupport.getValueRetrieverConfiguration()).getQueryItems().isEmpty())) {
                returnValue |= 0x10000000L;
                errors = PromptUtil.addError((Collection)errors, (long)0x10000000L, (String)RB.getStringResource(RB_KEY, "noDataItems.txt", locale));
            }
        } else {
            returnValue |= 0x20000L;
            errors = PromptUtil.addError((Collection)errors, (long)131072L, (String)RB.getStringResource(RB_KEY, "noDataSource.txt", locale));
        }
        if (returnValue == 0L) {
            returnValue = this.validateValue(dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    public DataTypeInterface getPromptDataType() {
        if (this.getSelectionType() == 300) {
            return OLAPMemberNameType.DEFAULT_INSTANCE;
        }
        return CollectionType.DEFAULT_INSTANCE_OLAPMEMBER;
    }

    public void setDataSource(DataSourceInterface dataSource) {
        if (dataSource != null && dataSource.getDataSourceType() != 2L && dataSource.getDataSourceType() != 8L) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidDataSourceType.txt"));
        }
        if (!Util.equal((Object)this.dataSource, (Object)dataSource)) {
            this.dataSource = dataSource;
            this.newVPNeeded = true;
        }
    }

    public DataSourceInterface getDataSource() {
        String path;
        DynamicValueRetrieverConfiguration dvrc;
        if (this.dataSource == null && this.vrDefSupport != null && this.vrDefSupport.getValueRetrieverConfiguration() instanceof DynamicValueRetrieverConfiguration && (dvrc = (DynamicValueRetrieverConfiguration)this.vrDefSupport.getValueRetrieverConfiguration()).getQueryItems() != null && !dvrc.getQueryItems().isEmpty()) {
            DataSource ds = ((QueryItem)dvrc.getQueryItems().get(0)).getDataSource();
            this.dataSource = new BaseDataSource(ds.getDataSourceType(), ds.getDataSourceLocation());
        }
        if (this.dataSource == null && this.getDataItem() != null && (path = DataProvider.getPathUrl((DataItem)this.getDataItem())) != null) {
            this.dataSource = new BaseDataSource(8L, path);
        }
        return this.dataSource;
    }

    public String getUniqueHierarchyName() {
        return this.uniqueHierarchyName;
    }

    public void setUniqueHierarchyName(String uniqueHierarchyName) {
        if (!Strings.equal((String)this.uniqueHierarchyName, (String)uniqueHierarchyName, (boolean)true, (boolean)false)) {
            this.uniqueHierarchyName = uniqueHierarchyName;
            this.dataItem = null;
            this.newVPNeeded = true;
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (this.level != level) {
            this.level = level;
            ValueProviderInterface vp = this.valueProviderSupport.getValueProvider();
            if (vp instanceof OLAPDataItemValueProvider) {
                ((OLAPDataItemValueProvider)vp).setDescendentLevel(level);
            } else {
                this.newVPNeeded = true;
            }
        }
    }

    public String getLevelName() {
        return this.levelName;
    }

    public void setLevelName(String levelName) {
        if (this.levelName != levelName) {
            this.levelName = levelName;
            ValueProviderInterface vp = this.valueProviderSupport.getValueProvider();
            if (vp instanceof PromptMemberValueProvider) {
                ((PromptMemberValueProvider)vp).setUniqueLevelName(levelName);
            } else {
                this.newVPNeeded = true;
            }
        }
    }

    public void setDataItem(Object dataItem) {
        if (!(dataItem instanceof DataItem)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "notADataItem.txt"));
        }
        if (!Util.equal((Object)this.dataItem, (Object)dataItem)) {
            this.dataItem = (DataItem)dataItem;
            String path = DataProvider.getPathUrl((DataItem)dataItem);
            if (!(path == null || this.dataSource != null && Strings.equal((String)this.dataSource.getDataSourceLocation(), (String)path, (boolean)false, (boolean)false))) {
                this.dataSource = new BaseDataSource(8L, path);
            } else if (path == null) {
                this.dataSource = null;
            }
            this.uniqueHierarchyName = null;
            this.newVPNeeded = true;
        }
    }

    public Object getDataItem() {
        return this.dataItem;
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.selectableSupport.consumeAttributes(provider);
        this.specialValueSupport.consumeAttributes(provider);
        this.setUniqueHierarchyName(provider.consumeAttr("uniqueHierarchyName"));
        this.setLevel(provider.consumeIntAttr("descendentLevel", -1));
        this.setLevelName(provider.consumeAttr("uniqueLevelName"));
        this.dataItemId = provider.consumeAttr("dataItemId");
        String refId = provider.consumeAttr("referenceId");
        if (null != refId) {
            PromptsReadingContext rc = provider.getReadingContext();
            if (null != rc) {
                Object obj = rc.getObject(refId);
                if (obj instanceof DataItem) {
                    this.setDataItem(obj);
                    this.getLogger2().debug("Found a DataItem for this id:", refId);
                } else {
                    String msg = MessageFormat.format(RB.getStringResource("OLAPMemberNameDefinition.noDataItem.log.fmt"), refId);
                    this.getLogger2().warn(msg);
                }
            } else {
                this.getLogger2().warn(RB.getStringResource("OLAPMemberNameDefinition.noReadingContext.log"));
            }
        }
        this.getLogger2().debug("consumeAttributes on ", this.getPromptName());
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        IntegratedWritingContext outer;
        super.writeDefinition(element, writingContext);
        this.selectableSupport.writeDefinition(element, writingContext);
        this.specialValueSupport.writeDefinition(element, writingContext);
        if (this.uniqueHierarchyName != null) {
            XmlUtil.setAttr((Element)element, (String)"uniqueHierarchyName", (String)this.uniqueHierarchyName);
        }
        if (null != (outer = writingContext.getOuterContext()) && null != this.getDataItem()) {
            String refId = outer.getReference(this.getDataItem());
            if (null != refId) {
                this.getLogger2().debug("Writing DataItem reference:", refId);
                XmlUtil.setAttr((Element)element, (String)"referenceId", (String)refId);
                XmlUtil.setIntAttr((Element)element, (String)"descendentLevel", (int)this.level, (int)-1);
            } else {
                this.getLogger2().error(RB.getStringResource("OLAPMemberNameDefinition.noRefID.log"));
            }
        } else {
            QueryItem qi;
            List queryItems;
            this.getLogger2().debug("Writing dataItemId and infoMapUrl for web service and shared prompt cases.");
            if (null != this.getDataItem()) {
                try {
                    this.getLogger2().debug("Writing id and url for real DataItem.");
                    XmlUtil.setAttr((Element)element, (String)"dataItemId", (String)((DataItem)this.getDataItem()).getID());
                }
                catch (InvalidIDException e) {
                    this.getLogger2().error(e.getMessage(), (Throwable)e);
                }
            } else if (this.dataItemId != null) {
                XmlUtil.setAttr((Element)element, (String)"dataItemId", (String)this.dataItemId);
            } else if (null != this.vrDefSupport.getValueRetrieverConfiguration() && this.vrDefSupport.getValueRetrieverConfiguration() instanceof DynamicValueRetrieverConfiguration && (queryItems = ((DynamicValueRetrieverConfiguration)this.vrDefSupport.getValueRetrieverConfiguration()).getQueryItems()) != null && !queryItems.isEmpty() && (qi = (QueryItem)queryItems.get(0)).getUniqueName() != null && qi.getDataSource() != null && qi.getDataSource().getDataSourceType() == 8L) {
                XmlUtil.setAttr((Element)element, (String)"dataItemId", (String)qi.getUniqueName());
            }
            if (this.getDataSource() != null) {
                ArrayList<PersistenceInterface> valueObjects = new ArrayList<PersistenceInterface>();
                PersistenceInterface itemValue = ValueUtil.getPersistableValue((Object)this.dataSource);
                valueObjects.add(itemValue);
                OLAPMemberNameDefinition.writeRelatedObjects(valueObjects, (Node)element, (PromptsWritingContext)writingContext, (String)"DataSource");
                if (this.dataSource.getDataSourceType() == 8L) {
                    XmlUtil.setIntAttr((Element)element, (String)"descendentLevel", (int)this.level, (int)-1);
                }
                if (this.dataSource.getDataSourceType() == 2L && this.levelName != null) {
                    XmlUtil.setAttr((Element)element, (String)"uniqueLevelName", (String)this.levelName);
                }
            }
        }
    }

    protected List writeDefaultValue() {
        Object defValue;
        ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>();
        if (this.isDefaultValueSet() && (defValue = this.getDefaultValue()) != null) {
            PersistenceInterface value = ValueUtil.getPersistableValue((Object)defValue);
            if (value == null) {
                this.getLogger2().error("Unable to get persistable value for " + defValue, "class=" + defValue.getClass().getName());
                this.getLogger2().error(this.getPromptName());
            } else if (value instanceof OLAPMemberNameValue) {
                OLAPMemberNameValue omnv = (OLAPMemberNameValue)value;
                ((OLAPMemberName)omnv.getValue()).setDataSource(null);
            } else if (value instanceof CollectionValue) {
                CollectionValue cv = (CollectionValue)value;
                List l = (List)cv.getValue();
                ArrayList<OLAPMemberName> newList = new ArrayList<OLAPMemberName>();
                if (l != null) {
                    for (Object o : l) {
                        if (!(o instanceof OLAPMemberName)) continue;
                        OLAPMemberName omn = (OLAPMemberName)o;
                        OLAPMemberName omn2 = (OLAPMemberName)OLAPMemberNameType.DEFAULT_INSTANCE.copyValue((Object)omn, Locale.getDefault());
                        omn2.setDataSource(null);
                        newList.add(omn2);
                    }
                }
                cv.setValue(newList);
            }
            list.add(value);
        }
        return list;
    }

    protected void consumeDefaultValue(List list) {
        if (!list.isEmpty()) {
            BasePersistedValue value = (BasePersistedValue)list.get(0);
            Object obj = value.getValue();
            this.setDefaultValue(obj);
        }
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList list;
        this.selectableSupport.consumeRelatedObjects(roHolder);
        this.specialValueSupport.consumeRelatedObjects(roHolder);
        ValueRetrieverDefinitionSupport temp = ValueRetrieverDefinitionSupport.newInstanceFromPersistence((RelatedObjectListsHolder)roHolder);
        if (null != temp) {
            Map optionsMap;
            UserContextInterface userContext;
            PromptsReadingContext rc;
            this.vrDefSupport = temp;
            if (null == this.dataItem && null != (rc = roHolder.getReadingContext()) && null != rc.getOptionsMap() && null != (userContext = (UserContextInterface)(optionsMap = rc.getOptionsMap()).get("USER_CONTEXT"))) {
                this.getLogger2().debug("Found a user context, so can make a DataProvider.");
                DataProvider dataProvider = new DataProvider(userContext);
                try {
                    DynamicValueRetrieverConfiguration dvrc;
                    String diId = null;
                    if (this.vrDefSupport != null && this.vrDefSupport.getValueRetrieverConfiguration() instanceof DynamicValueRetrieverConfiguration && (dvrc = (DynamicValueRetrieverConfiguration)this.vrDefSupport.getValueRetrieverConfiguration()).getQueryItems() != null && !dvrc.getQueryItems().isEmpty()) {
                        diId = ((QueryItem)dvrc.getQueryItems().get(0)).getUniqueName();
                    }
                    if (diId != null) {
                        DataItem di = dataProvider.getDataItemFromId(this.getDataSource().getDataSourceLocation(), diId);
                        if (di == null) {
                            String msg = MessageFormat.format(RB.getStringResource("OLAPMemberNameDefinition.invalidDataItemID.fmt.txt"), diId);
                            throw new IllegalStateException(msg);
                        }
                        this.setDataItem(di);
                        this.dataItemId = null;
                    }
                }
                catch (ServerConnectionException e) {
                    this.getLogger2().error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (!(list = roHolder.consumeObjects("DataSource")).isEmpty()) {
            Map optionsMap;
            UserContextInterface userContext;
            PromptsReadingContext rc;
            this.getLogger2().debug("consumeRelObjects, DataSource ");
            DataSourceInterface dataSource = (DataSourceInterface)((DataSourceValue)list.get(0)).getValue();
            this.setDataSource(dataSource);
            if (this.dataItemId != null && dataSource.getDataSourceType() == 8L && null == this.dataItem && null != (rc = roHolder.getReadingContext()) && null != rc.getOptionsMap() && null != (userContext = (UserContextInterface)(optionsMap = rc.getOptionsMap()).get("USER_CONTEXT"))) {
                this.getLogger2().debug("Found a user context, so can make a DataProvider.");
                DataProvider dataProvider = new DataProvider(userContext);
                try {
                    DataItem di = dataProvider.getDataItemFromId(dataSource.getDataSourceLocation(), this.dataItemId);
                    if (di == null) {
                        String msg = MessageFormat.format(RB.getStringResource("OLAPMemberNameDefinition.invalidDataItemID.fmt.txt"), this.dataItemId);
                        throw new IllegalStateException(msg);
                    }
                    this.setDataItem(di);
                    this.dataItemId = null;
                }
                catch (ServerConnectionException e) {
                    this.getLogger2().error(e.getMessage(), (Throwable)e);
                }
            }
        }
        super.consumeRelatedObjects(roHolder);
    }

    public String getDefinitionElementName() {
        return "OLAPMemberNameDefinition";
    }

    public List getReferencedResources(Class type, boolean recursive) {
        List list1 = this.vrDefSupport.getReferencedResources(type, recursive);
        if (list1.isEmpty()) {
            List list2 = this.valueProviderSupport.getReferencedResources(type, recursive);
            return list2;
        }
        return list1;
    }

    public boolean isRequired() {
        return this.selectableSupport.isRequired();
    }

    public int getMaximumValueCount() {
        return this.selectableSupport.getMaximumValueCount();
    }

    public int getMinimumValueCount() {
        return this.selectableSupport.getMinimumValueCount();
    }

    public int getSelectionType() {
        return this.selectableSupport.getSelectionType();
    }

    public boolean isSelectionOrdered() {
        return this.selectableSupport.isSelectionOrdered();
    }

    public void setMaximumValueCount(int maximumValueCount) {
        this.selectableSupport.setMaximumValueCount(maximumValueCount);
    }

    public void setMinimumValueCount(int minimumValueCount) {
        this.selectableSupport.setMinimumValueCount(minimumValueCount);
    }

    public void setSelectionOrdered(boolean selectionOrdered) {
        this.selectableSupport.setSelectionOrdered(selectionOrdered);
    }

    public int getMacroVariableListFormat() {
        return this.selectableSupport.getMacroVariableListFormat();
    }

    public String getMacroVariableQuote() {
        return this.selectableSupport.getMacroVariableQuote();
    }

    public String getMacroVariableListDelimiter() {
        return this.selectableSupport.getMacroVariableListDelimiter();
    }

    public void setMacroVariableListFormat(int listFormat) {
        this.selectableSupport.setMacroVariableListFormat(listFormat);
    }

    public void setMacroVariableQuote(String quote) {
        this.selectableSupport.setMacroVariableQuote(quote);
    }

    public void setMacroVariableListDelimiter(String delimiter) {
        this.selectableSupport.setMacroVariableListDelimiter(delimiter);
    }

    public ValueProviderInterface getValueProvider() {
        if (this.newVPNeeded) {
            DynamicValueProviderInterface vp = null;
            if (this.getDataItem() != null) {
                vp = new OLAPDataItemValueProvider();
                if (this.getDataItem() != null) {
                    vp.setDataItem(this.dataItem);
                }
            } else if (this.dataItemId != null && this.dataSource.getDataSourceType() == 8L) {
                vp = new OLAPDataItemValueProvider();
                vp.setInfoMapUrl(this.dataSource.getDataSourceLocation());
                vp.setDataItemId(this.dataItemId);
            } else if (this.dataSource.getDataSourceType() == 2L) {
                vp = new PromptMemberValueProvider(this.dataSource.getDataSourceLocation());
                ((PromptMemberValueProvider)vp).setUniqueHierarchyName(this.uniqueHierarchyName);
                if (this.getLevelName() != null) {
                    ((PromptMemberValueProvider)vp).setUniqueLevelName(this.getLevelName());
                }
            }
            if (this.getLevel() != -1 && vp instanceof OLAPDataItemValueProvider) {
                vp.setDescendentLevel(this.level);
            }
            this.valueProviderSupport.setValueProvider((ValueProviderInterface)vp);
            this.newVPNeeded = false;
        }
        return this.valueProviderSupport.getValueProvider();
    }

    public boolean isAllowUserValues() {
        return false;
    }

    public int getPageSize() {
        return 100;
    }

    public Collection<PromptDefinitionInterface> getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValueContext) {
        try {
            if (this.getValueProvider() instanceof DynamicValueProviderInterface) {
                return ((DynamicValueProviderInterface)this.getValueProvider()).getDependentPrompts(locale, dynamicValueContext);
            }
        }
        catch (ValueProviderException ve) {
            this.getLogger2().error(ve.getMessage(), (Throwable)ve);
        }
        return this.vrDefSupport.getDependentPrompts(locale, dynamicValueContext);
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValueSupport.getSupportedSpecialValues();
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValuesSupported) {
        this.specialValueSupport.setSupportedSpecialValues(specialValuesSupported);
    }

    public PropertyList getLocalizableProperties(Locale locale) {
        PropertyList list = super.getLocalizableProperties(locale);
        PromptUtil.addLocalizedPropertiesFromValueProvider((PropertyList)list, (ValueProviderDefinitionSupport)this.valueProviderSupport, (Locale)locale);
        this.vrDefSupport.addLocalizedPropertiesFromValueRetriever(locale, list);
        return list;
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        super.setLocalizableProperties(locale, map);
        PromptUtil.setLocalizedPropertiesOnValueProvider((PropertyMap)map, (ValueProviderDefinitionSupport)this.valueProviderSupport, (Locale)locale);
        this.vrDefSupport.setLocalizedPropertiesOnValueRetriever(locale, map);
    }

    public void setValueRetrieverConfiguration(ValueRetrieverConfiguration config) {
        this.vrDefSupport = ValueRetrieverDefinitionSupport.newInstance((ValueRetrieverConfiguration)config);
    }

    public ValueRetrieverConfiguration getValueRetrieverConfiguration() {
        this.vrDefSupport.setApplicationContext(this.getApplicationContext());
        ValueRetrieverConfiguration vrc = this.vrDefSupport.getValueRetrieverConfiguration();
        return vrc;
    }

    public Object clone() throws CloneNotSupportedException {
        OLAPMemberNameDefinition clone = (OLAPMemberNameDefinition)((Object)super.clone());
        if (null != this.vrDefSupport) {
            clone.vrDefSupport = (ValueRetrieverDefinitionSupport)this.vrDefSupport.clone();
        }
        return clone;
    }

    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        this.selectableSupport.configurePrompt((MutableSelectableDefinitionInterface)this, options, context);
        this.specialValueSupport.configurePrompt((MutableSupportedSpecialValuesInterface)this, options, context);
        super.configureAttributes(options, context);
        if (options.containsKey("dataSources")) {
            this.setDataSource(PromptConfigurationFactory.getDataSourceOption((String)"dataSources", options, context));
        }
        if (options.containsKey("dataItemId")) {
            this.dataItemId = PromptConfigurationFactory.getStringOption((String)"dataItemId", options, context);
        }
        if (options.containsKey(CONFIG_ATTRIBUTE_UNIQUE_HIERARCHY_NAME)) {
            this.uniqueHierarchyName = PromptConfigurationFactory.getStringOption((String)CONFIG_ATTRIBUTE_UNIQUE_HIERARCHY_NAME, options, context);
        }
        if (options.containsKey(CONFIG_ATTRIBUTE_LEVEL_NAME)) {
            this.uniqueHierarchyName = PromptConfigurationFactory.getStringOption((String)CONFIG_ATTRIBUTE_LEVEL_NAME, options, context);
        }
        if (options.containsKey(CONFIG_ATTRIBUTE_LEVEL_DEPTH)) {
            this.level = PromptConfigurationFactory.getIntOption((String)CONFIG_ATTRIBUTE_LEVEL_DEPTH, options, context);
        }
        if (options.containsKey(CONFIG_ATTRIBUTE_DATAITEM)) {
            this.setDataItem(options.get(CONFIG_ATTRIBUTE_DATAITEM));
        }
        this.vrDefSupport = ValueRetrieverDefinitionSupport.changeInstanceType((ValueRetrieverDefinitionSupport)this.vrDefSupport, options);
        this.vrDefSupport.configureAttributes(options, context);
        this.valueProviderSupport.configurePrompt((SelectableDefinitionInterface)this, options, context);
    }

    public boolean validIndividualValue(Object value, Locale locale) {
        long returnValue = this.validateIndividualValue(value);
        return returnValue == 0L;
    }

    public String getVersion() {
        String tempVersion = super.getVersion();
        if (null != this.getValueRetrieverConfiguration()) {
            try {
                if (XmlUtil.compareVersionStrings((String)tempVersion, (String)"2.0") <= 0) {
                    tempVersion = "2.0";
                }
            }
            catch (ParseException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        this.getLogger2().debug("version is:", tempVersion);
        return tempVersion;
    }
}

