/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.edit.models.providers;

import com.sas.entities.edit.models.providers.DynamicValuesProviderInterface;
import com.sas.entities.edit.models.providers.RB;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.BusinessRule;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.InformationMapFactory;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;

public class BusinessQueryDynamicValuesProvider
implements DynamicValuesProviderInterface {
    private String mapPath;
    private String dataItemID;
    private DataItemActionType sortDirection;
    private int maxValues;
    public static final String RB_KEY = "BusinessQueryDynamicValuesProvider.";

    public BusinessQueryDynamicValuesProvider(String mapPath, String dataItemID, DataItemActionType sortDirection, int maxValues) {
        this.sortDirection = sortDirection == DataItemActionType.SORT_DESCENDING || sortDirection == DataItemActionType.SORT_ASCENDING || sortDirection == DataItemActionType.SORT_NONE ? sortDirection : DataItemActionType.SORT_NONE;
        this.mapPath = mapPath;
        this.dataItemID = dataItemID;
        this.sortDirection = sortDirection;
        this.maxValues = maxValues;
    }

    public String getDataItemID() {
        return this.dataItemID;
    }

    public String getMapPath() {
        return this.mapPath;
    }

    public DataItemActionType getSortDirection() {
        return this.sortDirection;
    }

    public int getMaxValues() {
        return this.maxValues;
    }

    public Map getMapOfValues(Object context) {
        if (context instanceof Object[] && ((Object[])context).length == 2) {
            Map valueMap = null;
            Object[] contextInfo = (Object[])context;
            SessionContextInterface session = null;
            QueryConnectorInterface connector = null;
            if (contextInfo[0] instanceof SessionContextInterface) {
                session = (SessionContextInterface)contextInfo[0];
            }
            if (contextInfo[1] != null && !(contextInfo[1] instanceof QueryConnectorInterface)) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "missingContext.ex.txt"));
            }
            connector = (QueryConnectorInterface)contextInfo[1];
            try {
                valueMap = BusinessQueryDynamicValuesProvider.getValueMap(connector, session, this.getMapPath(), this.getDataItemID(), this.getSortDirection(), this.getMaxValues());
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException(RB.getStringResource(RB_KEY, "mapError.ex.txt"));
                ise.initCause(e);
                throw ise;
            }
            return valueMap;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "missingContext.ex.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getValueMap(QueryConnectorInterface queryConnector, SessionContextInterface sessionContext, String mapPath, String dataItemID, DataItemActionType sortDirection, int maxValues) throws IntelligentQueryException, ExecutionException, MetadataException, SQLException {
        LinkedHashMap<Object, Object> valueMap = new LinkedHashMap<Object, Object>();
        if (sessionContext != null && mapPath != null && dataItemID != null) {
            ResultSet resultSet = null;
            try (ResultSetInterface iqResultSet = null;){
                BusinessItem item;
                IntelligentQueryMetadataServiceInterface queryService = IntelligentQueryMetadataServiceFactory.newService();
                InformationMap informationMap = InformationMapFactory.getInstance().newInformationMap(sessionContext, queryService, new PathUrl(mapPath));
                StructureOfData structure = informationMap.getStructure();
                if (structure != null && !structure.isOLAP() && (item = informationMap.getBusinessItemByID(dataItemID)) instanceof DataItem) {
                    Map results;
                    Object rs;
                    DataItem dataItem = (DataItem)item;
                    DataSelection ds = BusinessQueryDynamicValuesProvider.getDataSelection(informationMap, dataItem, sortDirection, maxValues);
                    ArrayList<DataSelection> selectionList = new ArrayList<DataSelection>();
                    selectionList.add(ds);
                    QueryConnectorInterface connector = queryConnector;
                    if (queryConnector == null) {
                        connector = new QueryConnector();
                        RetrievalPolicy policy = new RetrievalPolicy();
                        policy.setPolicyValue(0);
                        policy.getConnectionConfiguration().setConnectionLifetime(0);
                    }
                    if ((rs = (iqResultSet = (ResultSetInterface)(results = connector.retrieveQueryResultMap(selectionList)).get(ds.getID())).getResultSet()) instanceof ResultSet) {
                        resultSet = (ResultSet)rs;
                        ResultSetMetaData meta = resultSet.getMetaData();
                        int type = meta.getColumnType(1);
                        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                        while (resultSet.next()) {
                            if (type == 91) {
                                valueMap.put(resultSet.getDate(1, cal), resultSet.getObject(2));
                                continue;
                            }
                            if (type == 92) {
                                valueMap.put(resultSet.getTime(1, cal), resultSet.getObject(2));
                                continue;
                            }
                            if (type == 93) {
                                valueMap.put(resultSet.getTimestamp(1, cal), resultSet.getObject(2));
                                continue;
                            }
                            valueMap.put(resultSet.getObject(1), resultSet.getObject(2));
                        }
                    }
                }
            }
        }
        return valueMap;
    }

    private static DataSelection getDataSelection(InformationMap informationMap, DataItem dataItem, DataItemActionType sortDirection, int maxValues) throws MetadataException {
        DataSelection dataSelection = DataSelectionFactory.newDataSelection((BusinessModel)informationMap);
        dataSelection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, true);
        dataSelection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
        DataItem dataItemUnformatted = dataItem;
        dataItemUnformatted.setFormattingForced(false);
        dataItemUnformatted.setUsage(DataItemActionType.USAGE_DETAIL);
        if (sortDirection == null) {
            sortDirection = DataItemActionType.SORT_NONE;
        }
        dataItemUnformatted.setSortDirection(sortDirection);
        RootDataItem dataItemFormatted = informationMap.newDataItem();
        informationMap.addBusinessItem((BusinessItem)dataItemFormatted);
        dataItemFormatted.setExpression(dataItemUnformatted.getExpression());
        dataItemFormatted.setFormat(dataItemUnformatted.getFormat());
        dataItemFormatted.setFormattingForced(true);
        DataItemReference dataItemRefUnformatted = dataSelection.getBusinessModel().newDataItemReference(dataItemUnformatted);
        DataItemReference dataItemRefFormatted = dataSelection.getBusinessModel().newDataItemReference((DataItem)dataItemFormatted);
        dataSelection.addBusinessItem((BusinessItem)dataItemRefUnformatted);
        dataSelection.addResultItem((DataItem)dataItemRefUnformatted, null);
        dataSelection.addBusinessItem((BusinessItem)dataItemRefFormatted);
        dataSelection.addResultItem((DataItem)dataItemRefFormatted, null);
        Governing govern = informationMap.newGoverning();
        informationMap.addBusinessRule((BusinessRule)govern);
        govern.setOutputObservations(maxValues);
        dataSelection.addBusinessRule((BusinessRule)govern);
        return dataSelection;
    }
}

