/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.totals;

import com.sas.dataselectors.totals.BaseTotalsSelectorAdapter;
import com.sas.dataselectors.totals.OLAPTotalsSelectorInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryTotalLocationType;
import com.sas.iquery.metadata.business.BusinessQueryTotalModeType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;

public class OLAPTotalsSelectorAdapter
extends BaseTotalsSelectorAdapter
implements OLAPTotalsSelectorInterface {
    protected boolean rowSubtotals;
    protected boolean rowTotals;
    protected boolean columnSubtotals;
    public String totalsType;
    public String totalsPosition;
    protected boolean expandedTotals;
    protected int percentOfTotalsApplied;

    public boolean rowSubtotals() {
        if (this.valuesFromDataModel()) {
            BusinessQuery dataModel = this.dataModel();
            String role = dataModel.getTotalType(Role.COLUMN);
            this.rowSubtotals(role.equalsIgnoreCase(BusinessQuery.ALLTOTAL) || role.equalsIgnoreCase(BusinessQuery.SUBTOTAL));
        }
        return this.rowSubtotals;
    }

    public void rowSubtotals(boolean rowSubtotals) {
        this.rowSubtotals = rowSubtotals;
    }

    public boolean rowTotals() {
        if (this.valuesFromDataModel()) {
            BusinessQuery dataModel = this.dataModel();
            String role = dataModel.getTotalType(Role.COLUMN);
            this.rowTotals(role.equalsIgnoreCase(BusinessQuery.ALLTOTAL) || role.equalsIgnoreCase(BusinessQuery.AXISTOTAL));
        }
        return this.rowTotals;
    }

    public void rowTotals(boolean rowTotals) {
        this.rowTotals = rowTotals;
    }

    public boolean columnSubtotals() {
        if (this.valuesFromDataModel()) {
            BusinessQuery dataModel = this.dataModel();
            String role = dataModel.getTotalType(Role.ROW);
            this.columnSubtotals(role.equalsIgnoreCase(BusinessQuery.ALLTOTAL) || role.equalsIgnoreCase(BusinessQuery.SUBTOTAL));
        }
        return this.columnSubtotals;
    }

    public void columnSubtotals(boolean columnSubtotals) {
        this.columnSubtotals = columnSubtotals;
    }

    public boolean isExpandedTotals() {
        if (this.valuesFromDataModel()) {
            BusinessQuery dataModel = this.dataModel();
            this.setExpandedTotals(!dataModel.isAxisValuesCoalesced());
        }
        return this.expandedTotals;
    }

    public void setExpandedTotals(boolean expanded) {
        this.expandedTotals = expanded;
    }

    public String getTotalsPosition() {
        if (this.valuesFromDataModel()) {
            BusinessQuery dataModel = this.dataModel();
            String tPos = BusinessQueryTotalLocationType.TOTAL_TOTAL_ROW_TOP_COLUMN_LEFT.equals(dataModel.getTotalLocation()) ? "T" : "B";
            this.setTotalsPosition(tPos);
        }
        return this.totalsPosition;
    }

    public void setTotalsPosition(String position) {
        if ("B".equals(position) || "T".equals(position)) {
            this.totalsPosition = position;
        }
    }

    public String getTotalsType() {
        if (this.valuesFromDataModel()) {
            BusinessQuery dataModel = this.dataModel();
            String tType = BusinessQueryTotalModeType.CUBE_VALUES.equals(dataModel.getTotalMode()) ? "U" : "V";
            this.setTotalsType(tType);
        }
        return this.totalsType;
    }

    public void setTotalsType(String type) {
        if ("U".equals(type) || "V".equals(type)) {
            this.totalsType = type;
        }
    }

    public int getAppliedPercentOfTotals() {
        boolean vfdm = this.valuesFromDataModel();
        this.valuesFromDataModel(true);
        int pct = 0;
        BusinessQuery model = this.dataModel();
        for (DataItem dataItem : model.getBusinessModel().getObjects(true, DataItem.class)) {
            ExpressionInterface exp = dataItem.getExpression();
            if (!(exp instanceof FractionOfTotalExpression)) continue;
            switch (((FractionOfTotalExpression)exp).getDenominatorType()) {
                case 5: {
                    pct |= 2;
                    break;
                }
                case 3: {
                    pct |= 1;
                    break;
                }
                case 1: {
                    pct |= 5;
                    break;
                }
                case 4: {
                    pct |= 8;
                    break;
                }
                case 2: {
                    pct |= 4;
                    break;
                }
            }
        }
        this.percentOfTotalsApplied = pct;
        this.valuesFromDataModel(vfdm);
        return this.percentOfTotalsApplied;
    }

    public boolean isGoingToRemovePercentOfTotal() {
        boolean isR = false;
        boolean vfdm = this.valuesFromDataModel();
        this.valuesFromDataModel(false);
        switch (this.getAppliedPercentOfTotals()) {
            case 1: {
                if (this.columnTotals()) break;
                isR = true;
                break;
            }
            case 2: {
                if (this.columnSubtotals()) break;
                isR = true;
                break;
            }
            case 3: {
                if (this.columnSubtotals() && this.columnTotals()) break;
                isR = true;
                break;
            }
            case 4: {
                if (this.rowTotals()) break;
                isR = true;
                break;
            }
            case 5: {
                if (this.rowTotals() && this.columnTotals()) break;
                isR = true;
                break;
            }
            case 6: {
                if (this.rowTotals() && this.columnSubtotals()) break;
                isR = true;
                break;
            }
            case 7: {
                if (this.rowTotals() && this.columnSubtotals() && this.columnSubtotals()) break;
                isR = true;
                break;
            }
            case 8: {
                if (this.rowSubtotals()) break;
                isR = true;
                break;
            }
            case 9: {
                if (this.rowSubtotals() && this.columnTotals()) break;
                isR = true;
                break;
            }
            case 10: {
                if (this.rowSubtotals() && this.columnSubtotals()) break;
                isR = true;
                break;
            }
            case 11: {
                if (this.rowSubtotals() && this.columnSubtotals() && this.columnTotals()) break;
                isR = true;
                break;
            }
            case 12: {
                if (this.rowSubtotals() && this.rowTotals()) break;
                isR = true;
                break;
            }
            case 13: {
                if (this.rowSubtotals() && this.rowTotals() && this.columnTotals()) break;
                isR = true;
                break;
            }
            case 14: {
                if (this.rowSubtotals() && this.rowTotals() && this.columnSubtotals()) break;
                isR = true;
                break;
            }
            case 15: {
                if (this.rowSubtotals() && this.rowTotals() && this.columnSubtotals() && this.columnTotals()) break;
                isR = true;
                break;
            }
        }
        this.valuesFromDataModel(vfdm);
        return isR;
    }
}

