/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.sort;

import com.sas.dataselectors.sort.OLAPSortSelectorAdapter;
import com.sas.dataselectors.sort.OLAPSortSelectorInterface;
import com.sas.dataselectors.sort.RB;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.embedded.OLAPDataSet;
import com.sas.swing.models.OLAPMemberDeferredRetrievalTreeNode;
import com.sas.swing.models.OLAPMemberTreeNode;
import com.sas.swing.visuals.dataselectors.sort.SortedItem;
import com.sas.util.SortDirectionInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class OLAPSortSelectorModelFactory
implements SortDirectionInterface {
    public static final String RB_KEY = "OLAPSortSelectorModelFactory.";

    public static OLAPSortSelectorInterface getAdapter(OLAPDataSetInterface model) {
        OLAPSortSelectorAdapter adapter = new OLAPSortSelectorAdapter();
        if (model != null) {
            try {
                if (model instanceof BusinessQueryProviderInterface) {
                    BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
                    AxisInterface[] axes = model.getResultSetMetadata().getAxes(0, -1);
                    AxisInterface rowAxis = null;
                    AxisInterface columnAxis = null;
                    for (int i = 0; i < axes.length; ++i) {
                        if (axes[i].getAxisNumber() == 1) {
                            rowAxis = axes[i];
                            continue;
                        }
                        if (axes[i].getAxisNumber() != 0) continue;
                        columnAxis = axes[i];
                    }
                    if (businessQuery.isActionSupported(BusinessQueryActionType.SORT_ASCENDING) && businessQuery.isActionSupported(BusinessQueryActionType.SORT_DESCENDING) && businessQuery.isActionSupported(BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING) && businessQuery.isActionSupported(BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING)) {
                        ArrayList id;
                        String name;
                        int dir;
                        BusinessQueryActionType sortDirection;
                        int size;
                        DefaultTreeModel availableCellValueItems = new DefaultTreeModel((TreeNode)new OLAPMemberDeferredRetrievalTreeNode(model, new int[]{1, 0}, true));
                        adapter.setAvailableCellValueItems(availableCellValueItems);
                        List rowCellsSorted = businessQuery.getSortCriteria(Role.COLUMN);
                        List columnCellsSorted = businessQuery.getSortCriteria(Role.ROW);
                        boolean cellValueHier = true;
                        DefaultMutableTreeNode cellSortedRoot = new DefaultMutableTreeNode(RB.getStringResource(RB_KEY, "root.txt"));
                        DefaultTreeModel cellSorted = new DefaultTreeModel(cellSortedRoot);
                        cellSorted.setAsksAllowsChildren(false);
                        ArrayList<Integer> cellValueDirections = new ArrayList<Integer>();
                        if (rowAxis != null) {
                            OLAPMemberTreeNode cellSortedRowNode = new OLAPMemberTreeNode(rowAxis);
                            size = rowCellsSorted.size();
                            sortDirection = businessQuery.getSortDirection(Role.COLUMN);
                            dir = 0;
                            if (sortDirection == BusinessQueryActionType.SORT_ASCENDING) {
                                cellValueHier = false;
                                dir = 0;
                                cellValueDirections.add(new Integer(0));
                            } else if (sortDirection == BusinessQueryActionType.SORT_DESCENDING) {
                                cellValueHier = false;
                                dir = 1;
                                cellValueDirections.add(new Integer(1));
                            } else if (sortDirection == BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING) {
                                dir = 0;
                                cellValueDirections.add(new Integer(0));
                            } else if (sortDirection == BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING) {
                                dir = 1;
                                cellValueDirections.add(new Integer(1));
                            }
                            if (sortDirection != BusinessQueryActionType.SORT_NONE && rowCellsSorted != null && size > 0) {
                                name = null;
                                id = new ArrayList();
                                name = OLAPSortSelectorModelFactory.getNameOfSortedItem(rowCellsSorted, id, model, businessQuery);
                                cellSortedRowNode.add(new DefaultMutableTreeNode(new SortedItem((Object)name, dir, id, 2)));
                            }
                            cellSortedRoot.add((MutableTreeNode)cellSortedRowNode);
                        }
                        if (columnAxis != null) {
                            OLAPMemberTreeNode cellSortedColumnNode = new OLAPMemberTreeNode(columnAxis);
                            size = columnCellsSorted.size();
                            sortDirection = businessQuery.getSortDirection(Role.ROW);
                            dir = 0;
                            if (sortDirection == BusinessQueryActionType.SORT_ASCENDING) {
                                cellValueHier = false;
                                dir = 0;
                                cellValueDirections.add(new Integer(0));
                            } else if (sortDirection == BusinessQueryActionType.SORT_DESCENDING) {
                                cellValueHier = false;
                                dir = 1;
                                cellValueDirections.add(new Integer(1));
                            } else if (sortDirection == BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING) {
                                dir = 0;
                                cellValueDirections.add(new Integer(0));
                            } else if (sortDirection == BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING) {
                                dir = 1;
                                cellValueDirections.add(new Integer(1));
                            }
                            if (sortDirection != BusinessQueryActionType.SORT_NONE && columnCellsSorted != null && size > 0) {
                                name = null;
                                id = new ArrayList();
                                name = OLAPSortSelectorModelFactory.getNameOfSortedItem(columnCellsSorted, id, model, businessQuery);
                                cellSortedColumnNode.add(new DefaultMutableTreeNode(new SortedItem((Object)name, dir, id, 1)));
                            }
                            cellSortedRoot.add((MutableTreeNode)cellSortedColumnNode);
                        }
                        int[] sortedCellValueDirections = new int[cellValueDirections.size()];
                        for (int i = 0; i < sortedCellValueDirections.length; ++i) {
                            sortedCellValueDirections[i] = (Integer)cellValueDirections.get(i);
                        }
                        adapter.setCellValueHierarchicalSort(cellValueHier);
                        adapter.setSortedCellValueDirections(sortedCellValueDirections);
                        adapter.setSortedCellValueItems(cellSorted);
                    }
                    List items = businessQuery.getResultItems(Role.COLUMN);
                    items.addAll(businessQuery.getResultItems(Role.ROW));
                    DefaultMutableTreeNode availRoot = new DefaultMutableTreeNode(RB.getStringResource(RB_KEY, "root.txt"));
                    DefaultTreeModel avail = new DefaultTreeModel(availRoot);
                    avail.setAsksAllowsChildren(false);
                    DefaultMutableTreeNode availRowNode = new DefaultMutableTreeNode(RB.getStringResource(RB_KEY, "rows.txt"));
                    DefaultMutableTreeNode availColumnNode = new DefaultMutableTreeNode(RB.getStringResource(RB_KEY, "columns.txt"));
                    availRoot.add(availRowNode);
                    availRoot.add(availColumnNode);
                    DefaultMutableTreeNode sortRoot = new DefaultMutableTreeNode(RB.getStringResource(RB_KEY, "root.txt"));
                    DefaultTreeModel sorted = new DefaultTreeModel(sortRoot);
                    sorted.setAsksAllowsChildren(false);
                    DefaultMutableTreeNode sortRowNode = new DefaultMutableTreeNode(RB.getStringResource(RB_KEY, "rows.txt"));
                    DefaultMutableTreeNode sortColumnNode = new DefaultMutableTreeNode(RB.getStringResource(RB_KEY, "columns.txt"));
                    sortRoot.add(sortRowNode);
                    sortRoot.add(sortColumnNode);
                    ArrayList<Integer> directions = new ArrayList<Integer>();
                    boolean hier = true;
                    String[] rowDims = null;
                    String[] colDims = null;
                    DefaultMutableTreeNode node = null;
                    String[] dimensions = null;
                    AxisInterface axis = null;
                    if (rowAxis != null) {
                        rowDims = rowAxis.getDimensionNames();
                    }
                    if (columnAxis != null) {
                        colDims = columnAxis.getDimensionNames();
                    }
                    for (int i = items.size() - 1; i >= 0; --i) {
                        DataItem di = (DataItem)items.get(i);
                        if (!di.isActionSupported(DataItemActionType.SORT_ASCENDING) || !di.isActionSupported(DataItemActionType.SORT_DESCENDING) || di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) continue;
                        Role role = businessQuery.getResultItemRole(di);
                        DataItemActionType sortDirection = di.getSortDirection();
                        String dimName = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)businessQuery.getBusinessModel(), (DataItem)di);
                        boolean ascending = true;
                        if (role == Role.ROW) {
                            node = sortDirection == DataItemActionType.SORT_NONE ? availRowNode : sortRowNode;
                            dimensions = rowDims;
                            axis = rowAxis;
                        } else if (role == Role.COLUMN) {
                            node = sortDirection == DataItemActionType.SORT_NONE ? availColumnNode : sortColumnNode;
                            dimensions = colDims;
                            axis = columnAxis;
                        }
                        if (sortDirection == DataItemActionType.SORT_ASCENDING) {
                            hier = false;
                            ascending = true;
                            directions.add(new Integer(0));
                        } else if (sortDirection == DataItemActionType.SORT_DESCENDING) {
                            hier = false;
                            ascending = false;
                            directions.add(new Integer(1));
                        } else if (sortDirection == DataItemActionType.SORT_HIERARCHICAL_ASCENDING) {
                            directions.add(new Integer(0));
                            ascending = true;
                        } else if (sortDirection == DataItemActionType.SORT_HIERARCHICAL_DESCENDING) {
                            directions.add(new Integer(1));
                            ascending = false;
                        }
                        OLAPSortSelectorModelFactory.addDataItem(node, dimensions, dimName, axis, ascending ? 0 : 1, di);
                    }
                    int[] sortedDirections = new int[directions.size()];
                    for (int i = 0; i < sortedDirections.length; ++i) {
                        sortedDirections[i] = (Integer)directions.get(i);
                    }
                    adapter.setAvailableLevelLabelItems(avail);
                    adapter.setSortedLevelLabelItems(sorted);
                    adapter.setSortedLevelLabelDirections(sortedDirections);
                    adapter.setLevelLabelHierarchicalSort(hier);
                }
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)OLAPSortSelectorModelFactory.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)OLAPSortSelectorModelFactory.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return adapter;
    }

    private static void addDataItem(MutableTreeNode node, String[] dimensions, String dimensionName, AxisInterface axis, int direction, DataItem dataItem) throws OLAPException, MetadataException {
        String displayLabel = null;
        for (int j = 0; j < dimensions.length; ++j) {
            if (!dimensionName.equals(dimensions[j])) continue;
            displayLabel = displayLabel == null ? axis.getAxisHeaders()[j] : displayLabel + "-" + axis.getAxisHeaders()[j];
        }
        if (displayLabel == null) {
            displayLabel = dataItem.getLabel();
        }
        node.insert(new DefaultMutableTreeNode(new SortedItem((Object)displayLabel, direction, (Object)dataItem.getID()), false), node.getChildCount());
    }

    public static String getDisplayedName(String uniqueName, OLAPDataSetInterface model) {
        String label = null;
        if (model != null && !(model instanceof OLAPDataSet)) {
            try {
                MetadataInterface metadata = model.getDatabaseMetadata();
                if (metadata != null) {
                    Filter filter = new Filter();
                    filter.setTreeOperator(Filter.SELF_TREE_OPERATOR);
                    filter.setUniqueMemberName(uniqueName);
                    MemberInterface[] members = metadata.getMembers(filter, 0, -1);
                    for (int i = 0; i < members.length; ++i) {
                        label = members[i].getName().trim();
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return label;
    }

    private static String getNameOfSortedItem(List list, List id, OLAPDataSetInterface model, BusinessQuery businessQuery) {
        String name = null;
        try {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object obj = list.get(i);
                if (obj != null && obj instanceof Object[] && ((Object[])obj).length != 0) {
                    Object[] array = (Object[])obj;
                    for (int j = 0; j < array.length; ++j) {
                        String dn = null;
                        if (array[j] instanceof String) {
                            dn = OLAPSortSelectorModelFactory.getDisplayedName((String)array[j], model);
                            id.add(array[j]);
                        } else if (array[j] instanceof DataItem) {
                            dn = ((DataItem)array[j]).getLabel();
                            id.add(((DataItem)array[j]).getID());
                        }
                        name = name == null ? dn : name + "." + dn;
                    }
                    continue;
                }
                if (obj == null) continue;
                String dn = null;
                if (obj instanceof String) {
                    dn = OLAPSortSelectorModelFactory.getDisplayedName((String)obj, model);
                    id.add(obj);
                } else if (obj instanceof DataItem) {
                    dn = ((DataItem)obj).getLabel();
                    id.add(((DataItem)obj).getID());
                }
                name = name == null ? dn : name + "." + dn;
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return name;
    }
}

