/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.ranking;

import com.sas.dataselectors.ranking.OLAPRankingSelectorAdapter;
import com.sas.dataselectors.ranking.OLAPRankingSelectorInterface;
import com.sas.dataselectors.ranking.RelationalRankingSelectorAdapter;
import com.sas.dataselectors.ranking.RelationalRankingSelectorInterface;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;

public class RankingSelectorAdapterFactory {
    public static RelationalRankingSelectorInterface getRelationalAdapter(BusinessQuery model) {
        RelationalRankingSelectorAdapter adapter = null;
        if (model != null && !model.getInputStructure().isOLAP()) {
            adapter = new RelationalRankingSelectorAdapter();
            adapter.dataModel(model);
        }
        return adapter;
    }

    public static OLAPRankingSelectorInterface getOLAPAdapter(BusinessQuery model) {
        OLAPRankingSelectorAdapter adapter = null;
        if (model != null && model.getInputStructure().isOLAP()) {
            adapter = new OLAPRankingSelectorAdapter();
            adapter.dataModel(model);
        }
        return adapter;
    }

    public static RelationalRankingSelectorInterface getRelationalAdapter(Object model) {
        RelationalRankingSelectorAdapter adapter = null;
        if (model != null) {
            BusinessQuery bq = null;
            if (model instanceof BusinessQueryProviderInterface) {
                bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            }
            if (bq != null && !bq.getInputStructure().isOLAP()) {
                adapter = new RelationalRankingSelectorAdapter();
                adapter.setModel(model);
                adapter.dataModel(bq);
            }
        }
        return adapter;
    }

    public static OLAPRankingSelectorInterface getOLAPAdapter(Object model) {
        OLAPRankingSelectorAdapter adapter = null;
        if (model != null) {
            BusinessQuery bq = null;
            if (model instanceof BusinessQueryProviderInterface) {
                bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            }
            if (bq != null && bq.getInputStructure().isOLAP()) {
                adapter = new OLAPRankingSelectorAdapter();
                adapter.setModel(model);
                adapter.dataModel(bq);
            }
        }
        return adapter;
    }
}

