/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.qualifiers;

import com.sas.dataselectors.qualifiers.QualifiersSelectorAdapter;
import com.sas.dataselectors.qualifiers.RB;
import com.sas.dataselectors.qualifiers.SwingQualifiersEditor;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.swing.dataselectors.editors.QualifiersEditorInterface;
import java.util.Locale;

public class QualifiersEditorFactory {
    public static final int SWING = 0;
    public static final int SERVLET = 1;
    public static final int BUSINESS_MODEL = 0;
    public static final int BUSINESS_QUERY = 1;

    public static QualifiersEditorInterface newEditor(int editorType, int modelType, Object model, String title) {
        if (editorType == 0) {
            if (modelType == 0 && model instanceof BusinessModel) {
                return QualifiersEditorFactory.newSwingEditor((BusinessModel)model, title);
            }
            if (modelType == 1 && model instanceof BusinessQuery) {
                return QualifiersEditorFactory.newSwingEditor((BusinessQuery)model, title);
            }
        }
        return null;
    }

    public static QualifiersEditorInterface newSwingEditor(BusinessQuery businessQuery, String title) {
        SwingQualifiersEditor editor = new SwingQualifiersEditor(new QualifiersSelectorAdapter(businessQuery), title);
        QualifiersEditorFactory.setProperties(editor, "QualifiersEditorBQ.", Locale.getDefault());
        return editor;
    }

    public static QualifiersEditorInterface newSwingEditor(BusinessModel businessModel, String title) {
        SwingQualifiersEditor editor = new SwingQualifiersEditor(new QualifiersSelectorAdapter(businessModel), title);
        QualifiersEditorFactory.setProperties(editor, "QualifiersEditorBM.", Locale.getDefault());
        return editor;
    }

    public static void setProperties(QualifiersEditorInterface editor, String key, Locale locale) {
        editor.clearButtonText(RB.getStringResource((String)key, (String)"clear.txt", (Locale)locale));
        editor.itemLabel(RB.getStringResource((String)key, (String)"itemLabel.txt", (Locale)locale));
        editor.itemName(RB.getStringResource((String)key, (String)"itemName.txt", (Locale)locale));
        editor.itemsLabel(RB.getStringResource((String)key, (String)"itemsLabel.txt", (Locale)locale));
        editor.itemsNameColumnLabel(RB.getStringResource((String)key, (String)"itemsNameColumnLabel.txt", (Locale)locale));
        editor.itemsValueColumnLabel(RB.getStringResource((String)key, (String)"itemsValueColumnLabel.txt", (Locale)locale));
    }
}

