/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.format;

import com.sas.dataselectors.format.RB;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IHostSystem;
import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.models.formats.FormatDescription;
import com.sas.models.formats.SASFormatModel;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.user.UserContextInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.omg.CORBA.StringHolder;

public class SASUserDefinedFormatModel
extends SASFormatModel {
    public static final String NUMERIC_USER_DEFINED_FORMAT = "NumUserDefinedFormat";
    public static final String CHARACTER_USER_DEFINED_FORMAT = "CharUserDefinedFormat";
    private List numericUserDefinedFormats;
    private List characterUserDefinedFormats;
    private LogicalServerInterface server;
    private UserContextInterface context;

    public SASUserDefinedFormatModel(LogicalServerInterface server, UserContextInterface context) {
        this.server = server;
        this.context = context;
    }

    public Map getFormatTypes(int dataType, Locale locale) {
        Map formats = super.getFormatTypes(dataType, locale);
        this.loadFormats(locale);
        boolean numeric = false;
        boolean character = false;
        if (dataType == 8 || dataType == 2 || dataType == -5 || dataType == 3 || dataType == 6 || dataType == 4 || dataType == -6 || dataType == 5 || dataType == 91 || dataType == 92 || dataType == 93 || dataType == 1111) {
            numeric = true;
        }
        if (dataType == 1 || dataType == 1111 || dataType == 12) {
            character = true;
        }
        if (numeric && this.numericUserDefinedFormats != null && !this.numericUserDefinedFormats.isEmpty()) {
            formats.put(NUMERIC_USER_DEFINED_FORMAT, RB.getStringResource("BusinessQueryFormatAdapter.UserDefined.txt", locale));
        }
        if (character && this.characterUserDefinedFormats != null && !this.characterUserDefinedFormats.isEmpty()) {
            formats.put(CHARACTER_USER_DEFINED_FORMAT, RB.getStringResource("BusinessQueryFormatAdapter.UserDefined.txt", locale));
        }
        return formats;
    }

    public List getFormatByType(Object formatCategory, Locale locale) {
        this.loadFormats(locale);
        if (formatCategory == NUMERIC_USER_DEFINED_FORMAT) {
            return this.numericUserDefinedFormats;
        }
        if (formatCategory == CHARACTER_USER_DEFINED_FORMAT) {
            return this.characterUserDefinedFormats;
        }
        return super.getFormatByType(formatCategory, locale);
    }

    private void loadFormats(Locale locale) {
        if (this.numericUserDefinedFormats == null && this.characterUserDefinedFormats == null) {
            List formats;
            if (this.server != null && this.context != null && (formats = SASUserDefinedFormatModel.userDefinedFormats(this.server, this.context, locale)) != null) {
                this.numericUserDefinedFormats = new ArrayList();
                this.characterUserDefinedFormats = new ArrayList();
                for (FormatDescription fd : formats) {
                    if (fd.getBaseFormatName().startsWith("$")) {
                        this.characterUserDefinedFormats.add(fd);
                        continue;
                    }
                    this.numericUserDefinedFormats.add(fd);
                }
            }
            if (this.numericUserDefinedFormats == null) {
                this.numericUserDefinedFormats = Collections.EMPTY_LIST;
            }
            if (this.characterUserDefinedFormats == null) {
                this.characterUserDefinedFormats = Collections.EMPTY_LIST;
            }
        }
    }

    private static File submitSASStatement(String statement, IWorkspace sasWorkspace, IFileref serverFile) {
        ILanguageService sasLanguage = sasWorkspace.LanguageService();
        try {
            sasLanguage.Submit(statement);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        CarriageControlSeqHolder logCarriageControlHldr = new CarriageControlSeqHolder();
        LineTypeSeqHolder logLineTypeHldr = new LineTypeSeqHolder();
        StringSeqHolder logHldr = new StringSeqHolder();
        try {
            sasLanguage.FlushLogLines(Integer.MAX_VALUE, logCarriageControlHldr, logLineTypeHldr, logHldr);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        File localFile = null;
        try {
            localFile = File.createTempFile("RMS", ".xml");
            localFile.createNewFile();
            IBinaryStream serverFileStream = serverFile.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
            FileOutputStream localStream = new FileOutputStream(localFile);
            byte[] buffer = null;
            int numberBytesRead = 1;
            int len = 8192;
            OctetSeqHolder holder = new OctetSeqHolder();
            while (numberBytesRead > 0) {
                buffer = null;
                serverFileStream.Read(len, holder);
                buffer = holder.value;
                numberBytesRead = buffer.length;
                if (buffer == null) {
                    numberBytesRead = 0;
                }
                if (numberBytesRead <= 0) continue;
                localStream.write(buffer);
            }
            localStream.close();
            serverFileStream.Close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List userDefinedFormats(LogicalServerInterface logicalServer, UserContextInterface userContext, Locale locale) {
        ArrayList formats = new ArrayList();
        DataProvider dp = null;
        try {
            IWorkspace sasWorkspace = null;
            dp = new DataProvider(userContext);
            sasWorkspace = dp.getIWorkspace(logicalServer.getName());
            IFileService fileService = sasWorkspace.FileService();
            StringHolder assignedResultsName = new StringHolder();
            IFileref serverResults = null;
            try {
                serverResults = fileService.AssignFileref("", "TEMP", "", "", assignedResultsName);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            String resultsFileref = assignedResultsName.value;
            IHostSystem host = sasWorkspace.Utilities().HostSystem();
            StringSeqHolder softwareInfo = new StringSeqHolder();
            VariableArray2dOfStringHolder hardwareInfo = new VariableArray2dOfStringHolder();
            host.GetInfo(softwareInfo, hardwareInfo);
            String osFamily = softwareInfo.value[3];
            String statement = null;
            statement = osFamily.indexOf("OS") >= 0 ? "proc sql;create view allfmts as select * from dictionary.formats where fmttype='F' and source='C'; quit; run; data _null_; file " + resultsFileref + " encoding=utf8; set allfmts; put fmtname; run;" : "proc sql;create view allfmts as select * from dictionary.formats where fmttype='F' and source='C'; quit; run; data _null_; file " + resultsFileref + " encoding=utf8 NOBOM; set allfmts; put fmtname; run;";
            File results = SASUserDefinedFormatModel.submitSASStatement(statement, sasWorkspace, serverResults);
            LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(results), "UTF-8"));
            String string = reader.readLine();
            while (string != null) {
                string = string.replaceAll(" +", " ").trim();
                int blankPos = string.indexOf(" ");
                int startPos = 0;
                while (blankPos > 0) {
                    SASUserDefinedFormatModel.addFormat(formats, string.substring(startPos, blankPos), locale);
                    startPos = blankPos + 1;
                    blankPos = string.indexOf(" ", startPos);
                }
                SASUserDefinedFormatModel.addFormat(formats, string.substring(startPos), locale);
                string = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            if (dp != null) {
                dp.close();
            }
            ArrayList arrayList = formats;
            return arrayList;
        }
        finally {
            return formats;
        }
    }

    private static void addFormat(List formats, String format, Locale locale) {
        FormatDescription fd = null;
        if (format != null) {
            fd = new FormatDescription();
            fd.setBaseFormatName(format);
            fd.setExample("");
            fd.setDescription("");
            fd.setWidthSupported(false);
            formats.add(fd);
        }
    }
}

