/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.format;

import com.sas.dataselectors.format.BusinessModelFormatAdapter;
import com.sas.dataselectors.format.RB;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.EntityInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.serverprop.formats.SASFormatAttributes;
import com.sas.iquery.metadata.serverprop.formats.SASFormatCategory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionUtil;
import com.sas.iquery.metadata.serverprop.formats.SASFormatException;
import com.sas.models.formats.FormatDescription;
import com.sas.swing.visuals.dataselectors.format.FormatTypeAdapterInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DataItemFormatAdapter
extends BusinessModelFormatAdapter
implements FormatTypeAdapterInterface {
    protected DataItem dataItem;
    protected String format;
    private List userDefinedFormatList;

    public DataItemFormatAdapter(DataItem di) {
        super(di.getBusinessModel());
        this.dataItem = di;
    }

    public int getType() {
        if (this.dataItem != null) {
            int type = this.dataItem.getExpressionTypeIgnoringFormattingForced();
            if (type == 2) {
                return 2;
            }
            if (type == 1) {
                return 12;
            }
            if (type == 9) {
                return 16;
            }
            if (type == 3) {
                return 1;
            }
            if (type == 4) {
                return 91;
            }
            if (type == 10) {
                return 2000;
            }
            if (type == 8) {
                return 91;
            }
            if (type == 7) {
                return 91;
            }
            if (type == 0) {
                return 1111;
            }
            if (type == 5) {
                return 92;
            }
            if (type == 6) {
                return 93;
            }
            if (type == 11) {
                return 12;
            }
        }
        return 8;
    }

    public String getFormat() {
        if (this.dataItem != null) {
            return this.dataItem.getFormat();
        }
        return this.format;
    }

    public void setFormat(String newFormat) {
        if (this.dataItem != null) {
            try {
                if (newFormat != null) {
                    this.dataItem.setFormat(newFormat);
                } else if (this.dataItem instanceof DataItemReference) {
                    ((DataItemReference)this.dataItem).resetFormat();
                } else {
                    this.dataItem.setFormat(null);
                }
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
        }
        this.format = newFormat;
    }

    public String getDataItemLabel() {
        if (this.dataItem != null) {
            return this.dataItem.getLabel();
        }
        return null;
    }

    @Override
    public Map getFormatTypes(int dataType, Locale locale) {
        Map map = super.getFormatTypes(dataType, locale);
        if (this.dataItem != null) {
            EntityInterface ent = this.dataItem.getExtendedAttributes();
            try {
                FormatDescription fd;
                this.userDefinedFormatList = new ArrayList();
                if (ent != null) {
                    AttributeDescriptorInterface[] extAttrs = ent.getAttributeDescriptors();
                    for (int i = 0; i < extAttrs.length; ++i) {
                        int index;
                        if (extAttrs[i].getName().equals("entityKey")) continue;
                        String attrName = extAttrs[i].getName();
                        if (attrName.startsWith("_allowedUserFormat")) {
                            fd = new FormatDescription();
                            index = attrName.indexOf("_", 2);
                            fd.setBaseFormatName(attrName.substring(index + 1, attrName.length() - 1));
                            fd.setExample("");
                            fd.setDescription(extAttrs[i].getDescription(locale));
                            this.userDefinedFormatList.add(fd);
                            continue;
                        }
                        if (!attrName.startsWith("_userFormat")) continue;
                        fd = new FormatDescription();
                        if (extAttrs[i].getDefault() != null) {
                            fd.setBaseFormatName(extAttrs[i].getDefault().toString());
                        } else {
                            index = attrName.indexOf("_", 2);
                            fd.setBaseFormatName(attrName.substring(index + 1, attrName.length() - 1));
                        }
                        fd.setExample("");
                        fd.setDescription(extAttrs[i].getDescription(locale));
                        this.userDefinedFormatList.add(fd);
                    }
                }
                String formatName = this.dataItem.getFormat();
                String baseFormatName = "";
                SASFormatAttributes formatAttrs = null;
                if (formatName != null && formatName.length() > 0) {
                    try {
                        formatAttrs = SASFormatDescriptionUtil.getFormatAttributes((String)formatName);
                    }
                    catch (SASFormatException fd2) {
                        // empty catch block
                    }
                }
                if (formatAttrs != null && formatAttrs.getType().equals(SASFormatCategory.USER_DEFINED_CATEGORY)) {
                    baseFormatName = formatAttrs.getBaseFormatName();
                }
                if (baseFormatName.trim().length() > 0 && !this.inList(baseFormatName, this.userDefinedFormatList)) {
                    fd = new FormatDescription();
                    fd.setBaseFormatName(baseFormatName);
                    fd.setExample("");
                    fd.setDescription("");
                    this.userDefinedFormatList.add(fd);
                }
                if (!this.userDefinedFormatList.isEmpty()) {
                    map.put(SASFormatCategory.USER_DEFINED_CATEGORY, RB.getStringResource("BusinessQueryFormatAdapter.UserDefined.txt", locale));
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return map;
    }

    private boolean inList(String candidate, List userDefinedFormats) {
        boolean retValue = false;
        for (int i = 0; i < userDefinedFormats.size(); ++i) {
            FormatDescription udfEntry = (FormatDescription)userDefinedFormats.get(i);
            String baseFormat = udfEntry.getBaseFormatName();
            if (!baseFormat.equals(candidate)) continue;
            retValue = true;
            break;
        }
        return retValue;
    }

    @Override
    public List getFormatByType(Object formatCategory, Locale locale) {
        if (formatCategory == SASFormatCategory.USER_DEFINED_CATEGORY && this.userDefinedFormatList != null) {
            return this.userDefinedFormatList;
        }
        List formats = super.getFormatByType(formatCategory, locale);
        return formats;
    }
}

