/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.find;

import com.sas.dataselectors.find.FindSelectorInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OLAPFindSelectorAdapter
implements FindSelectorInterface {
    protected OLAPDataSetInterface tableModel;
    protected ResultSetInterface resultSet;
    protected ResultSetMetadataInterface resultSetMetadata;
    protected AxisInterface rowAxis;
    protected TupleInterface[] rowTuples;
    protected AxisInterface columnAxis;
    protected TupleInterface[] columnTuples;
    protected Object[] cells;
    protected int currentRow;
    protected int currentColumn;
    public static int cellCount = 200;

    public OLAPFindSelectorAdapter(OLAPDataSetInterface model) {
        this.tableModel = model;
        this.resultSet = model;
        try {
            this.resultSetMetadata = this.resultSet.getResultSetMetadata();
            AxisInterface[] axes = this.resultSetMetadata.getAxes(0, -1);
            this.columnAxis = axes[0];
            this.rowAxis = axes[1];
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    public Map find(String type, String condition, String value, String direction) throws OLAPException {
        int rowNumber = -1;
        int columnNumber = -1;
        int startRowNumber = 0;
        int startColumnNumber = 0;
        int rowTupleCount = 0;
        int columnTupleCount = 0;
        int foundOrdinal = -1;
        rowTupleCount = this.rowAxis.getTupleCount();
        columnTupleCount = this.columnAxis.getTupleCount();
        this.resultSet = this.getTableModel();
        this.resultSetMetadata = this.resultSet.getResultSetMetadata();
        if (type.equals("1")) {
            this.rowTuples = this.rowAxis.getTuples(0, -1);
            startRowNumber = this.getStartIndex(this.rowTuples, direction, type);
            rowNumber = this.findMemberValue(this.rowTuples, startRowNumber, condition, value, direction);
        } else if (type.equals("2")) {
            this.columnTuples = this.columnAxis.getTuples(0, -1);
            startColumnNumber = this.getStartIndex(this.columnTuples, direction, type);
            columnNumber = this.findMemberValue(this.columnTuples, startColumnNumber, condition, value, direction);
        } else if ((type.equals("3") || type.equals("4")) && (foundOrdinal = this.findCellValue(rowTupleCount, columnTupleCount, type, condition, value, direction)) >= 0) {
            int[] foundCoords = OLAPUtil.calculateTupleCoordinates((ResultSetMetadataInterface)this.resultSetMetadata, (int)foundOrdinal);
            columnNumber = foundCoords[0];
            rowNumber = foundCoords[1];
        }
        HashMap<String, Integer> findMap = new HashMap<String, Integer>(2);
        if (rowNumber > -1) {
            this.setCurrentRow(rowNumber);
            findMap.put("ROW_NUMBER", new Integer(rowNumber + 1));
        }
        if (columnNumber > -1) {
            this.setCurrentColumn(columnNumber);
            findMap.put("COLUMN_NUMBER", new Integer(columnNumber + 1));
        }
        return findMap;
    }

    private int getStartIndex(TupleInterface[] tuples, String findDirection, String type) {
        int index = -1;
        int currentIndex = -1;
        if (type.equals("1")) {
            currentIndex = this.getCurrentRow();
        } else if (type.equals("2")) {
            currentIndex = this.getCurrentColumn();
        }
        if (findDirection.equals("1")) {
            index = currentIndex == tuples.length ? 0 : currentIndex + 1;
        } else if (findDirection.equals("2")) {
            index = currentIndex == 0 ? tuples.length : currentIndex - 1;
        }
        return index;
    }

    private int findCellValue(int rowTupleCount, int columnTupleCount, String type, String condition, String value, String direction) throws OLAPException {
        int[] startCoordinates = new int[]{this.getCurrentColumn(), this.getCurrentRow()};
        int[] endCoordinates = new int[]{0, 0};
        int tupleCount = 0;
        this.resultSet = this.getTableModel();
        this.resultSetMetadata = this.resultSet.getResultSetMetadata();
        int searchRow = this.getCurrentRow();
        int searchColumn = this.getCurrentColumn();
        boolean found = false;
        boolean doFind = true;
        boolean wrapSearch = false;
        boolean getFormattedData = true;
        if (direction.equals("1")) {
            if (searchRow > 0 || searchColumn > 0) {
                wrapSearch = true;
            }
        } else if (searchRow < rowTupleCount - 1 || searchColumn < columnTupleCount - 1) {
            wrapSearch = true;
        }
        if (type.equals("3")) {
            if (direction.equals("1")) {
                if (++searchColumn >= columnTupleCount) {
                    searchColumn = 0;
                    if (++searchRow >= rowTupleCount) {
                        searchRow = 0;
                    }
                }
            } else if (--searchColumn < 0) {
                searchColumn = columnTupleCount - 1;
                if (--searchRow < 0) {
                    searchRow = rowTupleCount - 1;
                }
            }
        } else if (type.equals("4")) {
            if (direction.equals("1")) {
                if (++searchRow >= rowTupleCount) {
                    searchRow = 0;
                    if (++searchColumn >= columnTupleCount) {
                        searchColumn = 0;
                    }
                }
            } else if (--searchRow < 0) {
                searchRow = rowTupleCount - 1;
                if (--searchColumn < 0) {
                    searchColumn = columnTupleCount - 1;
                }
            }
        }
        int stopRow = 0;
        int stopColumn = 0;
        if (direction.equals("1")) {
            stopRow = rowTupleCount - 1;
            stopColumn = columnTupleCount - 1;
        }
        int startOrdinal = -1;
        int endOrdinal = -1;
        int foundOrdinal = -1;
        int numRows = 0;
        int numCols = 0;
        while (doFind) {
            startCoordinates[0] = searchColumn;
            startCoordinates[1] = searchRow;
            if (type.equals("3")) {
                tupleCount = rowTupleCount;
            } else if (type.equals("4")) {
                tupleCount = columnTupleCount;
            }
            startOrdinal = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)this.resultSetMetadata, (int[])startCoordinates);
            endCoordinates = this.getEndCoordinates(searchColumn, searchRow, columnTupleCount, rowTupleCount, type, direction);
            endOrdinal = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)this.resultSetMetadata, (int[])endCoordinates);
            numRows = Math.abs(endCoordinates[1] - startCoordinates[1]) + 1;
            numCols = Math.abs(endCoordinates[0] - startCoordinates[0]) + 1;
            if (numRows == 0) {
                numRows = 1;
            }
            if (numCols == 0) {
                numCols = 1;
            }
            this.cells = getFormattedData ? (direction.equals("1") ? this.resultSet.getFormattedCells((long)startOrdinal, (long)endOrdinal) : this.resultSet.getFormattedCells((long)endOrdinal, (long)startOrdinal)) : this.resultSet.getCells((long)startOrdinal, (long)endOrdinal);
            int numberOfCells = this.cells.length;
            String cellValue = null;
            double doubleCellValue = 0.0;
            int compareValue = 0;
            int startIndex = 0;
            int endIndex = 0;
            if (direction.equals("1")) {
                endIndex = numberOfCells - 1;
            } else {
                startIndex = numberOfCells - 1;
                endIndex = 0;
            }
            int rowIndex = 0;
            int colIndex = 0;
            if (direction.equals("2")) {
                rowIndex = numRows - 1;
                colIndex = numCols - 1;
            }
            int j = startIndex;
            boolean searchCells = true;
            while (searchCells) {
                if (!getFormattedData) {
                    doubleCellValue = (Double)this.cells[j];
                } else {
                    cellValue = (String)this.cells[j];
                }
                if (condition.equals("1") && getFormattedData && (compareValue = cellValue.trim().compareTo(value.trim())) == 0) {
                    found = true;
                }
                if (found) {
                    int[] foundCoordinates = new int[]{0, 0};
                    if (type.equals("3")) {
                        foundCoordinates = direction.equals("2") ? this.getFoundCoordinatesForBackwardRowSearch(searchRow, searchColumn, this.cells.length, columnTupleCount, j) : this.getFoundCoordinatesForForwardRowSearch(searchRow, searchColumn, this.cells.length, columnTupleCount, j);
                    } else if (type.equals("4")) {
                        foundCoordinates = direction.equals("2") ? this.getFoundCoordinatesForBackwardColumnSearch(searchRow, searchColumn, this.cells.length, rowTupleCount, j) : this.getFoundCoordinatesForForwardColumnSearch(searchRow, searchColumn, this.cells.length, rowTupleCount, j);
                    }
                    foundOrdinal = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)this.resultSetMetadata, (int[])foundCoordinates);
                    break;
                }
                if (direction.equals("1")) {
                    if (type.equals("3")) {
                        ++j;
                    } else if (type.equals("4")) {
                        if (++rowIndex >= numRows) {
                            rowIndex = 0;
                            if (++colIndex >= numCols) {
                                searchCells = false;
                            }
                        }
                        j = rowIndex * numCols + colIndex;
                    }
                    if (j <= endIndex) continue;
                    searchCells = false;
                    continue;
                }
                if (type.equals("3")) {
                    --j;
                } else if (type.equals("4")) {
                    if (--rowIndex < 0) {
                        rowIndex = numRows - 1;
                        if (--colIndex < 0) {
                            searchCells = false;
                        }
                    }
                    j = rowIndex * numCols + colIndex;
                }
                if (j >= endIndex) continue;
                searchCells = false;
            }
            if (found) {
                doFind = false;
                continue;
            }
            if (direction.equals("1")) {
                if (endCoordinates[0] + 1 > stopColumn && endCoordinates[1] + 1 > stopRow) {
                    if (wrapSearch) {
                        searchColumn = 0;
                        searchRow = 0;
                        stopColumn = this.getCurrentColumn();
                        stopRow = this.getCurrentRow();
                        wrapSearch = false;
                        continue;
                    }
                    doFind = false;
                    continue;
                }
                if (type.equals("4")) {
                    if (endCoordinates[1] >= rowTupleCount - 1) {
                        searchRow = 0;
                        ++searchColumn;
                        continue;
                    }
                    searchRow = endCoordinates[1] + 1;
                    continue;
                }
                if (!type.equals("3")) continue;
                if (endCoordinates[0] >= columnTupleCount - 1) {
                    searchColumn = 0;
                    ++searchRow;
                    continue;
                }
                searchColumn = endCoordinates[0] + 1;
                continue;
            }
            if (endCoordinates[0] - 1 < stopColumn && endCoordinates[1] - 1 < stopRow) {
                if (wrapSearch) {
                    searchColumn = columnTupleCount - 1;
                    searchRow = rowTupleCount - 1;
                    stopColumn = this.getCurrentColumn();
                    stopRow = this.getCurrentRow();
                    wrapSearch = false;
                    continue;
                }
                doFind = false;
                continue;
            }
            if (type.equals("4")) {
                if (endCoordinates[1] == 0) {
                    searchRow = rowTupleCount - 1;
                    --searchColumn;
                    continue;
                }
                searchRow = endCoordinates[1] - 1;
                continue;
            }
            if (!type.equals("3")) continue;
            if (endCoordinates[0] == 0) {
                searchColumn = columnTupleCount - 1;
                --searchRow;
                continue;
            }
            searchColumn = endCoordinates[0] - 1;
        }
        return foundOrdinal;
    }

    private int[] getFoundCoordinatesForForwardRowSearch(int searchRow, int searchColumn, int numberOfCells, int columnTupleCount, int foundIndex) {
        int foundRow = 0;
        int foundColumn = 0;
        if (numberOfCells <= columnTupleCount) {
            foundColumn = searchColumn + foundIndex;
            foundRow = searchRow;
        } else {
            int columnAdj = foundIndex % columnTupleCount;
            int rowAdj = foundIndex / columnTupleCount;
            foundColumn = searchColumn + columnAdj;
            foundRow = searchRow + rowAdj;
        }
        int[] foundCoordinates = new int[]{foundColumn, foundRow};
        return foundCoordinates;
    }

    private int[] getFoundCoordinatesForForwardColumnSearch(int searchRow, int searchColumn, int numberOfCells, int rowTupleCount, int foundIndex) {
        int foundRow = 0;
        int foundColumn = 0;
        int numberOfColumns = 0;
        if (numberOfCells <= rowTupleCount) {
            foundRow = searchRow + foundIndex;
            foundColumn = searchColumn;
        } else {
            numberOfColumns = numberOfCells / rowTupleCount;
            foundRow = foundIndex / numberOfColumns;
            foundColumn = searchColumn + foundIndex % numberOfColumns;
        }
        int[] foundCoordinates = new int[]{foundColumn, foundRow};
        return foundCoordinates;
    }

    private int[] getFoundCoordinatesForBackwardRowSearch(int searchRow, int searchColumn, int numberOfCells, int columnTupleCount, int foundIndex) {
        int foundRow = 0;
        int foundColumn = 0;
        if (numberOfCells <= columnTupleCount) {
            foundColumn = searchColumn - (numberOfCells - 1) + foundIndex;
            foundRow = searchRow;
        } else {
            int numberOfRows = numberOfCells / columnTupleCount;
            int columnAdj = foundIndex % columnTupleCount;
            int rowAdj = foundIndex / columnTupleCount;
            if (foundIndex == 0) {
                foundColumn = 0;
                foundRow = searchRow - (numberOfRows - 1);
            } else {
                foundColumn = searchColumn - (searchColumn - columnAdj);
                foundRow = searchRow - (numberOfRows - 1 - rowAdj);
            }
        }
        int[] foundCoordinates = new int[]{foundColumn, foundRow};
        return foundCoordinates;
    }

    private int[] getFoundCoordinatesForBackwardColumnSearch(int searchRow, int searchColumn, int numberOfCells, int rowTupleCount, int foundIndex) {
        int foundRow = 0;
        int foundColumn = 0;
        int numberOfColumns = 0;
        if (numberOfCells <= rowTupleCount) {
            foundRow = foundIndex;
            foundColumn = searchColumn;
        } else {
            numberOfColumns = numberOfCells / rowTupleCount;
            int colAdj = numberOfColumns - 1 - foundIndex % numberOfColumns;
            if (foundIndex == 0) {
                foundRow = 0;
                foundColumn = searchColumn - (numberOfColumns - 1);
            } else {
                foundRow = foundIndex / numberOfColumns;
                foundColumn = searchColumn - colAdj;
            }
        }
        int[] foundCoordinates = new int[]{foundColumn, foundRow};
        return foundCoordinates;
    }

    private int[] getEndCoordinates(int column, int row, int numberOfColumnTuples, int numberOfRowTuples, String type, String direction) {
        int endMajor = 0;
        int endMinor = 0;
        int startMajor = 0;
        int startMinor = 0;
        int numberOfMajorTuples = 0;
        int numberOfMinorTuples = 0;
        if (type.equals("4")) {
            startMajor = column;
            numberOfMajorTuples = numberOfColumnTuples;
            startMinor = row;
            numberOfMinorTuples = numberOfRowTuples;
        } else if (type.equals("3")) {
            startMajor = row;
            numberOfMajorTuples = numberOfRowTuples;
            startMinor = column;
            numberOfMinorTuples = numberOfColumnTuples;
        }
        if (startMinor > 0) {
            if (direction.equals("1")) {
                endMajor = startMajor;
                endMinor = numberOfMinorTuples - startMinor < cellCount ? numberOfMinorTuples - 1 : startMinor + cellCount - 1;
            } else if (startMinor < numberOfMinorTuples - 1) {
                endMinor = numberOfMinorTuples < cellCount ? 0 : startMinor - cellCount + 1;
                endMajor = startMajor;
            } else {
                endMinor = 0;
                endMajor = startMajor - cellCount / numberOfMinorTuples + 1;
            }
        } else if (direction.equals("1")) {
            if (numberOfMinorTuples < cellCount) {
                endMajor = startMajor + cellCount / numberOfMinorTuples - 1;
                endMinor = numberOfMinorTuples - 1;
            } else {
                endMajor = startMajor;
                endMinor = startMinor + cellCount - 1;
            }
        } else if (numberOfMinorTuples <= cellCount) {
            endMajor = startMajor - cellCount / numberOfMinorTuples;
            endMinor = 0;
        } else {
            endMajor = startMajor;
            endMinor = 0;
        }
        if (direction.equals("1")) {
            if (endMajor >= numberOfMajorTuples) {
                endMajor = numberOfMajorTuples - 1;
            }
            if (endMinor >= numberOfMinorTuples) {
                endMinor = numberOfMinorTuples - 1;
            }
        } else {
            if (endMajor < 0) {
                endMajor = 0;
            }
            if (endMinor < 0) {
                endMinor = 0;
            }
        }
        int[] coordinates = new int[]{-1, -1};
        if (type.equals("4")) {
            coordinates[0] = endMajor;
            coordinates[1] = endMinor;
        } else if (type.equals("3")) {
            coordinates[0] = endMinor;
            coordinates[1] = endMajor;
        }
        return coordinates;
    }

    private int findMemberValue(TupleInterface[] tuples, int start, String condition, String value, String direction) throws OLAPException {
        int foundIndex = -1;
        if (this.rowAxis != null) {
            TupleInterface thistuple = null;
            TupleElementInterface thistupleelement = null;
            Pattern p = null;
            if (!condition.equals("1")) {
                p = Pattern.compile(value.toLowerCase());
            }
            boolean found = false;
            boolean wrapSearch = false;
            int startIndex = 0;
            int endIndex = 0;
            if (direction.equals("1")) {
                startIndex = start;
                endIndex = tuples.length;
                if (startIndex != 0) {
                    wrapSearch = true;
                }
            } else if (direction.equals("2")) {
                startIndex = start;
                endIndex = 0;
                if (startIndex != tuples.length) {
                    wrapSearch = true;
                }
            }
            int i = startIndex;
            boolean doFind = true;
            while (doFind) {
                if (i < tuples.length) {
                    thistuple = tuples[i];
                    for (int j = 0; j < thistuple.getTupleDepth(); ++j) {
                        thistupleelement = thistuple.getElement(j);
                        if (condition.equals("1")) {
                            if (value.equalsIgnoreCase(thistupleelement.getLabel().trim())) {
                                found = true;
                            }
                        } else {
                            boolean contains;
                            Matcher m = p.matcher(thistupleelement.getLabel().trim().toLowerCase());
                            if (condition.equals("6")) {
                                boolean startswith = m.lookingAt();
                                if (startswith && m.start() == 0) {
                                    found = true;
                                }
                            } else if (condition.equals("7") && (contains = m.find())) {
                                found = true;
                            }
                        }
                        if (!found) continue;
                        foundIndex = i;
                        break;
                    }
                }
                if (found) break;
                if (direction.equals("1")) {
                    if (++i <= endIndex) continue;
                    if (!wrapSearch) {
                        doFind = false;
                        continue;
                    }
                    endIndex = startIndex - 1;
                    i = startIndex = 0;
                    wrapSearch = false;
                    continue;
                }
                if (!direction.equals("2") || --i >= endIndex) continue;
                if (!wrapSearch) {
                    doFind = false;
                    continue;
                }
                endIndex = startIndex + 1;
                i = startIndex = tuples.length;
                wrapSearch = false;
            }
        }
        return foundIndex;
    }

    public AxisInterface getColumnAxis() {
        return this.columnAxis;
    }

    public TupleInterface[] getColumnTuples() {
        return this.columnTuples;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public ResultSetMetadataInterface getResultSetMetadata() {
        return this.resultSetMetadata;
    }

    public AxisInterface getRowAxis() {
        return this.rowAxis;
    }

    public TupleInterface[] getRowTuples() {
        return this.rowTuples;
    }

    public OLAPDataSetInterface getTableModel() {
        return this.tableModel;
    }

    public void setCurrentRow(int i) {
        this.currentRow = i;
    }

    public void setTableModel(OLAPDataSetInterface interface1) {
        this.tableModel = interface1;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public void setCurrentColumn(int i) {
        this.currentColumn = i;
    }
}

